/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.beans.PropertyEditorSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.beans.Utility;

public abstract class ArrayEditor
extends PropertyEditorSupport
implements Serializable {
    private static final long serialVersionUID = 2353798267181943054L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsText(String text) {
        if (text == null) {
            this.setValue(null);
            return;
        }
        String tmpText = Utility.replaceSystemProperty(Utility.xmlComentOut(text));
        int length = tmpText.length();
        if (length == 0) {
            this.setValue(this.createArray(new ArrayList(0)));
            return;
        }
        StringReader sr = new StringReader(tmpText);
        BufferedReader br = new BufferedReader(sr, length);
        ArrayList<String> list = new ArrayList<String>();
        try {
            StringBuffer buf = new StringBuffer();
            String line = null;
            while ((line = br.readLine()) != null) {
                String val = Utility.trim(line);
                boolean isEscape = false;
                int max = val.length();
                block16: for (int i = 0; i < max; ++i) {
                    char c = val.charAt(i);
                    switch (c) {
                        case ',': {
                            if (isEscape) {
                                buf.append(c);
                                isEscape = false;
                                continue block16;
                            }
                            if (buf.length() == 0) continue block16;
                            list.add(buf.toString());
                            buf.setLength(0);
                            continue block16;
                        }
                        case '\\': {
                            if (isEscape) {
                                buf.append(c);
                                isEscape = false;
                                continue block16;
                            }
                            isEscape = true;
                            continue block16;
                        }
                        default: {
                            if (isEscape) {
                                buf.append('\\');
                                isEscape = false;
                            }
                            buf.append(c);
                        }
                    }
                }
            }
            if (buf.length() != 0) {
                list.add(Utility.replaceSystemProperty(buf.toString()));
                buf.setLength(0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            sr.close();
        }
        this.setValue(this.createArray(list));
    }

    protected abstract Object createArray(List var1);

    @Override
    public String getAsText() {
        Object array = this.getValue();
        if (array == null) {
            return null;
        }
        if (!array.getClass().isArray()) {
            return array.toString();
        }
        StringBuffer buf = new StringBuffer();
        int max = Array.getLength(array);
        for (int i = 0; i < max; ++i) {
            String element = this.getAsText(Array.get(array, i));
            buf.append(element == null ? element : element.toString().replaceAll(",", "\\\\,"));
            if (i == max - 1) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    protected String getAsText(Object element) {
        return element == null ? null : element.toString();
    }
}

