/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import jp.ossc.nimbus.beans.BeanTableIndexKeyFactory;
import jp.ossc.nimbus.beans.BeanTableIndexManager;
import jp.ossc.nimbus.beans.BeanTableView;
import jp.ossc.nimbus.beans.NoSuchPropertyException;

public class BeanTable
implements List,
RandomAccess,
Serializable,
Cloneable {
    private static final long serialVersionUID = 619195842574715977L;
    protected BeanTableIndexManager indexManager;
    protected final boolean isSynchronized;
    protected List list;
    protected int modCount = 0;
    protected Comparator sortedComparator;

    public BeanTable(Class elementClass) {
        this(elementClass, false);
    }

    public BeanTable(Class elementClass, boolean isSynchronized) {
        this.indexManager = new BeanTableIndexManager(elementClass, isSynchronized);
        this.isSynchronized = isSynchronized;
        this.list = isSynchronized ? Collections.synchronizedList(new ArrayList()) : new ArrayList();
    }

    public BeanTable(Class elementClass, Collection c) {
        this(elementClass, c, false);
    }

    public BeanTable(Class elementClass, Collection c, boolean isSynchronized) {
        this(elementClass, isSynchronized);
        this.addAll(c);
    }

    public BeanTable(Class elementClass, int initialCapacity) {
        this(elementClass, initialCapacity, false);
    }

    public BeanTable(Class elementClass, int initialCapacity, boolean isSynchronized) {
        this.indexManager = new BeanTableIndexManager(elementClass, isSynchronized);
        this.isSynchronized = isSynchronized;
        this.list = isSynchronized ? Collections.synchronizedList(new ArrayList(initialCapacity)) : new ArrayList(initialCapacity);
    }

    public Class getElementClass() {
        return this.indexManager.getElementClass();
    }

    public void setIndex(String name, String[] props) throws NoSuchPropertyException {
        this.indexManager.setIndex(name, props);
    }

    public void setIndex(String name, BeanTableIndexKeyFactory keyFactory) {
        this.indexManager.setIndex(name, keyFactory);
    }

    public void removeIndex(String name) {
        this.indexManager.removeIndex(name);
    }

    public void analyzeIndex() {
        this.indexManager.clear();
        this.indexManager.addAll(this.list);
    }

    public BeanTableView createView() {
        return new BeanTableView(this.indexManager);
    }

    public void sort(String[] propNames) {
        this.sort(propNames, null);
    }

    public void sort(String[] propNames, boolean[] isAsc) {
        this.sortedComparator = BeanTableView.sort(this.getElementClass(), this.list, propNames, isAsc);
    }

    public int binarySearch(Object key) {
        return Collections.binarySearch(this.list, key, this.sortedComparator);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator iterator() {
        return new BeanTableIterator();
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int index) {
        return new BeanTableListIterator(index);
    }

    public List subList(int fromIndex, int toIndex) {
        return Collections.unmodifiableList(this.list.subList(fromIndex, toIndex));
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.list.toArray(a);
    }

    public Object get(int index) {
        return this.list.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean add(Object element) {
        if (element == null) {
            return false;
        }
        this.indexManager.add(element);
        boolean isAdd = this.list.add(element);
        if (isAdd) {
            ++this.modCount;
        }
        return isAdd;
    }

    public void add(int index, Object element) {
        if (element == null) {
            return;
        }
        this.indexManager.add(element);
        this.list.add(index, element);
        ++this.modCount;
    }

    public Object set(int index, Object element) {
        Object old = this.list.set(index, element);
        this.indexManager.replace(old, element);
        ++this.modCount;
        return old;
    }

    @Override
    public boolean addAll(Collection c) {
        if (this.list.addAll(c)) {
            this.indexManager.addAll(c);
            ++this.modCount;
            return true;
        }
        return false;
    }

    public boolean addAll(int index, Collection c) {
        if (this.list.addAll(index, c)) {
            this.indexManager.addAll(c);
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        boolean isRemoved = this.list.remove(o);
        if (isRemoved) {
            this.indexManager.remove(o);
            ++this.modCount;
        }
        return isRemoved;
    }

    public Object remove(int index) {
        Object ret = this.list.remove(index);
        this.indexManager.remove(ret);
        ++this.modCount;
        return ret;
    }

    @Override
    public boolean removeAll(Collection c) {
        if (this.list.removeAll(c)) {
            for (Object element : c) {
                this.indexManager.remove(element);
            }
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection c) {
        if (this.list.retainAll(c)) {
            this.indexManager.retainAll(c);
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.indexManager.clear();
        this.list.clear();
        ++this.modCount;
    }

    public Object clone() {
        BeanTable clone = null;
        try {
            clone = (BeanTable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        clone.list = this.isSynchronized ? Collections.synchronizedList(new ArrayList()) : new ArrayList();
        clone.indexManager = new BeanTableIndexManager(this.getElementClass(), this.isSynchronized);
        clone.addAll((Collection)this);
        return clone;
    }

    protected class BeanTableListIterator
    extends BeanTableIterator
    implements ListIterator {
        private static final long serialVersionUID = 8909520626834440479L;

        public BeanTableListIterator(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        public Object previous() {
            this.checkForComodification();
            try {
                int i = this.cursor - 1;
                Object previous = BeanTable.this.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        public void set(Object o) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                BeanTable.this.set(this.lastRet, o);
                ++this.expectedModCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object o) {
            this.checkForComodification();
            try {
                BeanTable.this.add(this.cursor++, o);
                this.lastRet = -1;
                ++this.expectedModCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }

    protected class BeanTableIterator
    implements Iterator,
    Serializable {
        private static final long serialVersionUID = -7202550703286618072L;
        protected int cursor = 0;
        protected int lastRet = -1;
        protected int expectedModCount;

        protected BeanTableIterator() {
            this.expectedModCount = BeanTable.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != BeanTable.this.size();
        }

        public Object next() {
            this.checkForComodification();
            try {
                Object next = BeanTable.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                BeanTable.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                ++this.expectedModCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (BeanTable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

