/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.beans.BeanTableIndex;
import jp.ossc.nimbus.beans.BeanTableIndexKeyFactory;
import jp.ossc.nimbus.beans.IndexNotFoundException;
import jp.ossc.nimbus.beans.IndexPropertyAccessException;
import jp.ossc.nimbus.beans.NoSuchPropertyException;

public class BeanTableIndexManager
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 5627700360788692960L;
    protected Class elementClass;
    protected boolean isSynchronized;
    protected Map nameIndexMap = new HashMap();
    protected Map singleIndexMap = new HashMap();
    protected Map complexIndexMap = new HashMap();
    protected Set valueSet = new HashSet();

    public BeanTableIndexManager() {
    }

    public BeanTableIndexManager(Class elementClass, boolean isSynchronized) {
        if (elementClass == null) {
            throw new IllegalArgumentException("elementClass is null.");
        }
        this.elementClass = elementClass;
        this.isSynchronized = isSynchronized;
    }

    public Class getElementClass() {
        return this.elementClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndex(String name, String[] props) throws NoSuchPropertyException {
        BeanTableIndex index = new BeanTableIndex(name, this.isSynchronized, this.elementClass, props);
        if (this.isSynchronized) {
            BeanTableIndexManager beanTableIndexManager = this;
            synchronized (beanTableIndexManager) {
                this.setIndexInternal(name, index, false);
            }
        } else {
            this.setIndexInternal(name, index, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndex(String name, BeanTableIndexKeyFactory keyFactory) {
        block6: {
            BeanTableIndex index = new BeanTableIndex(name, this.isSynchronized, this.elementClass, keyFactory);
            try {
                if (this.isSynchronized) {
                    BeanTableIndexManager beanTableIndexManager = this;
                    synchronized (beanTableIndexManager) {
                        this.setIndexInternal(name, index, true);
                        break block6;
                    }
                }
                this.setIndexInternal(name, index, true);
            }
            catch (NoSuchPropertyException noSuchPropertyException) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setIndexInternal(String name, BeanTableIndex index, boolean containsDummyProp) throws NoSuchPropertyException {
        Set indexedPropertyNames = index.getIndexedPropertyNames();
        if (indexedPropertyNames.size() == 1) {
            String propName = (String)indexedPropertyNames.iterator().next();
            if (this.singleIndexMap.containsKey(propName)) {
                BeanTableIndex singleIndex = (BeanTableIndex)this.singleIndexMap.get(propName);
                if (singleIndex.getName() != null) throw new IllegalArgumentException("Duplicate index. newIndex=" + name + ", duplicateIndex=" + singleIndex.getName());
                singleIndex.setName(name);
                index = singleIndex;
            } else {
                this.singleIndexMap.put(propName, index);
            }
        } else {
            if (this.complexIndexMap.containsKey(indexedPropertyNames)) {
                throw new IllegalArgumentException("Duplicate index. newIndex=" + name + ", duplicateIndex=" + ((BeanTableIndex)this.complexIndexMap.get(indexedPropertyNames)).getName());
            }
            this.complexIndexMap.put(indexedPropertyNames, index);
            for (String propName : indexedPropertyNames) {
                BeanTableIndex singleIndex = (BeanTableIndex)this.singleIndexMap.get(propName);
                if (singleIndex == null) {
                    try {
                        singleIndex = new BeanTableIndex(this.isSynchronized, this.elementClass, new String[]{propName});
                    }
                    catch (NoSuchPropertyException e) {
                        if (containsDummyProp) continue;
                        throw e;
                    }
                    this.singleIndexMap.put(propName, singleIndex);
                }
                singleIndex.addLinkedIndex(name);
            }
        }
        this.nameIndexMap.put(name, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIndex(String name) {
        if (this.isSynchronized) {
            BeanTableIndexManager beanTableIndexManager = this;
            synchronized (beanTableIndexManager) {
                this.removeIndexInternal(name);
            }
        } else {
            this.removeIndexInternal(name);
        }
    }

    protected void removeIndexInternal(String name) {
        BeanTableIndex index = (BeanTableIndex)this.nameIndexMap.remove(name);
        if (index == null) {
            return;
        }
        Set indexedPropertyNames = index.getIndexedPropertyNames();
        if (indexedPropertyNames.size() == 1) {
            String propName = (String)indexedPropertyNames.iterator().next();
            BeanTableIndex singleIndex = (BeanTableIndex)this.singleIndexMap.get(propName);
            if (singleIndex.getLinkedIndexSet().size() == 0) {
                this.singleIndexMap.remove(propName);
            } else {
                singleIndex.setName(null);
            }
        } else {
            this.complexIndexMap.remove(indexedPropertyNames);
            for (String propName : indexedPropertyNames) {
                BeanTableIndex singleIndex = (BeanTableIndex)this.singleIndexMap.get(propName);
                singleIndex.removeLinkedIndex(name);
                if (singleIndex.getName() != null || singleIndex.getLinkedIndexSet().size() != 0) continue;
                this.singleIndexMap.remove(propName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanTableIndex getIndex(String name) {
        if (this.isSynchronized) {
            BeanTableIndexManager beanTableIndexManager = this;
            synchronized (beanTableIndexManager) {
                return this.getIndexInternal(name);
            }
        }
        return this.getIndexInternal(name);
    }

    protected BeanTableIndex getIndexInternal(String name) {
        return (BeanTableIndex)this.nameIndexMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanTableIndex getIndexBy(String[] propNames) {
        if (this.isSynchronized) {
            BeanTableIndexManager beanTableIndexManager = this;
            synchronized (beanTableIndexManager) {
                return this.getIndexByInternal(propNames);
            }
        }
        return this.getIndexByInternal(propNames);
    }

    protected BeanTableIndex getIndexByInternal(String[] propNames) {
        if (propNames.length == 1) {
            return (BeanTableIndex)this.singleIndexMap.get(propNames[0]);
        }
        HashSet<String> keys = new HashSet<String>(5);
        for (int i = 0; i < propNames.length; ++i) {
            keys.add(propNames[i]);
        }
        return (BeanTableIndex)this.complexIndexMap.get(keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanTableIndex getIndexBy(Set propNames) {
        if (this.isSynchronized) {
            BeanTableIndexManager beanTableIndexManager = this;
            synchronized (beanTableIndexManager) {
                return this.getIndexByInternal(propNames);
            }
        }
        return this.getIndexByInternal(propNames);
    }

    protected BeanTableIndex getIndexByInternal(Set propNames) {
        if (propNames.size() == 1) {
            return (BeanTableIndex)this.singleIndexMap.get(propNames.iterator().next());
        }
        return (BeanTableIndex)this.complexIndexMap.get(propNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object element) throws IndexPropertyAccessException {
        if (this.isSynchronized) {
            BeanTableIndexManager beanTableIndexManager = this;
            synchronized (beanTableIndexManager) {
                return this.addInternal(element);
            }
        }
        return this.addInternal(element);
    }

    protected boolean addInternal(Object element) throws IndexPropertyAccessException {
        if (!this.valueSet.add(element)) {
            return false;
        }
        for (BeanTableIndex index : this.singleIndexMap.values()) {
            index.add(element);
        }
        for (BeanTableIndex index : this.complexIndexMap.values()) {
            index.add(element);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object element) throws IndexPropertyAccessException {
        if (this.isSynchronized) {
            BeanTableIndexManager beanTableIndexManager = this;
            synchronized (beanTableIndexManager) {
                this.removeInternal(element);
            }
        } else {
            this.removeInternal(element);
        }
    }

    protected void removeInternal(Object element) throws IndexPropertyAccessException {
        for (BeanTableIndex index : this.singleIndexMap.values()) {
            index.remove(element);
        }
        for (BeanTableIndex index : this.complexIndexMap.values()) {
            index.remove(element);
        }
        this.valueSet.remove(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(Object oldElement, Object newElement) throws IndexPropertyAccessException {
        if (this.isSynchronized) {
            BeanTableIndexManager beanTableIndexManager = this;
            synchronized (beanTableIndexManager) {
                this.replaceInternal(oldElement, newElement);
            }
        } else {
            this.replaceInternal(oldElement, newElement);
        }
    }

    protected void replaceInternal(Object oldElement, Object newElement) throws IndexPropertyAccessException {
        for (BeanTableIndex index : this.singleIndexMap.values()) {
            index.replace(oldElement, newElement);
        }
        for (BeanTableIndex index : this.complexIndexMap.values()) {
            index.replace(oldElement, newElement);
        }
        this.valueSet.remove(oldElement);
        this.valueSet.add(newElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection c) {
        if (this.isSynchronized) {
            BeanTableIndexManager beanTableIndexManager = this;
            synchronized (beanTableIndexManager) {
                return this.addAllInternal(c);
            }
        }
        return this.addAllInternal(c);
    }

    protected boolean addAllInternal(Collection c) {
        boolean modify = false;
        for (Object element : c) {
            if (!this.valueSet.add(element)) continue;
            for (BeanTableIndex index : this.singleIndexMap.values()) {
                index.add(element);
            }
            for (BeanTableIndex index : this.complexIndexMap.values()) {
                index.add(element);
            }
            modify |= true;
        }
        return modify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retainAll(Collection c) {
        if (this.isSynchronized) {
            BeanTableIndexManager beanTableIndexManager = this;
            synchronized (beanTableIndexManager) {
                this.retainAllInternal(c);
            }
        } else {
            this.retainAllInternal(c);
        }
    }

    protected void retainAllInternal(Collection c) {
        Iterator elements = this.valueSet.iterator();
        while (elements.hasNext()) {
            Object element = elements.next();
            if (c.contains(element)) continue;
            for (BeanTableIndex index : this.singleIndexMap.values()) {
                index.remove(element);
            }
            for (BeanTableIndex index : this.complexIndexMap.values()) {
                index.remove(element);
            }
            elements.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.isSynchronized) {
            BeanTableIndexManager beanTableIndexManager = this;
            synchronized (beanTableIndexManager) {
                this.clearInternal();
            }
        } else {
            this.clearInternal();
        }
    }

    protected void clearInternal() {
        for (BeanTableIndex index : this.singleIndexMap.values()) {
            index.clear();
        }
        for (BeanTableIndex index : this.complexIndexMap.values()) {
            index.clear();
        }
        this.valueSet.clear();
    }

    public Set elements() {
        return this.elements(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set elements(Set result) {
        if (this.isSynchronized) {
            BeanTableIndexManager beanTableIndexManager = this;
            synchronized (beanTableIndexManager) {
                return this.elementsInternal(result);
            }
        }
        return this.elementsInternal(result);
    }

    protected Set elementsInternal(Set result) {
        if (result == null) {
            result = new HashSet();
        }
        result.addAll(this.valueSet);
        return result;
    }

    public Set searchNull(String indexName, String propName) throws IndexNotFoundException {
        return this.searchNull(null, indexName, propName);
    }

    public Set searchNull(Set result, String indexName, String propName) throws IndexNotFoundException {
        BeanTableIndex index;
        BeanTableIndex beanTableIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchNull(result);
    }

    public Set searchNotNull(String indexName, String propName) throws IndexNotFoundException {
        return this.searchNotNull(null, indexName, propName);
    }

    public Set searchNotNull(Set result, String indexName, String propName) throws IndexNotFoundException {
        BeanTableIndex index;
        BeanTableIndex beanTableIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchNotNull(result);
    }

    public Set searchKeyElement(String indexName, String[] propNames) throws IndexNotFoundException {
        return this.searchKeyElement(null, indexName, propNames);
    }

    public Set searchKeyElement(Set result, String indexName, String[] propNames) throws IndexNotFoundException {
        BeanTableIndex index;
        BeanTableIndex beanTableIndex = index = indexName == null ? this.getIndexBy(propNames) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchKeyElement(result);
    }

    public Object searchByPrimaryElement(Object element, String indexName, String[] propNames) throws IndexNotFoundException, IndexPropertyAccessException {
        BeanTableIndex index;
        BeanTableIndex beanTableIndex = index = indexName == null ? this.getIndexBy(propNames) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchByPrimaryElement(element);
    }

    public Set searchByElement(Object element, String indexName, String[] propNames) throws IndexNotFoundException, IndexPropertyAccessException {
        return this.searchByElement(null, element, indexName, propNames);
    }

    public Set searchByElement(Set result, Object element, String indexName, String[] propNames) throws IndexNotFoundException, IndexPropertyAccessException {
        BeanTableIndex index;
        BeanTableIndex beanTableIndex = index = indexName == null ? this.getIndexBy(propNames) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchByElement(element, result);
    }

    public Set searchInElement(String indexName, String[] propNames, Object[] elements) throws IndexNotFoundException, IndexPropertyAccessException {
        return this.searchInElement(null, indexName, propNames, elements);
    }

    public Set searchInElement(Set result, String indexName, String[] propNames, Object[] elements) throws IndexNotFoundException, IndexPropertyAccessException {
        BeanTableIndex index;
        BeanTableIndex beanTableIndex = index = indexName == null ? this.getIndexBy(propNames) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchInElement(result, elements);
    }

    public Set searchBy(Object value, String indexName, String propName) {
        return this.searchBy(null, value, indexName, propName);
    }

    public Set searchBy(Set result, Object value, String indexName, String propName) {
        BeanTableIndex index;
        BeanTableIndex beanTableIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchBy(value, result);
    }

    public Set searchIn(String indexName, String propName, Object[] values) {
        return this.searchIn(null, indexName, propName, values);
    }

    public Set searchIn(Set result, String indexName, String propName, Object[] values) {
        BeanTableIndex index;
        BeanTableIndex beanTableIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchIn(result, values);
    }

    public Set searchBy(Map keys, String indexName) throws IndexNotFoundException, IllegalArgumentException {
        return this.searchBy(null, keys, indexName);
    }

    public Set searchBy(Set result, Map keys, String indexName) throws IndexNotFoundException, IllegalArgumentException {
        BeanTableIndex index;
        BeanTableIndex beanTableIndex = index = indexName == null ? this.getIndexBy(keys.keySet()) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchBy(keys, result);
    }

    public Set searchIn(String indexName, Map[] keys) throws IndexNotFoundException, IllegalArgumentException {
        return this.searchIn((Set)null, indexName, keys);
    }

    public Set searchIn(Set result, String indexName, Map[] keys) throws IndexNotFoundException, IllegalArgumentException {
        BeanTableIndex index;
        BeanTableIndex beanTableIndex = index = indexName == null ? this.getIndexBy(keys[0].keySet()) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchIn(result, keys);
    }

    public Set searchFromElement(Object from, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        return this.searchFromElement(null, from, indexName, propName);
    }

    public Set searchFromElement(Set result, Object from, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        BeanTableIndex index;
        BeanTableIndex beanTableIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchFromElement(from, result);
    }

    public Set searchFrom(Object from, String indexName, String propName) throws IndexNotFoundException {
        return this.searchFrom(null, from, indexName, propName);
    }

    public Set searchFrom(Set result, Object from, String indexName, String propName) throws IndexNotFoundException {
        BeanTableIndex index;
        BeanTableIndex beanTableIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchFrom(from, result);
    }

    public Set searchToElement(Object to, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        return this.searchToElement(null, to, indexName, propName);
    }

    public Set searchToElement(Set result, Object to, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        BeanTableIndex index;
        BeanTableIndex beanTableIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchToElement(to, result);
    }

    public Set searchTo(Object to, String indexName, String propName) throws IndexNotFoundException {
        return this.searchTo(null, to, indexName, propName);
    }

    public Set searchTo(Set result, Object to, String indexName, String propName) throws IndexNotFoundException {
        BeanTableIndex index;
        BeanTableIndex beanTableIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchTo(to, result);
    }

    public Set searchRangeElement(Object from, Object to, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        return this.searchRangeElement(null, from, to, indexName, propName);
    }

    public Set searchRangeElement(Set result, Object from, Object to, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        BeanTableIndex index;
        BeanTableIndex beanTableIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchRangeElement(from, to, result);
    }

    public Set searchRange(Object from, Object to, String indexName, String propName) throws IndexNotFoundException {
        return this.searchRange(null, from, to, indexName, propName);
    }

    public Set searchRange(Set result, Object from, Object to, String indexName, String propName) throws IndexNotFoundException {
        BeanTableIndex index;
        BeanTableIndex beanTableIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchRange(from, to, result);
    }

    public Set searchFromElement(Object from, boolean inclusive, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        return this.searchFromElement(null, from, inclusive, indexName, propName);
    }

    public Set searchFromElement(Set result, Object from, boolean inclusive, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        BeanTableIndex index;
        BeanTableIndex beanTableIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchFromElement(from, inclusive, result);
    }

    public Set searchFrom(Object from, boolean inclusive, String indexName, String propName) throws IndexNotFoundException {
        return this.searchFrom(null, from, inclusive, indexName, propName);
    }

    public Set searchFrom(Set result, Object from, boolean inclusive, String indexName, String propName) throws IndexNotFoundException {
        BeanTableIndex index;
        BeanTableIndex beanTableIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchFrom(from, inclusive, result);
    }

    public Set searchToElement(Object to, boolean inclusive, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        return this.searchToElement(null, to, inclusive, indexName, propName);
    }

    public Set searchToElement(Set result, Object to, boolean inclusive, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        BeanTableIndex index;
        BeanTableIndex beanTableIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchToElement(to, inclusive, result);
    }

    public Set searchTo(Object to, boolean inclusive, String indexName, String propName) throws IndexNotFoundException {
        return this.searchTo(null, to, inclusive, indexName, propName);
    }

    public Set searchTo(Set result, Object to, boolean inclusive, String indexName, String propName) throws IndexNotFoundException {
        BeanTableIndex index;
        BeanTableIndex beanTableIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchTo(to, inclusive, result);
    }

    public Set searchRangeElement(Object from, boolean fromInclusive, Object to, boolean toInclusive, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        return this.searchRangeElement(null, from, fromInclusive, to, toInclusive, indexName, propName);
    }

    public Set searchRangeElement(Set result, Object from, boolean fromInclusive, Object to, boolean toInclusive, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        BeanTableIndex index;
        BeanTableIndex beanTableIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchRangeElement(from, fromInclusive, to, toInclusive, result);
    }

    public Set searchRange(Object from, boolean fromInclusive, Object to, boolean toInclusive, String indexName, String propName) throws IndexNotFoundException {
        return this.searchRange(null, from, fromInclusive, to, toInclusive, indexName, propName);
    }

    public Set searchRange(Set result, Object from, boolean fromInclusive, Object to, boolean toInclusive, String indexName, String propName) throws IndexNotFoundException {
        BeanTableIndex index;
        BeanTableIndex beanTableIndex = index = indexName == null ? this.getIndexBy(new String[]{propName}) : this.getIndex(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.searchRange(from, fromInclusive, to, toInclusive, result);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal(out, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out, boolean writeValue) throws IOException {
        out.writeObject(this.elementClass);
        out.writeBoolean(this.isSynchronized);
        if (this.isSynchronized) {
            BeanTableIndexManager beanTableIndexManager = this;
            synchronized (beanTableIndexManager) {
                out.writeInt(this.nameIndexMap.size());
                for (BeanTableIndex beanTableIndex : this.nameIndexMap.values()) {
                    beanTableIndex.writeExternal(out, writeValue);
                }
                out.writeInt(this.singleIndexMap.size());
                for (Map.Entry entry : this.singleIndexMap.entrySet()) {
                    out.writeObject(entry.getKey());
                    ((BeanTableIndex)entry.getValue()).writeExternal(out, writeValue);
                }
                out.writeInt(this.complexIndexMap.size());
                for (Map.Entry entry : this.complexIndexMap.entrySet()) {
                    out.writeObject(entry.getKey());
                    ((BeanTableIndex)entry.getValue()).writeExternal(out, writeValue);
                }
                if (writeValue) {
                    out.writeObject(this.valueSet);
                }
            }
        } else {
            out.writeInt(this.nameIndexMap.size());
            for (BeanTableIndex beanTableIndex : this.nameIndexMap.values()) {
                beanTableIndex.writeExternal(out, writeValue);
            }
            out.writeInt(this.singleIndexMap.size());
            for (Map.Entry entry : this.singleIndexMap.entrySet()) {
                out.writeObject(entry.getKey());
                ((BeanTableIndex)entry.getValue()).writeExternal(out, writeValue);
            }
            out.writeInt(this.complexIndexMap.size());
            for (Map.Entry entry : this.complexIndexMap.entrySet()) {
                out.writeObject(entry.getKey());
                ((BeanTableIndex)entry.getValue()).writeExternal(out, writeValue);
            }
            if (writeValue) {
                out.writeObject(this.valueSet);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in, true);
    }

    public void readExternal(ObjectInput in, boolean readValue) throws IOException, ClassNotFoundException {
        BeanTableIndex index;
        int i;
        this.elementClass = (Class)in.readObject();
        this.isSynchronized = in.readBoolean();
        this.nameIndexMap = new HashMap();
        int size = in.readInt();
        for (i = 0; i < size; ++i) {
            index = new BeanTableIndex();
            index.readExternal(in, readValue);
            this.nameIndexMap.put(index.getName(), index);
        }
        this.singleIndexMap = new HashMap();
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            index = new BeanTableIndex();
            String propName = (String)in.readObject();
            index.readExternal(in, readValue);
            this.singleIndexMap.put(propName, index);
        }
        this.complexIndexMap = new HashMap();
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            index = new BeanTableIndex();
            Set propNames = (Set)in.readObject();
            index.readExternal(in, readValue);
            this.complexIndexMap.put(propNames, index);
        }
        this.valueSet = readValue ? (HashSet)in.readObject() : new HashSet();
    }

    public BeanTableIndexManager cloneEmpty(boolean isSynchronized) {
        BeanTableIndexManager clone = null;
        try {
            clone = (BeanTableIndexManager)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        clone.isSynchronized = isSynchronized;
        clone.nameIndexMap = new HashMap();
        clone.singleIndexMap = new HashMap();
        clone.complexIndexMap = new HashMap();
        try {
            for (Map.Entry entry : this.nameIndexMap.entrySet()) {
                clone.setIndexInternal((String)entry.getKey(), ((BeanTableIndex)entry.getValue()).cloneEmpty(isSynchronized), true);
            }
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
        clone.valueSet = new HashSet();
        return clone;
    }
}

