/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.beans.BeanTableIndexKeyFactory;
import jp.ossc.nimbus.beans.IndexPropertyAccessException;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.SimpleProperty;

public class ConcatenateIndexKeyFactory
implements BeanTableIndexKeyFactory,
Externalizable {
    protected Property[] properties;
    protected Set propertyNames;

    public ConcatenateIndexKeyFactory() {
    }

    public ConcatenateIndexKeyFactory(Class elementClass, String aliasName, String[] propNames) throws NoSuchPropertyException {
        this.properties = new Property[propNames.length];
        for (int i = 0; i < propNames.length; ++i) {
            SimpleProperty prop = new SimpleProperty(propNames[i]);
            if (!prop.isReadable(elementClass)) {
                throw new NoSuchPropertyException(elementClass, propNames[i]);
            }
            this.properties[i] = prop;
        }
        this.propertyNames = new HashSet();
        this.propertyNames.add(aliasName);
    }

    @Override
    public Set getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public Object createIndexKey(Object element) throws IndexPropertyAccessException {
        StringBuffer indexKey = new StringBuffer();
        String propertyName = null;
        try {
            for (int i = 0; i < this.properties.length; ++i) {
                Property property = this.properties[i];
                propertyName = property.getPropertyName();
                Object prop = property.getProperty(element);
                indexKey.append(prop);
            }
        }
        catch (NoSuchPropertyException e) {
            throw new IndexPropertyAccessException(element.getClass(), propertyName, e);
        }
        catch (InvocationTargetException e) {
            throw new IndexPropertyAccessException(element.getClass(), propertyName, e.getTargetException());
        }
        return indexKey.toString();
    }

    @Override
    public Object createIndexKeyByProperties(Map keys) throws IllegalArgumentException {
        String aliasName = (String)this.propertyNames.iterator().next();
        if (keys.containsKey(aliasName)) {
            return keys.get(aliasName);
        }
        StringBuffer indexKey = new StringBuffer();
        for (int i = 0; i < this.properties.length; ++i) {
            Property property = this.properties[i];
            if (!keys.containsKey(property.getPropertyName())) {
                throw new IllegalArgumentException("keys are insufficient. keys=" + keys);
            }
            indexKey.append(keys.get(property.getPropertyName()));
        }
        return indexKey.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.properties == null ? 0 : this.properties.length);
        if (this.properties != null) {
            for (int i = 0; i < this.properties.length; ++i) {
                Property property = this.properties[i];
                out.writeObject(property.getPropertyName());
            }
        }
        out.writeObject(this.propertyNames.iterator().next());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String aliasName;
        int len = in.readInt();
        if (len > 0) {
            this.properties = new Property[len];
            for (int i = 0; i < len; ++i) {
                this.properties[i] = new SimpleProperty((String)in.readObject());
            }
        }
        if ((aliasName = (String)in.readObject()) != null) {
            this.propertyNames = new HashSet();
            this.propertyNames.add(aliasName);
        }
    }
}

