/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import jp.ossc.nimbus.beans.Utility;

public class IntEditor
extends PropertyEditorSupport
implements Serializable {
    private static final long serialVersionUID = -3196165392819498738L;

    @Override
    public void setAsText(String text) {
        if (text == null) {
            this.setValue(null);
            return;
        }
        this.setValue(new Integer(IntEditor.toInt(text, true)));
    }

    public static final int toInt(String text, boolean replace) throws NumberFormatException {
        String str = replace ? Utility.replaceSystemProperty(text) : text;
        int intValue = 0;
        try {
            intValue = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            if ("MAX_VALUE".equals(str)) {
                intValue = Integer.MAX_VALUE;
            }
            if ("MIN_VALUE".equals(str)) {
                intValue = Integer.MIN_VALUE;
            }
            int index = str.lastIndexOf(".");
            if (index > 0 && index != str.length() - 1) {
                String className = str.substring(0, index);
                String fieldName = str.substring(index + 1);
                try {
                    Class clazz = Utility.convertStringToClass(className);
                    intValue = clazz.getField(fieldName).getInt(null);
                }
                catch (ClassNotFoundException e2) {
                    throw e;
                }
                catch (NoSuchFieldException e2) {
                    throw e;
                }
                catch (SecurityException e2) {
                    throw e;
                }
                catch (IllegalArgumentException e2) {
                    throw e;
                }
                catch (IllegalAccessException e2) {
                    throw e;
                }
            }
            throw e;
        }
        return intValue;
    }

    @Override
    public String getAsText() {
        Integer val = (Integer)this.getValue();
        return val == null ? null : val.toString();
    }
}

