/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.beans.BeanTableIndexKeyFactory;
import jp.ossc.nimbus.beans.IndexPropertyAccessException;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.SimpleProperty;

public class SubstringIndexKeyFactory
implements BeanTableIndexKeyFactory,
Externalizable {
    protected Property property;
    protected Set propertyNames;
    protected int beginIndex;
    protected int endIndex;
    protected boolean reverse;

    public SubstringIndexKeyFactory() {
    }

    public SubstringIndexKeyFactory(Class elementClass, String propName, String aliasName, int beginIndex) throws NoSuchPropertyException, IllegalArgumentException {
        this(elementClass, propName, aliasName, beginIndex, -1);
    }

    public SubstringIndexKeyFactory(Class elementClass, String propName, String aliasName, int beginIndex, int endIndex) throws NoSuchPropertyException, IllegalArgumentException {
        this(elementClass, propName, aliasName, beginIndex, endIndex, false);
    }

    public SubstringIndexKeyFactory(Class elementClass, String propName, String aliasName, int beginIndex, int endIndex, boolean reverse) throws NoSuchPropertyException, IllegalArgumentException {
        if (beginIndex < 0) {
            throw new IllegalArgumentException("beginIndex >= 0 : " + beginIndex);
        }
        if (endIndex == 0) {
            throw new IllegalArgumentException("endIndex != 0 : " + endIndex);
        }
        if (endIndex > 0 && beginIndex >= endIndex) {
            throw new IllegalArgumentException("beginIndex < endIndex : beginIndex=" + beginIndex + ", endIndex=" + endIndex);
        }
        SimpleProperty prop = new SimpleProperty(propName);
        if (!prop.isReadable(elementClass)) {
            throw new NoSuchPropertyException(elementClass, propName);
        }
        this.property = prop;
        this.propertyNames = new HashSet();
        this.propertyNames.add(aliasName);
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.reverse = reverse;
    }

    @Override
    public Set getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public Object createIndexKey(Object element) throws IndexPropertyAccessException {
        String strProp = null;
        try {
            Object prop = this.property.getProperty(element);
            if (prop == null) {
                return null;
            }
            if (!(prop instanceof String)) {
                throw new IndexPropertyAccessException(prop.getClass(), this.property.getPropertyName(), "Type is not String. type=" + prop.getClass().getName());
            }
            strProp = (String)prop;
        }
        catch (NoSuchPropertyException e) {
            throw new IndexPropertyAccessException(element.getClass(), this.property.getPropertyName(), e);
        }
        catch (InvocationTargetException e) {
            throw new IndexPropertyAccessException(element.getClass(), this.property.getPropertyName(), e.getTargetException());
        }
        return this.substring(strProp);
    }

    protected String substring(String str) {
        int len = str.length();
        if (len == 0) {
            return str;
        }
        if (this.beginIndex > len) {
            return "";
        }
        if (this.reverse) {
            if (this.endIndex > 0) {
                return str.substring(this.endIndex > len ? 0 : len - this.endIndex, len - this.beginIndex);
            }
            return str.substring(0, len - this.beginIndex);
        }
        if (this.endIndex > 0) {
            return str.substring(this.beginIndex, this.endIndex > len ? len : this.endIndex);
        }
        return str.substring(this.beginIndex);
    }

    @Override
    public Object createIndexKeyByProperties(Map keys) throws IllegalArgumentException {
        String aliasName = (String)this.propertyNames.iterator().next();
        if (keys.containsKey(aliasName)) {
            return keys.get(aliasName);
        }
        if (keys.containsKey(this.property.getPropertyName())) {
            Object prop = keys.get(this.property.getPropertyName());
            if (prop == null) {
                return null;
            }
            if (!(prop instanceof String)) {
                throw new IllegalArgumentException("Type is not String. type=" + prop.getClass().getName());
            }
            return this.substring((String)prop);
        }
        throw new IllegalArgumentException("keys are insufficient. keys=" + keys);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.property.getPropertyName());
        out.writeObject(this.propertyNames.iterator().next());
        out.writeInt(this.beginIndex);
        out.writeInt(this.endIndex);
        out.writeBoolean(this.reverse);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String aliasName;
        String propertyName = (String)in.readObject();
        if (propertyName != null) {
            this.property = new SimpleProperty(propertyName);
        }
        if ((aliasName = (String)in.readObject()) != null) {
            this.propertyNames = new HashSet();
            this.propertyNames.add(aliasName);
        }
        this.beginIndex = in.readInt();
        this.endIndex = in.readInt();
        this.reverse = in.readBoolean();
    }
}

