/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.File;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import jp.ossc.nimbus.core.ManagerMetaData;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServerMetaData;
import jp.ossc.nimbus.core.ServiceLoaderConfig;
import jp.ossc.nimbus.core.ServiceManager;
import jp.ossc.nimbus.core.ServiceManagerFactory;

public class Utility {
    public static final String SYSTEM_PROPERTY_START = "${";
    public static final String SYSTEM_PROPERTY_END = "}";
    private static final String DEFAULT_SERVICE_FILE_PROPERTY_KEY = "jp.ossc.nimbus.service.url";
    private static final String DEFAULT_SERVICE_FILE = "nimbus-service.xml";
    private static final String ARRAY_CLASS_SUFFIX = "[]";

    public static URL getDefaultServiceURL() {
        String urlString = System.getProperty(DEFAULT_SERVICE_FILE_PROPERTY_KEY);
        URL url = null;
        if (urlString != null) {
            try {
                url = Utility.convertServicePathToURL(urlString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (url != null) {
                return url;
            }
        }
        url = Utility.class.getClassLoader().getResource(DEFAULT_SERVICE_FILE);
        return url;
    }

    public static URL convertServicePathToURL(String path) throws IllegalArgumentException {
        if (path == null || path.length() == 0) {
            return Utility.getDefaultServiceURL();
        }
        URL url = null;
        File localFile = new File(path);
        if (localFile.exists()) {
            if (!localFile.isFile()) {
                throw new IllegalArgumentException("ServicePath must be file : " + localFile);
            }
            try {
                url = localFile.toURL();
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL resource = classLoader.getResource(path);
            if (resource != null) {
                url = resource;
            }
        }
        if (url == null) {
            throw new IllegalArgumentException("ServicePath not found : " + path);
        }
        return url;
    }

    public static String replaceSystemProperty(String str) {
        String result = str;
        if (result == null) {
            return null;
        }
        int startIndex = result.indexOf(SYSTEM_PROPERTY_START);
        if (startIndex == -1) {
            return result;
        }
        int endIndex = result.indexOf(SYSTEM_PROPERTY_END, startIndex);
        if (endIndex == -1) {
            return result;
        }
        String propStr = result.substring(startIndex + SYSTEM_PROPERTY_START.length(), endIndex);
        String prop = null;
        if (propStr != null && propStr.length() != 0) {
            prop = System.getProperty(propStr);
        }
        if (prop == null) {
            return result.substring(0, endIndex + SYSTEM_PROPERTY_END.length()) + Utility.replaceSystemProperty(result.substring(endIndex + SYSTEM_PROPERTY_END.length()));
        }
        if ((result = result.substring(0, startIndex) + prop + result.substring(endIndex + SYSTEM_PROPERTY_END.length())).indexOf(SYSTEM_PROPERTY_START) != -1) {
            return Utility.replaceSystemProperty(result);
        }
        return result;
    }

    public static String replaceManagerProperty(ServiceManager manager, String str) {
        String result = str;
        if (result == null) {
            return null;
        }
        int startIndex = result.indexOf(SYSTEM_PROPERTY_START);
        if (startIndex == -1) {
            return result;
        }
        int endIndex = result.indexOf(SYSTEM_PROPERTY_END, startIndex);
        if (endIndex == -1) {
            return result;
        }
        String propStr = result.substring(startIndex + SYSTEM_PROPERTY_START.length(), endIndex);
        String prop = null;
        if (propStr != null && propStr.length() != 0) {
            prop = manager.getProperty(propStr);
        }
        if (prop == null) {
            return result.substring(0, endIndex + SYSTEM_PROPERTY_END.length()) + Utility.replaceManagerProperty(manager, result.substring(endIndex + SYSTEM_PROPERTY_END.length()));
        }
        if ((result = result.substring(0, startIndex) + prop + result.substring(endIndex + SYSTEM_PROPERTY_END.length())).indexOf(SYSTEM_PROPERTY_START) != -1) {
            return Utility.replaceManagerProperty(manager, result);
        }
        return result;
    }

    public static String replaceManagerProperty(ManagerMetaData manager, String str) {
        String result = str;
        if (result == null) {
            return null;
        }
        int startIndex = result.indexOf(SYSTEM_PROPERTY_START);
        if (startIndex == -1) {
            return result;
        }
        int endIndex = result.indexOf(SYSTEM_PROPERTY_END, startIndex);
        if (endIndex == -1) {
            return result;
        }
        String propStr = result.substring(startIndex + SYSTEM_PROPERTY_START.length(), endIndex);
        String prop = null;
        if (propStr != null && propStr.length() != 0) {
            prop = manager.getProperty(propStr);
        }
        if (prop == null) {
            return result.substring(0, endIndex + SYSTEM_PROPERTY_END.length()) + Utility.replaceManagerProperty(manager, result.substring(endIndex + SYSTEM_PROPERTY_END.length()));
        }
        if ((result = result.substring(0, startIndex) + prop + result.substring(endIndex + SYSTEM_PROPERTY_END.length())).indexOf(SYSTEM_PROPERTY_START) != -1) {
            return Utility.replaceManagerProperty(manager, result);
        }
        return result;
    }

    public static String replaceServiceLoderConfig(String str, ServiceLoaderConfig config) {
        if (config == null) {
            return str;
        }
        String result = str;
        if (result == null) {
            return null;
        }
        int startIndex = result.indexOf(SYSTEM_PROPERTY_START);
        if (startIndex == -1) {
            return result;
        }
        int endIndex = result.indexOf(SYSTEM_PROPERTY_END, startIndex);
        if (endIndex == -1) {
            return result;
        }
        String propStr = result.substring(startIndex + SYSTEM_PROPERTY_START.length(), endIndex);
        String prop = null;
        if (propStr != null && propStr.length() != 0) {
            prop = config.getProperty(propStr);
        }
        if (prop == null) {
            return result.substring(0, endIndex + SYSTEM_PROPERTY_END.length()) + Utility.replaceServiceLoderConfig(result.substring(endIndex + SYSTEM_PROPERTY_END.length()), config);
        }
        if ((result = result.substring(0, startIndex) + prop + result.substring(endIndex + SYSTEM_PROPERTY_END.length())).indexOf(SYSTEM_PROPERTY_START) != -1) {
            return Utility.replaceServiceLoderConfig(result, config);
        }
        return result;
    }

    public static String replaceServerProperty(String str) {
        String result = str;
        if (result == null) {
            return null;
        }
        int startIndex = result.indexOf(SYSTEM_PROPERTY_START);
        if (startIndex == -1) {
            return result;
        }
        int endIndex = result.indexOf(SYSTEM_PROPERTY_END, startIndex);
        if (endIndex == -1) {
            return result;
        }
        String propStr = result.substring(startIndex + SYSTEM_PROPERTY_START.length(), endIndex);
        String prop = null;
        if (propStr != null && propStr.length() != 0) {
            prop = ServiceManagerFactory.getProperty(propStr);
        }
        if (prop == null) {
            return result.substring(0, endIndex + SYSTEM_PROPERTY_END.length()) + Utility.replaceServerProperty(result.substring(endIndex + SYSTEM_PROPERTY_END.length()));
        }
        if ((result = result.substring(0, startIndex) + prop + result.substring(endIndex + SYSTEM_PROPERTY_END.length())).indexOf(SYSTEM_PROPERTY_START) != -1) {
            return Utility.replaceServerProperty(result);
        }
        return result;
    }

    public static String getProperty(String name, ServiceLoaderConfig config, ServiceManager manager, MetaData metaData) {
        String prop = System.getProperty(name);
        if (prop != null) {
            return prop;
        }
        if (config != null && (prop = config.getProperty(name)) != null) {
            return prop;
        }
        if (manager != null && (prop = manager.getProperty(name)) != null) {
            return prop;
        }
        if (metaData != null) {
            ServerMetaData serverData = null;
            ManagerMetaData mngData = null;
            MetaData parent = metaData;
            while (parent != null) {
                if (mngData == null && parent instanceof ManagerMetaData) {
                    mngData = (ManagerMetaData)parent;
                } else if (serverData == null && parent instanceof ServerMetaData) {
                    serverData = (ServerMetaData)parent;
                    break;
                }
                if ((parent = parent.getParent()) != null) continue;
            }
            if (mngData != null && (prop = mngData.getProperty(name)) != null) {
                return prop;
            }
            if (serverData != null && (prop = serverData.getProperty(name)) != null) {
                return prop;
            }
        }
        return ServiceManagerFactory.getProperty(name);
    }

    public static Class convertStringToClass(String typeStr) throws ClassNotFoundException {
        return Utility.convertStringToClass(typeStr, false);
    }

    public static Class convertStringToClass(String typeStr, boolean isWrapp) throws ClassNotFoundException {
        Class type = null;
        if (typeStr != null) {
            if (Byte.TYPE.getName().equals(typeStr)) {
                type = isWrapp ? Byte.class : Byte.TYPE;
            } else if (Character.TYPE.getName().equals(typeStr)) {
                type = isWrapp ? Character.class : Character.TYPE;
            } else if (Short.TYPE.getName().equals(typeStr)) {
                type = isWrapp ? Short.class : Short.TYPE;
            } else if (Integer.TYPE.getName().equals(typeStr)) {
                type = isWrapp ? Integer.class : Integer.TYPE;
            } else if (Long.TYPE.getName().equals(typeStr)) {
                type = isWrapp ? Long.class : Long.TYPE;
            } else if (Float.TYPE.getName().equals(typeStr)) {
                type = isWrapp ? Float.class : Float.TYPE;
            } else if (Double.TYPE.getName().equals(typeStr)) {
                type = isWrapp ? Double.class : Double.TYPE;
            } else if (Boolean.TYPE.getName().equals(typeStr)) {
                type = isWrapp ? Boolean.class : Boolean.TYPE;
            } else if (typeStr.endsWith(ARRAY_CLASS_SUFFIX) && typeStr.length() > 2) {
                Class elementType = Utility.convertStringToClass(typeStr.substring(0, typeStr.length() - 2), false);
                type = Array.newInstance(elementType, 0).getClass();
            } else {
                type = Class.forName(typeStr, true, NimbusClassLoader.getInstance());
            }
        }
        return type;
    }
}

