/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import java.util.Locale;
import jp.ossc.nimbus.beans.NimbusPropertyEditorManager;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.ExceptionConsumeInterceptorServiceMBean;
import jp.ossc.nimbus.service.log.Logger;

public class ExceptionConsumeInterceptorService
extends ServiceBase
implements Interceptor,
ExceptionConsumeInterceptorServiceMBean {
    private static final long serialVersionUID = 5814164743760498457L;
    private String[] exceptionClassNames;
    private Class[] exceptionClasses;
    private ServiceName logServiceName;
    private Logger log;
    private String logKey;
    private String[] logArgs;
    private Locale logLocale;
    private Object returnValue;
    private boolean isLoggingException;

    @Override
    public void setExceptionClassNames(String[] classnames) {
        this.exceptionClassNames = classnames;
    }

    @Override
    public String[] getExceptionClassNames() {
        return this.exceptionClassNames;
    }

    @Override
    public void setReturnValue(Object val) {
        this.returnValue = val;
    }

    @Override
    public Object getReturnValue() {
        return this.returnValue;
    }

    @Override
    public void setLoggerServiceName(ServiceName name) {
        this.logServiceName = name;
    }

    @Override
    public ServiceName getLoggerServiceName() {
        return this.logServiceName;
    }

    @Override
    public void setLoggerMessageCode(String key) {
        this.logKey = key;
    }

    @Override
    public String getLoggerMessageCode() {
        return this.logKey;
    }

    @Override
    public void setLoggerMessageArgs(String[] args) {
        this.logArgs = args;
    }

    @Override
    public String[] getLoggerMessageArgs() {
        return this.logArgs;
    }

    @Override
    public void setLoggerMessageLocale(Locale locale) {
        this.logLocale = locale;
    }

    @Override
    public Locale getLoggerMessageLocale() {
        return this.logLocale;
    }

    @Override
    public void setLoggingException(boolean isLogging) {
        this.isLoggingException = isLogging;
    }

    @Override
    public boolean isLoggingException() {
        return this.isLoggingException;
    }

    public void setLoggerService(Logger log) {
        this.log = log;
    }

    @Override
    public void startService() throws Exception {
        if (this.logServiceName != null) {
            if (this.logKey == null) {
                throw new IllegalArgumentException("LoggerMessageCode is null.");
            }
            if (this.log == null) {
                this.log = (Logger)ServiceManagerFactory.getServiceObject(this.logServiceName);
            }
        }
        if (this.exceptionClassNames != null) {
            this.exceptionClasses = new Class[this.exceptionClassNames.length];
            NimbusClassLoader loader = NimbusClassLoader.getInstance();
            for (int i = 0; i < this.exceptionClassNames.length; ++i) {
                this.exceptionClasses[i] = Class.forName(this.exceptionClassNames[i], true, loader);
            }
        }
    }

    @Override
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3) {
            try {
                return chain.invokeNext(context);
            }
            catch (Throwable th) {
                if (this.exceptionClasses != null) {
                    Class<?> caught = th.getClass();
                    for (int i = 0; i < this.exceptionClasses.length; ++i) {
                        if (!this.exceptionClasses[i].isAssignableFrom(caught)) continue;
                        if (this.logKey != null) {
                            Logger logger;
                            Logger logger2 = logger = this.log == null ? this.getLogger() : this.log;
                            if (logger != null) {
                                logger.write(this.logLocale, this.logKey, this.logArgs, this.isLoggingException ? th : null);
                            }
                        }
                        return this.createReturnValue((MethodInvocationContext)context);
                    }
                }
                throw th;
            }
        }
        return chain.invokeNext(context);
    }

    private Object createReturnValue(MethodInvocationContext context) {
        if (this.returnValue == null) {
            return this.returnValue;
        }
        Method method = context.getTargetMethod();
        Class<?> retType = method.getReturnType();
        if (Void.TYPE.equals(retType)) {
            return null;
        }
        if (this.returnValue != null && retType.isInstance(this.returnValue)) {
            return this.returnValue;
        }
        ServiceLoader loader = null;
        try {
            ServiceMetaData data = ServiceManagerFactory.getServiceMetaData(this.getServiceNameObject());
            if (data != null) {
                loader = data.getServiceLoader();
            }
        }
        catch (ServiceNotFoundException data) {
            // empty catch block
        }
        PropertyEditor editor = null;
        editor = loader == null ? NimbusPropertyEditorManager.findEditor(retType) : loader.findEditor(retType);
        if (editor == null) {
            return null;
        }
        editor.setAsText(this.returnValue.toString());
        return editor.getValue();
    }
}

