/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jp.ossc.nimbus.beans.MethodEditor;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.PropertyAccess;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.TraceLoggingInterceptorServiceMBean;
import jp.ossc.nimbus.service.sequence.Sequence;

public class TraceLoggingInterceptorService
extends ServiceBase
implements Interceptor,
TraceLoggingInterceptorServiceMBean {
    private static final long serialVersionUID = -6275466936441558184L;
    private String requestMessageId = "TLIS_00001";
    private String responseMessageId = "TLIS_00002";
    private boolean isEnabled = true;
    private boolean isOutputRequestLog = true;
    private boolean isOutputResponseLog = false;
    private boolean isOutputTarget = true;
    private boolean isOutputMethod = true;
    private boolean isOutputParameter = false;
    private boolean isOutputCallStackTrace = false;
    private boolean isOutputReturn = true;
    private boolean isOutputThrowable = false;
    private boolean isOutputPerformance = false;
    private boolean isOutputTargetOnResponse = false;
    private boolean isOutputMethodOnResponse = false;
    private boolean isOutputParameterOnResponse = false;
    private String[] outputTargetProperties;
    private String[] outputParameterProperties;
    private String[] outputReturnProperties;
    private PropertyAccess propertyAccess;
    private ServiceName sequenceServiceName;
    private Sequence sequence;

    @Override
    public void setEnabled(boolean enable) {
        this.isEnabled = enable;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setRequestMessageId(String id) {
        this.requestMessageId = id;
    }

    @Override
    public String getRequestMessageId() {
        return this.requestMessageId;
    }

    @Override
    public void setResponseMessageId(String id) {
        this.responseMessageId = id;
    }

    @Override
    public String getResponseMessageId() {
        return this.responseMessageId;
    }

    @Override
    public void setOutputRequestLog(boolean isOutput) {
        this.isOutputRequestLog = isOutput;
    }

    @Override
    public boolean isOutputRequestLog() {
        return this.isOutputRequestLog;
    }

    @Override
    public void setOutputResponseLog(boolean isOutput) {
        this.isOutputResponseLog = isOutput;
    }

    @Override
    public boolean isOutputResponseLog() {
        return this.isOutputResponseLog;
    }

    @Override
    public void setOutputTarget(boolean isOutput) {
        this.isOutputTarget = isOutput;
    }

    @Override
    public boolean isOutputTarget() {
        return this.isOutputTarget;
    }

    @Override
    public void setOutputMethod(boolean isOutput) {
        this.isOutputMethod = isOutput;
    }

    @Override
    public boolean isOutputMethod() {
        return this.isOutputMethod;
    }

    @Override
    public void setOutputParameter(boolean isOutput) {
        this.isOutputParameter = isOutput;
    }

    @Override
    public boolean isOutputParameter() {
        return this.isOutputParameter;
    }

    @Override
    public void setOutputCallStackTrace(boolean isOutput) {
        this.isOutputCallStackTrace = isOutput;
    }

    @Override
    public boolean isOutputCallStackTrace() {
        return this.isOutputCallStackTrace;
    }

    @Override
    public void setOutputReturn(boolean isOutput) {
        this.isOutputReturn = isOutput;
    }

    @Override
    public boolean isOutputReturn() {
        return this.isOutputReturn;
    }

    @Override
    public void setOutputThrowable(boolean isOutput) {
        this.isOutputThrowable = isOutput;
    }

    @Override
    public boolean isOutputThrowable() {
        return this.isOutputThrowable;
    }

    @Override
    public void setOutputPerformance(boolean isOutput) {
        this.isOutputPerformance = isOutput;
    }

    @Override
    public boolean isOutputPerformance() {
        return this.isOutputPerformance;
    }

    @Override
    public void setOutputTargetOnResponse(boolean isOutput) {
        this.isOutputTargetOnResponse = isOutput;
    }

    @Override
    public boolean isOutputTargetOnResponse() {
        return this.isOutputTargetOnResponse;
    }

    @Override
    public void setOutputMethodOnResponse(boolean isOutput) {
        this.isOutputMethodOnResponse = isOutput;
    }

    @Override
    public boolean isOutputMethodOnResponse() {
        return this.isOutputMethodOnResponse;
    }

    @Override
    public void setOutputParameterOnResponse(boolean isOutput) {
        this.isOutputParameterOnResponse = isOutput;
    }

    @Override
    public boolean isOutputParameterOnResponse() {
        return this.isOutputParameterOnResponse;
    }

    @Override
    public void setOutputTargetProperties(String[] props) {
        this.outputTargetProperties = props;
    }

    @Override
    public String[] getOutputTargetProperties() {
        return this.outputTargetProperties;
    }

    @Override
    public void setOutputParameterProperties(String[] props) {
        this.outputParameterProperties = props;
    }

    @Override
    public String[] getOutputParameterProperties() {
        return this.outputParameterProperties;
    }

    @Override
    public void setOutputReturnProperties(String[] props) {
        this.outputReturnProperties = props;
    }

    @Override
    public String[] getOutputReturnProperties() {
        return this.outputReturnProperties;
    }

    @Override
    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    @Override
    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    @Override
    public void startService() throws Exception {
        if (this.outputParameterProperties != null && this.outputParameterProperties.length != 0 || this.outputReturnProperties != null && this.outputReturnProperties.length != 0 || this.outputTargetProperties != null && this.outputTargetProperties.length != 0) {
            this.propertyAccess = new PropertyAccess();
            this.propertyAccess.setIgnoreNullProperty(true);
        }
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
        }
    }

    @Override
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() != 3 || !this.isEnabled()) {
            return chain.invokeNext(context);
        }
        long start = System.currentTimeMillis();
        StringBuffer buf = null;
        StringBuffer targetBuf = null;
        StringBuffer methodBuf = null;
        StringBuffer parameterBuf = null;
        String sequenceId = null;
        if (this.sequence != null) {
            sequenceId = this.sequence.increment();
            if (buf == null) {
                buf = new StringBuffer();
            }
            buf.append(sequenceId);
        }
        if (this.isOutputTarget || this.isOutputTargetOnResponse) {
            targetBuf = new StringBuffer();
            Object target = context.getTargetObject();
            if (this.outputTargetProperties != null && this.outputTargetProperties.length != 0) {
                targetBuf.append('[');
                for (int i = 0; i < this.outputTargetProperties.length; ++i) {
                    Object prop = null;
                    try {
                        prop = this.propertyAccess.get(target, this.outputTargetProperties[i]);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (NoSuchPropertyException noSuchPropertyException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    this.printObject(targetBuf, prop);
                    if (i == this.outputTargetProperties.length - 1) continue;
                    targetBuf.append(',');
                }
                targetBuf.append(']');
            } else {
                this.printObject(targetBuf, target);
            }
            if (this.isOutputTarget) {
                if (buf == null) {
                    buf = new StringBuffer();
                } else {
                    buf.append(',');
                }
                buf.append(targetBuf);
            }
        }
        if (context instanceof MethodInvocationContext) {
            MethodInvocationContext methodContext = (MethodInvocationContext)context;
            if (this.isOutputMethod || this.isOutputMethodOnResponse) {
                methodBuf = new StringBuffer();
                Method method = methodContext.getTargetMethod();
                if (method != null) {
                    MethodEditor editor = new MethodEditor();
                    editor.setValue(method);
                    methodBuf.append(editor.getAsText());
                } else {
                    methodBuf.append("null");
                }
                if (this.isOutputMethod) {
                    if (buf == null) {
                        buf = new StringBuffer();
                    } else {
                        buf.append(',');
                    }
                    buf.append(methodBuf);
                }
            }
            if (this.isOutputParameter || this.isOutputParameterOnResponse) {
                parameterBuf = new StringBuffer();
                Object[] params = methodContext.getParameters();
                if (params != null) {
                    parameterBuf.append('[');
                    if (this.outputParameterProperties != null && this.outputParameterProperties.length != 0) {
                        for (int i = 0; i < this.outputParameterProperties.length; ++i) {
                            Object prop = null;
                            try {
                                prop = this.propertyAccess.get(params, this.outputParameterProperties[i]);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                            }
                            catch (NoSuchPropertyException noSuchPropertyException) {
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                // empty catch block
                            }
                            this.printObject(parameterBuf, prop);
                            if (i == this.outputParameterProperties.length - 1) continue;
                            parameterBuf.append(',');
                        }
                    } else {
                        this.printObject(parameterBuf, params);
                    }
                    parameterBuf.append(']');
                } else {
                    parameterBuf.append("null");
                }
                if (this.isOutputParameter) {
                    if (buf == null) {
                        buf = new StringBuffer();
                    } else {
                        buf.append(',');
                    }
                    buf.append(parameterBuf);
                }
            }
        }
        if (this.isOutputRequestLog && this.getLogger().isWrite(this.requestMessageId)) {
            if (this.isOutputCallStackTrace) {
                this.getLogger().write(this.requestMessageId, (Object)(buf == null ? "" : buf.toString()), (Throwable)new Exception("Call stack"));
            } else {
                this.getLogger().write(this.requestMessageId, (Object)(buf == null ? "" : buf.toString()));
            }
        }
        if (buf != null) {
            buf.setLength(0);
        }
        Throwable throwable = null;
        Object ret = null;
        try {
            Object i = ret = chain.invokeNext(context);
            return i;
        }
        catch (Throwable th) {
            throwable = th;
            throw th;
        }
        finally {
            long end = System.currentTimeMillis();
            if (this.isOutputResponseLog && this.getLogger().isWrite(this.responseMessageId)) {
                if (buf == null) {
                    buf = new StringBuffer();
                }
                if (sequenceId != null) {
                    buf.append(sequenceId);
                }
                if (this.isOutputTargetOnResponse) {
                    if (buf.length() != 0) {
                        buf.append(',');
                    }
                    buf.append(targetBuf);
                }
                if (this.isOutputMethodOnResponse) {
                    if (buf.length() != 0) {
                        buf.append(',');
                    }
                    buf.append(methodBuf);
                }
                if (this.isOutputParameterOnResponse) {
                    if (buf.length() != 0) {
                        buf.append(',');
                    }
                    buf.append(parameterBuf);
                }
                if (throwable == null && this.isOutputReturn) {
                    if (buf.length() != 0) {
                        buf.append(',');
                    }
                    if (this.outputReturnProperties != null && this.outputReturnProperties.length != 0) {
                        buf.append('[');
                        for (int i = 0; i < this.outputReturnProperties.length; ++i) {
                            Object prop = null;
                            try {
                                prop = this.propertyAccess.get(ret, this.outputReturnProperties[i]);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                            }
                            catch (NoSuchPropertyException noSuchPropertyException) {
                            }
                            catch (InvocationTargetException invocationTargetException) {}
                            this.printObject(buf, prop);
                            if (i == this.outputReturnProperties.length - 1) continue;
                            buf.append(',');
                        }
                        buf.append(']');
                    } else {
                        this.printObject(buf, ret);
                    }
                }
                if (this.isOutputPerformance) {
                    if (buf.length() != 0) {
                        buf.append(',');
                    }
                    buf.append(end - start);
                }
                if (throwable != null && this.isOutputThrowable) {
                    this.getLogger().write(this.responseMessageId, (Object)buf.toString(), throwable);
                } else {
                    this.getLogger().write(this.responseMessageId, (Object)buf.toString());
                }
            }
        }
    }

    private StringBuffer printObject(StringBuffer buf, Object value) {
        if (value == null) {
            buf.append(value);
        } else if (value.getClass().isArray()) {
            buf.append('[');
            int imax = Array.getLength(value);
            for (int i = 0; i < imax; ++i) {
                this.printObject(buf, Array.get(value, i));
                if (i == imax - 1) continue;
                buf.append(',');
            }
            buf.append(']');
        } else if (value.getClass().isPrimitive() || value instanceof Boolean || value instanceof Number) {
            buf.append(value);
        } else {
            buf.append('\"').append(value).append('\"');
        }
        return buf;
    }
}

