/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyAccess;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.HttpServletRequestTransferInterceptorServiceMBean;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorService;
import jp.ossc.nimbus.service.context.Context;

public class HttpServletRequestTransferInterceptorService
extends ServletFilterInterceptorService
implements HttpServletRequestTransferInterceptorServiceMBean {
    private static final long serialVersionUID = 8599129621419714729L;
    protected ServiceName threadContextServiceName;
    protected Context threadContext;
    protected PropertyAccess propertyAccess;
    protected Map requestPropertyAndContextKeyMapping;

    @Override
    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    @Override
    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    @Override
    public void setRequestPropertyAndContextKeyMapping(Map mapping) {
        this.requestPropertyAndContextKeyMapping = mapping;
    }

    @Override
    public Map getRequestPropertyAndContextKeyMapping() {
        return this.requestPropertyAndContextKeyMapping;
    }

    @Override
    public void createService() throws Exception {
        this.propertyAccess = new PropertyAccess();
        this.propertyAccess.setIgnoreNullProperty(true);
    }

    @Override
    public void startService() throws Exception {
        if (this.requestPropertyAndContextKeyMapping == null || this.requestPropertyAndContextKeyMapping.size() == 0) {
            throw new IllegalArgumentException("RequestPropertyAndContextKeyMapping must be specified.");
        }
        if (this.threadContextServiceName != null) {
            this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
        }
        for (Map.Entry entry : this.requestPropertyAndContextKeyMapping.entrySet()) {
            Property prop = this.propertyAccess.getProperty((String)entry.getKey());
            if (prop.isReadable(HttpServletRequest.class)) continue;
            throw new IllegalArgumentException("'" + entry.getKey() + "' cannot acquire from a request. value=null");
        }
    }

    @Override
    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3) {
            HttpServletRequest request = (HttpServletRequest)context.getServletRequest();
            for (Map.Entry entry : this.requestPropertyAndContextKeyMapping.entrySet()) {
                Object value = null;
                try {
                    value = this.propertyAccess.get(request, (String)entry.getKey());
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
                this.threadContext.put(entry.getValue(), value);
            }
        }
        return chain.invokeNext(context);
    }
}

