/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aspect.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.service.aspect.metadata.PatternMetaData;
import org.w3c.dom.Element;

public class PatternsMetaData
extends MetaData
implements Serializable {
    private static final long serialVersionUID = 6594049214635771499L;
    public static final String PATTERNS_TAG_NAME = "patterns";
    private final List patternList = new ArrayList();

    public PatternsMetaData(MetaData parent) {
        super(parent);
    }

    public List getPatternList() {
        return this.patternList;
    }

    public void addPattern(PatternMetaData pattern) {
        this.patternList.add(pattern);
    }

    @Override
    public void importXML(Element element) throws DeploymentException {
        super.importXML(element);
        if (!element.getTagName().equals(PATTERNS_TAG_NAME)) {
            throw new DeploymentException("Tag must be patterns : " + element.getTagName());
        }
        Iterator patternElements = PatternsMetaData.getChildrenByTagName(element, "pattern");
        while (patternElements.hasNext()) {
            PatternMetaData patternData = new PatternMetaData(this);
            patternData.importXML((Element)patternElements.next());
            this.addPattern(patternData);
        }
    }
}

