/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.Serializable;
import java.util.Set;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceFactoryServiceBase;
import jp.ossc.nimbus.service.cache.MemorySizeOverflowValidatorFactoryServiceMBean;
import jp.ossc.nimbus.service.cache.MemorySizeOverflowValidatorService;

public class MemorySizeOverflowValidatorFactoryService
extends ServiceFactoryServiceBase
implements MemorySizeOverflowValidatorFactoryServiceMBean,
Serializable {
    private static final long serialVersionUID = -4609416416411165086L;
    private final MemorySizeOverflowValidatorService template = new MemorySizeOverflowValidatorService();

    @Override
    protected Service createServiceInstance() throws Exception {
        MemorySizeOverflowValidatorService validator = new MemorySizeOverflowValidatorService();
        validator.setHighHeapMemorySize(this.template.getHighHeapMemorySize());
        validator.setMaxHeapMemorySize(this.template.getMaxHeapMemorySize());
        return validator;
    }

    @Override
    public void setMaxHeapMemorySize(String size) throws IllegalArgumentException {
        this.template.setMaxHeapMemorySize(size);
        Set instanceSet = this.getManagedInstanceSet();
        for (MemorySizeOverflowValidatorService validator : instanceSet) {
            validator.setMaxHeapMemorySize(size);
        }
    }

    @Override
    public String getMaxHeapMemorySize() {
        return this.template.getMaxHeapMemorySize();
    }

    @Override
    public void setHighHeapMemorySize(String size) throws IllegalArgumentException {
        this.template.setHighHeapMemorySize(size);
        Set instanceSet = this.getManagedInstanceSet();
        for (MemorySizeOverflowValidatorService validator : instanceSet) {
            validator.setHighHeapMemorySize(size);
        }
    }

    @Override
    public String getHighHeapMemorySize() {
        return this.template.getHighHeapMemorySize();
    }

    @Override
    public void reset() {
        Set instanceSet = this.getManagedInstanceSet();
        for (MemorySizeOverflowValidatorService validator : instanceSet) {
            validator.reset();
        }
    }
}

