/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.connection;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.aop.interceptor.MetricsInfo;
import jp.ossc.nimbus.service.connection.SQLMetricsCollector;
import jp.ossc.nimbus.service.connection.SQLMetricsCollectorServiceMBean;
import jp.ossc.nimbus.service.writer.Category;
import jp.ossc.nimbus.service.writer.MessageWriteException;

public class SQLMetricsCollectorService
extends ServiceBase
implements SQLMetricsCollector,
DaemonRunnable,
SQLMetricsCollectorServiceMBean {
    private static final long serialVersionUID = -114715010029870256L;
    private static final Comparator COMP = new MetricsInfoComparator();
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String LINE_FEED_STRING = "\\n";
    private static final String CARRIAGE_RETURN_STRING = "\\r";
    private static final String CSV_ENCLOSE_STRING = "\"\"";
    private static final char CSV_ENCLOSE_CHAR = '\"';
    private static final char CARRIAGE_RETURN = '\r';
    private static final char LINE_FEED = '\n';
    private Map metricsInfos;
    private boolean isEnabled = true;
    private boolean isCalculateOnlyNormal;
    private String dateFormat = "HH:mm:ss.SSS";
    private long outputInterval = 60000L;
    private boolean isResetByOutput;
    private Daemon writerDaemon;
    private ServiceName categoryServiceName;
    private Category metricsCategory;
    private boolean isOutputTimestamp = false;
    private boolean isOutputCount = true;
    private boolean isOutputExceptionCount = false;
    private boolean isOutputErrorCount = false;
    private boolean isOutputLastTime = false;
    private boolean isOutputLastExceptionTime = false;
    private boolean isOutputLastErrorTime = false;
    private boolean isOutputBestPerformance = true;
    private boolean isOutputBestPerformanceTime = false;
    private boolean isOutputWorstPerformance = true;
    private boolean isOutputWorstPerformanceTime = false;
    private boolean isOutputAveragePerformance = true;
    private int maxMetricsSize = -1;

    @Override
    public void setEnabled(boolean enable) {
        this.isEnabled = enable;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setCalculateOnlyNormal(boolean isCalc) {
        this.isCalculateOnlyNormal = isCalc;
    }

    @Override
    public boolean isCalculateOnlyNormal() {
        return this.isCalculateOnlyNormal;
    }

    @Override
    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public String displayMetricsInfo() {
        MetricsInfo[] infos = this.metricsInfos.values().toArray(new MetricsInfo[this.metricsInfos.size()]);
        Arrays.sort(infos, COMP);
        SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
        StringBuffer buf = new StringBuffer();
        buf.append("\"No.\"");
        if (this.isOutputCount) {
            buf.append(",\"Count\"");
        }
        if (this.isOutputExceptionCount) {
            buf.append(",\"ExceptionCount\"");
        }
        if (this.isOutputErrorCount) {
            buf.append(",\"ErrorCount\"");
        }
        if (this.isOutputLastTime) {
            buf.append(",\"LastTime\"");
        }
        if (this.isOutputLastExceptionTime) {
            buf.append(",\"LastExceptionTime\"");
        }
        if (this.isOutputLastErrorTime) {
            buf.append(",\"LastErrorTime\"");
        }
        if (this.isOutputBestPerformance) {
            buf.append(",\"Best performance[ms]\"");
        }
        if (this.isOutputBestPerformanceTime) {
            buf.append(",\"Best performance time\"");
        }
        if (this.isOutputWorstPerformance) {
            buf.append(",\"Worst performance[ms]\"");
        }
        if (this.isOutputWorstPerformanceTime) {
            buf.append(",\"Worst performance time\"");
        }
        if (this.isOutputAveragePerformance) {
            buf.append(",\"Average performance[ms]\"");
        }
        buf.append(",\"SQL\"");
        buf.append(LINE_SEP);
        for (int i = 0; i < infos.length; ++i) {
            buf.append('\"').append(i + 1).append('\"');
            if (this.isOutputCount) {
                buf.append(',').append('\"').append(infos[i].getCount()).append('\"');
            }
            if (this.isOutputExceptionCount) {
                buf.append(',').append('\"').append(infos[i].getExceptionCount()).append('\"');
            }
            if (this.isOutputErrorCount) {
                buf.append(',').append('\"').append(infos[i].getErrorCount()).append('\"');
            }
            if (this.isOutputLastTime) {
                if (infos[i].getLastTime() == 0L) {
                    buf.append(",\"\"");
                } else {
                    buf.append(',').append('\"').append(format.format(new Date(infos[i].getLastTime()))).append('\"');
                }
            }
            if (this.isOutputLastExceptionTime) {
                if (infos[i].getLastExceptionTime() == 0L) {
                    buf.append(",\"\"");
                } else {
                    buf.append(',').append('\"').append(format.format(new Date(infos[i].getLastExceptionTime()))).append('\"');
                }
            }
            if (this.isOutputLastErrorTime) {
                if (infos[i].getLastErrorTime() == 0L) {
                    buf.append(",\"\"");
                } else {
                    buf.append('\"').append(',').append(format.format(new Date(infos[i].getLastErrorTime()))).append('\"');
                }
            }
            if (this.isOutputBestPerformance) {
                buf.append(',').append('\"').append(infos[i].getBestPerformance()).append('\"');
            }
            if (this.isOutputBestPerformanceTime) {
                if (infos[i].getBestPerformanceTime() == 0L) {
                    buf.append(",\"\"");
                } else {
                    buf.append(',').append('\"').append(format.format(new Date(infos[i].getBestPerformanceTime()))).append('\"');
                }
            }
            if (this.isOutputWorstPerformance) {
                buf.append(',').append('\"').append(infos[i].getWorstPerformance()).append('\"');
            }
            if (this.isOutputWorstPerformanceTime) {
                if (infos[i].getWorstPerformanceTime() == 0L) {
                    buf.append(",\"\"");
                } else {
                    buf.append(',').append('\"').append(format.format(new Date(infos[i].getWorstPerformanceTime()))).append('\"');
                }
            }
            if (this.isOutputAveragePerformance) {
                buf.append(',').append('\"').append(infos[i].getAveragePerformance()).append('\"');
            }
            buf.append(',').append('\"').append(this.escape(infos[i].getKey())).append('\"');
            buf.append(LINE_SEP);
        }
        if (this.isOutputTimestamp) {
            buf.append(format.format(new Date())).append(LINE_SEP);
        }
        return buf.toString();
    }

    protected String escape(String str) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length == 0) {
            return str;
        }
        StringBuffer buf = new StringBuffer();
        block5: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\r': {
                    buf.append(CARRIAGE_RETURN_STRING);
                    continue block5;
                }
                case '\n': {
                    buf.append(LINE_FEED_STRING);
                    continue block5;
                }
                case '\"': {
                    buf.append(CSV_ENCLOSE_STRING);
                    continue block5;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    @Override
    public void reset() {
        this.metricsInfos.clear();
    }

    @Override
    public MetricsInfo getMetricsInfo(String sql) {
        return (MetricsInfo)this.metricsInfos.get(sql);
    }

    @Override
    public void setOutputInterval(long interval) {
        this.outputInterval = interval;
    }

    @Override
    public long getOutputInterval() {
        return this.outputInterval;
    }

    @Override
    public void setResetByOutput(boolean isReset) {
        this.isResetByOutput = isReset;
    }

    @Override
    public boolean isResetByOutput() {
        return this.isResetByOutput;
    }

    @Override
    public void setCategoryServiceName(ServiceName name) {
        this.categoryServiceName = name;
    }

    @Override
    public ServiceName getCategoryServiceName() {
        return this.categoryServiceName;
    }

    @Override
    public void setOutputTimestamp(boolean isOutput) {
        this.isOutputTimestamp = isOutput;
    }

    @Override
    public boolean isOutputTimestamp() {
        return this.isOutputTimestamp;
    }

    @Override
    public void setOutputCount(boolean isOutput) {
        this.isOutputCount = isOutput;
    }

    @Override
    public boolean isOutputCount() {
        return this.isOutputCount;
    }

    @Override
    public void setOutputExceptionCount(boolean isOutput) {
        this.isOutputExceptionCount = isOutput;
    }

    @Override
    public boolean isOutputExceptionCount() {
        return this.isOutputExceptionCount;
    }

    @Override
    public void setOutputErrorCount(boolean isOutput) {
        this.isOutputErrorCount = isOutput;
    }

    @Override
    public boolean isOutputErrorCount() {
        return this.isOutputErrorCount;
    }

    @Override
    public void setOutputLastTime(boolean isOutput) {
        this.isOutputLastTime = isOutput;
    }

    @Override
    public boolean isOutputLastTime() {
        return this.isOutputLastTime;
    }

    @Override
    public void setOutputLastExceptionTime(boolean isOutput) {
        this.isOutputLastExceptionTime = isOutput;
    }

    @Override
    public boolean isOutputLastExceptionTime() {
        return this.isOutputLastExceptionTime;
    }

    @Override
    public void setOutputLastErrorTime(boolean isOutput) {
        this.isOutputLastErrorTime = isOutput;
    }

    @Override
    public boolean isOutputLastErrorTime() {
        return this.isOutputLastErrorTime;
    }

    @Override
    public void setOutputBestPerformance(boolean isOutput) {
        this.isOutputBestPerformance = isOutput;
    }

    @Override
    public boolean isOutputBestPerformance() {
        return this.isOutputBestPerformance;
    }

    @Override
    public void setOutputBestPerformanceTime(boolean isOutput) {
        this.isOutputBestPerformanceTime = isOutput;
    }

    @Override
    public boolean isOutputBestPerformanceTime() {
        return this.isOutputBestPerformanceTime;
    }

    @Override
    public void setOutputWorstPerformance(boolean isOutput) {
        this.isOutputWorstPerformance = isOutput;
    }

    @Override
    public boolean isOutputWorstPerformance() {
        return this.isOutputWorstPerformance;
    }

    @Override
    public void setOutputWorstPerformanceTime(boolean isOutput) {
        this.isOutputWorstPerformanceTime = isOutput;
    }

    @Override
    public boolean isOutputWorstPerformanceTime() {
        return this.isOutputWorstPerformanceTime;
    }

    @Override
    public void setOutputAveragePerformance(boolean isOutput) {
        this.isOutputAveragePerformance = isOutput;
    }

    @Override
    public boolean isOutputAveragePerformance() {
        return this.isOutputAveragePerformance;
    }

    @Override
    public void setMaxMetricsSize(int max) {
        this.maxMetricsSize = max;
    }

    @Override
    public int getMaxMetricsSize() {
        return this.maxMetricsSize;
    }

    @Override
    public void createService() throws Exception {
        this.metricsInfos = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void startService() throws Exception {
        this.metricsInfos.clear();
        if (this.categoryServiceName != null) {
            this.metricsCategory = (Category)ServiceManagerFactory.getServiceObject(this.categoryServiceName);
        }
        if (this.metricsCategory != null) {
            this.writerDaemon = new Daemon(this);
            this.writerDaemon.setName("Nimbus MetricsWriteDaemon " + this.getServiceNameObject());
            this.writerDaemon.start();
        }
    }

    @Override
    public void stopService() throws Exception {
        System.out.println(this.displayMetricsInfo());
        if (this.writerDaemon != null) {
            this.writerDaemon.stop();
            this.writerDaemon = null;
        }
    }

    @Override
    public void destroyService() throws Exception {
        this.metricsInfos = null;
    }

    @Override
    public void register(String sql, long performance) {
        this.register(sql, performance, false, false);
    }

    @Override
    public void registerException(String sql, long performance) {
        this.register(sql, performance, true, false);
    }

    @Override
    public void registerError(String sql, long performance) {
        this.register(sql, performance, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(String sql, long performance, boolean isException, boolean isError) {
        Map map = this.metricsInfos;
        synchronized (map) {
            MetricsInfo metricsInfo = (MetricsInfo)this.metricsInfos.get(sql);
            if (metricsInfo == null) {
                if (this.maxMetricsSize > 0 && this.metricsInfos.size() > this.maxMetricsSize) {
                    return;
                }
                metricsInfo = new MetricsInfo(sql, this.isCalculateOnlyNormal);
                this.metricsInfos.put(sql, metricsInfo);
            }
            metricsInfo.calculate(performance, isException, isError);
        }
    }

    @Override
    public boolean onStart() {
        return true;
    }

    @Override
    public boolean onStop() {
        return true;
    }

    @Override
    public boolean onSuspend() {
        return true;
    }

    @Override
    public boolean onResume() {
        return true;
    }

    @Override
    public Object provide(DaemonControl ctrl) {
        try {
            Thread.sleep(this.outputInterval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void consume(Object dequeued, DaemonControl ctrl) {
        int i;
        MetricsInfo[] infos;
        Date timestamp = new Date();
        if (this.metricsCategory != null) {
            infos = this.metricsInfos.values().toArray(new MetricsInfo[this.metricsInfos.size()]);
            Arrays.sort(infos, COMP);
            for (i = 0; i < infos.length; ++i) {
                try {
                    this.metricsCategory.write(this.createRecord(timestamp, i + 1, infos[i]));
                    continue;
                }
                catch (MessageWriteException messageWriteException) {
                    // empty catch block
                }
            }
        }
        if (this.isResetByOutput) {
            infos = this.metricsInfos.values().toArray(new MetricsInfo[this.metricsInfos.size()]);
            for (i = 0; i < infos.length; ++i) {
                infos[i].reset();
            }
        }
    }

    private Map createRecord(Date timestamp, int order, MetricsInfo info) {
        HashMap<String, Object> record = new HashMap<String, Object>();
        if (this.isOutputTimestamp) {
            record.put("Timestamp", timestamp);
        }
        if (order > 0) {
            record.put("Order", new Integer(order));
        }
        record.put("SQL", info.getKey());
        if (this.isOutputCount) {
            record.put("Count", new Long(info.getCount()));
        }
        if (this.isOutputExceptionCount) {
            record.put("ExceptionCount", new Long(info.getExceptionCount()));
        }
        if (this.isOutputErrorCount) {
            record.put("ErrorCount", new Long(info.getErrorCount()));
        }
        if (this.isOutputLastTime) {
            record.put("LastTime", info.getLastTime() == 0L ? null : new Date(info.getLastTime()));
        }
        if (this.isOutputLastExceptionTime) {
            record.put("LastExceptionTime", info.getLastExceptionTime() == 0L ? null : new Date(info.getLastExceptionTime()));
        }
        if (this.isOutputLastErrorTime) {
            record.put("LastErrorTime", info.getLastErrorTime() == 0L ? null : new Date(info.getLastErrorTime()));
        }
        if (this.isOutputBestPerformance) {
            record.put("BestPerformance", new Long(info.getBestPerformance()));
        }
        if (this.isOutputBestPerformanceTime) {
            record.put("BestPerformanceTime", info.getBestPerformanceTime() == 0L ? null : new Date(info.getBestPerformanceTime()));
        }
        if (this.isOutputWorstPerformance) {
            record.put("WorstPerformance", new Long(info.getWorstPerformance()));
        }
        if (this.isOutputWorstPerformanceTime) {
            record.put("WorstPerformanceTime", info.getWorstPerformanceTime() == 0L ? null : new Date(info.getWorstPerformanceTime()));
        }
        if (this.isOutputAveragePerformance) {
            record.put("AveragePerformance", new Long(info.getAveragePerformance()));
        }
        return record;
    }

    @Override
    public void garbage() {
    }

    private static class MetricsInfoComparator
    implements Comparator {
        private MetricsInfoComparator() {
        }

        public int compare(Object o1, Object o2) {
            long sortKey2;
            MetricsInfo info1 = (MetricsInfo)o1;
            MetricsInfo info2 = (MetricsInfo)o2;
            long sortKey1 = info1.getAveragePerformance() * info1.getCount();
            if (sortKey1 > (sortKey2 = info2.getAveragePerformance() * info2.getCount())) {
                return -1;
            }
            if (sortKey1 < sortKey2) {
                return 1;
            }
            return 0;
        }
    }
}

