/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.context;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.beans.BeanTableIndexKeyFactory;
import jp.ossc.nimbus.beans.IndexNotFoundException;
import jp.ossc.nimbus.beans.IndexPropertyAccessException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.CacheMap;
import jp.ossc.nimbus.service.context.ContextStore;
import jp.ossc.nimbus.service.context.DistributedSharedContext;
import jp.ossc.nimbus.service.context.DistributedSharedContextServiceMBean;
import jp.ossc.nimbus.service.context.MD5HashSharedContextKeyDistributorService;
import jp.ossc.nimbus.service.context.SharedContext;
import jp.ossc.nimbus.service.context.SharedContextIllegalIndexException;
import jp.ossc.nimbus.service.context.SharedContextKeyDistributor;
import jp.ossc.nimbus.service.context.SharedContextSendException;
import jp.ossc.nimbus.service.context.SharedContextService;
import jp.ossc.nimbus.service.context.SharedContextTimeoutException;
import jp.ossc.nimbus.service.context.SharedContextUpdateException;
import jp.ossc.nimbus.service.context.SharedContextUpdateListener;
import jp.ossc.nimbus.service.context.SharedContextValueDifference;
import jp.ossc.nimbus.service.context.SharedContextView;
import jp.ossc.nimbus.service.interpreter.EvaluateException;
import jp.ossc.nimbus.service.interpreter.Interpreter;
import jp.ossc.nimbus.service.keepalive.ClusterListener;
import jp.ossc.nimbus.service.keepalive.ClusterService;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageException;
import jp.ossc.nimbus.service.publish.MessageReceiver;
import jp.ossc.nimbus.service.publish.MessageSendException;
import jp.ossc.nimbus.service.publish.RequestMessageListener;
import jp.ossc.nimbus.service.publish.RequestServerConnection;
import jp.ossc.nimbus.service.publish.RequestTimeoutException;
import jp.ossc.nimbus.service.publish.ServerConnectionFactory;
import jp.ossc.nimbus.service.queue.AsynchContext;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.QueueHandler;
import jp.ossc.nimbus.service.queue.QueueHandlerContainerService;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class DistributedSharedContextService
extends ServiceBase
implements DistributedSharedContext,
RequestMessageListener,
ClusterListener,
DistributedSharedContextServiceMBean {
    private static final long serialVersionUID = -8599934979277211223L;
    private ServiceName requestConnectionFactoryServiceName;
    private ServiceName clientCacheMapServiceName;
    private ServiceName serverCacheMapServiceName;
    private ServiceName clusterServiceName;
    private ServiceName sharedContextKeyDistributorServiceName;
    private SharedContextKeyDistributor keyDistributor;
    private ServiceName contextStoreServiceName;
    private ContextStore contextStore;
    private ServiceName interpreterServiceName;
    private Interpreter interpreter;
    private int executeThreadSize;
    private ServiceName executeQueueServiceName;
    private int parallelRequestThreadSize;
    private ServiceName parallelRequestQueueServiceName;
    private QueueHandlerContainerService parallelRequestQueueHandlerContainer;
    private ServiceName sharedContextTransactionManagerServiceName;
    private String subject = "DistributedSharedContext";
    private String clientSubject;
    private boolean isClient;
    private long synchronizeTimeout = 10000L;
    private long rehashTimeout = 10000L;
    private long defaultTimeout = 1000L;
    private boolean isLoadKeyOnStart;
    private boolean isLoadOnStart;
    private boolean isClearBeforeSave = true;
    private int distributedSize = 2;
    private int replicationSize = 2;
    private RequestServerConnection serverConnection;
    private MessageReceiver messageReceiver;
    private ClusterService cluster;
    private Message targetMessage;
    private SharedContextService[] sharedContextArray;
    private DistributeInfo distributeInfo;
    private boolean isRehashEnabled = true;
    private boolean isMainDistributed = false;
    private boolean isManagedDataNode;
    private List updateListeners;
    private ServiceName[] sharedContextUpdateListenerServiceNames;
    private Map indexMap;

    @Override
    public void setSharedContextKeyDistributorServiceName(ServiceName name) {
        this.sharedContextKeyDistributorServiceName = name;
    }

    @Override
    public ServiceName getSharedContextKeyDistributorServiceName() {
        return this.sharedContextKeyDistributorServiceName;
    }

    @Override
    public void setDistributedSize(int size) throws IllegalArgumentException {
        if (size <= 1) {
            throw new IllegalArgumentException("DistributedSize must be 2 or more." + size);
        }
        this.distributedSize = size;
    }

    @Override
    public int getDistributedSize() {
        return this.distributedSize;
    }

    @Override
    public void setReplicationSize(int size) throws IllegalArgumentException {
        if (size <= 0) {
            throw new IllegalArgumentException("ReplicationSize must be 1 or more." + size);
        }
        this.replicationSize = size;
    }

    @Override
    public int getReplicationSize() {
        return this.replicationSize;
    }

    @Override
    public void setRequestConnectionFactoryServiceName(ServiceName name) {
        this.requestConnectionFactoryServiceName = name;
    }

    @Override
    public ServiceName getRequestConnectionFactoryServiceName() {
        return this.requestConnectionFactoryServiceName;
    }

    @Override
    public void setClusterServiceName(ServiceName name) {
        this.clusterServiceName = name;
    }

    @Override
    public ServiceName getClusterServiceName() {
        return this.clusterServiceName;
    }

    @Override
    public void setSharedContextTransactionManagerServiceName(ServiceName name) {
        this.sharedContextTransactionManagerServiceName = name;
    }

    @Override
    public ServiceName getSharedContextTransactionManagerServiceName() {
        return this.sharedContextTransactionManagerServiceName;
    }

    @Override
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setClient(boolean isClient) throws SharedContextSendException, SharedContextTimeoutException {
        if (this.isClient == isClient) {
            return;
        }
        this.isClient = isClient;
        if (this.getState() == 3) {
            try {
                this.messageReceiver.addSubject(this, isClient ? this.clientSubject : this.subject);
                this.messageReceiver.removeSubject(this, isClient ? this.subject : this.clientSubject);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            this.synchronize();
        }
    }

    @Override
    public boolean isClient() {
        return this.isClient;
    }

    @Override
    public void setRehashEnabled(boolean isEnabled) throws SharedContextSendException, SharedContextTimeoutException {
        block7: {
            if (this.getState() == 3) {
                try {
                    Message message = this.serverConnection.createMessage(this.subject, Integer.toString(7));
                    message.setSubject(this.clientSubject, null);
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() == 0) break block7;
                    message.setObject(new DistributedSharedContextEvent(7, isEnabled ? Boolean.TRUE : Boolean.FALSE));
                    try {
                        Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 0, this.defaultTimeout);
                        for (int i = 0; i < responses.length; ++i) {
                            Object ret = responses[i].getObject();
                            responses[i].recycle();
                            if (!(ret instanceof Throwable)) continue;
                            throw new SharedContextSendException((Throwable)ret);
                        }
                    }
                    catch (RequestTimeoutException e) {
                        throw new SharedContextTimeoutException(e);
                    }
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
            }
        }
        this.isRehashEnabled = isEnabled;
    }

    @Override
    public boolean isRehashEnabled() {
        return this.isRehashEnabled;
    }

    @Override
    public void setClientCacheMapServiceName(ServiceName name) {
        this.clientCacheMapServiceName = name;
    }

    @Override
    public ServiceName getClientCacheMapServiceName() {
        return this.clientCacheMapServiceName;
    }

    @Override
    public void setServerCacheMapServiceName(ServiceName name) {
        this.serverCacheMapServiceName = name;
    }

    @Override
    public ServiceName getServerCacheMapServiceName() {
        return this.serverCacheMapServiceName;
    }

    @Override
    public void setContextStoreServiceName(ServiceName name) {
        this.contextStoreServiceName = name;
    }

    @Override
    public ServiceName getContextStoreServiceName() {
        return this.contextStoreServiceName;
    }

    @Override
    public void setInterpreterServiceName(ServiceName name) {
        this.interpreterServiceName = name;
    }

    @Override
    public ServiceName getInterpreterServiceName() {
        return this.interpreterServiceName;
    }

    @Override
    public void setExecuteThreadSize(int size) {
        this.executeThreadSize = size;
    }

    @Override
    public int getExecuteThreadSize() {
        return this.executeThreadSize;
    }

    @Override
    public void setExecuteQueueServiceName(ServiceName name) {
        this.executeQueueServiceName = name;
    }

    @Override
    public ServiceName getExecuteQueueServiceName() {
        return this.executeQueueServiceName;
    }

    @Override
    public void setParallelRequestThreadSize(int size) {
        this.parallelRequestThreadSize = size;
    }

    @Override
    public int getParallelRequestThreadSize() {
        return this.parallelRequestThreadSize;
    }

    @Override
    public void setParallelRequestQueueServiceName(ServiceName name) {
        this.parallelRequestQueueServiceName = name;
    }

    @Override
    public ServiceName getParallelRequestQueueServiceName() {
        return this.parallelRequestQueueServiceName;
    }

    @Override
    public void setLoadKeyOnStart(boolean isLoad) {
        this.isLoadKeyOnStart = isLoad;
    }

    @Override
    public boolean isLoadKeyOnStart() {
        return this.isLoadKeyOnStart;
    }

    @Override
    public void setLoadOnStart(boolean isLoad) {
        this.isLoadOnStart = isLoad;
    }

    @Override
    public boolean isLoadOnStart() {
        return this.isLoadOnStart;
    }

    @Override
    public void setClearBeforeSave(boolean isClear) {
        this.isClearBeforeSave = isClear;
    }

    @Override
    public boolean isClearBeforeSave() {
        return this.isClearBeforeSave;
    }

    @Override
    public void setSynchronizeTimeout(long timeout) {
        this.synchronizeTimeout = timeout;
        if (this.getState() == 3) {
            for (int i = 0; i < this.sharedContextArray.length; ++i) {
                this.sharedContextArray[i].setSynchronizeTimeout(this.synchronizeTimeout);
            }
        }
    }

    @Override
    public long getSynchronizeTimeout() {
        return this.synchronizeTimeout;
    }

    @Override
    public void setRehashTimeout(long timeout) {
        this.rehashTimeout = timeout;
    }

    @Override
    public long getRehashTimeout() {
        return this.rehashTimeout;
    }

    @Override
    public void setDefaultTimeout(long timeout) {
        this.defaultTimeout = timeout;
        if (this.getState() == 3) {
            for (int i = 0; i < this.sharedContextArray.length; ++i) {
                this.sharedContextArray[i].setDefaultTimeout(this.defaultTimeout);
            }
        }
    }

    @Override
    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    @Override
    public void setManagedDataNode(boolean isManage) {
        this.isManagedDataNode = isManage;
    }

    @Override
    public boolean isManagedDataNode() {
        return this.isManagedDataNode;
    }

    @Override
    public void setSharedContextUpdateListenerServiceNames(ServiceName[] names) {
        this.sharedContextUpdateListenerServiceNames = names;
    }

    @Override
    public ServiceName[] getSharedContextUpdateListenerServiceNames() {
        return this.sharedContextUpdateListenerServiceNames;
    }

    @Override
    public void setIndex(String name, String[] props) {
        if (this.getState() == 3) {
            for (int i = 0; i < this.sharedContextArray.length; ++i) {
                this.sharedContextArray[i].setIndex(name, props);
            }
        }
        this.indexMap.put(name, props);
    }

    @Override
    public void setIndex(String name, BeanTableIndexKeyFactory keyFactory) {
        if (this.getState() == 3) {
            for (int i = 0; i < this.sharedContextArray.length; ++i) {
                this.sharedContextArray[i].setIndex(name, keyFactory);
            }
        }
        this.indexMap.put(name, keyFactory);
    }

    @Override
    public void removeIndex(String name) {
        if (this.getState() == 3) {
            for (int i = 0; i < this.sharedContextArray.length; ++i) {
                this.sharedContextArray[i].removeIndex(name);
            }
        }
        this.indexMap.remove(name);
    }

    @Override
    public boolean isMainDistributed() {
        return this.isMainDistributed;
    }

    @Override
    public void setMainDistributed(boolean isDistributed) {
        this.isMainDistributed = isDistributed;
    }

    @Override
    public void createService() throws Exception {
        this.indexMap = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void startService() throws Exception {
        if (this.sharedContextKeyDistributorServiceName == null) {
            MD5HashSharedContextKeyDistributorService defaultKeyDistributor = new MD5HashSharedContextKeyDistributorService();
            defaultKeyDistributor.create();
            defaultKeyDistributor.start();
            this.keyDistributor = defaultKeyDistributor;
        } else {
            this.keyDistributor = (SharedContextKeyDistributor)ServiceManagerFactory.getServiceObject(this.sharedContextKeyDistributorServiceName);
        }
        if (this.contextStoreServiceName != null) {
            this.contextStore = (ContextStore)ServiceManagerFactory.getServiceObject(this.contextStoreServiceName);
        }
        if (this.requestConnectionFactoryServiceName == null) {
            throw new IllegalArgumentException("RequestConnectionFactoryServiceName must be specified.");
        }
        if (this.sharedContextUpdateListenerServiceNames != null) {
            for (int i = 0; i < this.sharedContextUpdateListenerServiceNames.length; ++i) {
                this.addSharedContextUpdateListener((SharedContextUpdateListener)ServiceManagerFactory.getServiceObject(this.sharedContextUpdateListenerServiceNames[i]));
            }
        }
        if (this.parallelRequestThreadSize > 0) {
            this.parallelRequestQueueHandlerContainer = new QueueHandlerContainerService();
            this.parallelRequestQueueHandlerContainer.create();
            this.parallelRequestQueueHandlerContainer.setQueueHandlerSize(this.parallelRequestThreadSize);
            if (this.parallelRequestQueueServiceName == null) {
                DefaultQueueService parallelRequestQueue = new DefaultQueueService();
                parallelRequestQueue.create();
                parallelRequestQueue.start();
                this.parallelRequestQueueHandlerContainer.setQueueService(parallelRequestQueue);
            } else {
                this.parallelRequestQueueHandlerContainer.setQueueServiceName(this.parallelRequestQueueServiceName);
            }
            this.parallelRequestQueueHandlerContainer.setQueueHandler(new ParallelRequestQueueHandler());
            this.parallelRequestQueueHandlerContainer.start();
        }
        ServerConnectionFactory factory = (ServerConnectionFactory)ServiceManagerFactory.getServiceObject(this.requestConnectionFactoryServiceName);
        this.serverConnection = (RequestServerConnection)factory.getServerConnection();
        this.messageReceiver = (MessageReceiver)ServiceManagerFactory.getServiceObject(this.requestConnectionFactoryServiceName);
        this.clientSubject = this.subject + ".Client";
        this.targetMessage = this.serverConnection.createMessage(this.subject, null);
        this.messageReceiver.addSubject(this, this.isClient ? this.clientSubject : this.subject);
        if (this.clusterServiceName == null) {
            throw new IllegalArgumentException("ClusterServiceName must be specified.");
        }
        this.cluster = (ClusterService)ServiceManagerFactory.getServiceObject(this.clusterServiceName);
        if (this.interpreterServiceName != null) {
            this.interpreter = (Interpreter)ServiceManagerFactory.getServiceObject(this.interpreterServiceName);
        }
        this.sharedContextArray = new SharedContextService[this.distributedSize];
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            SharedContextService sharedContextService = this.sharedContextArray[i] = this.isMainDistributed ? new ForDistributedSharedContextService(i) : new SharedContextService();
            if (this.isManagedDataNode) {
                this.sharedContextArray[i].setServiceManagerName(this.getServiceManagerName());
            }
            this.sharedContextArray[i].setServiceName(this.getServiceName() + '$' + i);
            this.sharedContextArray[i].create();
            this.sharedContextArray[i].setRequestConnectionFactoryServiceName(this.requestConnectionFactoryServiceName);
            this.sharedContextArray[i].setClusterServiceName(this.clusterServiceName);
            if (this.clientCacheMapServiceName != null) {
                this.sharedContextArray[i].setClientCacheMap((CacheMap)ServiceManagerFactory.getServiceObject(this.clientCacheMapServiceName));
            }
            if (this.serverCacheMapServiceName != null) {
                this.sharedContextArray[i].setServerCacheMap((CacheMap)ServiceManagerFactory.getServiceObject(this.serverCacheMapServiceName));
            }
            if (this.contextStoreServiceName != null) {
                this.sharedContextArray[i].setContextStoreServiceName(this.contextStoreServiceName);
            }
            if (this.interpreterServiceName != null) {
                this.sharedContextArray[i].setInterpreterServiceName(this.interpreterServiceName);
            }
            if (this.executeQueueServiceName != null) {
                this.sharedContextArray[i].setExecuteQueueServiceName(this.executeQueueServiceName);
            }
            if (this.sharedContextTransactionManagerServiceName != null) {
                this.sharedContextArray[i].setSharedContextTransactionManagerServiceName(this.sharedContextTransactionManagerServiceName);
            }
            this.sharedContextArray[i].setExecuteThreadSize(this.executeThreadSize);
            this.sharedContextArray[i].setSubject(this.subject + "$" + i);
            this.sharedContextArray[i].setClient(true);
            this.sharedContextArray[i].setSynchronizeTimeout(this.synchronizeTimeout);
            this.sharedContextArray[i].setDefaultTimeout(this.defaultTimeout);
            this.sharedContextArray[i].setSynchronizeOnStart(false);
            this.sharedContextArray[i].setSaveOnlyMain(true);
            this.sharedContextArray[i].setClearBeforeSave(false);
            this.sharedContextArray[i].setLoadOnStart(false);
            this.sharedContextArray[i].setLoadKeyOnStart(false);
            this.sharedContextArray[i].setSaveOnStop(false);
            if (this.updateListeners != null) {
                for (int j = 0; j < this.updateListeners.size(); ++j) {
                    this.sharedContextArray[i].addSharedContextUpdateListener((SharedContextUpdateListener)this.updateListeners.get(j));
                }
            }
            for (Map.Entry entry : this.indexMap.entrySet()) {
                if (entry.getValue() instanceof BeanTableIndexKeyFactory) {
                    this.sharedContextArray[i].setIndex((String)entry.getKey(), (BeanTableIndexKeyFactory)entry.getValue());
                    continue;
                }
                this.sharedContextArray[i].setIndex((String)entry.getKey(), (String[])entry.getValue());
            }
            this.sharedContextArray[i].start();
        }
        this.distributeInfo = new DistributeInfo(this.getId(), this.distributedSize);
        this.cluster.addClusterListener(this);
        this.rehash();
        if (this.isMain()) {
            if (this.isLoadKeyOnStart) {
                this.loadKey();
            } else if (this.isLoadOnStart) {
                this.load();
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.cluster != null) {
            this.cluster.removeClusterListener(this);
        }
        if (this.messageReceiver != null) {
            try {
                this.messageReceiver.removeMessageListener(this);
            }
            catch (MessageSendException messageSendException) {
                // empty catch block
            }
        }
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            this.sharedContextArray[i].stop();
            this.sharedContextArray[i].destroy();
        }
        if (this.parallelRequestQueueHandlerContainer != null) {
            this.parallelRequestQueueHandlerContainer.stop();
            this.parallelRequestQueueHandlerContainer.destroy();
            this.parallelRequestQueueHandlerContainer = null;
        }
    }

    @Override
    public void destroyService() throws Exception {
        this.indexMap = null;
    }

    @Override
    public void synchronize() throws SharedContextSendException, SharedContextTimeoutException {
        this.synchronize(this.synchronizeTimeout <= 0L ? 0L : this.synchronizeTimeout * (long)this.sharedContextArray.length);
    }

    @Override
    public synchronized void synchronize(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        if (this.sharedContextArray == null || this.sharedContextArray.length == 0) {
            return;
        }
        if (this.parallelRequestQueueHandlerContainer == null) {
            for (int i = 0; i < this.sharedContextArray.length; ++i) {
                long start = System.currentTimeMillis();
                boolean isNoTimeout = timeout <= 0L;
                long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                if (!isNoTimeout && timeout < 0L) {
                    throw new SharedContextTimeoutException("There is a node that is not possible yet synchronized. completed=" + i + "notCompleted=" + (this.sharedContextArray.length - i));
                }
                this.sharedContextArray[i].synchronize(timeout);
            }
        } else {
            AsynchContext asynchContext;
            int i;
            DefaultQueueService responseQueue = new DefaultQueueService();
            try {
                responseQueue.create();
                responseQueue.start();
            }
            catch (Exception start) {
                // empty catch block
            }
            responseQueue.accept();
            for (i = 0; i < this.sharedContextArray.length; ++i) {
                asynchContext = new AsynchContext(new SynchronizeParallelRequest(this.sharedContextArray[i], timeout), responseQueue);
                this.parallelRequestQueueHandlerContainer.push(asynchContext);
            }
            for (i = 0; i < this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                try {
                    asynchContext.checkError();
                    continue;
                }
                catch (SharedContextSendException e) {
                    throw e;
                }
                catch (SharedContextTimeoutException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw new SharedContextSendException(th);
                }
            }
        }
    }

    @Override
    public void rehash() throws SharedContextSendException, SharedContextTimeoutException {
        this.rehash(this.rehashTimeout);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void rehash(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        if (!this.isRehashEnabled) {
            return;
        }
        if (this.isMain()) {
            try {
                Map decreaseDistributeInfos;
                Message message = this.serverConnection.createMessage(this.subject, Integer.toString(1));
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() == 0) {
                    DistributeGrid grid = new DistributeGrid();
                    grid.addDistributeInfo(this.distributeInfo);
                    grid.rehash();
                    this.distributeInfo.apply(this.distributeInfo, this.sharedContextArray);
                    return;
                }
                message.setObject(new DistributedSharedContextEvent(1, new Long(timeout)));
                long start = System.currentTimeMillis();
                Message[] responses = null;
                try {
                    responses = this.serverConnection.request(message, 0, timeout);
                }
                catch (RequestTimeoutException e) {
                    throw new SharedContextTimeoutException("Timeout has occurred to get state of distribution.", e);
                }
                boolean isNoTimeout = timeout <= 0L;
                timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                DistributeGrid grid = new DistributeGrid();
                grid.addDistributeInfo(this.distributeInfo);
                for (int i = 0; i < responses.length; ++i) {
                    grid.addDistributeInfo((DistributeInfo)responses[i].getObject());
                    responses[i].recycle();
                }
                grid.rehash();
                RehashResponseCallBack callback = new RehashResponseCallBack();
                Map increaseDistributeInfos = grid.getIncreaseDistributeInfos();
                DistributeInfo info2 = (DistributeInfo)increaseDistributeInfos.remove(this.getId());
                if (info2 != null) {
                    info2.apply(this.distributeInfo, this.sharedContextArray);
                }
                if (increaseDistributeInfos.size() != 0) {
                    callback.setResponseCount(increaseDistributeInfos.size());
                    for (DistributeInfo info2 : increaseDistributeInfos.values()) {
                        Message rehashMessage = this.serverConnection.createMessage(this.subject, Integer.toString(3));
                        rehashMessage.setObject(new DistributedSharedContextEvent(3, info2));
                        rehashMessage.addDestinationId(info2.getId());
                        this.serverConnection.request(rehashMessage, 1, timeout, callback);
                    }
                    callback.waitResponse(timeout);
                }
                if ((info2 = (DistributeInfo)(decreaseDistributeInfos = grid.getDecreaseDistributeInfos()).remove(this.getId())) != null) {
                    info2.apply(this.distributeInfo, this.sharedContextArray);
                }
                if (decreaseDistributeInfos.size() == 0) return;
                callback.setResponseCount(decreaseDistributeInfos.size());
                for (DistributeInfo info2 : decreaseDistributeInfos.values()) {
                    Message rehashMessage = this.serverConnection.createMessage(this.subject, Integer.toString(3));
                    rehashMessage.setObject(new DistributedSharedContextEvent(3, info2));
                    rehashMessage.addDestinationId(info2.getId());
                    this.serverConnection.request(rehashMessage, 1, timeout, callback);
                }
                callback.waitResponse(timeout);
                return;
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, Integer.toString(2));
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() == 0) return;
            message.setObject(new DistributedSharedContextEvent(2, new Long(timeout)));
            try {
                Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
                Object ret = responses[0].getObject();
                responses[0].recycle();
                if (!(ret instanceof Throwable)) return;
                throw new SharedContextSendException((Throwable)ret);
            }
            catch (RequestTimeoutException e) {
                throw new SharedContextTimeoutException(e);
            }
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
    }

    @Override
    public synchronized void load() throws Exception {
        this.load(-1L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void load(long timeout) throws Exception {
        if (this.isMain()) {
            if (this.contextStore == null) throw new UnsupportedOperationException();
            this.contextStore.load(this);
            return;
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, null);
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() == 0) return;
            message.setObject(new DistributedSharedContextEvent(5));
            try {
                Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
                Object ret = responses[0].getObject();
                responses[0].recycle();
                if (!(ret instanceof Throwable)) return;
                throw new SharedContextSendException((Throwable)ret);
            }
            catch (RequestTimeoutException e) {
                throw new SharedContextTimeoutException(e);
            }
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
    }

    @Override
    public synchronized void load(Object key) throws Exception {
        this.load(key, -1L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void load(Object key, long timeout) throws Exception {
        if (this.isMain()) {
            if (this.contextStore == null) throw new UnsupportedOperationException();
            this.contextStore.load(this, key);
            return;
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() == 0) return;
            message.setObject(new DistributedSharedContextEvent(5, key));
            try {
                Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
                Object ret = responses[0].getObject();
                responses[0].recycle();
                if (!(ret instanceof Throwable)) return;
                throw new SharedContextSendException((Throwable)ret);
            }
            catch (RequestTimeoutException e) {
                throw new SharedContextTimeoutException(e);
            }
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
    }

    @Override
    public synchronized void loadKey() throws Exception {
        this.loadKey(-1L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void loadKey(long timeout) throws Exception {
        if (this.isMain()) {
            if (this.contextStore == null) throw new UnsupportedOperationException();
            this.contextStore.loadKey(this);
            return;
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, null);
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() == 0) return;
            message.setObject(new DistributedSharedContextEvent(6));
            try {
                Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
                Object ret = responses[0].getObject();
                responses[0].recycle();
                if (!(ret instanceof Throwable)) return;
                throw new SharedContextSendException((Throwable)ret);
            }
            catch (RequestTimeoutException e) {
                throw new SharedContextTimeoutException(e);
            }
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
    }

    @Override
    public synchronized void save() throws Exception {
        this.save(-1L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void save(long timeout) throws Exception {
        if (this.isMain()) {
            AsynchContext asynchContext;
            int i;
            if (this.contextStore == null) throw new UnsupportedOperationException();
            if (this.isClearBeforeSave) {
                this.contextStore.clear();
            }
            if (this.parallelRequestQueueHandlerContainer == null) {
                for (int i2 = 0; i2 < this.sharedContextArray.length; ++i2) {
                    this.sharedContextArray[i2].save(timeout);
                }
                return;
            }
            DefaultQueueService responseQueue = new DefaultQueueService();
            try {
                responseQueue.create();
                responseQueue.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
            responseQueue.accept();
            for (i = 0; i < this.sharedContextArray.length; ++i) {
                asynchContext = new AsynchContext(new SaveParallelRequest(this.sharedContextArray[i], timeout), responseQueue);
                this.parallelRequestQueueHandlerContainer.push(asynchContext);
            }
            for (i = 0; i < this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                try {
                    asynchContext.checkError();
                    continue;
                }
                catch (Exception e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw new SharedContextSendException(th);
                }
            }
            return;
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, null);
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() == 0) return;
            message.setObject(new DistributedSharedContextEvent(4, new Long(timeout)));
            try {
                Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
                Object ret = responses[0].getObject();
                responses[0].recycle();
                if (!(ret instanceof Throwable)) return;
                throw new SharedContextSendException((Throwable)ret);
            }
            catch (RequestTimeoutException e) {
                throw new SharedContextTimeoutException(e);
            }
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
    }

    @Override
    public void save(Object key) throws Exception {
        this.save(key, -1L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void save(Object key, long timeout) throws Exception {
        if (this.isMain()) {
            if (this.contextStore == null) throw new UnsupportedOperationException();
            this.sharedContextArray[this.getDataNodeIndex(key)].save(key, timeout);
            return;
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() == 0) return;
            message.setObject(new DistributedSharedContextEvent(4, new Object[]{key, new Long(timeout)}));
            try {
                Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
                Object ret = responses[0].getObject();
                responses[0].recycle();
                if (!(ret instanceof Throwable)) return;
                throw new SharedContextSendException((Throwable)ret);
            }
            catch (RequestTimeoutException e) {
                throw new SharedContextTimeoutException(e);
            }
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
    }

    @Override
    public void lock(Object key) throws SharedContextSendException, SharedContextTimeoutException {
        this.lock(key, this.defaultTimeout);
    }

    protected SharedContext selectDistributeContext(Object key) {
        return this.sharedContextArray[this.getDataNodeIndex(key)];
    }

    @Override
    public void lock(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        this.selectDistributeContext(key).lock(key, timeout);
    }

    @Override
    public boolean unlock(Object key) throws SharedContextSendException {
        return this.unlock(key, false);
    }

    @Override
    public boolean unlock(Object key, boolean force) throws SharedContextSendException {
        return this.selectDistributeContext(key).unlock(key, force);
    }

    @Override
    public Object getLockOwner(Object key) {
        return this.selectDistributeContext(key).getLockOwner(key);
    }

    @Override
    public Object put(Object key, Object value) throws SharedContextSendException {
        return this.put(key, value, this.defaultTimeout);
    }

    @Override
    public Object put(Object key, Object value, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        return this.selectDistributeContext(key).put(key, value, timeout);
    }

    @Override
    public Object putLocal(Object key, Object value) {
        return this.selectDistributeContext(key).putLocal(key, value);
    }

    @Override
    public void putAsynch(Object key, Object value) throws SharedContextSendException {
        this.selectDistributeContext(key).putAsynch(key, value);
    }

    @Override
    public void update(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
        this.update(key, diff, this.defaultTimeout);
    }

    @Override
    public void update(Object key, SharedContextValueDifference diff, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        this.selectDistributeContext(key).update(key, diff, timeout);
    }

    @Override
    public void updateLocal(Object key, SharedContextValueDifference diff) throws SharedContextUpdateException {
        this.selectDistributeContext(key).updateLocal(key, diff);
    }

    @Override
    public void updateAsynch(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
        this.selectDistributeContext(key).updateAsynch(key, diff);
    }

    @Override
    public void updateIfExists(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
        this.updateIfExists(key, diff, this.defaultTimeout);
    }

    @Override
    public void updateIfExists(Object key, SharedContextValueDifference diff, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        this.selectDistributeContext(key).updateIfExists(key, diff, timeout);
    }

    @Override
    public void updateLocalIfExists(Object key, SharedContextValueDifference diff) throws SharedContextUpdateException {
        this.selectDistributeContext(key).updateLocalIfExists(key, diff);
    }

    @Override
    public void updateAsynchIfExists(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
        this.selectDistributeContext(key).updateAsynchIfExists(key, diff);
    }

    @Override
    public Object remove(Object key) throws SharedContextSendException {
        return this.remove(key, this.defaultTimeout);
    }

    @Override
    public Object remove(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        return this.selectDistributeContext(key).remove(key, timeout);
    }

    @Override
    public Object removeLocal(Object key) {
        return this.selectDistributeContext(key).removeLocal(key);
    }

    @Override
    public void removeAsynch(Object key) throws SharedContextSendException {
        this.selectDistributeContext(key).removeAsynch(key);
    }

    @Override
    public void putAll(Map t) {
        this.putAll(t, this.defaultTimeout);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void putAll(Map t, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        AsynchContext asynchContext;
        long start = System.currentTimeMillis();
        HashMap distMap = new HashMap();
        Iterator entries = t.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            SharedContext context = this.selectDistributeContext(entry.getKey());
            HashMap map = (HashMap)distMap.get(context);
            if (map == null) {
                map = new HashMap();
                distMap.put(context, map);
            }
            map.put(entry.getKey(), entry.getValue());
        }
        if (this.parallelRequestQueueHandlerContainer == null) {
            int completed = 0;
            for (Map.Entry entry : distMap.entrySet()) {
                if (timeout > 0L) {
                    long currentTimeout = timeout - (start - System.currentTimeMillis());
                    if (currentTimeout <= 0L) throw new SharedContextTimeoutException("There is a node that is not possible yet putAll. completed=" + completed + "notCompleted=" + (distMap.size() - completed));
                    ((SharedContext)entry.getKey()).putAll((Map)entry.getValue(), currentTimeout);
                } else {
                    ((SharedContext)entry.getKey()).putAll((Map)entry.getValue(), timeout);
                }
                ++completed;
            }
            return;
        }
        DefaultQueueService responseQueue = new DefaultQueueService();
        try {
            responseQueue.create();
            responseQueue.start();
        }
        catch (Exception entry) {
            // empty catch block
        }
        responseQueue.accept();
        while (entries.hasNext()) {
            Map.Entry entry;
            entry = entries.next();
            asynchContext = new AsynchContext(new PutAllParallelRequest((SharedContext)entry.getKey(), (Map)entry.getValue(), timeout), responseQueue);
            this.parallelRequestQueueHandlerContainer.push(asynchContext);
        }
        for (int i = 0; i < this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
            try {
                asynchContext.checkError();
                continue;
            }
            catch (SharedContextSendException e) {
                throw e;
            }
            catch (SharedContextTimeoutException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable th) {
                throw new SharedContextSendException(th);
            }
        }
    }

    @Override
    public synchronized void putAllLocal(Map t) {
        for (Map.Entry entry : t.entrySet()) {
            this.selectDistributeContext(entry.getKey()).putLocal(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized void putAllAsynch(Map t) throws SharedContextSendException {
        Iterator entries = t.entrySet().iterator();
        HashMap distMap = new HashMap();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            SharedContext context = this.selectDistributeContext(entry.getKey());
            HashMap map = (HashMap)distMap.get(context);
            if (map == null) {
                map = new HashMap();
                distMap.put(context, map);
            }
            map.put(entry.getKey(), entry.getValue());
        }
        if (this.parallelRequestQueueHandlerContainer == null) {
            for (Map.Entry entry : distMap.entrySet()) {
                ((SharedContext)entry.getKey()).putAllAsynch((Map)entry.getValue());
            }
        } else {
            AsynchContext asynchContext;
            DefaultQueueService responseQueue = new DefaultQueueService();
            try {
                responseQueue.create();
                responseQueue.start();
            }
            catch (Exception context) {
                // empty catch block
            }
            responseQueue.accept();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                asynchContext = new AsynchContext(new PutAllAsynchParallelRequest((SharedContext)entry.getKey(), (Map)entry.getValue()), responseQueue);
                this.parallelRequestQueueHandlerContainer.push(asynchContext);
            }
            for (int i = 0; i < this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                try {
                    asynchContext.checkError();
                    continue;
                }
                catch (SharedContextSendException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw new SharedContextSendException(th);
                }
            }
        }
    }

    @Override
    public void clear() throws SharedContextSendException {
        this.clear(this.defaultTimeout <= 0L ? 0L : this.defaultTimeout * (long)this.sharedContextArray.length);
    }

    @Override
    public synchronized void clear(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        if (this.parallelRequestQueueHandlerContainer == null) {
            for (int i = 0; i < this.sharedContextArray.length; ++i) {
                long start = System.currentTimeMillis();
                boolean isNoTimeout = timeout <= 0L;
                long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                if (!isNoTimeout && timeout < 0L) {
                    throw new SharedContextTimeoutException("There is a node that is not possible yet clear. completed=" + i + "notCompleted=" + (this.sharedContextArray.length - i));
                }
                this.sharedContextArray[i].clear(timeout);
            }
        } else {
            AsynchContext asynchContext;
            int i;
            DefaultQueueService responseQueue = new DefaultQueueService();
            try {
                responseQueue.create();
                responseQueue.start();
            }
            catch (Exception start) {
                // empty catch block
            }
            responseQueue.accept();
            for (i = 0; i < this.sharedContextArray.length; ++i) {
                asynchContext = new AsynchContext(new ClearParallelRequest(this.sharedContextArray[i], timeout), responseQueue);
                this.parallelRequestQueueHandlerContainer.push(asynchContext);
            }
            for (i = 0; i < this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                try {
                    asynchContext.checkError();
                    continue;
                }
                catch (SharedContextSendException e) {
                    throw e;
                }
                catch (SharedContextTimeoutException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw new SharedContextSendException(th);
                }
            }
        }
    }

    @Override
    public synchronized void clearLocal() {
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            this.sharedContextArray[i].clearLocal();
        }
    }

    @Override
    public synchronized void clearAsynch() throws SharedContextSendException {
        if (this.parallelRequestQueueHandlerContainer == null) {
            for (int i = 0; i < this.sharedContextArray.length; ++i) {
                this.sharedContextArray[i].clearAsynch();
            }
        } else {
            AsynchContext asynchContext;
            int i;
            DefaultQueueService responseQueue = new DefaultQueueService();
            try {
                responseQueue.create();
                responseQueue.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
            responseQueue.accept();
            for (i = 0; i < this.sharedContextArray.length; ++i) {
                asynchContext = new AsynchContext(new ClearAsynchParallelRequest(this.sharedContextArray[i]), responseQueue);
                this.parallelRequestQueueHandlerContainer.push(asynchContext);
            }
            for (i = 0; i < this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                try {
                    asynchContext.checkError();
                    continue;
                }
                catch (SharedContextSendException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw new SharedContextSendException(th);
                }
            }
        }
    }

    @Override
    public void analyzeIndex(String name) {
        if (this.parallelRequestQueueHandlerContainer == null) {
            for (int i = 0; i < this.sharedContextArray.length; ++i) {
                this.sharedContextArray[i].analyzeIndex(name);
            }
        } else {
            AsynchContext asynchContext;
            int i;
            DefaultQueueService responseQueue = new DefaultQueueService();
            try {
                responseQueue.create();
                responseQueue.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
            responseQueue.accept();
            for (i = 0; i < this.sharedContextArray.length; ++i) {
                asynchContext = new AsynchContext(new AnalyzeIndexParallelRequest(this.sharedContextArray[i], name), responseQueue);
                this.parallelRequestQueueHandlerContainer.push(asynchContext);
            }
            for (i = 0; i < this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                try {
                    asynchContext.checkError();
                    continue;
                }
                catch (SharedContextIllegalIndexException e) {
                    throw e;
                }
                catch (SharedContextSendException e) {
                    throw e;
                }
                catch (SharedContextTimeoutException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw new SharedContextSendException(th);
                }
            }
        }
    }

    @Override
    public SharedContextView createView() {
        return new DistributedSharedContextView();
    }

    @Override
    public Object executeInterpretQuery(String query, Map variables) throws EvaluateException, SharedContextSendException, SharedContextTimeoutException {
        return this.executeInterpretQuery(query, variables, this.defaultTimeout);
    }

    @Override
    public Object executeInterpretQuery(String query, Map variables, long timeout) throws EvaluateException, SharedContextSendException, SharedContextTimeoutException {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.parallelRequestQueueHandlerContainer == null) {
            for (int i = 0; i < this.sharedContextArray.length; ++i) {
                long start = System.currentTimeMillis();
                boolean isNoTimeout = timeout <= 0L;
                long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                if (!isNoTimeout && timeout < 0L) {
                    throw new SharedContextTimeoutException("nodeSize=" + this.sharedContextArray.length + ", responseCount=" + i);
                }
                result.add(this.sharedContextArray[i].executeInterpretQuery(query, variables, timeout));
            }
        } else {
            AsynchContext asynchContext;
            int i;
            DefaultQueueService responseQueue = new DefaultQueueService();
            try {
                responseQueue.create();
                responseQueue.start();
            }
            catch (Exception start) {
                // empty catch block
            }
            responseQueue.accept();
            for (i = 0; i < this.sharedContextArray.length; ++i) {
                asynchContext = new AsynchContext(new ExecuteInterpretQueryParallelRequest(this.sharedContextArray[i], query, variables, timeout), responseQueue);
                this.parallelRequestQueueHandlerContainer.push(asynchContext);
            }
            for (i = 0; i < this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                try {
                    asynchContext.checkError();
                }
                catch (EvaluateException e) {
                    throw e;
                }
                catch (SharedContextSendException e) {
                    throw e;
                }
                catch (SharedContextTimeoutException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw new SharedContextSendException(th);
                }
                result.add(asynchContext.getOutput());
            }
        }
        return result;
    }

    @Override
    public Object executeInterpretQuery(String query, String mergeQuery, Map variables) throws EvaluateException, SharedContextSendException, SharedContextTimeoutException {
        return this.executeInterpretQuery(query, mergeQuery, variables, this.defaultTimeout);
    }

    @Override
    public Object executeInterpretQuery(String query, String mergeQuery, Map variables, long timeout) throws EvaluateException, SharedContextSendException, SharedContextTimeoutException {
        if (this.interpreter == null) {
            throw new EvaluateException("Interpreter is null.");
        }
        List results = (List)this.executeInterpretQuery(query, variables, timeout);
        if (mergeQuery == null || mergeQuery.length() == 0) {
            return results;
        }
        if (variables == null) {
            variables = new HashMap<String, List>();
        }
        variables.put("results", results);
        return this.interpreter.evaluate(mergeQuery, variables);
    }

    @Override
    public Object get(Object key) throws SharedContextSendException {
        return this.get(key, this.defaultTimeout);
    }

    @Override
    public Object get(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        return this.selectDistributeContext(key).get(key, timeout);
    }

    @Override
    public Object getLocal(Object key) {
        return this.selectDistributeContext(key).getLocal(key);
    }

    @Override
    public Set keySet() throws SharedContextSendException {
        return this.keySet(this.defaultTimeout <= 0L ? 0L : this.defaultTimeout * (long)this.sharedContextArray.length);
    }

    @Override
    public synchronized Set keySet(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        HashSet result = new HashSet();
        if (this.parallelRequestQueueHandlerContainer == null) {
            for (int i = 0; i < this.sharedContextArray.length; ++i) {
                long start = System.currentTimeMillis();
                boolean isNoTimeout = timeout <= 0L;
                long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                if (!isNoTimeout && timeout < 0L) {
                    throw new SharedContextTimeoutException("nodeSize=" + this.sharedContextArray.length + ", responseCount=" + i);
                }
                result.addAll(this.sharedContextArray[i].keySet(timeout));
            }
        } else {
            AsynchContext asynchContext;
            int i;
            DefaultQueueService responseQueue = new DefaultQueueService();
            try {
                responseQueue.create();
                responseQueue.start();
            }
            catch (Exception start) {
                // empty catch block
            }
            responseQueue.accept();
            for (i = 0; i < this.sharedContextArray.length; ++i) {
                asynchContext = new AsynchContext(new KeySetParallelRequest(this.sharedContextArray[i], timeout), responseQueue);
                this.parallelRequestQueueHandlerContainer.push(asynchContext);
            }
            for (i = 0; i < this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                try {
                    asynchContext.checkError();
                }
                catch (SharedContextSendException e) {
                    throw e;
                }
                catch (SharedContextTimeoutException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw new SharedContextSendException(th);
                }
                result.addAll((Set)asynchContext.getOutput());
            }
        }
        return result;
    }

    @Override
    public synchronized Set keySetLocal() {
        HashSet result = new HashSet();
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            result.addAll(this.sharedContextArray[i].keySetLocal());
        }
        return result;
    }

    @Override
    public int size() throws SharedContextSendException {
        return this.size(this.defaultTimeout <= 0L ? 0L : this.defaultTimeout * (long)this.sharedContextArray.length);
    }

    @Override
    public synchronized int size(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        int result = 0;
        if (this.parallelRequestQueueHandlerContainer == null) {
            for (int i = 0; i < this.sharedContextArray.length; ++i) {
                long start = System.currentTimeMillis();
                boolean isNoTimeout = timeout <= 0L;
                long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                if (!isNoTimeout && timeout < 0L) {
                    throw new SharedContextTimeoutException("nodeSize=" + this.sharedContextArray.length + ", responseCount=" + i);
                }
                result += this.sharedContextArray[i].size(timeout);
            }
        } else {
            AsynchContext asynchContext;
            int i;
            DefaultQueueService responseQueue = new DefaultQueueService();
            try {
                responseQueue.create();
                responseQueue.start();
            }
            catch (Exception start) {
                // empty catch block
            }
            responseQueue.accept();
            for (i = 0; i < this.sharedContextArray.length; ++i) {
                asynchContext = new AsynchContext(new SizeParallelRequest(this.sharedContextArray[i], timeout), responseQueue);
                this.parallelRequestQueueHandlerContainer.push(asynchContext);
            }
            for (i = 0; i < this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                try {
                    asynchContext.checkError();
                }
                catch (SharedContextSendException e) {
                    throw e;
                }
                catch (SharedContextTimeoutException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw new SharedContextSendException(th);
                }
                result += ((Integer)asynchContext.getOutput()).intValue();
            }
        }
        return result;
    }

    @Override
    public synchronized int sizeLocal() {
        int result = 0;
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            result += this.sharedContextArray[i].sizeLocal();
        }
        return result;
    }

    @Override
    public boolean isEmpty() throws SharedContextSendException {
        return this.size() == 0;
    }

    @Override
    public boolean isEmptyLocal() {
        return this.sizeLocal() == 0;
    }

    @Override
    public boolean containsKey(Object key) throws SharedContextSendException {
        return this.containsKey(key, this.defaultTimeout);
    }

    @Override
    public boolean containsKey(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        return this.selectDistributeContext(key).containsKey(key, timeout);
    }

    @Override
    public boolean containsKeyLocal(Object key) {
        return this.selectDistributeContext(key).containsKeyLocal(key);
    }

    @Override
    public boolean containsValue(Object value) throws SharedContextSendException {
        return this.containsValue(value, this.defaultTimeout <= 0L ? 0L : this.defaultTimeout * (long)this.sharedContextArray.length);
    }

    @Override
    public boolean containsValue(Object value, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        if (this.parallelRequestQueueHandlerContainer == null) {
            for (int i = 0; i < this.sharedContextArray.length; ++i) {
                long start = System.currentTimeMillis();
                boolean isNoTimeout = timeout <= 0L;
                long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                if (!isNoTimeout && timeout < 0L) {
                    throw new SharedContextTimeoutException("nodeSize=" + this.sharedContextArray.length + ", responseCount=" + i);
                }
                if (!this.sharedContextArray[i].containsValue(value, timeout)) continue;
                return true;
            }
        } else {
            AsynchContext asynchContext;
            int i;
            DefaultQueueService responseQueue = new DefaultQueueService();
            try {
                responseQueue.create();
                responseQueue.start();
            }
            catch (Exception start) {
                // empty catch block
            }
            responseQueue.accept();
            for (i = 0; i < this.sharedContextArray.length; ++i) {
                asynchContext = new AsynchContext(new ContainsValueParallelRequest(this.sharedContextArray[i], value, timeout), responseQueue);
                this.parallelRequestQueueHandlerContainer.push(asynchContext);
            }
            for (i = 0; i < this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                try {
                    asynchContext.checkError();
                }
                catch (SharedContextSendException e) {
                    throw e;
                }
                catch (SharedContextTimeoutException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw new SharedContextSendException(th);
                }
                if (!((Boolean)asynchContext.getOutput()).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsValueLocal(Object value) {
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            if (!this.sharedContextArray[i].containsValueLocal(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection valuesLocal() {
        ArrayList result = new ArrayList();
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            result.addAll(this.sharedContextArray[i].valuesLocal());
        }
        return result;
    }

    @Override
    public Map all() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map allLocal() {
        HashMap result = new HashMap();
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            result.putAll(this.sharedContextArray[i].allLocal());
        }
        return result;
    }

    @Override
    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set entrySetLocal() {
        LinkedHashSet result = new LinkedHashSet();
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            result.addAll(this.sharedContextArray[i].entrySetLocal());
        }
        return result;
    }

    @Override
    public int getNodeCount() {
        return this.sharedContextArray != null ? this.sharedContextArray.length : this.getDistributedSize();
    }

    @Override
    public int getDataNodeIndex(Object key) {
        return this.keyDistributor.selectDataNodeIndex(key, this.sharedContextArray.length);
    }

    @Override
    public int size(int nodeIndex) throws SharedContextSendException, SharedContextTimeoutException {
        return this.sharedContextArray[nodeIndex].size();
    }

    @Override
    public Set keySet(int nodeIndex) throws SharedContextSendException, SharedContextTimeoutException {
        return this.sharedContextArray[nodeIndex].keySet();
    }

    @Override
    public Set keySetMain() throws SharedContextSendException, SharedContextTimeoutException {
        HashSet keySet = new HashSet();
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            if (!this.sharedContextArray[i].isMain()) continue;
            keySet.addAll(this.sharedContextArray[i].keySet());
        }
        return keySet;
    }

    @Override
    public boolean isClient(int nodeIndex) {
        return this.sharedContextArray[nodeIndex].isClient();
    }

    @Override
    public boolean isMain(int nodeIndex) {
        return this.sharedContextArray[nodeIndex].isMain();
    }

    @Override
    public boolean isMain(Object key) {
        int nodeIndex = this.getDataNodeIndex(key);
        return nodeIndex >= 0 ? this.sharedContextArray[nodeIndex].isMain() : false;
    }

    @Override
    public void addSharedContextUpdateListener(SharedContextUpdateListener listener) {
        if (this.updateListeners == null) {
            this.updateListeners = Collections.synchronizedList(new ArrayList());
        }
        if (!this.updateListeners.contains(listener)) {
            this.updateListeners.add(listener);
        }
        if (this.sharedContextArray != null) {
            for (int i = 0; i < this.sharedContextArray.length; ++i) {
                this.sharedContextArray[i].addSharedContextUpdateListener(listener);
            }
        }
    }

    @Override
    public void removeSharedContextUpdateListener(SharedContextUpdateListener listener) {
        if (this.updateListeners == null) {
            return;
        }
        this.updateListeners.remove(listener);
        if (this.sharedContextArray != null) {
            for (int i = 0; i < this.sharedContextArray.length; ++i) {
                this.sharedContextArray[i].removeSharedContextUpdateListener(listener);
            }
        }
    }

    @Override
    public String displayDistributeInfo() throws SharedContextSendException, SharedContextTimeoutException {
        DistributeGrid grid;
        block7: {
            grid = new DistributeGrid();
            try {
                Message message = this.serverConnection.createMessage(this.subject, Integer.toString(1));
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (!this.isClient) {
                    grid.addDistributeInfo(this.distributeInfo);
                }
                if (receiveClients.size() == 0) break block7;
                long timeout = this.rehashTimeout;
                message.setObject(new DistributedSharedContextEvent(1, new Long(timeout)));
                try {
                    Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 0, timeout);
                    for (int i = 0; i < responses.length; ++i) {
                        grid.addDistributeInfo((DistributeInfo)responses[i].getObject());
                        responses[i].recycle();
                    }
                }
                catch (RequestTimeoutException e) {
                    throw new SharedContextTimeoutException(e);
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
        }
        return grid.toString();
    }

    @Override
    public void onMessage(Message message) {
    }

    @Override
    public Message onRequestMessage(Object sourceId, int sequence, Message message, String responseSubject, String responseKey) {
        DistributedSharedContextEvent event = null;
        try {
            event = (DistributedSharedContextEvent)message.getObject();
        }
        catch (MessageException e) {
            return null;
        }
        Message result = null;
        switch (event.type) {
            case 1: {
                result = this.onGetDistributeInfo(event, responseSubject, responseKey);
                break;
            }
            case 3: {
                result = this.onRehash(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 2: {
                this.onRehashRequest(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 4: {
                result = this.onSave(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 5: {
                result = this.onLoad(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 6: {
                result = this.onLoadKey(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 7: {
                result = this.onRehashSwitch(event, responseSubject, responseKey);
                break;
            }
        }
        return result;
    }

    protected Message createResponseMessage(String responseSubject, String responseKey, Object response) {
        Message result = null;
        try {
            result = this.serverConnection.createMessage(responseSubject, responseKey);
            result.setObject(response);
        }
        catch (MessageException e) {
            this.getLogger().write("DSCS_00001", new Object[]{this.isClient ? this.clientSubject : this.subject, responseSubject, responseKey, response}, (Throwable)e);
        }
        return result;
    }

    protected Message onGetDistributeInfo(DistributedSharedContextEvent event, String responseSubject, String responseKey) {
        return this.createResponseMessage(responseSubject, responseKey, this.distributeInfo);
    }

    protected Message onRehashRequest(final DistributedSharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        if (this.isMain()) {
            Thread rehashThread = new Thread(){

                @Override
                public void run() {
                    Message response = null;
                    try {
                        DistributedSharedContextService.this.rehash((Long)event.value);
                        response = DistributedSharedContextService.this.createResponseMessage(responseSubject, responseKey, null);
                    }
                    catch (Throwable th) {
                        response = DistributedSharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                    }
                    try {
                        DistributedSharedContextService.this.serverConnection.response(sourceId, sequence, response);
                    }
                    catch (MessageSendException e) {
                        DistributedSharedContextService.this.getLogger().write("DSCS_00002", new Object[]{DistributedSharedContextService.this.isClient ? DistributedSharedContextService.this.clientSubject : DistributedSharedContextService.this.subject, response}, (Throwable)e);
                    }
                }
            };
            rehashThread.start();
        }
        return null;
    }

    protected Message onRehash(DistributedSharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        final DistributeInfo info = (DistributeInfo)event.value;
        Thread rehashThread = new Thread(){

            @Override
            public void run() {
                Message response = null;
                try {
                    info.apply(DistributedSharedContextService.this.distributeInfo, DistributedSharedContextService.this.sharedContextArray);
                    response = DistributedSharedContextService.this.createResponseMessage(responseSubject, responseKey, null);
                }
                catch (Throwable th) {
                    response = DistributedSharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                }
                try {
                    DistributedSharedContextService.this.serverConnection.response(sourceId, sequence, response);
                }
                catch (MessageSendException e) {
                    DistributedSharedContextService.this.getLogger().write("DSCS_00002", new Object[]{DistributedSharedContextService.this.isClient ? DistributedSharedContextService.this.clientSubject : DistributedSharedContextService.this.subject, response}, (Throwable)e);
                }
            }
        };
        rehashThread.start();
        return null;
    }

    protected Message onSave(final DistributedSharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        if (this.isMain()) {
            Thread saveThread = new Thread(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    Message response = null;
                    try {
                        Object param = event.value;
                        if (param instanceof Long) {
                            long timeout = (Long)param;
                            if (DistributedSharedContextService.this.contextStore == null) throw new UnsupportedOperationException();
                            if (DistributedSharedContextService.this.isClearBeforeSave) {
                                DistributedSharedContextService.this.contextStore.clear();
                            }
                            for (int i = 0; i < DistributedSharedContextService.this.sharedContextArray.length; ++i) {
                                long start = System.currentTimeMillis();
                                boolean isNoTimeout = timeout <= 0L;
                                long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                                if (!isNoTimeout && timeout < 0L) {
                                    throw new SharedContextTimeoutException();
                                }
                                DistributedSharedContextService.this.sharedContextArray[i].save(timeout);
                            }
                        } else {
                            Object key = ((Object[])param)[0];
                            long timeout = (Long)((Object[])param)[1];
                            if (DistributedSharedContextService.this.contextStore == null) throw new UnsupportedOperationException();
                            DistributedSharedContextService.this.sharedContextArray[DistributedSharedContextService.this.getDataNodeIndex(key)].save(key, timeout);
                        }
                        response = DistributedSharedContextService.this.createResponseMessage(responseSubject, responseKey, null);
                    }
                    catch (Throwable th) {
                        response = DistributedSharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                    }
                    try {
                        DistributedSharedContextService.this.serverConnection.response(sourceId, sequence, response);
                        return;
                    }
                    catch (MessageSendException e) {
                        DistributedSharedContextService.this.getLogger().write("DSCS_00002", new Object[]{DistributedSharedContextService.this.isClient ? DistributedSharedContextService.this.clientSubject : DistributedSharedContextService.this.subject, response}, (Throwable)e);
                    }
                }
            };
            saveThread.start();
        }
        return null;
    }

    protected synchronized Message onLoad(final DistributedSharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        if (this.isMain()) {
            Thread loadThread = new Thread(){

                @Override
                public void run() {
                    Message response = null;
                    try {
                        if (DistributedSharedContextService.this.contextStore != null) {
                            if (event.value == null) {
                                DistributedSharedContextService.this.contextStore.load(DistributedSharedContextService.this);
                            } else {
                                DistributedSharedContextService.this.contextStore.load(DistributedSharedContextService.this, event.value);
                            }
                        } else {
                            throw new UnsupportedOperationException();
                        }
                        response = DistributedSharedContextService.this.createResponseMessage(responseSubject, responseKey, null);
                    }
                    catch (Throwable th) {
                        response = DistributedSharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                    }
                    try {
                        DistributedSharedContextService.this.serverConnection.response(sourceId, sequence, response);
                    }
                    catch (MessageSendException e) {
                        DistributedSharedContextService.this.getLogger().write("DSCS_00002", new Object[]{DistributedSharedContextService.this.isClient ? DistributedSharedContextService.this.clientSubject : DistributedSharedContextService.this.subject, response}, (Throwable)e);
                    }
                }
            };
            loadThread.start();
        }
        return null;
    }

    protected synchronized Message onLoadKey(DistributedSharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        if (this.isMain()) {
            Thread loadThread = new Thread(){

                @Override
                public void run() {
                    Message response = null;
                    try {
                        if (DistributedSharedContextService.this.contextStore == null) {
                            throw new UnsupportedOperationException();
                        }
                        DistributedSharedContextService.this.contextStore.loadKey(DistributedSharedContextService.this);
                        response = DistributedSharedContextService.this.createResponseMessage(responseSubject, responseKey, null);
                    }
                    catch (Throwable th) {
                        response = DistributedSharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                    }
                    try {
                        DistributedSharedContextService.this.serverConnection.response(sourceId, sequence, response);
                    }
                    catch (MessageSendException e) {
                        DistributedSharedContextService.this.getLogger().write("DSCS_00002", new Object[]{DistributedSharedContextService.this.isClient ? DistributedSharedContextService.this.clientSubject : DistributedSharedContextService.this.subject, response}, (Throwable)e);
                    }
                }
            };
            loadThread.start();
        }
        return null;
    }

    protected synchronized Message onRehashSwitch(DistributedSharedContextEvent event, String responseSubject, String responseKey) {
        this.isRehashEnabled = (Boolean)event.value;
        return this.createResponseMessage(responseSubject, responseKey, null);
    }

    @Override
    public boolean isMain() {
        return this.isMain(this.cluster.getMembers());
    }

    private boolean isMain(List members) {
        if (this.isClient) {
            return false;
        }
        Set targetMembers = this.serverConnection.getReceiveClientIds(this.targetMessage);
        Object myId = this.cluster.getUID();
        int imax = members.size();
        for (int i = 0; i < imax; ++i) {
            Object id = members.get(i);
            if (id.equals(myId)) {
                return true;
            }
            if (!targetMembers.contains(id)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getId() {
        return this.cluster == null ? null : this.cluster.getUID();
    }

    @Override
    public Object getMainId() {
        if (this.cluster == null) {
            return null;
        }
        Object myId = this.cluster.getUID();
        List members = this.cluster.getMembers();
        Set targetMembers = this.serverConnection.getReceiveClientIds(this.targetMessage);
        int imax = members.size();
        for (int i = 0; i < imax; ++i) {
            Object id = members.get(i);
            if (id.equals(myId)) {
                return myId;
            }
            if (!targetMembers.contains(id)) continue;
            return id;
        }
        return myId;
    }

    @Override
    public List getMemberIdList() {
        return this.cluster == null ? new ArrayList() : this.cluster.getMembers();
    }

    @Override
    public Set getClientMemberIdSet() {
        if (this.serverConnection == null || this.clientSubject == null) {
            return new HashSet();
        }
        try {
            Message message = this.serverConnection.createMessage(this.clientSubject, null);
            Set result = this.serverConnection.getReceiveClientIds(message);
            if (this.isClient) {
                result.add(this.getId());
            }
            return result;
        }
        catch (MessageException e) {
            return new HashSet();
        }
    }

    @Override
    public Set getServerMemberIdSet() {
        if (this.serverConnection == null) {
            return new HashSet();
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, null);
            Set result = this.serverConnection.getReceiveClientIds(message);
            if (!this.isClient) {
                result.add(this.getId());
            }
            return result;
        }
        catch (MessageException e) {
            return new HashSet();
        }
    }

    @Override
    public void memberInit(Object myId, List members) {
    }

    @Override
    public void memberChange(List oldMembers, List newMembers) {
        if (this.isMain(newMembers)) {
            HashSet deadMembers = new HashSet(oldMembers);
            deadMembers.removeAll(newMembers);
            if (deadMembers.size() != 0) {
                try {
                    this.rehash();
                }
                catch (Throwable th) {
                    this.getLogger().write("DSCS_00003", new Object[]{this.isClient ? this.clientSubject : this.subject}, th);
                }
            }
        }
    }

    @Override
    public void changeMain() throws Exception {
    }

    @Override
    public void changeSub() {
    }

    protected class SearchRangePropertyParallelRequest
    extends SharedContextViewParallelRequest {
        private long timeout;
        private Object fromProp;
        private Object toProp;
        private String indexName;
        private String propName;
        private boolean fromInclusive;
        private boolean toInclusive;

        public SearchRangePropertyParallelRequest(SharedContextView view, long timeout, Object fromProp, Object toProp, String indexName, String propName) {
            super(view);
            this.timeout = timeout;
            this.fromProp = fromProp;
            this.toProp = toProp;
            this.indexName = indexName;
            this.propName = propName;
        }

        public SearchRangePropertyParallelRequest(SharedContextView view, long timeout, Object fromProp, boolean fromInclusive, Object toProp, boolean toInclusive, String indexName, String propName) {
            this(view, timeout, fromProp, toProp, indexName, propName);
            this.fromInclusive = fromInclusive;
            this.toInclusive = toInclusive;
        }

        @Override
        public Object execute() throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.view.searchRangeProperty(this.timeout, this.fromProp, this.fromInclusive, this.toProp, this.toInclusive, this.indexName, this.propName);
        }
    }

    protected class SearchRangeParallelRequest
    extends SharedContextViewParallelRequest {
        private long timeout;
        private Object fromValue;
        private Object toValue;
        private String indexName;
        private String propName;
        private boolean fromInclusive;
        private boolean toInclusive;

        public SearchRangeParallelRequest(SharedContextView view, long timeout, Object fromValue, Object toValue, String indexName, String propName) {
            super(view);
            this.timeout = timeout;
            this.fromValue = fromValue;
            this.toValue = toValue;
            this.indexName = indexName;
            this.propName = propName;
        }

        public SearchRangeParallelRequest(SharedContextView view, long timeout, Object fromValue, boolean fromInclusive, Object toValue, boolean toInclusive, String indexName, String propName) {
            this(view, timeout, fromValue, toValue, indexName, propName);
            this.fromInclusive = fromInclusive;
            this.toInclusive = toInclusive;
        }

        @Override
        public Object execute() throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.view.searchRange(this.timeout, this.fromValue, this.fromInclusive, this.toValue, this.toInclusive, this.indexName, this.propName);
        }
    }

    protected class SearchToPropertyParallelRequest
    extends SharedContextViewParallelRequest {
        private long timeout;
        private Object toProp;
        private String indexName;
        private String propName;
        private boolean inclusive;

        public SearchToPropertyParallelRequest(SharedContextView view, long timeout, Object toProp, String indexName, String propName) {
            super(view);
            this.timeout = timeout;
            this.toProp = toProp;
            this.indexName = indexName;
            this.propName = propName;
        }

        public SearchToPropertyParallelRequest(SharedContextView view, long timeout, Object toProp, boolean inclusive, String indexName, String propName) {
            this(view, timeout, toProp, indexName, propName);
            this.inclusive = inclusive;
        }

        @Override
        public Object execute() throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.view.searchToProperty(this.timeout, this.toProp, this.inclusive, this.indexName, this.propName);
        }
    }

    protected class SearchToParallelRequest
    extends SharedContextViewParallelRequest {
        private long timeout;
        private Object toValue;
        private String indexName;
        private String propName;
        private boolean inclusive;

        public SearchToParallelRequest(SharedContextView view, long timeout, Object toValue, String indexName, String propName) {
            super(view);
            this.timeout = timeout;
            this.toValue = toValue;
            this.indexName = indexName;
            this.propName = propName;
        }

        public SearchToParallelRequest(SharedContextView view, long timeout, Object toValue, boolean inclusive, String indexName, String propName) {
            this(view, timeout, toValue, indexName, propName);
            this.inclusive = inclusive;
        }

        @Override
        public Object execute() throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.view.searchTo(this.timeout, this.toValue, this.inclusive, this.indexName, this.propName);
        }
    }

    protected class SearchFromPropertyParallelRequest
    extends SharedContextViewParallelRequest {
        private long timeout;
        private Object fromProp;
        private String indexName;
        private String propName;
        private boolean inclusive;

        public SearchFromPropertyParallelRequest(SharedContextView view, long timeout, Object fromProp, String indexName, String propName) {
            super(view);
            this.timeout = timeout;
            this.fromProp = fromProp;
            this.indexName = indexName;
            this.propName = propName;
        }

        public SearchFromPropertyParallelRequest(SharedContextView view, long timeout, Object fromProp, boolean inclusive, String indexName, String propName) {
            this(view, timeout, fromProp, indexName, propName);
            this.inclusive = inclusive;
        }

        @Override
        public Object execute() throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.view.searchFromProperty(this.timeout, this.fromProp, this.inclusive, this.indexName, this.propName);
        }
    }

    protected class SearchFromParallelRequest
    extends SharedContextViewParallelRequest {
        private long timeout;
        private Object fromValue;
        private String indexName;
        private String propName;
        private boolean inclusive;

        public SearchFromParallelRequest(SharedContextView view, long timeout, Object fromValue, String indexName, String propName) {
            super(view);
            this.inclusive = true;
            this.timeout = timeout;
            this.fromValue = fromValue;
            this.indexName = indexName;
            this.propName = propName;
        }

        public SearchFromParallelRequest(SharedContextView view, long timeout, Object fromValue, boolean inclusive, String indexName, String propName) {
            this(view, timeout, fromValue, indexName, propName);
            this.inclusive = inclusive;
        }

        @Override
        public Object execute() throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.view.searchFrom(this.timeout, this.fromValue, this.inclusive, this.indexName, this.propName);
        }
    }

    protected class SearchInPropertyMapParallelRequest
    extends SharedContextViewParallelRequest {
        private long timeout;
        private String indexName;
        private Map[] props;

        public SearchInPropertyMapParallelRequest(SharedContextView view, long timeout, String indexName, Map[] props) {
            super(view);
            this.timeout = timeout;
            this.props = props;
            this.indexName = indexName;
        }

        @Override
        public Object execute() throws IndexNotFoundException, IllegalArgumentException, SharedContextSendException, SharedContextTimeoutException {
            return this.view.searchInProperty(this.timeout, this.indexName, this.props);
        }
    }

    protected class SearchByPropertyMapParallelRequest
    extends SharedContextViewParallelRequest {
        private long timeout;
        private Map props;
        private String indexName;

        public SearchByPropertyMapParallelRequest(SharedContextView view, long timeout, Map props, String indexName) {
            super(view);
            this.timeout = timeout;
            this.props = props;
            this.indexName = indexName;
        }

        @Override
        public Object execute() throws IndexNotFoundException, IllegalArgumentException, SharedContextSendException, SharedContextTimeoutException {
            return this.view.searchByProperty(this.timeout, this.props, this.indexName);
        }
    }

    protected class SearchInPropertyParallelRequest
    extends SharedContextViewParallelRequest {
        private long timeout;
        private String indexName;
        private String propName;
        private Object[] props;

        public SearchInPropertyParallelRequest(SharedContextView view, long timeout, String indexName, String propName, Object[] props) {
            super(view);
            this.timeout = timeout;
            this.indexName = indexName;
            this.propName = propName;
            this.props = props;
        }

        @Override
        public Object execute() throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.view.searchInProperty(this.timeout, this.indexName, this.propName, this.props);
        }
    }

    protected class SearchByPropertyParallelRequest
    extends SharedContextViewParallelRequest {
        private long timeout;
        private Object prop;
        private String indexName;
        private String propName;

        public SearchByPropertyParallelRequest(SharedContextView view, long timeout, Object prop, String indexName, String propName) {
            super(view);
            this.timeout = timeout;
            this.indexName = indexName;
            this.propName = propName;
            this.prop = prop;
        }

        @Override
        public Object execute() throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.view.searchByProperty(this.timeout, this.prop, this.indexName, this.propName);
        }
    }

    protected class SearchInParallelRequest
    extends SharedContextViewParallelRequest {
        private long timeout;
        private String indexName;
        private String[] propNames;
        private Object[] values;

        public SearchInParallelRequest(SharedContextView view, long timeout, String indexName, String[] propNames, Object[] values) {
            super(view);
            this.timeout = timeout;
            this.indexName = indexName;
            this.propNames = propNames;
            this.values = values;
        }

        @Override
        public Object execute() throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.view.searchIn(this.timeout, this.indexName, this.propNames, this.values);
        }
    }

    protected class SearchByParallelRequest
    extends SharedContextViewParallelRequest {
        private long timeout;
        private Object value;
        private String indexName;
        private String[] propNames;

        public SearchByParallelRequest(SharedContextView view, long timeout, Object value, String indexName, String[] propNames) {
            super(view);
            this.timeout = timeout;
            this.value = value;
            this.indexName = indexName;
            this.propNames = propNames;
        }

        @Override
        public Object execute() throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.view.searchBy(this.timeout, this.value, this.indexName, this.propNames);
        }
    }

    protected class SearchNotNullParallelRequest
    extends SharedContextViewParallelRequest {
        private long timeout;
        private String indexName;
        private String propName;

        public SearchNotNullParallelRequest(SharedContextView view, long timeout, String indexName, String propName) {
            super(view);
            this.timeout = timeout;
            this.indexName = indexName;
            this.propName = propName;
        }

        @Override
        public Object execute() throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.view.searchNotNull(this.timeout, this.indexName, this.propName);
        }
    }

    protected class SearchNullParallelRequest
    extends SharedContextViewParallelRequest {
        private long timeout;
        private String indexName;
        private String propName;

        public SearchNullParallelRequest(SharedContextView view, long timeout, String indexName, String propName) {
            super(view);
            this.timeout = timeout;
            this.indexName = indexName;
            this.propName = propName;
        }

        @Override
        public Object execute() throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.view.searchNull(this.timeout, this.indexName, this.propName);
        }
    }

    protected class SearchKeyParallelRequest
    extends SharedContextViewParallelRequest {
        private long timeout;
        private String indexName;
        private String[] propNames;

        public SearchKeyParallelRequest(SharedContextView view, long timeout, String indexName, String[] propNames) {
            super(view);
            this.timeout = timeout;
            this.indexName = indexName;
            this.propNames = propNames;
        }

        @Override
        public Object execute() throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.view.searchKey(this.timeout, this.indexName, this.propNames);
        }
    }

    protected abstract class SharedContextViewParallelRequest
    extends ParallelRequest {
        protected SharedContextView view;

        public SharedContextViewParallelRequest(SharedContextView view) {
            this.view = view;
        }
    }

    protected class DistributedSharedContextView
    implements SharedContextView,
    Cloneable {
        protected SharedContextView[] views;

        public DistributedSharedContextView() {
            this.views = new SharedContextView[DistributedSharedContextService.this.sharedContextArray.length];
            for (int i = 0; i < DistributedSharedContextService.this.sharedContextArray.length; ++i) {
                this.views[i] = DistributedSharedContextService.this.sharedContextArray[i].createView();
            }
        }

        @Override
        public Set getResultSet() {
            HashSet result = new HashSet();
            for (int i = 0; i < this.views.length; ++i) {
                result.addAll(this.views[i].getResultSet());
            }
            return result;
        }

        @Override
        public SharedContextView and() {
            for (int i = 0; i < this.views.length; ++i) {
                this.views[i].and();
            }
            return this;
        }

        @Override
        public SharedContextView or() {
            for (int i = 0; i < this.views.length; ++i) {
                this.views[i].or();
            }
            return this;
        }

        @Override
        public SharedContextView nand() {
            for (int i = 0; i < this.views.length; ++i) {
                this.views[i].nand();
            }
            return this;
        }

        @Override
        public SharedContextView nor() {
            for (int i = 0; i < this.views.length; ++i) {
                this.views[i].nor();
            }
            return this;
        }

        @Override
        public SharedContextView xor() {
            for (int i = 0; i < this.views.length; ++i) {
                this.views[i].xor();
            }
            return this;
        }

        @Override
        public SharedContextView xnor() {
            for (int i = 0; i < this.views.length; ++i) {
                this.views[i].xnor();
            }
            return this;
        }

        @Override
        public SharedContextView imp() {
            for (int i = 0; i < this.views.length; ++i) {
                this.views[i].imp();
            }
            return this;
        }

        @Override
        public SharedContextView nimp() {
            for (int i = 0; i < this.views.length; ++i) {
                this.views[i].nimp();
            }
            return this;
        }

        @Override
        public SharedContextView cimp() {
            for (int i = 0; i < this.views.length; ++i) {
                this.views[i].cimp();
            }
            return this;
        }

        @Override
        public SharedContextView cnimp() {
            for (int i = 0; i < this.views.length; ++i) {
                this.views[i].cnimp();
            }
            return this;
        }

        @Override
        public SharedContextView not() {
            for (int i = 0; i < this.views.length; ++i) {
                this.views[i].not();
            }
            return this;
        }

        @Override
        public SharedContextView and(SharedContextView view) {
            for (int i = 0; i < this.views.length; ++i) {
                this.views[i].and(view);
            }
            return this;
        }

        @Override
        public SharedContextView or(SharedContextView view) {
            for (int i = 0; i < this.views.length; ++i) {
                this.views[i].or(view);
            }
            return this;
        }

        @Override
        public SharedContextView nand(SharedContextView view) {
            for (int i = 0; i < this.views.length; ++i) {
                this.views[i].nand(view);
            }
            return this;
        }

        @Override
        public SharedContextView nor(SharedContextView view) {
            for (int i = 0; i < this.views.length; ++i) {
                this.views[i].nor(view);
            }
            return this;
        }

        @Override
        public SharedContextView xor(SharedContextView view) {
            for (int i = 0; i < this.views.length; ++i) {
                this.views[i].xor(view);
            }
            return this;
        }

        @Override
        public SharedContextView xnor(SharedContextView view) {
            for (int i = 0; i < this.views.length; ++i) {
                this.views[i].xnor(view);
            }
            return this;
        }

        @Override
        public SharedContextView imp(SharedContextView view) {
            for (int i = 0; i < this.views.length; ++i) {
                this.views[i].imp(view);
            }
            return this;
        }

        @Override
        public SharedContextView nimp(SharedContextView view) {
            for (int i = 0; i < this.views.length; ++i) {
                this.views[i].nimp(view);
            }
            return this;
        }

        @Override
        public SharedContextView cimp(SharedContextView view) {
            for (int i = 0; i < this.views.length; ++i) {
                this.views[i].cimp(view);
            }
            return this;
        }

        @Override
        public SharedContextView cnimp(SharedContextView view) {
            for (int i = 0; i < this.views.length; ++i) {
                this.views[i].cnimp(view);
            }
            return this;
        }

        @Override
        public SharedContextView searchKey(String indexName, String[] propNames) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchKey(DistributedSharedContextService.this.defaultTimeout, indexName, propNames);
        }

        @Override
        public SharedContextView searchKey(long timeout, String indexName, String[] propNames) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            if (DistributedSharedContextService.this.parallelRequestQueueHandlerContainer == null) {
                for (int i = 0; i < this.views.length; ++i) {
                    long start = System.currentTimeMillis();
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout < 0L) {
                        throw new SharedContextTimeoutException("nodeSize=" + this.views.length + ", responseCount=" + i);
                    }
                    this.views[i].searchKey(timeout, indexName, propNames);
                }
            } else {
                AsynchContext asynchContext;
                int i;
                DefaultQueueService responseQueue = new DefaultQueueService();
                try {
                    responseQueue.create();
                    responseQueue.start();
                }
                catch (Exception start) {
                    // empty catch block
                }
                responseQueue.accept();
                for (i = 0; i < this.views.length; ++i) {
                    asynchContext = new AsynchContext(new SearchKeyParallelRequest(this.views[i], timeout, indexName, propNames), responseQueue);
                    DistributedSharedContextService.this.parallelRequestQueueHandlerContainer.push(asynchContext);
                }
                for (i = 0; i < DistributedSharedContextService.this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                    try {
                        asynchContext.checkError();
                        continue;
                    }
                    catch (IndexNotFoundException e) {
                        throw e;
                    }
                    catch (SharedContextSendException e) {
                        throw e;
                    }
                    catch (SharedContextTimeoutException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        throw new SharedContextSendException(th);
                    }
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchNull(String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchNull(DistributedSharedContextService.this.defaultTimeout, indexName, propName);
        }

        @Override
        public SharedContextView searchNull(long timeout, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            if (DistributedSharedContextService.this.parallelRequestQueueHandlerContainer == null) {
                for (int i = 0; i < this.views.length; ++i) {
                    long start = System.currentTimeMillis();
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout < 0L) {
                        throw new SharedContextTimeoutException("nodeSize=" + this.views.length + ", responseCount=" + i);
                    }
                    this.views[i].searchNull(timeout, indexName, propName);
                }
            } else {
                AsynchContext asynchContext;
                int i;
                DefaultQueueService responseQueue = new DefaultQueueService();
                try {
                    responseQueue.create();
                    responseQueue.start();
                }
                catch (Exception start) {
                    // empty catch block
                }
                responseQueue.accept();
                for (i = 0; i < this.views.length; ++i) {
                    asynchContext = new AsynchContext(new SearchNullParallelRequest(this.views[i], timeout, indexName, propName), responseQueue);
                    DistributedSharedContextService.this.parallelRequestQueueHandlerContainer.push(asynchContext);
                }
                for (i = 0; i < DistributedSharedContextService.this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                    try {
                        asynchContext.checkError();
                        continue;
                    }
                    catch (IndexNotFoundException e) {
                        throw e;
                    }
                    catch (SharedContextSendException e) {
                        throw e;
                    }
                    catch (SharedContextTimeoutException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        throw new SharedContextSendException(th);
                    }
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchNotNull(String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchNotNull(DistributedSharedContextService.this.defaultTimeout, indexName, propName);
        }

        @Override
        public SharedContextView searchNotNull(long timeout, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            if (DistributedSharedContextService.this.parallelRequestQueueHandlerContainer == null) {
                for (int i = 0; i < this.views.length; ++i) {
                    long start = System.currentTimeMillis();
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout < 0L) {
                        throw new SharedContextTimeoutException("nodeSize=" + this.views.length + ", responseCount=" + i);
                    }
                    this.views[i].searchNotNull(timeout, indexName, propName);
                }
            } else {
                AsynchContext asynchContext;
                int i;
                DefaultQueueService responseQueue = new DefaultQueueService();
                try {
                    responseQueue.create();
                    responseQueue.start();
                }
                catch (Exception start) {
                    // empty catch block
                }
                responseQueue.accept();
                for (i = 0; i < this.views.length; ++i) {
                    asynchContext = new AsynchContext(new SearchNotNullParallelRequest(this.views[i], timeout, indexName, propName), responseQueue);
                    DistributedSharedContextService.this.parallelRequestQueueHandlerContainer.push(asynchContext);
                }
                for (i = 0; i < DistributedSharedContextService.this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                    try {
                        asynchContext.checkError();
                        continue;
                    }
                    catch (IndexNotFoundException e) {
                        throw e;
                    }
                    catch (SharedContextSendException e) {
                        throw e;
                    }
                    catch (SharedContextTimeoutException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        throw new SharedContextSendException(th);
                    }
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchBy(Object value, String indexName, String[] propNames) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchBy(DistributedSharedContextService.this.defaultTimeout, value, indexName, propNames);
        }

        @Override
        public SharedContextView searchBy(long timeout, Object value, String indexName, String[] propNames) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            if (DistributedSharedContextService.this.parallelRequestQueueHandlerContainer == null) {
                for (int i = 0; i < this.views.length; ++i) {
                    long start = System.currentTimeMillis();
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout < 0L) {
                        throw new SharedContextTimeoutException("nodeSize=" + this.views.length + ", responseCount=" + i);
                    }
                    this.views[i].searchBy(timeout, value, indexName, propNames);
                }
            } else {
                AsynchContext asynchContext;
                int i;
                DefaultQueueService responseQueue = new DefaultQueueService();
                try {
                    responseQueue.create();
                    responseQueue.start();
                }
                catch (Exception start) {
                    // empty catch block
                }
                responseQueue.accept();
                for (i = 0; i < this.views.length; ++i) {
                    asynchContext = new AsynchContext(new SearchByParallelRequest(this.views[i], timeout, value, indexName, propNames), responseQueue);
                    DistributedSharedContextService.this.parallelRequestQueueHandlerContainer.push(asynchContext);
                }
                for (i = 0; i < DistributedSharedContextService.this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                    try {
                        asynchContext.checkError();
                        continue;
                    }
                    catch (IndexNotFoundException e) {
                        throw e;
                    }
                    catch (IndexPropertyAccessException e) {
                        throw e;
                    }
                    catch (SharedContextSendException e) {
                        throw e;
                    }
                    catch (SharedContextTimeoutException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        throw new SharedContextSendException(th);
                    }
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchIn(String indexName, String[] propNames, Object[] values) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchIn(DistributedSharedContextService.this.defaultTimeout, indexName, propNames, values);
        }

        @Override
        public SharedContextView searchIn(long timeout, String indexName, String[] propNames, Object[] values) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            if (DistributedSharedContextService.this.parallelRequestQueueHandlerContainer == null) {
                for (int i = 0; i < this.views.length; ++i) {
                    long start = System.currentTimeMillis();
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout < 0L) {
                        throw new SharedContextTimeoutException("nodeSize=" + this.views.length + ", responseCount=" + i);
                    }
                    this.views[i].searchIn(timeout, indexName, propNames, values);
                }
            } else {
                AsynchContext asynchContext;
                int i;
                DefaultQueueService responseQueue = new DefaultQueueService();
                try {
                    responseQueue.create();
                    responseQueue.start();
                }
                catch (Exception start) {
                    // empty catch block
                }
                responseQueue.accept();
                for (i = 0; i < this.views.length; ++i) {
                    asynchContext = new AsynchContext(new SearchInParallelRequest(this.views[i], timeout, indexName, propNames, values), responseQueue);
                    DistributedSharedContextService.this.parallelRequestQueueHandlerContainer.push(asynchContext);
                }
                for (i = 0; i < DistributedSharedContextService.this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                    try {
                        asynchContext.checkError();
                        continue;
                    }
                    catch (IndexNotFoundException e) {
                        throw e;
                    }
                    catch (IndexPropertyAccessException e) {
                        throw e;
                    }
                    catch (SharedContextSendException e) {
                        throw e;
                    }
                    catch (SharedContextTimeoutException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        throw new SharedContextSendException(th);
                    }
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchByProperty(Object prop, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchByProperty(DistributedSharedContextService.this.defaultTimeout, prop, indexName, propName);
        }

        @Override
        public SharedContextView searchByProperty(long timeout, Object prop, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            if (DistributedSharedContextService.this.parallelRequestQueueHandlerContainer == null) {
                for (int i = 0; i < this.views.length; ++i) {
                    long start = System.currentTimeMillis();
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout < 0L) {
                        throw new SharedContextTimeoutException("nodeSize=" + this.views.length + ", responseCount=" + i);
                    }
                    this.views[i].searchByProperty(timeout, prop, indexName, propName);
                }
            } else {
                AsynchContext asynchContext;
                int i;
                DefaultQueueService responseQueue = new DefaultQueueService();
                try {
                    responseQueue.create();
                    responseQueue.start();
                }
                catch (Exception start) {
                    // empty catch block
                }
                responseQueue.accept();
                for (i = 0; i < this.views.length; ++i) {
                    asynchContext = new AsynchContext(new SearchByPropertyParallelRequest(this.views[i], timeout, prop, indexName, propName), responseQueue);
                    DistributedSharedContextService.this.parallelRequestQueueHandlerContainer.push(asynchContext);
                }
                for (i = 0; i < DistributedSharedContextService.this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                    try {
                        asynchContext.checkError();
                        continue;
                    }
                    catch (IndexNotFoundException e) {
                        throw e;
                    }
                    catch (SharedContextSendException e) {
                        throw e;
                    }
                    catch (SharedContextTimeoutException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        throw new SharedContextSendException(th);
                    }
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchInProperty(String indexName, String propName, Object[] props) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchInProperty(DistributedSharedContextService.this.defaultTimeout, indexName, propName, props);
        }

        @Override
        public SharedContextView searchInProperty(long timeout, String indexName, String propName, Object[] props) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            if (DistributedSharedContextService.this.parallelRequestQueueHandlerContainer == null) {
                for (int i = 0; i < this.views.length; ++i) {
                    long start = System.currentTimeMillis();
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout < 0L) {
                        throw new SharedContextTimeoutException("nodeSize=" + this.views.length + ", responseCount=" + i);
                    }
                    this.views[i].searchInProperty(timeout, indexName, propName, props);
                }
            } else {
                AsynchContext asynchContext;
                int i;
                DefaultQueueService responseQueue = new DefaultQueueService();
                try {
                    responseQueue.create();
                    responseQueue.start();
                }
                catch (Exception start) {
                    // empty catch block
                }
                responseQueue.accept();
                for (i = 0; i < this.views.length; ++i) {
                    asynchContext = new AsynchContext(new SearchInPropertyParallelRequest(this.views[i], timeout, indexName, propName, props), responseQueue);
                    DistributedSharedContextService.this.parallelRequestQueueHandlerContainer.push(asynchContext);
                }
                for (i = 0; i < DistributedSharedContextService.this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                    try {
                        asynchContext.checkError();
                        continue;
                    }
                    catch (IndexNotFoundException e) {
                        throw e;
                    }
                    catch (SharedContextSendException e) {
                        throw e;
                    }
                    catch (SharedContextTimeoutException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        throw new SharedContextSendException(th);
                    }
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchByProperty(Map props, String indexName) throws IndexNotFoundException, IllegalArgumentException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchByProperty(DistributedSharedContextService.this.defaultTimeout, props, indexName);
        }

        @Override
        public SharedContextView searchByProperty(long timeout, Map props, String indexName) throws IndexNotFoundException, IllegalArgumentException, SharedContextSendException, SharedContextTimeoutException {
            if (DistributedSharedContextService.this.parallelRequestQueueHandlerContainer == null) {
                for (int i = 0; i < this.views.length; ++i) {
                    long start = System.currentTimeMillis();
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout < 0L) {
                        throw new SharedContextTimeoutException("nodeSize=" + this.views.length + ", responseCount=" + i);
                    }
                    this.views[i].searchByProperty(timeout, props, indexName);
                }
            } else {
                AsynchContext asynchContext;
                int i;
                DefaultQueueService responseQueue = new DefaultQueueService();
                try {
                    responseQueue.create();
                    responseQueue.start();
                }
                catch (Exception start) {
                    // empty catch block
                }
                responseQueue.accept();
                for (i = 0; i < this.views.length; ++i) {
                    asynchContext = new AsynchContext(new SearchByPropertyMapParallelRequest(this.views[i], timeout, props, indexName), responseQueue);
                    DistributedSharedContextService.this.parallelRequestQueueHandlerContainer.push(asynchContext);
                }
                for (i = 0; i < DistributedSharedContextService.this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                    try {
                        asynchContext.checkError();
                        continue;
                    }
                    catch (IndexNotFoundException e) {
                        throw e;
                    }
                    catch (IllegalArgumentException e) {
                        throw e;
                    }
                    catch (SharedContextSendException e) {
                        throw e;
                    }
                    catch (SharedContextTimeoutException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        throw new SharedContextSendException(th);
                    }
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchInProperty(String indexName, Map[] props) throws IndexNotFoundException, IllegalArgumentException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchInProperty(DistributedSharedContextService.this.defaultTimeout, indexName, props);
        }

        @Override
        public SharedContextView searchInProperty(long timeout, String indexName, Map[] props) throws IndexNotFoundException, IllegalArgumentException, SharedContextSendException, SharedContextTimeoutException {
            if (DistributedSharedContextService.this.parallelRequestQueueHandlerContainer == null) {
                for (int i = 0; i < this.views.length; ++i) {
                    long start = System.currentTimeMillis();
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout < 0L) {
                        throw new SharedContextTimeoutException("nodeSize=" + this.views.length + ", responseCount=" + i);
                    }
                    this.views[i].searchInProperty(timeout, indexName, props);
                }
            } else {
                AsynchContext asynchContext;
                int i;
                DefaultQueueService responseQueue = new DefaultQueueService();
                try {
                    responseQueue.create();
                    responseQueue.start();
                }
                catch (Exception start) {
                    // empty catch block
                }
                responseQueue.accept();
                for (i = 0; i < this.views.length; ++i) {
                    asynchContext = new AsynchContext(new SearchInPropertyMapParallelRequest(this.views[i], timeout, indexName, props), responseQueue);
                    DistributedSharedContextService.this.parallelRequestQueueHandlerContainer.push(asynchContext);
                }
                for (i = 0; i < DistributedSharedContextService.this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                    try {
                        asynchContext.checkError();
                        continue;
                    }
                    catch (IndexNotFoundException e) {
                        throw e;
                    }
                    catch (IllegalArgumentException e) {
                        throw e;
                    }
                    catch (SharedContextSendException e) {
                        throw e;
                    }
                    catch (SharedContextTimeoutException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        throw new SharedContextSendException(th);
                    }
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchFrom(Object fromValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchFrom(DistributedSharedContextService.this.defaultTimeout, fromValue, indexName, propName);
        }

        @Override
        public SharedContextView searchFrom(long timeout, Object fromValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            if (DistributedSharedContextService.this.parallelRequestQueueHandlerContainer == null) {
                for (int i = 0; i < this.views.length; ++i) {
                    long start = System.currentTimeMillis();
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout < 0L) {
                        throw new SharedContextTimeoutException("nodeSize=" + this.views.length + ", responseCount=" + i);
                    }
                    this.views[i].searchFrom(timeout, fromValue, indexName, propName);
                }
            } else {
                AsynchContext asynchContext;
                int i;
                DefaultQueueService responseQueue = new DefaultQueueService();
                try {
                    responseQueue.create();
                    responseQueue.start();
                }
                catch (Exception start) {
                    // empty catch block
                }
                responseQueue.accept();
                for (i = 0; i < this.views.length; ++i) {
                    asynchContext = new AsynchContext(new SearchFromParallelRequest(this.views[i], timeout, fromValue, indexName, propName), responseQueue);
                    DistributedSharedContextService.this.parallelRequestQueueHandlerContainer.push(asynchContext);
                }
                for (i = 0; i < DistributedSharedContextService.this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                    try {
                        asynchContext.checkError();
                        continue;
                    }
                    catch (IndexNotFoundException e) {
                        throw e;
                    }
                    catch (IndexPropertyAccessException e) {
                        throw e;
                    }
                    catch (SharedContextSendException e) {
                        throw e;
                    }
                    catch (SharedContextTimeoutException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        throw new SharedContextSendException(th);
                    }
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchFromProperty(Object fromProp, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchFromProperty(DistributedSharedContextService.this.defaultTimeout, fromProp, indexName, propName);
        }

        @Override
        public SharedContextView searchFromProperty(long timeout, Object fromProp, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            if (DistributedSharedContextService.this.parallelRequestQueueHandlerContainer == null) {
                for (int i = 0; i < this.views.length; ++i) {
                    long start = System.currentTimeMillis();
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout < 0L) {
                        throw new SharedContextTimeoutException("nodeSize=" + this.views.length + ", responseCount=" + i);
                    }
                    this.views[i].searchFromProperty(timeout, fromProp, indexName, propName);
                }
            } else {
                AsynchContext asynchContext;
                int i;
                DefaultQueueService responseQueue = new DefaultQueueService();
                try {
                    responseQueue.create();
                    responseQueue.start();
                }
                catch (Exception start) {
                    // empty catch block
                }
                responseQueue.accept();
                for (i = 0; i < this.views.length; ++i) {
                    asynchContext = new AsynchContext(new SearchFromPropertyParallelRequest(this.views[i], timeout, fromProp, indexName, propName), responseQueue);
                    DistributedSharedContextService.this.parallelRequestQueueHandlerContainer.push(asynchContext);
                }
                for (i = 0; i < DistributedSharedContextService.this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                    try {
                        asynchContext.checkError();
                        continue;
                    }
                    catch (IndexNotFoundException e) {
                        throw e;
                    }
                    catch (SharedContextSendException e) {
                        throw e;
                    }
                    catch (SharedContextTimeoutException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        throw new SharedContextSendException(th);
                    }
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchTo(Object toValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchTo(DistributedSharedContextService.this.defaultTimeout, toValue, indexName, propName);
        }

        @Override
        public SharedContextView searchTo(long timeout, Object toValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            if (DistributedSharedContextService.this.parallelRequestQueueHandlerContainer == null) {
                for (int i = 0; i < this.views.length; ++i) {
                    long start = System.currentTimeMillis();
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout < 0L) {
                        throw new SharedContextTimeoutException("nodeSize=" + this.views.length + ", responseCount=" + i);
                    }
                    this.views[i].searchTo(timeout, toValue, indexName, propName);
                }
            } else {
                AsynchContext asynchContext;
                int i;
                DefaultQueueService responseQueue = new DefaultQueueService();
                try {
                    responseQueue.create();
                    responseQueue.start();
                }
                catch (Exception start) {
                    // empty catch block
                }
                responseQueue.accept();
                for (i = 0; i < this.views.length; ++i) {
                    asynchContext = new AsynchContext(new SearchToParallelRequest(this.views[i], timeout, toValue, indexName, propName), responseQueue);
                    DistributedSharedContextService.this.parallelRequestQueueHandlerContainer.push(asynchContext);
                }
                for (i = 0; i < DistributedSharedContextService.this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                    try {
                        asynchContext.checkError();
                        continue;
                    }
                    catch (IndexNotFoundException e) {
                        throw e;
                    }
                    catch (IndexPropertyAccessException e) {
                        throw e;
                    }
                    catch (SharedContextSendException e) {
                        throw e;
                    }
                    catch (SharedContextTimeoutException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        throw new SharedContextSendException(th);
                    }
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchToProperty(Object toProp, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchToProperty(DistributedSharedContextService.this.defaultTimeout, toProp, indexName, propName);
        }

        @Override
        public SharedContextView searchToProperty(long timeout, Object toProp, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            if (DistributedSharedContextService.this.parallelRequestQueueHandlerContainer == null) {
                for (int i = 0; i < this.views.length; ++i) {
                    long start = System.currentTimeMillis();
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout < 0L) {
                        throw new SharedContextTimeoutException("nodeSize=" + this.views.length + ", responseCount=" + i);
                    }
                    this.views[i].searchToProperty(timeout, toProp, indexName, propName);
                }
            } else {
                AsynchContext asynchContext;
                int i;
                DefaultQueueService responseQueue = new DefaultQueueService();
                try {
                    responseQueue.create();
                    responseQueue.start();
                }
                catch (Exception start) {
                    // empty catch block
                }
                responseQueue.accept();
                for (i = 0; i < this.views.length; ++i) {
                    asynchContext = new AsynchContext(new SearchToPropertyParallelRequest(this.views[i], timeout, toProp, indexName, propName), responseQueue);
                    DistributedSharedContextService.this.parallelRequestQueueHandlerContainer.push(asynchContext);
                }
                for (i = 0; i < DistributedSharedContextService.this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                    try {
                        asynchContext.checkError();
                        continue;
                    }
                    catch (IndexNotFoundException e) {
                        throw e;
                    }
                    catch (SharedContextSendException e) {
                        throw e;
                    }
                    catch (SharedContextTimeoutException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        throw new SharedContextSendException(th);
                    }
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchRange(Object fromValue, Object toValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchRange(DistributedSharedContextService.this.defaultTimeout, fromValue, toValue, indexName, propName);
        }

        @Override
        public SharedContextView searchRange(long timeout, Object fromValue, Object toValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            if (DistributedSharedContextService.this.parallelRequestQueueHandlerContainer == null) {
                for (int i = 0; i < this.views.length; ++i) {
                    long start = System.currentTimeMillis();
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout < 0L) {
                        throw new SharedContextTimeoutException("nodeSize=" + this.views.length + ", responseCount=" + i);
                    }
                    this.views[i].searchRange(timeout, fromValue, toValue, indexName, propName);
                }
            } else {
                AsynchContext asynchContext;
                int i;
                DefaultQueueService responseQueue = new DefaultQueueService();
                try {
                    responseQueue.create();
                    responseQueue.start();
                }
                catch (Exception start) {
                    // empty catch block
                }
                responseQueue.accept();
                for (i = 0; i < this.views.length; ++i) {
                    asynchContext = new AsynchContext(new SearchRangeParallelRequest(this.views[i], timeout, fromValue, toValue, indexName, propName), responseQueue);
                    DistributedSharedContextService.this.parallelRequestQueueHandlerContainer.push(asynchContext);
                }
                for (i = 0; i < DistributedSharedContextService.this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                    try {
                        asynchContext.checkError();
                        continue;
                    }
                    catch (IndexNotFoundException e) {
                        throw e;
                    }
                    catch (IndexPropertyAccessException e) {
                        throw e;
                    }
                    catch (SharedContextSendException e) {
                        throw e;
                    }
                    catch (SharedContextTimeoutException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        throw new SharedContextSendException(th);
                    }
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchRangeProperty(Object fromProp, Object toProp, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchRangeProperty(DistributedSharedContextService.this.defaultTimeout, fromProp, toProp, indexName, propName);
        }

        @Override
        public SharedContextView searchRangeProperty(long timeout, Object fromProp, Object toProp, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            if (DistributedSharedContextService.this.parallelRequestQueueHandlerContainer == null) {
                for (int i = 0; i < this.views.length; ++i) {
                    long start = System.currentTimeMillis();
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout < 0L) {
                        throw new SharedContextTimeoutException("nodeSize=" + this.views.length + ", responseCount=" + i);
                    }
                    this.views[i].searchRangeProperty(timeout, fromProp, toProp, indexName, propName);
                }
            } else {
                AsynchContext asynchContext;
                int i;
                DefaultQueueService responseQueue = new DefaultQueueService();
                try {
                    responseQueue.create();
                    responseQueue.start();
                }
                catch (Exception start) {
                    // empty catch block
                }
                responseQueue.accept();
                for (i = 0; i < this.views.length; ++i) {
                    asynchContext = new AsynchContext(new SearchRangePropertyParallelRequest(this.views[i], timeout, fromProp, toProp, indexName, propName), responseQueue);
                    DistributedSharedContextService.this.parallelRequestQueueHandlerContainer.push(asynchContext);
                }
                for (i = 0; i < DistributedSharedContextService.this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                    try {
                        asynchContext.checkError();
                        continue;
                    }
                    catch (IndexNotFoundException e) {
                        throw e;
                    }
                    catch (IndexPropertyAccessException e) {
                        throw e;
                    }
                    catch (SharedContextSendException e) {
                        throw e;
                    }
                    catch (SharedContextTimeoutException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        throw new SharedContextSendException(th);
                    }
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchFrom(Object fromValue, boolean inclusive, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchFrom(DistributedSharedContextService.this.defaultTimeout, fromValue, inclusive, indexName, propName);
        }

        @Override
        public SharedContextView searchFrom(long timeout, Object fromValue, boolean inclusive, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            if (DistributedSharedContextService.this.parallelRequestQueueHandlerContainer == null) {
                for (int i = 0; i < this.views.length; ++i) {
                    long start = System.currentTimeMillis();
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout < 0L) {
                        throw new SharedContextTimeoutException("nodeSize=" + this.views.length + ", responseCount=" + i);
                    }
                    this.views[i].searchFrom(timeout, fromValue, inclusive, indexName, propName);
                }
            } else {
                AsynchContext asynchContext;
                int i;
                DefaultQueueService responseQueue = new DefaultQueueService();
                try {
                    responseQueue.create();
                    responseQueue.start();
                }
                catch (Exception start) {
                    // empty catch block
                }
                responseQueue.accept();
                for (i = 0; i < this.views.length; ++i) {
                    asynchContext = new AsynchContext(new SearchFromParallelRequest(this.views[i], timeout, fromValue, inclusive, indexName, propName), responseQueue);
                    DistributedSharedContextService.this.parallelRequestQueueHandlerContainer.push(asynchContext);
                }
                for (i = 0; i < DistributedSharedContextService.this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                    try {
                        asynchContext.checkError();
                        continue;
                    }
                    catch (IndexNotFoundException e) {
                        throw e;
                    }
                    catch (IndexPropertyAccessException e) {
                        throw e;
                    }
                    catch (SharedContextSendException e) {
                        throw e;
                    }
                    catch (SharedContextTimeoutException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        throw new SharedContextSendException(th);
                    }
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchFromProperty(Object fromProp, boolean inclusive, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchFromProperty(DistributedSharedContextService.this.defaultTimeout, fromProp, inclusive, indexName, propName);
        }

        @Override
        public SharedContextView searchFromProperty(long timeout, Object fromProp, boolean inclusive, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            if (DistributedSharedContextService.this.parallelRequestQueueHandlerContainer == null) {
                for (int i = 0; i < this.views.length; ++i) {
                    long start = System.currentTimeMillis();
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout < 0L) {
                        throw new SharedContextTimeoutException("nodeSize=" + this.views.length + ", responseCount=" + i);
                    }
                    this.views[i].searchFromProperty(timeout, fromProp, inclusive, indexName, propName);
                }
            } else {
                AsynchContext asynchContext;
                int i;
                DefaultQueueService responseQueue = new DefaultQueueService();
                try {
                    responseQueue.create();
                    responseQueue.start();
                }
                catch (Exception start) {
                    // empty catch block
                }
                responseQueue.accept();
                for (i = 0; i < this.views.length; ++i) {
                    asynchContext = new AsynchContext(new SearchFromPropertyParallelRequest(this.views[i], timeout, fromProp, inclusive, indexName, propName), responseQueue);
                    DistributedSharedContextService.this.parallelRequestQueueHandlerContainer.push(asynchContext);
                }
                for (i = 0; i < DistributedSharedContextService.this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                    try {
                        asynchContext.checkError();
                        continue;
                    }
                    catch (IndexNotFoundException e) {
                        throw e;
                    }
                    catch (SharedContextSendException e) {
                        throw e;
                    }
                    catch (SharedContextTimeoutException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        throw new SharedContextSendException(th);
                    }
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchTo(Object toValue, boolean inclusive, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchTo(DistributedSharedContextService.this.defaultTimeout, toValue, inclusive, indexName, propName);
        }

        @Override
        public SharedContextView searchTo(long timeout, Object toValue, boolean inclusive, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            if (DistributedSharedContextService.this.parallelRequestQueueHandlerContainer == null) {
                for (int i = 0; i < this.views.length; ++i) {
                    long start = System.currentTimeMillis();
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout < 0L) {
                        throw new SharedContextTimeoutException("nodeSize=" + this.views.length + ", responseCount=" + i);
                    }
                    this.views[i].searchTo(timeout, toValue, inclusive, indexName, propName);
                }
            } else {
                AsynchContext asynchContext;
                int i;
                DefaultQueueService responseQueue = new DefaultQueueService();
                try {
                    responseQueue.create();
                    responseQueue.start();
                }
                catch (Exception start) {
                    // empty catch block
                }
                responseQueue.accept();
                for (i = 0; i < this.views.length; ++i) {
                    asynchContext = new AsynchContext(new SearchToParallelRequest(this.views[i], timeout, toValue, inclusive, indexName, propName), responseQueue);
                    DistributedSharedContextService.this.parallelRequestQueueHandlerContainer.push(asynchContext);
                }
                for (i = 0; i < DistributedSharedContextService.this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                    try {
                        asynchContext.checkError();
                        continue;
                    }
                    catch (IndexNotFoundException e) {
                        throw e;
                    }
                    catch (IndexPropertyAccessException e) {
                        throw e;
                    }
                    catch (SharedContextSendException e) {
                        throw e;
                    }
                    catch (SharedContextTimeoutException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        throw new SharedContextSendException(th);
                    }
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchToProperty(Object toProp, boolean inclusive, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchToProperty(DistributedSharedContextService.this.defaultTimeout, toProp, inclusive, indexName, propName);
        }

        @Override
        public SharedContextView searchToProperty(long timeout, Object toProp, boolean inclusive, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            if (DistributedSharedContextService.this.parallelRequestQueueHandlerContainer == null) {
                for (int i = 0; i < this.views.length; ++i) {
                    long start = System.currentTimeMillis();
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout < 0L) {
                        throw new SharedContextTimeoutException("nodeSize=" + this.views.length + ", responseCount=" + i);
                    }
                    this.views[i].searchToProperty(timeout, toProp, inclusive, indexName, propName);
                }
            } else {
                AsynchContext asynchContext;
                int i;
                DefaultQueueService responseQueue = new DefaultQueueService();
                try {
                    responseQueue.create();
                    responseQueue.start();
                }
                catch (Exception start) {
                    // empty catch block
                }
                responseQueue.accept();
                for (i = 0; i < this.views.length; ++i) {
                    asynchContext = new AsynchContext(new SearchToPropertyParallelRequest(this.views[i], timeout, toProp, inclusive, indexName, propName), responseQueue);
                    DistributedSharedContextService.this.parallelRequestQueueHandlerContainer.push(asynchContext);
                }
                for (i = 0; i < DistributedSharedContextService.this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                    try {
                        asynchContext.checkError();
                        continue;
                    }
                    catch (IndexNotFoundException e) {
                        throw e;
                    }
                    catch (SharedContextSendException e) {
                        throw e;
                    }
                    catch (SharedContextTimeoutException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        throw new SharedContextSendException(th);
                    }
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchRange(Object fromValue, boolean fromInclusive, Object toValue, boolean toInclusive, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchRange(DistributedSharedContextService.this.defaultTimeout, fromValue, fromInclusive, toValue, toInclusive, indexName, propName);
        }

        @Override
        public SharedContextView searchRange(long timeout, Object fromValue, boolean fromInclusive, Object toValue, boolean toInclusive, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            if (DistributedSharedContextService.this.parallelRequestQueueHandlerContainer == null) {
                for (int i = 0; i < this.views.length; ++i) {
                    long start = System.currentTimeMillis();
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout < 0L) {
                        throw new SharedContextTimeoutException("nodeSize=" + this.views.length + ", responseCount=" + i);
                    }
                    this.views[i].searchRange(timeout, fromValue, fromInclusive, toValue, toInclusive, indexName, propName);
                }
            } else {
                AsynchContext asynchContext;
                int i;
                DefaultQueueService responseQueue = new DefaultQueueService();
                try {
                    responseQueue.create();
                    responseQueue.start();
                }
                catch (Exception start) {
                    // empty catch block
                }
                responseQueue.accept();
                for (i = 0; i < this.views.length; ++i) {
                    asynchContext = new AsynchContext(new SearchRangeParallelRequest(this.views[i], timeout, fromValue, fromInclusive, toValue, toInclusive, indexName, propName), responseQueue);
                    DistributedSharedContextService.this.parallelRequestQueueHandlerContainer.push(asynchContext);
                }
                for (i = 0; i < DistributedSharedContextService.this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                    try {
                        asynchContext.checkError();
                        continue;
                    }
                    catch (IndexNotFoundException e) {
                        throw e;
                    }
                    catch (IndexPropertyAccessException e) {
                        throw e;
                    }
                    catch (SharedContextSendException e) {
                        throw e;
                    }
                    catch (SharedContextTimeoutException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        throw new SharedContextSendException(th);
                    }
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchRangeProperty(Object fromProp, boolean fromInclusive, Object toProp, boolean toInclusive, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchRangeProperty(DistributedSharedContextService.this.defaultTimeout, fromProp, fromInclusive, toProp, toInclusive, indexName, propName);
        }

        @Override
        public SharedContextView searchRangeProperty(long timeout, Object fromProp, boolean fromInclusive, Object toProp, boolean toInclusive, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            if (DistributedSharedContextService.this.parallelRequestQueueHandlerContainer == null) {
                for (int i = 0; i < this.views.length; ++i) {
                    long start = System.currentTimeMillis();
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout < 0L) {
                        throw new SharedContextTimeoutException("nodeSize=" + this.views.length + ", responseCount=" + i);
                    }
                    this.views[i].searchRangeProperty(timeout, fromProp, fromInclusive, toProp, toInclusive, indexName, propName);
                }
            } else {
                AsynchContext asynchContext;
                int i;
                DefaultQueueService responseQueue = new DefaultQueueService();
                try {
                    responseQueue.create();
                    responseQueue.start();
                }
                catch (Exception start) {
                    // empty catch block
                }
                responseQueue.accept();
                for (i = 0; i < this.views.length; ++i) {
                    asynchContext = new AsynchContext(new SearchRangePropertyParallelRequest(this.views[i], timeout, fromProp, fromInclusive, toProp, toInclusive, indexName, propName), responseQueue);
                    DistributedSharedContextService.this.parallelRequestQueueHandlerContainer.push(asynchContext);
                }
                for (i = 0; i < DistributedSharedContextService.this.sharedContextArray.length && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                    try {
                        asynchContext.checkError();
                        continue;
                    }
                    catch (IndexNotFoundException e) {
                        throw e;
                    }
                    catch (IndexPropertyAccessException e) {
                        throw e;
                    }
                    catch (SharedContextSendException e) {
                        throw e;
                    }
                    catch (SharedContextTimeoutException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        throw new SharedContextSendException(th);
                    }
                }
            }
            return this;
        }

        @Override
        public Object clone() {
            DistributedSharedContextView clone = null;
            try {
                clone = (DistributedSharedContextView)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            if (this.views != null) {
                clone.views = new SharedContextView[this.views.length];
                for (int i = 0; i < this.views.length; ++i) {
                    clone.views[i] = (SharedContextView)this.views[i].clone();
                }
            }
            return clone;
        }
    }

    protected class ForDistributedSharedContextService
    extends SharedContextService {
        private static final long serialVersionUID = 8735006923163788146L;
        protected int nodeIndex;

        public ForDistributedSharedContextService(int index) {
            this.nodeIndex = index;
        }

        @Override
        protected Object getMainId(List members, Object excludeId) {
            if (this.cluster == null) {
                return null;
            }
            int offset = this.nodeIndex % members.size();
            Set targetMembers = this.serverConnection.getReceiveClientIds(this.targetMessage);
            Object myId = this.cluster.getUID();
            int imax = members.size();
            for (int i = 0; i < imax; ++i) {
                Object id;
                int index = offset + i;
                if (index >= imax) {
                    index -= imax;
                }
                if ((id = members.get(index)).equals(excludeId)) continue;
                if (id.equals(myId)) {
                    return myId;
                }
                if (!targetMembers.contains(id)) continue;
                return id;
            }
            return myId;
        }
    }

    protected class ParallelRequestQueueHandler
    implements QueueHandler {
        protected ParallelRequestQueueHandler() {
        }

        @Override
        public void handleDequeuedObject(Object obj) throws Throwable {
            if (obj == null) {
                return;
            }
            AsynchContext ac = (AsynchContext)obj;
            ac.setOutput(((ParallelRequest)ac.getInput()).execute());
            ac.getResponseQueue().push(ac);
        }

        @Override
        public boolean handleError(Object obj, Throwable th) throws Throwable {
            return false;
        }

        @Override
        public void handleRetryOver(Object obj, Throwable th) throws Throwable {
            AsynchContext ac = (AsynchContext)obj;
            ac.setThrowable(th);
            ac.getResponseQueue().push(ac);
        }
    }

    protected class ContainsValueParallelRequest
    extends SharedContextParallelRequest {
        private Object value;
        private long timeout;

        public ContainsValueParallelRequest(SharedContext context, Object value, long timeout) {
            super(context);
            this.value = value;
            this.timeout = timeout;
        }

        @Override
        public Object execute() throws SharedContextSendException, SharedContextTimeoutException {
            return this.context.containsValue(this.value, this.timeout) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    protected class SizeParallelRequest
    extends SharedContextParallelRequest {
        private long timeout;

        public SizeParallelRequest(SharedContext context, long timeout) {
            super(context);
            this.timeout = timeout;
        }

        @Override
        public Object execute() throws SharedContextSendException, SharedContextTimeoutException {
            return new Integer(this.context.size(this.timeout));
        }
    }

    protected class KeySetParallelRequest
    extends SharedContextParallelRequest {
        private long timeout;

        public KeySetParallelRequest(SharedContext context, long timeout) {
            super(context);
            this.timeout = timeout;
        }

        @Override
        public Object execute() throws SharedContextSendException, SharedContextTimeoutException {
            return this.context.keySet(this.timeout);
        }
    }

    protected class ExecuteInterpretQueryParallelRequest
    extends SharedContextParallelRequest {
        private String query;
        private Map variables;
        private long timeout;

        public ExecuteInterpretQueryParallelRequest(SharedContext context, String query, Map variables, long timeout) {
            super(context);
            this.query = query;
            this.variables = variables;
            this.timeout = timeout;
        }

        @Override
        public Object execute() throws EvaluateException, SharedContextSendException, SharedContextTimeoutException {
            return this.context.executeInterpretQuery(this.query, this.variables, this.timeout);
        }
    }

    protected class AnalyzeIndexParallelRequest
    extends SharedContextParallelRequest {
        private String name;

        public AnalyzeIndexParallelRequest(SharedContext context, String name) {
            super(context);
            this.name = name;
        }

        @Override
        public Object execute() throws SharedContextIllegalIndexException, SharedContextSendException, SharedContextTimeoutException {
            this.context.analyzeIndex(this.name);
            return null;
        }
    }

    protected class ClearAsynchParallelRequest
    extends SharedContextParallelRequest {
        public ClearAsynchParallelRequest(SharedContext context) {
            super(context);
        }

        @Override
        public Object execute() throws SharedContextSendException {
            this.context.clearAsynch();
            return null;
        }
    }

    protected class ClearParallelRequest
    extends SharedContextParallelRequest {
        private long timeout;

        public ClearParallelRequest(SharedContext context, long timeout) {
            super(context);
            this.timeout = timeout;
        }

        @Override
        public Object execute() throws SharedContextSendException, SharedContextTimeoutException {
            this.context.clear(this.timeout);
            return null;
        }
    }

    protected class PutAllAsynchParallelRequest
    extends SharedContextParallelRequest {
        private Map map;

        public PutAllAsynchParallelRequest(SharedContext context, Map t) {
            super(context);
            this.map = t;
        }

        @Override
        public Object execute() throws SharedContextSendException {
            this.context.putAllAsynch(this.map);
            return null;
        }
    }

    protected class PutAllParallelRequest
    extends SharedContextParallelRequest {
        private Map map;
        private long timeout;

        public PutAllParallelRequest(SharedContext context, Map t, long timeout) {
            super(context);
            this.map = t;
            this.timeout = timeout;
        }

        @Override
        public Object execute() throws SharedContextSendException, SharedContextTimeoutException {
            this.context.putAll(this.map, this.timeout);
            return null;
        }
    }

    protected class SaveParallelRequest
    extends SharedContextParallelRequest {
        private long timeout;

        public SaveParallelRequest(SharedContext context, long timeout) {
            super(context);
            this.timeout = timeout;
        }

        @Override
        public Object execute() throws Exception {
            this.context.save(this.timeout);
            return null;
        }
    }

    protected class SynchronizeParallelRequest
    extends SharedContextParallelRequest {
        private long timeout;

        public SynchronizeParallelRequest(SharedContext context, long timeout) {
            super(context);
            this.timeout = timeout;
        }

        @Override
        public Object execute() throws SharedContextSendException, SharedContextTimeoutException {
            this.context.synchronize(this.timeout);
            return null;
        }
    }

    protected abstract class SharedContextParallelRequest
    extends ParallelRequest {
        protected SharedContext context;

        public SharedContextParallelRequest(SharedContext context) {
            this.context = context;
        }
    }

    protected abstract class ParallelRequest {
        protected ParallelRequest() {
        }

        public abstract Object execute() throws Throwable;
    }

    private class RehashResponseCallBack
    implements RequestServerConnection.ResponseCallBack {
        private SynchronizeMonitor monitor = new WaitSynchronizeMonitor();
        private boolean isTimeout;
        private Throwable throwable;
        private int responseCount;
        private int currentResponseCount;

        public RehashResponseCallBack() {
            this.monitor.initMonitor();
        }

        public void setResponseCount(int count) {
            this.responseCount = count;
            this.currentResponseCount = 0;
            this.isTimeout = false;
            this.throwable = null;
        }

        @Override
        public void onResponse(Object sourceId, Message message, boolean isLast) {
            ++this.currentResponseCount;
            if (message == null) {
                this.isTimeout = true;
                this.monitor.notifyMonitor();
            } else {
                Object response = null;
                try {
                    response = message.getObject();
                    message.recycle();
                }
                catch (MessageException e) {
                    this.throwable = e;
                    this.monitor.notifyMonitor();
                }
                if (response instanceof Throwable) {
                    this.throwable = (Throwable)response;
                    this.monitor.notifyMonitor();
                } else if (this.currentResponseCount >= this.responseCount) {
                    this.monitor.notifyMonitor();
                }
            }
        }

        public void waitResponse(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            try {
                if (!this.monitor.waitMonitor(timeout)) {
                    throw new SharedContextTimeoutException();
                }
            }
            catch (InterruptedException e) {
                throw new SharedContextTimeoutException(e);
            }
            if (this.isTimeout) {
                throw new SharedContextTimeoutException();
            }
            if (this.throwable != null) {
                if (this.throwable instanceof SharedContextSendException) {
                    throw (SharedContextSendException)this.throwable;
                }
                if (this.throwable instanceof SharedContextTimeoutException) {
                    throw (SharedContextTimeoutException)this.throwable;
                }
                throw new SharedContextSendException(this.throwable);
            }
        }
    }

    private static class DistributeInfoComparator
    implements Comparator {
        public static final Comparator INSTANCE = new DistributeInfoComparator();

        private DistributeInfoComparator() {
        }

        public int compare(Object o1, Object o2) {
            DistributeInfo d1 = (DistributeInfo)o1;
            DistributeInfo d2 = (DistributeInfo)o2;
            return d1.getServerCount() - d2.getServerCount();
        }
    }

    private class DistributeGrid {
        private int[] serverCounts;
        private final Map distributeInfos = new HashMap();
        private final Map increaseInfos = new HashMap();
        private final Map decreaseInfos = new HashMap();

        public DistributeGrid() {
            this.serverCounts = new int[DistributedSharedContextService.this.sharedContextArray.length];
        }

        public void addDistributeInfo(DistributeInfo info) {
            this.distributeInfos.put(info.getId(), info);
            for (int i = 0; i < this.serverCounts.length; ++i) {
                if (!info.isServer(i)) continue;
                int n = i;
                this.serverCounts[n] = this.serverCounts[n] + 1;
            }
        }

        public int getServerCount(int index) {
            return this.serverCounts[index];
        }

        public void rehash() {
            HashSet infoSet = new HashSet(this.distributeInfos.values());
            DistributeInfo[] infos = infoSet.toArray(new DistributeInfo[infoSet.size()]);
            block0: for (int i = 0; i < this.serverCounts.length; ++i) {
                if (this.serverCounts[i] >= DistributedSharedContextService.this.replicationSize) continue;
                Arrays.sort(infos, DistributeInfoComparator.INSTANCE);
                for (int j = 0; j < infos.length; ++j) {
                    if (infos[j].isServer(i)) continue;
                    infos[j].setServer(i);
                    int n = i;
                    this.serverCounts[n] = this.serverCounts[n] + 1;
                    this.increaseInfos.put(infos[j].getId(), infos[j]);
                    if (this.serverCounts[i] >= DistributedSharedContextService.this.replicationSize) continue block0;
                }
            }
            infos = infoSet.toArray(new DistributeInfo[infoSet.size()]);
            if (infos.length > 1) {
                int diffSize = DistributedSharedContextService.this.replicationSize >= infos.length ? 0 : 1;
                while (true) {
                    Arrays.sort(infos, DistributeInfoComparator.INSTANCE);
                    DistributeInfo maxInfo = infos[infos.length - 1];
                    DistributeInfo minInfo = infos[0];
                    if (maxInfo.getServerCount() - minInfo.getServerCount() <= diffSize) break;
                    int index = maxInfo.getMaxServerIndex(minInfo);
                    maxInfo.setClient(index);
                    this.decreaseInfos.put(maxInfo.getId(), maxInfo);
                    minInfo.setServer(index);
                    this.increaseInfos.put(minInfo.getId(), minInfo);
                }
            }
        }

        public Map getIncreaseDistributeInfos() {
            return this.increaseInfos;
        }

        public Map getDecreaseDistributeInfos() {
            return this.decreaseInfos;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            DistributeInfo[] infos = this.distributeInfos.values().toArray(new DistributeInfo[this.distributeInfos.size()]);
            int imax = infos.length;
            for (int i = 0; i < imax; ++i) {
                buf.append(infos[i].getId()).append(',');
                int jmax = infos[i].size();
                for (int j = 0; j < jmax; ++j) {
                    buf.append(infos[i].isServer(j) ? "S" : "C");
                    if (j == jmax - 1) continue;
                    buf.append(',');
                }
                if (i == imax - 1) continue;
                buf.append('\n');
            }
            return buf.toString();
        }
    }

    public static class DistributeInfo
    implements Externalizable {
        private Object id;
        private boolean[] serverFlagArray;
        private int serverCount;

        public DistributeInfo() {
        }

        public DistributeInfo(Object id, int distributedSize) {
            this.id = id;
            this.serverFlagArray = new boolean[distributedSize];
        }

        public Object getId() {
            return this.id;
        }

        public void setServer(int index) {
            if (this.serverFlagArray[index]) {
                return;
            }
            this.serverFlagArray[index] = true;
            ++this.serverCount;
        }

        public void setClient(int index) {
            if (!this.serverFlagArray[index]) {
                return;
            }
            this.serverFlagArray[index] = false;
            --this.serverCount;
        }

        public boolean isServer(int index) {
            return this.serverFlagArray[index];
        }

        public int size() {
            return this.serverFlagArray.length;
        }

        public int getServerCount() {
            return this.serverCount;
        }

        public int getMaxServerIndex(DistributeInfo target) {
            if (this.getServerCount() == 0) {
                return -1;
            }
            int i = this.serverFlagArray.length;
            while (--i >= 0) {
                if (!this.serverFlagArray[i] || target.isServer(i)) continue;
                return i;
            }
            return -1;
        }

        public synchronized void apply(DistributeInfo info, SharedContextService[] contexts) throws SharedContextSendException, SharedContextTimeoutException {
            for (int i = 0; i < contexts.length; ++i) {
                boolean isClient;
                boolean bl = isClient = !this.isServer(i);
                if (isClient == contexts[i].isClient()) continue;
                contexts[i].setClient(!this.isServer(i));
                if (isClient) {
                    info.setClient(i);
                    continue;
                }
                info.setServer(i);
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.id);
            out.writeInt(this.serverFlagArray.length);
            for (int i = 0; i < this.serverFlagArray.length; ++i) {
                out.write(this.serverFlagArray[i] ? 1 : 0);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.id = in.readObject();
            this.serverFlagArray = new boolean[in.readInt()];
            for (int i = 0; i < this.serverFlagArray.length; ++i) {
                boolean bl = this.serverFlagArray[i] = in.read() == 1;
                if (!this.serverFlagArray[i]) continue;
                ++this.serverCount;
            }
        }
    }

    public static class DistributedSharedContextEvent
    implements Externalizable {
        public static final byte EVENT_GET_DIST_INFO = 1;
        public static final byte EVENT_REHASH_REQUEST = 2;
        public static final byte EVENT_REHASH = 3;
        public static final byte EVENT_SAVE = 4;
        public static final byte EVENT_LOAD = 5;
        public static final byte EVENT_LOAD_KEY = 6;
        public static final byte EVENT_REHASH_SWITCH = 7;
        public byte type;
        public Object value;

        public DistributedSharedContextEvent() {
        }

        public DistributedSharedContextEvent(byte type) {
            this(type, null);
        }

        public DistributedSharedContextEvent(byte type, Object value) {
            this.type = type;
            this.value = value;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.write(this.type);
            out.writeObject(this.value);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = (byte)in.read();
            this.value = in.readObject();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.append('{');
            buf.append("type=").append(this.type);
            buf.append(", value=").append(this.value);
            buf.append('}');
            return buf.toString();
        }
    }
}

