/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.context;

import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.context.MD5HashSharedContextKeyDistributorServiceMBean;
import jp.ossc.nimbus.service.context.SharedContextIllegalDistributeException;
import jp.ossc.nimbus.service.context.SharedContextKeyDistributor;

public class MD5HashSharedContextKeyDistributorService
extends ServiceBase
implements SharedContextKeyDistributor,
MD5HashSharedContextKeyDistributorServiceMBean {
    private static final long serialVersionUID = 6233853944104905295L;
    private Property keyProperty;

    @Override
    public void setKeyProperty(String prop) {
        this.keyProperty = PropertyFactory.createProperty(prop);
    }

    @Override
    public String getKeyProperty() {
        return this.keyProperty == null ? null : this.keyProperty.getPropertyName();
    }

    @Override
    public int selectDataNodeIndex(Object key, int distributedSize) throws SharedContextIllegalDistributeException {
        if (this.keyProperty != null) {
            try {
                key = this.keyProperty.getProperty(key);
            }
            catch (NoSuchPropertyException e) {
                throw new SharedContextIllegalDistributeException(e);
            }
            catch (InvocationTargetException e) {
                throw new SharedContextIllegalDistributeException(e);
            }
        }
        long hash = key == null ? 0L : (long)key.hashCode();
        try {
            hash = new BigInteger(MessageDigest.getInstance("MD5").digest(BigInteger.valueOf(hash).toByteArray())).longValue();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return (int)Math.min(Math.abs(hash / (Long.MIN_VALUE / (long)distributedSize)), (long)(distributedSize - 1));
    }
}

