/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.context;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.ossc.nimbus.beans.BeanTableIndexKeyFactory;
import jp.ossc.nimbus.beans.IndexPropertyAccessException;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.SimpleProperty;

public class SharedContextIndex
implements Externalizable,
Cloneable {
    protected String name;
    protected TreeMap indexKeyMap = new TreeMap(new ComparableComparator());
    protected Set notNullKeySet = new HashSet();
    protected Set linkedIndex = new HashSet();
    protected BeanTableIndexKeyFactory indexKeyFactory;

    public SharedContextIndex() {
    }

    public SharedContextIndex(String[] propNames) {
        this(null, propNames);
    }

    public SharedContextIndex(String name, String[] propNames) {
        if (propNames == null || propNames.length == 0) {
            new IllegalArgumentException("propNames is empty.");
        }
        this.name = name;
        this.indexKeyFactory = new DefaultSharedContextIndexKeyFactory(propNames);
    }

    public SharedContextIndex(String name, BeanTableIndexKeyFactory keyFactory) {
        this.name = name;
        this.indexKeyFactory = keyFactory;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public Set getIndexedPropertyNames() {
        return this.indexKeyFactory.getPropertyNames();
    }

    public void addLinkedIndex(String indexName) {
        this.linkedIndex.add(indexName);
    }

    public void removeLinkedIndex(String indexName) {
        this.linkedIndex.remove(indexName);
    }

    public Set getLinkedIndexSet() {
        return this.linkedIndex;
    }

    public synchronized void add(Object key, Object value) throws IndexPropertyAccessException {
        Object indexKey = this.indexKeyFactory.createIndexKey(value);
        HashSet<Object> keys = (HashSet<Object>)this.indexKeyMap.get(indexKey);
        if (keys == null) {
            keys = new HashSet<Object>();
            this.indexKeyMap.put(indexKey, keys);
        }
        keys.add(key);
        if (indexKey != null) {
            this.notNullKeySet.add(key);
        }
    }

    public synchronized void addAll(Map c) throws IndexPropertyAccessException {
        for (Map.Entry entry : c.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public synchronized void remove(Object key, Object value) throws IndexPropertyAccessException {
        Object indexKey = this.indexKeyFactory.createIndexKey(value);
        Set keys = (Set)this.indexKeyMap.get(indexKey);
        if (keys != null) {
            keys.remove(key);
            if (keys.size() == 0) {
                this.indexKeyMap.remove(indexKey);
            }
        }
        this.notNullKeySet.remove(key);
    }

    public synchronized void replace(Object key, Object oldValue, Object newValue) throws IndexPropertyAccessException {
        this.remove(key, oldValue);
        this.add(key, newValue);
    }

    public synchronized void clear() {
        this.indexKeyMap.clear();
        this.notNullKeySet.clear();
    }

    public Set searchKey() {
        return this.searchKey(null);
    }

    public synchronized Set searchKey(Set result) {
        if (result == null) {
            result = new HashSet();
        }
        for (Set keys : this.indexKeyMap.values()) {
            result.add(keys.iterator().next());
        }
        return result;
    }

    public Set searchNull() {
        return this.searchNull(null);
    }

    public synchronized Set searchNull(Set result) {
        Set keys = (Set)this.indexKeyMap.get(null);
        if (result == null) {
            result = new HashSet();
        }
        if (keys != null) {
            result.addAll(keys);
        }
        return result;
    }

    public Set searchNotNull() {
        return this.searchNotNull(null);
    }

    public synchronized Set searchNotNull(Set result) {
        if (result == null) {
            result = new HashSet();
        }
        result.addAll(this.notNullKeySet);
        return result;
    }

    public synchronized Object searchByPrimary(Object value) throws IndexPropertyAccessException {
        Object indexKey = this.indexKeyFactory.createIndexKey(value);
        Set keys = (Set)this.indexKeyMap.get(indexKey);
        if (keys == null) {
            return null;
        }
        return keys.iterator().next();
    }

    public Set searchBy(Object value) throws IndexPropertyAccessException {
        return this.searchBy(null, value);
    }

    public synchronized Set searchBy(Set result, Object value) throws IndexPropertyAccessException {
        Object indexKey = this.indexKeyFactory.createIndexKey(value);
        Set keys = (Set)this.indexKeyMap.get(indexKey);
        if (result == null) {
            result = new HashSet();
        }
        if (keys == null) {
            return result;
        }
        result.addAll(keys);
        return result;
    }

    public Set searchIn(Object[] values) throws IndexPropertyAccessException {
        return this.searchIn(null, values);
    }

    public synchronized Set searchIn(Set result, Object[] values) throws IndexPropertyAccessException {
        if (result == null) {
            result = new HashSet();
        }
        for (int i = 0; i < values.length; ++i) {
            Object indexKey = this.indexKeyFactory.createIndexKey(values[i]);
            Set ret = (Set)this.indexKeyMap.get(indexKey);
            if (ret == null) continue;
            result.addAll(ret);
        }
        return result;
    }

    public Set searchByProperty(Object prop) {
        return this.searchByProperty(null, prop);
    }

    public synchronized Set searchByProperty(Set result, Object prop) {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        Set keys = (Set)this.indexKeyMap.get(prop);
        if (keys == null) {
            return result;
        }
        if (result == null) {
            result = new HashSet();
        }
        result.addAll(keys);
        return result;
    }

    public Set searchInProperty(Object[] props) {
        return this.searchInProperty(null, props);
    }

    public synchronized Set searchInProperty(Set result, Object[] props) {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        if (result == null) {
            result = new HashSet();
        }
        for (int i = 0; i < props.length; ++i) {
            Set keys = (Set)this.indexKeyMap.get(props[i]);
            if (keys == null) continue;
            result.addAll(keys);
        }
        return result;
    }

    public Set searchByProperty(Map props) throws IllegalArgumentException {
        return this.searchByProperty(null, props);
    }

    public synchronized Set searchByProperty(Set result, Map props) throws IllegalArgumentException {
        Object indexKey = this.indexKeyFactory.createIndexKeyByProperties(props);
        Set keys = (Set)this.indexKeyMap.get(indexKey);
        if (keys == null) {
            return result;
        }
        if (result == null) {
            result = new HashSet();
        }
        result.addAll(keys);
        return result;
    }

    public Set searchInProperty(Map[] props) throws IllegalArgumentException {
        return this.searchInProperty((Set)null, props);
    }

    public synchronized Set searchInProperty(Set result, Map[] props) throws IllegalArgumentException {
        if (result == null) {
            result = new HashSet();
        }
        for (int i = 0; i < props.length; ++i) {
            Map propMap = props[i];
            Object indexKey = this.indexKeyFactory.createIndexKeyByProperties(propMap);
            Set keys = (Set)this.indexKeyMap.get(indexKey);
            if (keys == null) continue;
            result.addAll(keys);
        }
        return result;
    }

    public Set searchFrom(Object fromValue) throws IndexPropertyAccessException {
        return this.searchFrom(null, fromValue);
    }

    public Set searchFrom(Set result, Object fromValue) throws IndexPropertyAccessException {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        Object fromProp = this.indexKeyFactory.createIndexKey(fromValue);
        return this.searchFromProperty(result, fromProp);
    }

    public Set searchFromProperty(Object fromProp) {
        return this.searchFromProperty(null, fromProp);
    }

    public synchronized Set searchFromProperty(Set result, Object fromProp) {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        if (result == null) {
            result = new HashSet();
        }
        for (Set keys : this.indexKeyMap.tailMap(fromProp).values()) {
            result.addAll(keys);
        }
        return result;
    }

    public Set searchTo(Object toValue) throws IndexPropertyAccessException {
        return this.searchTo(null, toValue);
    }

    public Set searchTo(Set result, Object toValue) throws IndexPropertyAccessException {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        Object toProp = this.indexKeyFactory.createIndexKey(toValue);
        return this.searchToProperty(result, toProp);
    }

    public Set searchToProperty(Object toProp) {
        return this.searchToProperty(null, toProp);
    }

    public synchronized Set searchToProperty(Set result, Object toProp) {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        if (result == null) {
            result = new HashSet();
        }
        for (Set keys : this.indexKeyMap.headMap(toProp).values()) {
            result.addAll(keys);
        }
        return result;
    }

    public Set searchRange(Object fromValue, Object toValue) throws IndexPropertyAccessException {
        return this.searchRange(null, fromValue, toValue);
    }

    public Set searchRange(Set result, Object fromValue, Object toValue) throws IndexPropertyAccessException {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        Object fromProp = this.indexKeyFactory.createIndexKey(fromValue);
        Object toProp = this.indexKeyFactory.createIndexKey(toValue);
        return this.searchRangeProperty(result, fromProp, toProp);
    }

    public Set searchRangeProperty(Object fromProp, Object toProp) {
        return this.searchRangeProperty(null, fromProp, toProp);
    }

    public synchronized Set searchRangeProperty(Set result, Object fromProp, Object toProp) {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        if (result == null) {
            result = new HashSet();
        }
        if (fromProp == null) {
            return this.searchToProperty(result, toProp);
        }
        if (toProp == null) {
            return this.searchFromProperty(result, fromProp);
        }
        for (Set keys : this.indexKeyMap.subMap(fromProp, toProp).values()) {
            result.addAll(keys);
        }
        return result;
    }

    public Set searchFrom(Object fromValue, boolean inclusive) throws IndexPropertyAccessException {
        return this.searchFrom(null, fromValue, inclusive);
    }

    public Set searchFrom(Set result, Object fromValue, boolean inclusive) throws IndexPropertyAccessException {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        Object fromProp = this.indexKeyFactory.createIndexKey(fromValue);
        return this.searchFromProperty(result, fromProp, inclusive);
    }

    public Set searchFromProperty(Object fromProp, boolean inclusive) {
        return this.searchFromProperty(null, fromProp, inclusive);
    }

    public synchronized Set searchFromProperty(Set result, Object fromProp, boolean inclusive) {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        if (result == null) {
            result = new HashSet();
        }
        for (Set keys : this.indexKeyMap.tailMap(fromProp, inclusive).values()) {
            result.addAll(keys);
        }
        return result;
    }

    public Set searchTo(Object toValue, boolean inclusive) throws IndexPropertyAccessException {
        return this.searchTo(null, toValue, inclusive);
    }

    public Set searchTo(Set result, Object toValue, boolean inclusive) throws IndexPropertyAccessException {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        Object toProp = this.indexKeyFactory.createIndexKey(toValue);
        return this.searchToProperty(result, toProp, inclusive);
    }

    public Set searchToProperty(Object toProp, boolean inclusive) {
        return this.searchToProperty(null, toProp, inclusive);
    }

    public synchronized Set searchToProperty(Set result, Object toProp, boolean inclusive) {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        if (result == null) {
            result = new HashSet();
        }
        for (Set keys : this.indexKeyMap.headMap(toProp, inclusive).values()) {
            result.addAll(keys);
        }
        return result;
    }

    public Set searchRange(Object fromValue, boolean fromInclusive, Object toValue, boolean toInclusive) throws IndexPropertyAccessException {
        return this.searchRange(null, fromValue, fromInclusive, toValue, toInclusive);
    }

    public Set searchRange(Set result, Object fromValue, boolean fromInclusive, Object toValue, boolean toInclusive) throws IndexPropertyAccessException {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        Object fromProp = this.indexKeyFactory.createIndexKey(fromValue);
        Object toProp = this.indexKeyFactory.createIndexKey(toValue);
        return this.searchRangeProperty(result, fromProp, fromInclusive, toProp, toInclusive);
    }

    public Set searchRangeProperty(Object fromProp, boolean fromInclusive, Object toProp, boolean toInclusive) {
        return this.searchRangeProperty(null, fromProp, fromInclusive, toProp, toInclusive);
    }

    public synchronized Set searchRangeProperty(Set result, Object fromProp, boolean fromInclusive, Object toProp, boolean toInclusive) {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        if (result == null) {
            result = new HashSet();
        }
        if (fromProp == null) {
            return this.searchToProperty(result, toProp, toInclusive);
        }
        if (toProp == null) {
            return this.searchFromProperty(result, fromProp, fromInclusive);
        }
        for (Set keys : this.indexKeyMap.subMap(fromProp, fromInclusive, toProp, toInclusive).values()) {
            result.addAll(keys);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal(out, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out, boolean writeValue) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.indexKeyFactory);
        SharedContextIndex sharedContextIndex = this;
        synchronized (sharedContextIndex) {
            out.writeObject(this.linkedIndex);
            if (writeValue) {
                out.writeObject(this.indexKeyMap);
                out.writeObject(this.notNullKeySet);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in, true);
    }

    public void readExternal(ObjectInput in, boolean readValue) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        this.indexKeyFactory = (BeanTableIndexKeyFactory)in.readObject();
        this.linkedIndex = (Set)in.readObject();
        if (readValue) {
            this.indexKeyMap = (TreeMap)in.readObject();
            this.notNullKeySet = (Set)in.readObject();
        }
    }

    public SharedContextIndex cloneEmpty() {
        SharedContextIndex clone = null;
        try {
            clone = (SharedContextIndex)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        clone.indexKeyMap = new TreeMap(new ComparableComparator());
        clone.notNullKeySet = new HashSet();
        clone.linkedIndex = new HashSet();
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedContextIndex clone(Set keySet) {
        SharedContextIndex clone = null;
        try {
            clone = (SharedContextIndex)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        clone.indexKeyMap = new TreeMap(new ComparableComparator());
        clone.notNullKeySet = new HashSet();
        clone.linkedIndex = new HashSet();
        SharedContextIndex sharedContextIndex = this;
        synchronized (sharedContextIndex) {
            for (Map.Entry entry : this.indexKeyMap.entrySet()) {
                Set set = (Set)entry.getValue();
                HashSet newSet = null;
                for (Object key : keySet) {
                    if (!set.contains(key)) continue;
                    if (newSet == null) {
                        newSet = new HashSet();
                    }
                    newSet.add(key);
                }
                if (newSet == null) continue;
                clone.indexKeyMap.put(entry.getKey(), newSet);
            }
            for (Object key : keySet) {
                if (!this.notNullKeySet.contains(key)) continue;
                clone.notNullKeySet.add(key);
            }
        }
        return clone;
    }

    public static class ComplexKey
    implements Comparable,
    Externalizable {
        private Comparable[] keys;
        private int hashCode;

        public ComplexKey() {
        }

        public ComplexKey(int size) {
            this.keys = new Comparable[size];
        }

        public void set(int index, Object key) {
            this.keys[index] = (Comparable)key;
            this.hashCode += key == null ? 0 : key.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof ComplexKey)) {
                return false;
            }
            ComplexKey cmp = (ComplexKey)obj;
            for (int i = 0; i < this.keys.length; ++i) {
                if (!(this.keys[i] == null ? cmp.keys[i] != null : !this.keys[i].equals(cmp.keys[i]))) continue;
                return false;
            }
            return true;
        }

        public int compareTo(Object obj) {
            ComplexKey cmp = (ComplexKey)obj;
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] == null) {
                    if (cmp.keys[i] == null) continue;
                    return -1;
                }
                if (cmp.keys[i] == null) {
                    return 1;
                }
                int ret = this.keys[i].compareTo(cmp.keys[i]);
                if (ret == 0) continue;
                return ret;
            }
            return 0;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.keys);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            Object[] tmpKeys = (Object[])in.readObject();
            if (tmpKeys != null) {
                this.keys = new Comparable[tmpKeys.length];
                for (int i = 0; i < tmpKeys.length; ++i) {
                    this.set(i, tmpKeys[i]);
                }
            }
        }
    }

    protected static class ComparableComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 6961807867939374647L;

        protected ComparableComparator() {
        }

        public int compare(Object o1, Object o2) {
            Comparable c1 = (Comparable)o1;
            Comparable c2 = (Comparable)o2;
            if (c1 != null && c2 != null) {
                return c1.compareTo(c2);
            }
            if (c1 == null && c2 != null) {
                return -1;
            }
            if (c1 != null && c2 == null) {
                return 1;
            }
            return 0;
        }
    }

    protected class DefaultSharedContextIndexKeyFactory
    implements BeanTableIndexKeyFactory,
    Externalizable {
        protected List indexedProperties = new ArrayList();
        protected Set indexedPropertyNames = new HashSet();

        public DefaultSharedContextIndexKeyFactory(String[] propNames) {
            for (int i = 0; i < propNames.length; ++i) {
                SimpleProperty prop = new SimpleProperty(propNames[i]);
                if (this.indexedPropertyNames.contains(prop.getPropertyName())) continue;
                this.indexedPropertyNames.add(prop.getPropertyName());
                this.indexedProperties.add(prop);
            }
            ((ArrayList)this.indexedProperties).trimToSize();
        }

        @Override
        public Set getPropertyNames() {
            return this.indexedPropertyNames;
        }

        @Override
        public Object createIndexKey(Object value) throws IndexPropertyAccessException {
            int indexKeySize = this.indexedProperties.size();
            if (indexKeySize == 1) {
                try {
                    return ((Property)this.indexedProperties.get(0)).getProperty(value);
                }
                catch (NoSuchPropertyException e) {
                    throw new IndexPropertyAccessException(value == null ? null : value.getClass(), ((Property)this.indexedProperties.get(0)).getPropertyName(), e);
                }
                catch (InvocationTargetException e) {
                    throw new IndexPropertyAccessException(value == null ? null : value.getClass(), ((Property)this.indexedProperties.get(0)).getPropertyName(), e.getTargetException());
                }
            }
            ComplexKey indexKey = new ComplexKey(indexKeySize);
            for (int i = 0; i < indexKeySize; ++i) {
                SimpleProperty prop = (SimpleProperty)this.indexedProperties.get(i);
                try {
                    indexKey.set(i, prop.getProperty(value));
                    continue;
                }
                catch (NoSuchPropertyException e) {
                    throw new IndexPropertyAccessException(value == null ? null : value.getClass(), ((Property)this.indexedProperties.get(0)).getPropertyName(), e);
                }
                catch (InvocationTargetException e) {
                    throw new IndexPropertyAccessException(value == null ? null : value.getClass(), ((Property)this.indexedProperties.get(0)).getPropertyName(), e.getTargetException());
                }
            }
            return indexKey;
        }

        @Override
        public Object createIndexKeyByProperties(Map keys) throws IllegalArgumentException {
            if (!keys.keySet().containsAll(this.indexedPropertyNames)) {
                throw new IllegalArgumentException("keys are insufficient. keys=" + keys + ", indexedProperties=" + this.indexedPropertyNames);
            }
            int indexKeySize = this.indexedPropertyNames.size();
            if (indexKeySize == 1) {
                return keys.get(this.indexedPropertyNames.iterator().next());
            }
            ComplexKey indexKey = new ComplexKey(indexKeySize);
            for (int i = 0; i < indexKeySize; ++i) {
                indexKey.set(i, keys.get(((Property)this.indexedProperties.get(i)).getPropertyName()));
            }
            return indexKey;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.indexedProperties.size());
            for (int i = 0; i < this.indexedProperties.size(); ++i) {
                SimpleProperty prop = (SimpleProperty)this.indexedProperties.get(i);
                out.writeObject(prop.getPropertyName());
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.indexedProperties = new ArrayList();
            this.indexedPropertyNames = new HashSet();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                String propName = (String)in.readObject();
                this.indexedProperties.add(new SimpleProperty(propName));
                this.indexedPropertyNames.add(propName);
            }
            ((ArrayList)this.indexedProperties).trimToSize();
        }
    }
}

