/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.crypt;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.crypt.CipherCryptServiceMBean;
import jp.ossc.nimbus.service.crypt.Crypt;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.ReversibleConverter;
import jp.ossc.nimbus.util.converter.StringConverter;

public class CipherCryptService
extends ServiceBase
implements Crypt,
StringConverter,
ReversibleConverter,
CipherCryptServiceMBean {
    private static final long serialVersionUID = 5230161454391953789L;
    private static final String CC___00001 = "CC___00001";
    private static final String CC___00002 = "CC___00002";
    private static final String CC___00003 = "CC___00003";
    protected String transformation = "DES/ECB/PKCS5Padding";
    protected Key key;
    protected Provider cipherProvider;
    protected String cipherProviderName;
    protected Provider messageDigestProvider;
    protected String messageDigestProviderName;
    protected AlgorithmParameters algorithmParameters;
    protected AlgorithmParameterSpec algorithmParameterSpec;
    protected SecureRandom secureRandom;
    protected String encoding = "ISO_8859-1";
    protected String hashAlgorithm = "MD5";
    protected int convertType;
    protected String storePath;
    protected String storeType;
    protected String storeProviderName;
    protected Provider storeProvider;
    protected String storePassword;
    protected String keyAlias;
    protected String keyPassword;

    @Override
    public void setTransformation(String trans) {
        this.transformation = trans;
    }

    @Override
    public String getTransformation() {
        return this.transformation;
    }

    @Override
    public void setKey(Key k) {
        this.key = k;
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public void setCipherProvider(Provider p) {
        this.cipherProvider = p;
    }

    @Override
    public Provider getCipherProvider() {
        return this.cipherProvider;
    }

    @Override
    public void setCipherProviderName(String name) {
        this.cipherProviderName = name;
    }

    @Override
    public String getCipherProviderName() {
        return this.cipherProviderName;
    }

    @Override
    public void setAlgorithmParameters(AlgorithmParameters params) {
        this.algorithmParameters = params;
    }

    @Override
    public AlgorithmParameters getAlgorithmParameters() {
        return this.algorithmParameters;
    }

    @Override
    public void setAlgorithmParameterSpec(AlgorithmParameterSpec params) {
        this.algorithmParameterSpec = params;
    }

    @Override
    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.algorithmParameterSpec;
    }

    @Override
    public void setSecureRandom(SecureRandom random) {
        this.secureRandom = random;
    }

    @Override
    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    @Override
    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setHashAlgorithm(String algorithm) {
        this.hashAlgorithm = algorithm;
    }

    @Override
    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @Override
    public void setMessageDigestProvider(Provider p) {
        this.messageDigestProvider = p;
    }

    @Override
    public Provider getMessageDigestProvider() {
        return this.messageDigestProvider;
    }

    @Override
    public void setMessageDigestProviderName(String name) {
        this.messageDigestProviderName = name;
    }

    @Override
    public String getMessageDigestProviderName() {
        return this.messageDigestProviderName;
    }

    @Override
    public void setConvertType(int type) {
        this.convertType = type;
    }

    @Override
    public int getConvertType() {
        return this.convertType;
    }

    @Override
    public void setStorePath(String path) {
        this.storePath = path;
    }

    @Override
    public String getStorePath() {
        return this.storePath;
    }

    @Override
    public void setStoreType(String type) {
        this.storeType = type;
    }

    @Override
    public String getStoreType() {
        return this.storeType;
    }

    @Override
    public void setStoreProviderName(String name) {
        this.storeProviderName = name;
    }

    @Override
    public String getStoreProviderName() {
        return this.storeProviderName;
    }

    @Override
    public void setStoreProvider(Provider provider) {
        this.storeProvider = provider;
    }

    @Override
    public Provider getStoreProvider() {
        return this.storeProvider;
    }

    @Override
    public void setStorePassword(String password) {
        this.storePassword = password;
    }

    @Override
    public String getStorePassword() {
        return this.storePassword;
    }

    @Override
    public void setKeyAlias(String alias) {
        this.keyAlias = alias;
    }

    @Override
    public String getKeyAlias() {
        return this.keyAlias;
    }

    @Override
    public void setKeyPassword(String password) {
        this.keyPassword = password;
    }

    @Override
    public String getKeyPassword() {
        return this.keyPassword;
    }

    @Override
    public void startService() throws Exception {
        String encodeStr;
        String decodeStr;
        if (this.key == null && this.storePath != null) {
            if (this.storePassword == null) {
                throw new IllegalArgumentException("StorePassword is null");
            }
            if (this.keyAlias == null) {
                throw new IllegalArgumentException("KeyAlias is null");
            }
            if (this.keyPassword == null) {
                throw new IllegalArgumentException("KeyPassword is null");
            }
            this.key = this.loadKey();
        }
        if (this.key != null && !"test".equals(decodeStr = this.doDecodeInternal(encodeStr = this.doEncodeInternal("test")))) {
            throw new IllegalArgumentException("This encryption cannot convert reversible.");
        }
        if (this.hashAlgorithm != null) {
            this.doHashInternal("test");
        }
        if (this.key == null && this.hashAlgorithm == null) {
            throw new IllegalArgumentException("It is necessary to specify either of key or hashAlgorithm.");
        }
    }

    protected Key loadKey() throws Exception {
        InputStream is = null;
        is = new File(this.storePath).exists() ? new FileInputStream(this.storePath) : this.getClass().getResourceAsStream(this.storePath);
        if (is == null) {
            throw new IOException("KeyStore is not found. path=" + this.storePath);
        }
        KeyStore store = null;
        String type = this.storeType;
        if (type == null) {
            type = KeyStore.getDefaultType();
        }
        store = this.storeProviderName != null ? KeyStore.getInstance(type, this.storeProviderName) : (this.storeProvider != null ? KeyStore.getInstance(type, this.storeProvider) : KeyStore.getInstance(type));
        store.load(is, this.storePassword.toCharArray());
        return store.getKey(this.keyAlias, this.keyPassword.toCharArray());
    }

    @Override
    public String doEncode(String str) {
        try {
            return this.doEncodeInternal(str);
        }
        catch (NoSuchAlgorithmException e) {
            this.getLogger().write(CC___00001, e);
        }
        catch (NoSuchProviderException e) {
            this.getLogger().write(CC___00001, e);
        }
        catch (NoSuchPaddingException e) {
            this.getLogger().write(CC___00001, e);
        }
        catch (InvalidKeyException e) {
            this.getLogger().write(CC___00001, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            this.getLogger().write(CC___00001, e);
        }
        catch (IllegalBlockSizeException e) {
            this.getLogger().write(CC___00001, e);
        }
        catch (BadPaddingException e) {
            this.getLogger().write(CC___00001, e);
        }
        catch (UnsupportedEncodingException e) {
            this.getLogger().write(CC___00001, e);
        }
        return str;
    }

    protected String doEncodeInternal(String str) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        if (this.transformation == null || this.key == null) {
            throw new UnsupportedOperationException("Transformation or key is not specified.");
        }
        if (str == null) {
            return null;
        }
        Cipher c = this.createCipher();
        this.intiCipher(c, 1);
        return CipherCryptService.toHexString(c.doFinal(str.getBytes(this.encoding)));
    }

    protected Cipher createCipher() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        if (this.cipherProvider != null) {
            return Cipher.getInstance(this.transformation, this.cipherProvider);
        }
        if (this.cipherProviderName != null) {
            return Cipher.getInstance(this.transformation, this.cipherProviderName);
        }
        return Cipher.getInstance(this.transformation);
    }

    protected void intiCipher(Cipher c, int opmode) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.algorithmParameters != null) {
            if (this.secureRandom == null) {
                c.init(opmode, this.key, this.algorithmParameters);
            } else {
                c.init(opmode, this.key, this.algorithmParameters, this.secureRandom);
            }
        } else if (this.algorithmParameterSpec != null) {
            if (this.secureRandom == null) {
                c.init(opmode, this.key, this.algorithmParameterSpec);
            } else {
                c.init(opmode, this.key, this.algorithmParameterSpec, this.secureRandom);
            }
        } else if (this.secureRandom != null) {
            c.init(opmode, this.key, this.secureRandom);
        } else {
            c.init(opmode, this.key);
        }
    }

    protected static String toHexString(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        for (int n : bytes) {
            String str = Integer.toHexString(n &= 0xFF).toUpperCase();
            if (str.length() == 1) {
                buf.append('0');
            }
            buf.append(str);
        }
        return buf.toString();
    }

    @Override
    public String doDecode(String str) {
        try {
            return this.doDecodeInternal(str);
        }
        catch (NoSuchAlgorithmException e) {
            this.getLogger().write(CC___00002, e);
        }
        catch (NoSuchProviderException e) {
            this.getLogger().write(CC___00002, e);
        }
        catch (NoSuchPaddingException e) {
            this.getLogger().write(CC___00002, e);
        }
        catch (InvalidKeyException e) {
            this.getLogger().write(CC___00002, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            this.getLogger().write(CC___00002, e);
        }
        catch (IllegalBlockSizeException e) {
            this.getLogger().write(CC___00002, e);
        }
        catch (BadPaddingException e) {
            this.getLogger().write(CC___00002, e);
        }
        catch (UnsupportedEncodingException e) {
            this.getLogger().write(CC___00002, e);
        }
        return str;
    }

    protected String doDecodeInternal(String str) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        Cipher c = this.createCipher();
        this.intiCipher(c, 2);
        return new String(c.doFinal(CipherCryptService.toBytes(str)), this.encoding);
    }

    protected static byte[] toBytes(String hex) {
        byte[] bytes = new byte[hex.length() / 2];
        int max = hex.length();
        for (int i = 0; i < max; i += 2) {
            bytes[i / 2] = (byte)(Integer.parseInt(hex.substring(i, i + 2), 16) & 0xFF);
        }
        return bytes;
    }

    @Override
    public String doHash(String str) {
        try {
            return this.doHashInternal(str);
        }
        catch (NoSuchProviderException e) {
            this.getLogger().write(CC___00003, e);
        }
        catch (NoSuchAlgorithmException e) {
            this.getLogger().write(CC___00003, e);
        }
        catch (UnsupportedEncodingException e) {
            this.getLogger().write(CC___00003, e);
        }
        return str;
    }

    protected String doHashInternal(String str) throws NoSuchProviderException, NoSuchAlgorithmException, UnsupportedEncodingException {
        if (this.hashAlgorithm == null) {
            throw new UnsupportedOperationException("HashAlgorithm is not specified.");
        }
        if (str == null) {
            return null;
        }
        MessageDigest messageDigest = null;
        messageDigest = this.messageDigestProvider != null ? MessageDigest.getInstance(this.hashAlgorithm, this.messageDigestProvider) : (this.messageDigestProviderName != null ? MessageDigest.getInstance(this.hashAlgorithm, this.messageDigestProviderName) : MessageDigest.getInstance(this.hashAlgorithm));
        return CipherCryptService.toHexString(messageDigest.digest(str.getBytes(this.encoding)));
    }

    @Override
    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        return this.convert((String)(obj instanceof String ? obj : String.valueOf(obj)));
    }

    @Override
    public String convert(String str) throws ConvertException {
        switch (this.convertType) {
            case 2: {
                return this.doDecode(str);
            }
        }
        return this.doEncode(str);
    }
}

