/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ftp.ftpclient;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.ossc.nimbus.service.ftp.FTPClient;
import jp.ossc.nimbus.service.ftp.FTPErrorResponseException;
import jp.ossc.nimbus.service.ftp.FTPException;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileListParser;

public class FTPClientImpl
implements FTPClient {
    private org.apache.commons.net.ftp.FTPClient client;
    private FTPFileListParser ftpFileListParser;
    private int transferType = 0;
    private File homeDir;
    private boolean isJavaRegexEnabled = false;
    private boolean isPassive = false;
    private int port = 21;

    public FTPClientImpl(org.apache.commons.net.ftp.FTPClient client) {
        this.client = client;
    }

    public void setFTPFileListParser(FTPFileListParser parser) {
        this.ftpFileListParser = parser;
    }

    public FTPFileListParser getFTPFileListParser() {
        return this.ftpFileListParser;
    }

    public void setHomeDirectory(File dir) {
        this.homeDir = dir;
    }

    public File getHomeDirectory() {
        return this.homeDir;
    }

    public void setJavaRegexEnabled(boolean isEnabled) {
        this.isJavaRegexEnabled = isEnabled;
    }

    public boolean isJavaRegexEnabled() {
        return this.isJavaRegexEnabled;
    }

    @Override
    public void connect(String host) throws FTPException {
        try {
            this.client.connect(host);
            this.port = 21;
        }
        catch (SocketException e) {
            throw new FTPException(e);
        }
        catch (UnknownHostException e) {
            throw new FTPException(e);
        }
        catch (IOException e) {
            throw new FTPException(e);
        }
    }

    @Override
    public void connect(String host, int port) throws FTPException {
        try {
            this.client.connect(host, port);
            this.port = port;
        }
        catch (SocketException e) {
            throw new FTPException(e);
        }
        catch (UnknownHostException e) {
            throw new FTPException(e);
        }
        catch (IOException e) {
            throw new FTPException(e);
        }
    }

    @Override
    public void connect(String host, int port, String localAddr, int localPort) throws FTPException {
        try {
            this.client.connect(host, port, InetAddress.getByName(localAddr), localPort);
            this.port = port;
        }
        catch (SocketException e) {
            throw new FTPException(e);
        }
        catch (UnknownHostException e) {
            throw new FTPException(e);
        }
        catch (IOException e) {
            throw new FTPException(e);
        }
    }

    @Override
    public void login(String user, String password) throws FTPException {
        try {
            if (!this.client.login(user, password)) {
                throw new FTPErrorResponseException(this.client.getReplyCode(), "login failed. cause=" + this.client.getReplyString());
            }
        }
        catch (IOException e) {
            throw new FTPException(e);
        }
    }

    @Override
    public void logout() throws FTPException {
        try {
            if (!this.client.logout()) {
                throw new FTPErrorResponseException(this.client.getReplyCode(), "logout failed. cause=" + this.client.getReplyString());
            }
        }
        catch (IOException e) {
            throw new FTPException(e);
        }
    }

    @Override
    public String[] ls() throws FTPException {
        try {
            if (this.ftpFileListParser == null) {
                return this.client.listNames();
            }
            FTPFile[] files = this.client.listFiles(this.ftpFileListParser);
            if (files == null || files.length == 0) {
                return new String[0];
            }
            String[] paths = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                paths[i] = files[i].getName();
            }
            return paths;
        }
        catch (IOException e) {
            throw new FTPException(e);
        }
    }

    public FTPFile[] lsFTPFile() throws FTPException {
        try {
            return this.ftpFileListParser == null ? this.client.listFiles() : this.client.listFiles(this.ftpFileListParser);
        }
        catch (IOException e) {
            throw new FTPException(e);
        }
    }

    @Override
    public String[] ls(String path) throws FTPException {
        try {
            if (this.ftpFileListParser == null) {
                return this.client.listNames(path);
            }
            FTPFile[] files = this.client.listFiles(this.ftpFileListParser, path);
            if (files == null || files.length == 0) {
                return new String[0];
            }
            String[] paths = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                paths[i] = files[i].getName();
            }
            return paths;
        }
        catch (IOException e) {
            throw new FTPException(e);
        }
    }

    public FTPFile[] lsFTPFile(String path) throws FTPException {
        try {
            return this.ftpFileListParser == null ? this.client.listFiles(path) : this.client.listFiles(this.ftpFileListParser, path);
        }
        catch (IOException e) {
            throw new FTPException(e);
        }
    }

    @Override
    public String pwd() throws FTPException {
        try {
            return this.client.printWorkingDirectory();
        }
        catch (IOException e) {
            throw new FTPException(e);
        }
    }

    @Override
    public File lpwd() throws FTPException {
        if (this.homeDir == null) {
            return new File(".");
        }
        return this.homeDir;
    }

    @Override
    public void cd(String path) throws FTPException {
        try {
            if (!this.client.changeWorkingDirectory(path)) {
                throw new FTPErrorResponseException(this.client.getReplyCode(), "Can't change directory! from=" + this.client.printWorkingDirectory() + ", to=" + path + ", cause=" + this.client.getReplyString());
            }
        }
        catch (IOException e) {
            throw new FTPException(e);
        }
    }

    @Override
    public void lcd(String path) throws FTPException {
        File file = new File(path);
        if (!file.isAbsolute() && this.homeDir != null) {
            file = new File(this.homeDir, path);
        }
        if (!file.exists()) {
            throw new FTPException("Can't change directory, because it is not exists! path=" + path);
        }
        if (!file.isDirectory()) {
            throw new FTPException("Can't change directory, because it is not directory! path=" + path);
        }
        this.homeDir = file;
    }

    @Override
    public void mkdir(String dir) throws FTPException {
        try {
            if (!this.client.makeDirectory(dir)) {
                throw new FTPErrorResponseException(this.client.getReplyCode(), "Can't make directory! dir=" + dir + ", cause=" + this.client.getReplyString());
            }
        }
        catch (IOException e) {
            throw new FTPException(e);
        }
    }

    @Override
    public void rename(String from, String to) throws FTPException {
        try {
            if (!this.client.rename(from, to)) {
                throw new FTPErrorResponseException(this.client.getReplyCode(), "Can't rename file! from=" + from + ", to=" + to + ", cause=" + this.client.getReplyString());
            }
        }
        catch (IOException e) {
            throw new FTPException(e);
        }
    }

    @Override
    public File get(String path) throws FTPException {
        FileOutputStream fos = null;
        try {
            File file = new File(path);
            String name = file.getName();
            File localFile = this.homeDir == null ? new File(name) : new File(this.homeDir, name);
            fos = new FileOutputStream(localFile);
            if (!this.client.retrieveFile(path, (OutputStream)fos)) {
                throw new FTPErrorResponseException(this.client.getReplyCode(), "Can't get file! remote=" + path + ", local=" + localFile + ", cause=" + this.client.getReplyString());
            }
            File file2 = localFile;
            return file2;
        }
        catch (IOException e) {
            throw new FTPException(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public File get(String remote, String local) throws FTPException {
        FileOutputStream fos = null;
        try {
            File localFile = new File(local);
            if (this.homeDir != null && !localFile.isAbsolute()) {
                localFile = new File(this.homeDir, local);
            }
            if (!this.client.retrieveFile(remote, (OutputStream)(fos = new FileOutputStream(localFile)))) {
                throw new FTPErrorResponseException(this.client.getReplyCode(), "Can't get file! remote=" + remote + ", local=" + localFile + ", cause=" + this.client.getReplyString());
            }
            File file = localFile;
            return file;
        }
        catch (IOException e) {
            throw new FTPException(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public File[] mget(String path) throws FTPException {
        try {
            File file = new File(path);
            File dir = file.getParentFile();
            FTPFile[] files = null;
            files = dir == null ? (this.ftpFileListParser == null ? this.client.listFiles() : this.client.listFiles(this.ftpFileListParser)) : (this.ftpFileListParser == null ? this.client.listFiles(dir.getPath()) : this.client.listFiles(this.ftpFileListParser, dir.getPath()));
            if (files == null || files.length == 0) {
                return new File[0];
            }
            String fileName = file.getName();
            if (!this.isJavaRegexEnabled) {
                fileName = fileName.replaceAll("\\.", "\\\\.");
                fileName = fileName.replaceAll("\\*", ".*");
            }
            Pattern p = Pattern.compile(fileName);
            ArrayList<File> result = new ArrayList<File>();
            for (int i = 0; i < files.length; ++i) {
                Matcher m;
                if (files[i].isDirectory() || !(m = p.matcher(files[i].getName())).matches()) continue;
                result.add(this.get(dir == null ? files[i].getName() : new File(dir, files[i].getName()).getPath()));
            }
            return result.toArray(new File[result.size()]);
        }
        catch (IOException e) {
            throw new FTPException(e);
        }
    }

    @Override
    public void put(String path) throws FTPException {
        FileInputStream fis = null;
        try {
            File localFile = new File(path);
            String remote = localFile.getName();
            if (this.homeDir != null && !localFile.isAbsolute()) {
                localFile = new File(this.homeDir, path);
            }
            if (!this.client.storeFile(remote, (InputStream)(fis = new FileInputStream(localFile)))) {
                throw new FTPErrorResponseException(this.client.getReplyCode(), "Can't put file! local=" + path + ", remote=" + remote + ", cause=" + this.client.getReplyString());
            }
        }
        catch (IOException e) {
            throw new FTPException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void put(String local, String remote) throws FTPException {
        FileInputStream fis = null;
        try {
            File localFile = new File(local);
            if (this.homeDir != null && !localFile.isAbsolute()) {
                localFile = new File(this.homeDir, local);
            }
            if (!this.client.storeFile(remote, (InputStream)(fis = new FileInputStream(localFile)))) {
                throw new FTPErrorResponseException(this.client.getReplyCode(), "Can't put file! local=" + local + ", remote=" + remote + ", cause=" + this.client.getReplyString());
            }
        }
        catch (IOException e) {
            throw new FTPException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void mput(String path) throws FTPException {
        File file = new File(path);
        if (this.homeDir != null && !file.isAbsolute()) {
            file = new File(this.homeDir, path);
        }
        File dir = file.getParentFile();
        String fileName = file.getName();
        if (!this.isJavaRegexEnabled) {
            fileName = fileName.replaceAll("\\.", "\\\\.");
            fileName = fileName.replaceAll("\\*", ".*");
        }
        File[] files = dir.listFiles();
        Pattern p = Pattern.compile(fileName);
        for (int i = 0; i < files.length; ++i) {
            Matcher m;
            if (files[i].isDirectory() || !(m = p.matcher(files[i].getName())).matches()) continue;
            this.put(files[i].getPath());
        }
    }

    @Override
    public void delete(String path) throws FTPException {
        try {
            if (!this.client.deleteFile(path)) {
                throw new FTPErrorResponseException(this.client.getReplyCode(), "Can't delete file! path=" + path + ", cause=" + this.client.getReplyString());
            }
        }
        catch (IOException e) {
            throw new FTPException(e);
        }
    }

    @Override
    public void mdelete(String path) throws FTPException {
        try {
            File file = new File(path);
            File dir = file.getParentFile();
            FTPFile[] files = null;
            files = dir == null ? (this.ftpFileListParser == null ? this.client.listFiles() : this.client.listFiles(this.ftpFileListParser)) : (this.ftpFileListParser == null ? this.client.listFiles(dir.getPath()) : this.client.listFiles(this.ftpFileListParser, dir.getPath()));
            if (files == null || files.length == 0) {
                return;
            }
            String fileName = file.getName();
            if (!this.isJavaRegexEnabled) {
                fileName = fileName.replaceAll("\\.", "\\\\.");
                fileName = fileName.replaceAll("\\*", ".*");
            }
            Pattern p = Pattern.compile(fileName);
            for (int i = 0; i < files.length; ++i) {
                Matcher m;
                if (files[i].isDirectory() || !(m = p.matcher(files[i].getName())).matches()) continue;
                this.delete(dir == null ? files[i].getName() : new File(dir, files[i].getName()).getPath());
            }
        }
        catch (IOException e) {
            throw new FTPException(e);
        }
    }

    @Override
    public void ascii() throws FTPException {
        this.setTransferType(0);
    }

    @Override
    public void binary() throws FTPException {
        this.setTransferType(2);
    }

    @Override
    public void active() throws FTPException {
        if (this.isPassive) {
            try {
                if (!this.client.enterRemoteActiveMode(this.client.getRemoteAddress(), this.port)) {
                    throw new FTPErrorResponseException(this.client.getReplyCode(), "Can't change active mode! cause=" + this.client.getReplyString());
                }
                this.client.enterLocalActiveMode();
                this.isPassive = false;
            }
            catch (IOException e) {
                throw new FTPException(e);
            }
        }
    }

    @Override
    public void passive() throws FTPException {
        if (!this.isPassive) {
            try {
                if (!this.client.enterRemotePassiveMode()) {
                    throw new FTPErrorResponseException(this.client.getReplyCode(), "Can't change passive mode! cause=" + this.client.getReplyString());
                }
                this.client.enterLocalPassiveMode();
                this.isPassive = true;
            }
            catch (IOException e) {
                throw new FTPException(e);
            }
        }
    }

    @Override
    public void setTransferType(int type) throws FTPException {
        try {
            this.client.setFileType(type);
            this.transferType = type;
        }
        catch (IOException e) {
            throw new FTPException(e);
        }
    }

    @Override
    public int getTransferType() throws FTPException {
        return this.transferType;
    }

    @Override
    public void close() throws FTPException {
        try {
            this.client.disconnect();
        }
        catch (IOException e) {
            throw new FTPException(e);
        }
    }
}

