/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.graph.DatabaseDatasetCondition;
import jp.ossc.nimbus.service.graph.DatabaseDatasetFactoryServiceMBean;
import jp.ossc.nimbus.service.graph.DatasetCondition;
import jp.ossc.nimbus.service.graph.DatasetCreateException;
import jp.ossc.nimbus.service.graph.DatasetFactory;
import org.jfree.data.general.Dataset;

public abstract class DatabaseDatasetFactoryService
extends ServiceBase
implements DatabaseDatasetFactoryServiceMBean,
DatasetFactory,
Serializable {
    private static final long serialVersionUID = -1040225706936424053L;
    public static final int DEFAULT_FETCH_SIZE = 10000;
    private static final String SEPARATOR = "=";
    private String name;
    private ConnectionFactory connFactory;
    private String[] sqls;
    private List dsConditionList;
    private Map seriesSqlMap;
    private int fetchSize = 10000;

    @Override
    public void createService() throws Exception {
        this.dsConditionList = new ArrayList();
        this.seriesSqlMap = new LinkedHashMap();
    }

    @Override
    public void startService() throws Exception {
        if (this.name == null || this.name.length() == 0) {
            this.name = this.getServiceName();
        }
        if (this.connFactory == null) {
            throw new IllegalArgumentException("ConnectionFactory is null.");
        }
        if (this.sqls == null || this.sqls.length == 0) {
            throw new IllegalArgumentException("sqls must be specified.");
        }
        for (int i = 0; i < this.sqls.length; ++i) {
            String seriesSql = this.sqls[i];
            int index = seriesSql.indexOf(SEPARATOR);
            if (index == -1) {
                throw new IllegalArgumentException("sqls is invalid." + seriesSql);
            }
            String seriesName = seriesSql.substring(0, index);
            String sql = seriesSql.substring(index + 1);
            this.seriesSqlMap.put(seriesName, sql);
        }
    }

    @Override
    public void stopService() throws Exception {
        this.dsConditionList.clear();
        this.seriesSqlMap.clear();
    }

    @Override
    public void destroyService() throws Exception {
        this.dsConditionList = null;
        this.seriesSqlMap = null;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setConnectionFactory(ConnectionFactory connFactory) {
        this.connFactory = connFactory;
    }

    @Override
    public ConnectionFactory getConnectionFactory() {
        return this.connFactory;
    }

    @Override
    public void setSqls(String[] sqls) {
        this.sqls = sqls;
    }

    @Override
    public String[] getSqls() {
        return this.sqls;
    }

    @Override
    public void setFetchSize(int size) {
        this.fetchSize = size;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void addDatasetCondition(DatasetCondition dsCondition) {
        this.dsConditionList.add(dsCondition);
    }

    @Override
    public DatasetCondition[] getDatasetConditions() {
        return this.dsConditionList.toArray(new DatasetCondition[this.dsConditionList.size()]);
    }

    @Override
    public Dataset createDataset(DatasetCondition[] dsConditions) throws DatasetCreateException {
        List<DatasetCondition> list;
        Connection conn = null;
        try {
            conn = this.connFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new DatasetCreateException("Dataset [" + this.name + "]", e);
        }
        DatasetCondition[] conditions = null;
        if (dsConditions != null && dsConditions.length > 0) {
            conditions = dsConditions;
        }
        if (conditions == null && this.dsConditionList.size() > 0) {
            conditions = this.dsConditionList.toArray(new DatasetCondition[this.dsConditionList.size()]);
        }
        Dataset dataset = null;
        LinkedHashMap<String[], ResultSet> seriesRsMap = new LinkedHashMap<String[], ResultSet>();
        ArrayList<DatabaseDatasetCondition> allConditions = new ArrayList<DatabaseDatasetCondition>();
        HashMap conditionMap = new HashMap();
        if (conditions != null && conditions.length > 0) {
            for (int i = 0; i < conditions.length; ++i) {
                DatasetCondition dsCondition = conditions[i];
                if (!(dsCondition instanceof DatabaseDatasetCondition) || !this.name.equals(dsCondition.getName())) continue;
                String seriesName = conditions[i].getSeriesName();
                if (seriesName == null) {
                    allConditions.add((DatabaseDatasetCondition)dsCondition);
                    continue;
                }
                if (conditionMap.containsKey(seriesName)) {
                    list = (List)conditionMap.get(seriesName);
                    list.add(dsCondition);
                    continue;
                }
                list = new ArrayList();
                list.add(dsCondition);
                conditionMap.put(seriesName, list);
            }
        }
        try {
            String[] series2;
            for (String[] series2 : this.seriesSqlMap.keySet()) {
                PreparedStatement pstmt = conn.prepareStatement((String)this.seriesSqlMap.get(series2), 1003, 1007);
                pstmt.setFetchSize(this.fetchSize);
                pstmt.setFetchDirection(1000);
                if (allConditions.size() > 0) {
                    for (int i = 0; i < allConditions.size(); ++i) {
                        DatabaseDatasetCondition condition = (DatabaseDatasetCondition)allConditions.get(i);
                        this.setObject(pstmt, condition);
                    }
                } else if (conditionMap.containsKey(series2)) {
                    list = (List)conditionMap.get(series2);
                    for (int i = 0; i < list.size(); ++i) {
                        DatabaseDatasetCondition condition = (DatabaseDatasetCondition)list.get(i);
                        this.setObject(pstmt, condition);
                    }
                }
                ResultSet rs = pstmt.executeQuery();
                seriesRsMap.put(series2, rs);
            }
            series2 = null;
            ResultSet[] rSets = null;
            if (seriesRsMap.size() > 0) {
                series2 = seriesRsMap.keySet().toArray(new String[seriesRsMap.size()]);
                rSets = seriesRsMap.values().toArray(new ResultSet[seriesRsMap.size()]);
            }
            dataset = this.createDataset(dsConditions, series2, rSets);
        }
        catch (SQLException e) {
            throw new DatasetCreateException("Dataset [" + this.name + "]", e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return dataset;
    }

    private void setObject(PreparedStatement pstmt, DatabaseDatasetCondition dbDsCondition) throws DatasetCreateException, SQLException {
        ParameterMetaData paramMetaData = pstmt.getParameterMetaData();
        if (paramMetaData == null) {
            throw new DatasetCreateException("ParameterMetaData is null.");
        }
        int paramCnt = paramMetaData.getParameterCount();
        if (paramCnt > 0) {
            for (int k = 0; k < paramCnt; ++k) {
                Object paramObj = dbDsCondition.getParamObject(k);
                if (paramObj == null) continue;
                pstmt.setObject(k + 1, paramObj);
            }
        }
    }

    protected abstract Dataset createDataset(DatasetCondition[] var1, String[] var2, ResultSet[] var3) throws DatasetCreateException;
}

