/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.graph.DatasetCondition;
import jp.ossc.nimbus.service.graph.DatasetCreateException;
import jp.ossc.nimbus.service.graph.DatasetFactory;
import jp.ossc.nimbus.service.graph.PlotCondition;
import jp.ossc.nimbus.service.graph.PlotCreateException;
import jp.ossc.nimbus.service.graph.PlotFactory;
import jp.ossc.nimbus.service.graph.TickUnitAdjuster;
import jp.ossc.nimbus.service.graph.XYPlotConditionImpl;
import jp.ossc.nimbus.service.graph.XYPlotFactoryServiceMBean;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYDataset;

public class XYPlotFactoryService
extends ServiceBase
implements XYPlotFactoryServiceMBean,
PlotFactory {
    private static final long serialVersionUID = 7687375902291200266L;
    private String name;
    private ServiceName[] dsFactoryServiceNames;
    private Map dsFactoryMap;
    private ServiceName[] domainAxisServiceNames;
    private ServiceName[] rangeAxisServiceNames;
    private Map domainAxisIndexMap;
    private Map rangeAxisIndexMap;
    protected TickUnitAdjuster[] adjusters;
    protected ServiceName[] tickUnitAdjusterServiceNames;
    protected XYPlot tmpPlot;
    private Properties dsRendererNames;
    private Properties dsDomainAxisNames;
    private Properties dsRangeAxisNames;

    @Override
    public void setDatasetFactoryServiceNames(ServiceName[] names) {
        this.dsFactoryServiceNames = names;
    }

    @Override
    public ServiceName[] getDatasetFactoryServiceNames() {
        return this.dsFactoryServiceNames;
    }

    @Override
    public void setDatasetRendererServiceNames(Properties names) {
        this.dsRendererNames = names;
    }

    @Override
    public Properties getDatasetRendererServiceNames() {
        return this.dsRendererNames;
    }

    @Override
    public void setDatasetDomainAxisNames(Properties names) {
        this.dsDomainAxisNames = names;
    }

    @Override
    public Properties getDatasetDomainAxisNames() {
        return this.dsDomainAxisNames;
    }

    @Override
    public void setDatasetRangeAxisNames(Properties names) {
        this.dsRangeAxisNames = names;
    }

    @Override
    public Properties getDatasetRangeAxisNames() {
        return this.dsRangeAxisNames;
    }

    @Override
    public void setDomainAxisServiceNames(ServiceName[] serviceNames) {
        this.domainAxisServiceNames = serviceNames;
    }

    @Override
    public ServiceName[] getDomainAxisServiceNames() {
        return this.domainAxisServiceNames;
    }

    @Override
    public void setRangeAxisServiceNames(ServiceName[] serviceNames) {
        this.rangeAxisServiceNames = serviceNames;
    }

    @Override
    public ServiceName[] getRangeAxisServiceNames() {
        return this.rangeAxisServiceNames;
    }

    @Override
    public void setTickUnitAdjusters(TickUnitAdjuster[] adjusters) {
        this.adjusters = adjusters;
    }

    @Override
    public TickUnitAdjuster[] getTickUnitAdjusters() {
        return this.adjusters;
    }

    @Override
    public void setTickUnitAdjusterServiceNames(ServiceName[] names) {
        this.tickUnitAdjusterServiceNames = names;
    }

    @Override
    public ServiceName[] getTickUnitAdjusterNames() {
        return this.tickUnitAdjusterServiceNames;
    }

    @Override
    public void createService() throws Exception {
        this.dsFactoryMap = new LinkedHashMap();
        this.domainAxisIndexMap = new HashMap();
        this.rangeAxisIndexMap = new HashMap();
        this.tmpPlot = new XYPlot(null, (ValueAxis)new NumberAxis(), (ValueAxis)new NumberAxis(), (XYItemRenderer)new XYLineAndShapeRenderer(true, false));
    }

    @Override
    public void startService() throws Exception {
        int i;
        if (this.name == null || this.name.length() == 0) {
            this.name = this.getServiceName();
        }
        if (this.dsFactoryServiceNames == null || this.dsFactoryServiceNames.length == 0) {
            throw new IllegalArgumentException("DatasetFactory ServiceNames must be specified.");
        }
        for (i = 0; i < this.dsFactoryServiceNames.length; ++i) {
            DatasetFactory dsFactory = (DatasetFactory)ServiceManagerFactory.getServiceObject(this.dsFactoryServiceNames[i]);
            if (dsFactory == null) {
                throw new IllegalArgumentException("DatasetFactory[" + this.dsFactoryServiceNames[i].getServiceName() + "] is null.");
            }
            this.dsFactoryMap.put(dsFactory.getName(), dsFactory);
        }
        if (this.domainAxisServiceNames != null && this.domainAxisServiceNames.length > 0) {
            for (i = 0; i < this.domainAxisServiceNames.length; ++i) {
                this.domainAxisIndexMap.put(this.domainAxisServiceNames[i].getServiceName(), new Integer(i));
            }
        }
        if (this.rangeAxisServiceNames != null && this.rangeAxisServiceNames.length > 0) {
            for (i = 0; i < this.rangeAxisServiceNames.length; ++i) {
                this.rangeAxisIndexMap.put(this.rangeAxisServiceNames[i].getServiceName(), new Integer(i));
            }
        }
        if (this.tickUnitAdjusterServiceNames != null && this.tickUnitAdjusterServiceNames.length != 0) {
            this.adjusters = new TickUnitAdjuster[this.tickUnitAdjusterServiceNames.length];
            for (i = 0; i < this.adjusters.length; ++i) {
                this.adjusters[i] = (TickUnitAdjuster)ServiceManagerFactory.getServiceObject(this.tickUnitAdjusterServiceNames[i]);
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        this.dsFactoryMap.clear();
        this.domainAxisIndexMap.clear();
        this.rangeAxisIndexMap.clear();
    }

    @Override
    public void destroyService() throws Exception {
        this.dsFactoryMap = null;
        this.domainAxisIndexMap = null;
        this.rangeAxisIndexMap = null;
        this.tmpPlot = null;
    }

    protected XYPlot newXYPlot() {
        return new XYPlot(null, (ValueAxis)(this.domainAxisServiceNames == null || this.domainAxisServiceNames.length == 0 ? new NumberAxis() : null), (ValueAxis)(this.rangeAxisServiceNames == null || this.rangeAxisServiceNames.length == 0 ? new NumberAxis() : null), (XYItemRenderer)(this.dsRendererNames == null || this.dsRendererNames.size() == 0 ? new XYLineAndShapeRenderer(true, false) : null));
    }

    protected XYPlot copyXYPlot() {
        int i;
        XYPlot xyPlot = this.newXYPlot();
        xyPlot.setAxisOffset(this.tmpPlot.getAxisOffset());
        xyPlot.setBackgroundAlpha(this.tmpPlot.getBackgroundAlpha());
        xyPlot.setBackgroundImage(this.tmpPlot.getBackgroundImage());
        xyPlot.setBackgroundImageAlignment(this.tmpPlot.getBackgroundImageAlignment());
        xyPlot.setBackgroundPaint(this.tmpPlot.getBackgroundPaint());
        xyPlot.setDatasetRenderingOrder(this.tmpPlot.getDatasetRenderingOrder());
        if (this.tmpPlot.getDomainAxisCount() > 0) {
            for (i = 0; i < this.tmpPlot.getDomainAxisCount(); ++i) {
                try {
                    if (this.tmpPlot.getDomainAxis(i) == null) continue;
                    xyPlot.setDomainAxis(i, (ValueAxis)this.tmpPlot.getDomainAxis(i).clone());
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
            }
        }
        xyPlot.setDomainAxisLocation(this.tmpPlot.getDomainAxisLocation());
        xyPlot.setDomainCrosshairLockedOnData(this.tmpPlot.isDomainCrosshairLockedOnData());
        xyPlot.setDomainCrosshairPaint(this.tmpPlot.getDomainCrosshairPaint());
        xyPlot.setDomainCrosshairStroke(this.tmpPlot.getDomainCrosshairStroke());
        xyPlot.setDomainCrosshairValue(this.tmpPlot.getDomainCrosshairValue());
        xyPlot.setDomainCrosshairVisible(this.tmpPlot.isDomainCrosshairVisible());
        xyPlot.setDomainGridlinePaint(this.tmpPlot.getDomainGridlinePaint());
        xyPlot.setDomainGridlineStroke(this.tmpPlot.getDomainCrosshairStroke());
        xyPlot.setDomainGridlinesVisible(this.tmpPlot.isDomainGridlinesVisible());
        xyPlot.setDomainTickBandPaint(this.tmpPlot.getDomainTickBandPaint());
        xyPlot.setDrawingSupplier(this.tmpPlot.getDrawingSupplier());
        xyPlot.setFixedDomainAxisSpace(this.tmpPlot.getFixedDomainAxisSpace());
        xyPlot.setFixedLegendItems(this.tmpPlot.getFixedLegendItems());
        xyPlot.setFixedRangeAxisSpace(this.tmpPlot.getFixedRangeAxisSpace());
        xyPlot.setForegroundAlpha(this.tmpPlot.getForegroundAlpha());
        xyPlot.setInsets(this.tmpPlot.getInsets());
        xyPlot.setNoDataMessage(this.tmpPlot.getNoDataMessage());
        xyPlot.setNoDataMessageFont(this.tmpPlot.getNoDataMessageFont());
        xyPlot.setNoDataMessagePaint(this.tmpPlot.getNoDataMessagePaint());
        xyPlot.setOrientation(this.tmpPlot.getOrientation());
        xyPlot.setOutlinePaint(this.tmpPlot.getOutlinePaint());
        xyPlot.setOutlineStroke(this.tmpPlot.getOutlineStroke());
        xyPlot.setQuadrantOrigin(this.tmpPlot.getQuadrantOrigin());
        for (i = 0; i < 4; ++i) {
            xyPlot.setQuadrantPaint(i, this.tmpPlot.getQuadrantPaint(i));
        }
        if (this.tmpPlot.getRangeAxisCount() > 0) {
            for (i = 0; i < this.tmpPlot.getRangeAxisCount(); ++i) {
                try {
                    if (this.tmpPlot.getRangeAxis(i) == null) continue;
                    xyPlot.setRangeAxis(i, (ValueAxis)this.tmpPlot.getRangeAxis(i).clone());
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
            }
        }
        xyPlot.setRangeAxisLocation(this.tmpPlot.getRangeAxisLocation());
        xyPlot.setRangeCrosshairLockedOnData(this.tmpPlot.isRangeCrosshairLockedOnData());
        xyPlot.setRangeCrosshairPaint(this.tmpPlot.getRangeCrosshairPaint());
        xyPlot.setRangeCrosshairStroke(this.tmpPlot.getRangeCrosshairStroke());
        xyPlot.setRangeCrosshairValue(this.tmpPlot.getRangeCrosshairValue());
        xyPlot.setRangeCrosshairVisible(this.tmpPlot.isRangeCrosshairVisible());
        xyPlot.setRangeGridlinePaint(this.tmpPlot.getRangeGridlinePaint());
        xyPlot.setRangeGridlineStroke(this.tmpPlot.getRangeGridlineStroke());
        xyPlot.setRangeGridlinesVisible(this.tmpPlot.isRangeGridlinesVisible());
        xyPlot.setRangeTickBandPaint(this.tmpPlot.getRangeTickBandPaint());
        xyPlot.setRangeZeroBaselinePaint(this.tmpPlot.getRangeZeroBaselinePaint());
        xyPlot.setRangeZeroBaselineStroke(this.tmpPlot.getRangeZeroBaselineStroke());
        xyPlot.setRangeZeroBaselineVisible(this.tmpPlot.isRangeZeroBaselineVisible());
        xyPlot.setSeriesRenderingOrder(this.tmpPlot.getSeriesRenderingOrder());
        xyPlot.setWeight(this.tmpPlot.getWeight());
        return xyPlot;
    }

    protected XYPlotConditionImpl mergeXYPlotCondition(PlotCondition[] plotConditions) {
        if (plotConditions == null || plotConditions.length == 0) {
            return null;
        }
        XYPlotConditionImpl xyPlotCondition = null;
        if (plotConditions.length == 1) {
            xyPlotCondition = (XYPlotConditionImpl)plotConditions[0];
        } else {
            for (int i = 0; i < plotConditions.length; ++i) {
                int fontSize;
                int fontStyle;
                String fontName;
                Map map;
                LinkedHashSet orders;
                XYPlotConditionImpl plotCondition;
                Set enableDatasetNameSet;
                if (!this.name.equals(plotConditions[i].getName()) || !(plotConditions[i] instanceof XYPlotConditionImpl)) continue;
                if (xyPlotCondition == null) {
                    xyPlotCondition = new XYPlotConditionImpl();
                    xyPlotCondition.setName(this.name);
                }
                if ((enableDatasetNameSet = (plotCondition = (XYPlotConditionImpl)plotConditions[i]).getEnableDatasetNameSet()) != null) {
                    xyPlotCondition.setEnableDatasetNameSet(enableDatasetNameSet);
                }
                if ((orders = plotCondition.getDatasetNameOrderSet()) != null) {
                    xyPlotCondition.setDatasetNameOrderSet(orders);
                }
                if ((map = plotCondition.getDatasetConditionMap()) != null) {
                    xyPlotCondition.addDatasetConditionMap(map);
                }
                if ((map = plotCondition.getRangeAxisVisibleMap()) != null) {
                    xyPlotCondition.addRangeAxisVisibleMap(map);
                }
                if ((map = plotCondition.getDomainAxisLabelFontNameMap()) != null) {
                    xyPlotCondition.addDomainAxisLabelFontNameMap(map);
                }
                if ((map = plotCondition.getDomainAxisLabelFontStyleMap()) != null) {
                    xyPlotCondition.addDomainAxisLabelFontStyleMap(map);
                }
                if ((map = plotCondition.getDomainAxisLabelFontSizeMap()) != null) {
                    xyPlotCondition.addDomainAxisLabelFontSizeMap(map);
                }
                if ((map = plotCondition.getRangeAxisTickLabelFontNameMap()) != null) {
                    xyPlotCondition.addRangeAxisTickLabelFontNameMap(map);
                }
                if ((map = plotCondition.getRangeAxisTickLabelFontStyleMap()) != null) {
                    xyPlotCondition.addRangeAxisTickLabelFontStyleMap(map);
                }
                if ((map = plotCondition.getRangeAxisTickLabelFontSizeMap()) != null) {
                    xyPlotCondition.addRangeAxisTickLabelFontSizeMap(map);
                }
                if ((map = plotCondition.getDomainAxisLabelFontNameMap()) != null) {
                    xyPlotCondition.addDomainAxisLabelFontNameMap(map);
                }
                if ((map = plotCondition.getDomainAxisLabelFontStyleMap()) != null) {
                    xyPlotCondition.addDomainAxisLabelFontStyleMap(map);
                }
                if ((map = plotCondition.getDomainAxisLabelFontSizeMap()) != null) {
                    xyPlotCondition.addDomainAxisLabelFontSizeMap(map);
                }
                if ((map = plotCondition.getRangeAxisLabelFontNameMap()) != null) {
                    xyPlotCondition.addRangeAxisLabelFontNameMap(map);
                }
                if ((map = plotCondition.getRangeAxisLabelFontStyleMap()) != null) {
                    xyPlotCondition.addRangeAxisLabelFontStyleMap(map);
                }
                if ((map = plotCondition.getRangeAxisLabelFontSizeMap()) != null) {
                    xyPlotCondition.addRangeAxisLabelFontSizeMap(map);
                }
                if ((fontName = plotCondition.getDefaultDomainAxisTickLabelFontName()) != null) {
                    xyPlotCondition.setDefaultDomainAxisTickLabelFontName(fontName);
                }
                if ((fontStyle = plotCondition.getDefaultDomainAxisTickLabelFontStyle()) != Integer.MIN_VALUE) {
                    xyPlotCondition.setDefaultDomainAxisTickLabelFontStyle(fontStyle);
                }
                if ((fontSize = plotCondition.getDefaultDomainAxisTickLabelFontSize()) != Integer.MIN_VALUE) {
                    xyPlotCondition.setDefaultDomainAxisTickLabelFontSize(fontSize);
                }
                if ((fontName = plotCondition.getDefaultRangeAxisTickLabelFontName()) != null) {
                    xyPlotCondition.setDefaultRangeAxisTickLabelFontName(fontName);
                }
                if ((fontStyle = plotCondition.getDefaultRangeAxisTickLabelFontStyle()) != Integer.MIN_VALUE) {
                    xyPlotCondition.setDefaultRangeAxisTickLabelFontStyle(fontStyle);
                }
                if ((fontSize = plotCondition.getDefaultRangeAxisTickLabelFontSize()) != Integer.MIN_VALUE) {
                    xyPlotCondition.setDefaultRangeAxisTickLabelFontSize(fontSize);
                }
                if ((fontName = plotCondition.getDefaultDomainAxisLabelFontName()) != null) {
                    xyPlotCondition.setDefaultDomainAxisLabelFontName(fontName);
                }
                if ((fontStyle = plotCondition.getDefaultDomainAxisLabelFontStyle()) != Integer.MIN_VALUE) {
                    xyPlotCondition.setDefaultDomainAxisLabelFontStyle(fontStyle);
                }
                if ((fontSize = plotCondition.getDefaultDomainAxisLabelFontSize()) != Integer.MIN_VALUE) {
                    xyPlotCondition.setDefaultDomainAxisLabelFontSize(fontSize);
                }
                if ((fontName = plotCondition.getDefaultRangeAxisLabelFontName()) != null) {
                    xyPlotCondition.setDefaultRangeAxisLabelFontName(fontName);
                }
                if ((fontStyle = plotCondition.getDefaultRangeAxisLabelFontStyle()) != Integer.MIN_VALUE) {
                    xyPlotCondition.setDefaultRangeAxisLabelFontStyle(fontStyle);
                }
                if ((fontSize = plotCondition.getDefaultRangeAxisLabelFontSize()) == Integer.MIN_VALUE) continue;
                xyPlotCondition.setDefaultRangeAxisLabelFontSize(fontSize);
            }
        }
        return xyPlotCondition;
    }

    @Override
    public Plot createPlot(PlotCondition[] plotConditions) throws PlotCreateException {
        int j;
        XYPlotConditionImpl xyPlotCondition = this.mergeXYPlotCondition(plotConditions);
        if (xyPlotCondition == null) {
            return new XYPlot(null, (ValueAxis)new NumberAxis(), (ValueAxis)new NumberAxis(), (XYItemRenderer)new XYLineAndShapeRenderer(true, false));
        }
        XYPlot xyPlot = this.copyXYPlot();
        ArrayList dsFactoryList = new ArrayList();
        String[] enableDsNames = xyPlotCondition.getEnableDatasetNames();
        String[] dsNamesOrder = xyPlotCondition.getDatasetNameOrder();
        if (dsNamesOrder != null && dsNamesOrder.length > 0) {
            for (j = 0; j < dsNamesOrder.length; ++j) {
                String dsName = dsNamesOrder[j];
                boolean isEnabled = false;
                if (enableDsNames == null || enableDsNames.length <= 0) continue;
                for (int k = 0; k < enableDsNames.length; ++k) {
                    if (!dsName.equals(enableDsNames[k])) continue;
                    isEnabled = true;
                    break;
                }
                if (!isEnabled || !this.dsFactoryMap.containsKey(dsName)) continue;
                dsFactoryList.add(this.dsFactoryMap.get(dsName));
            }
        } else {
            dsFactoryList.addAll(this.dsFactoryMap.values());
        }
        for (j = 0; j < dsFactoryList.size(); ++j) {
            String rangeAxisName;
            String domainAxisName;
            DatasetFactory dsFactory = (DatasetFactory)dsFactoryList.get(j);
            String dsName = dsFactory.getName();
            DatasetCondition[] dsConditions = xyPlotCondition.getDatasetConditions();
            Dataset ds = null;
            try {
                ds = dsFactory.createDataset(dsConditions);
            }
            catch (DatasetCreateException e) {
                throw new PlotCreateException(e);
            }
            ServiceNameEditor editor = new ServiceNameEditor();
            editor.setServiceManagerName(this.getServiceManagerName());
            if (ds == null || !(ds instanceof XYDataset)) continue;
            xyPlot.setDataset(j, (XYDataset)ds);
            if (this.dsDomainAxisNames != null && this.dsDomainAxisNames.size() > 0 && (domainAxisName = this.dsDomainAxisNames.getProperty(dsName)) != null && this.domainAxisIndexMap.containsKey(domainAxisName)) {
                Integer domainAxisIndex = (Integer)this.domainAxisIndexMap.get(domainAxisName);
                xyPlot.mapDatasetToDomainAxis(j, domainAxisIndex.intValue());
            }
            if (this.dsRangeAxisNames != null && this.dsRangeAxisNames.size() > 0 && (rangeAxisName = this.dsRangeAxisNames.getProperty(dsName)) != null && this.rangeAxisIndexMap.containsKey(rangeAxisName)) {
                Integer rangeAxisIndex = (Integer)this.rangeAxisIndexMap.get(rangeAxisName);
                xyPlot.mapDatasetToRangeAxis(j, rangeAxisIndex.intValue());
            }
            XYItemRenderer renderer = null;
            if (this.dsRendererNames != null && this.dsRendererNames.size() > 0) {
                String rendererNameStr = this.dsRendererNames.getProperty(dsName);
                editor.setAsText(rendererNameStr);
                ServiceName rendererName = (ServiceName)editor.getValue();
                renderer = (XYItemRenderer)ServiceManagerFactory.getServiceObject(rendererName);
            }
            if (renderer != null) {
                xyPlot.setRenderer(j, renderer);
                continue;
            }
            xyPlot.setRenderer(j, (XYItemRenderer)new XYLineAndShapeRenderer(true, false));
        }
        if (this.domainAxisServiceNames != null && this.domainAxisServiceNames.length > 0) {
            for (j = 0; j < this.domainAxisServiceNames.length; ++j) {
                ValueAxis domainAxis = (ValueAxis)ServiceManagerFactory.getServiceObject(this.domainAxisServiceNames[j]);
                if (xyPlotCondition.getDefaultDomainAxisLabelFontName() != null || xyPlotCondition.getDefaultDomainAxisLabelFontStyle() != Integer.MIN_VALUE || xyPlotCondition.getDefaultDomainAxisLabelFontSize() != Integer.MIN_VALUE) {
                    domainAxis.setLabelFont(this.mergeFont(domainAxis.getLabelFont(), xyPlotCondition.getDefaultDomainAxisLabelFontName(), xyPlotCondition.getDefaultDomainAxisLabelFontStyle(), xyPlotCondition.getDefaultDomainAxisLabelFontSize()));
                } else if (xyPlotCondition.getDomainAxisLabelFontName(j) != null || xyPlotCondition.getDomainAxisLabelFontStyle(j) != Integer.MIN_VALUE || xyPlotCondition.getDomainAxisLabelFontSize(j) != Integer.MIN_VALUE) {
                    domainAxis.setLabelFont(this.mergeFont(domainAxis.getLabelFont(), xyPlotCondition.getDomainAxisLabelFontName(j), xyPlotCondition.getDomainAxisLabelFontStyle(j), xyPlotCondition.getDomainAxisLabelFontSize(j)));
                }
                if (xyPlotCondition.getDefaultDomainAxisTickLabelFontName() != null || xyPlotCondition.getDefaultDomainAxisTickLabelFontStyle() != Integer.MIN_VALUE || xyPlotCondition.getDefaultDomainAxisTickLabelFontSize() != Integer.MIN_VALUE) {
                    domainAxis.setTickLabelFont(this.mergeFont(domainAxis.getTickLabelFont(), xyPlotCondition.getDefaultDomainAxisTickLabelFontName(), xyPlotCondition.getDefaultDomainAxisTickLabelFontStyle(), xyPlotCondition.getDefaultDomainAxisTickLabelFontSize()));
                } else if (xyPlotCondition.getDomainAxisTickLabelFontName(j) != null || xyPlotCondition.getDomainAxisTickLabelFontStyle(j) != Integer.MIN_VALUE || xyPlotCondition.getDomainAxisTickLabelFontSize(j) != Integer.MIN_VALUE) {
                    domainAxis.setTickLabelFont(this.mergeFont(domainAxis.getTickLabelFont(), xyPlotCondition.getDomainAxisTickLabelFontName(j), xyPlotCondition.getDomainAxisTickLabelFontStyle(j), xyPlotCondition.getDomainAxisTickLabelFontSize(j)));
                }
                xyPlot.setDomainAxis(j, domainAxis);
            }
        }
        if (this.rangeAxisServiceNames != null && this.rangeAxisServiceNames.length > 0) {
            for (j = 0; j < this.rangeAxisServiceNames.length; ++j) {
                ValueAxis rangeAxis = (ValueAxis)ServiceManagerFactory.getServiceObject(this.rangeAxisServiceNames[j]);
                if (xyPlotCondition.getDefaultRangeAxisLabelFontName() != null || xyPlotCondition.getDefaultRangeAxisLabelFontStyle() != Integer.MIN_VALUE || xyPlotCondition.getDefaultRangeAxisLabelFontSize() != Integer.MIN_VALUE) {
                    rangeAxis.setLabelFont(this.mergeFont(rangeAxis.getLabelFont(), xyPlotCondition.getDefaultRangeAxisLabelFontName(), xyPlotCondition.getDefaultRangeAxisLabelFontStyle(), xyPlotCondition.getDefaultRangeAxisLabelFontSize()));
                } else if (xyPlotCondition.getRangeAxisLabelFontName(j) != null || xyPlotCondition.getRangeAxisLabelFontStyle(j) != Integer.MIN_VALUE || xyPlotCondition.getRangeAxisLabelFontSize(j) != Integer.MIN_VALUE) {
                    rangeAxis.setLabelFont(this.mergeFont(rangeAxis.getLabelFont(), xyPlotCondition.getRangeAxisLabelFontName(j), xyPlotCondition.getRangeAxisLabelFontStyle(j), xyPlotCondition.getRangeAxisLabelFontSize(j)));
                }
                if (xyPlotCondition.getDefaultRangeAxisTickLabelFontName() != null || xyPlotCondition.getDefaultRangeAxisTickLabelFontStyle() != Integer.MIN_VALUE || xyPlotCondition.getDefaultRangeAxisTickLabelFontSize() != Integer.MIN_VALUE) {
                    rangeAxis.setTickLabelFont(this.mergeFont(rangeAxis.getTickLabelFont(), xyPlotCondition.getDefaultRangeAxisTickLabelFontName(), xyPlotCondition.getDefaultRangeAxisTickLabelFontStyle(), xyPlotCondition.getDefaultRangeAxisTickLabelFontSize()));
                } else if (xyPlotCondition.getRangeAxisTickLabelFontName(j) != null || xyPlotCondition.getRangeAxisTickLabelFontStyle(j) != Integer.MIN_VALUE || xyPlotCondition.getRangeAxisTickLabelFontSize(j) != Integer.MIN_VALUE) {
                    rangeAxis.setTickLabelFont(this.mergeFont(rangeAxis.getTickLabelFont(), xyPlotCondition.getRangeAxisTickLabelFontName(j), xyPlotCondition.getRangeAxisTickLabelFontStyle(j), xyPlotCondition.getRangeAxisTickLabelFontSize(j)));
                }
                if (xyPlotCondition.isRangeAxisVisible(j) != null) {
                    rangeAxis.setVisible(xyPlotCondition.isRangeAxisVisible(j).booleanValue());
                }
                xyPlot.setRangeAxis(j, rangeAxis);
            }
        }
        if (this.adjusters != null) {
            for (int i = 0; i < this.adjusters.length; ++i) {
                this.adjusters[i].adjust(xyPlot);
            }
        }
        return xyPlot;
    }

    protected Font mergeFont(Font orgFont, String fontName, int fontStyle, int fontSize) {
        if (orgFont == null) {
            return new Font(fontName, fontStyle, fontSize);
        }
        String newName = orgFont.getName();
        int newStyle = orgFont.getStyle();
        int newSize = orgFont.getSize();
        if (fontName != null) {
            newName = fontName;
        }
        if (fontStyle != Integer.MIN_VALUE) {
            newStyle = fontStyle;
        }
        if (fontSize != Integer.MIN_VALUE) {
            newSize = fontSize;
        }
        return new Font(newName, newStyle, newSize);
    }

    @Override
    public Plot getPlot() {
        return this.tmpPlot;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

