/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jmx;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.jmx.MBeanWatcherServiceMBean;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.writer.Category;
import jp.ossc.nimbus.service.writer.MessageWriteException;
import jp.ossc.nimbus.util.converter.Converter;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

public class MBeanWatcherService
extends ServiceBase
implements DaemonRunnable,
MBeanWatcherServiceMBean {
    private static final long serialVersionUID = -1421073056315791503L;
    protected ServiceName jndiFinderServiceName;
    protected JndiFinder jndiFinder;
    protected String rmiAdaptorName = "jmx/invoker/RMIAdaptor";
    private String serviceURL;
    private Map jmxConnectorEnvironment;
    private long interval;
    private ServiceName categoryServiceName;
    private List targetList;
    private boolean isConnectOnStart;
    private String getValueErrorMessageId = "MBW__00001";
    private String connectErrorMessageId = "MBW__00002";
    private String writeErrorMessageId = "MBW__00003";
    private boolean isMBeanSet;
    private ObjectName objectName;
    private QueryExp queryExp;
    private JMXConnector connector;
    private Category category;
    private Daemon watcher;
    private long startTime;
    private Map contextMap = Collections.synchronizedMap(new HashMap());

    @Override
    public void setJndiFinderServiceName(ServiceName name) {
        this.jndiFinderServiceName = name;
    }

    @Override
    public ServiceName getJndiFinderServiceName() {
        return this.jndiFinderServiceName;
    }

    @Override
    public void setRMIAdaptorName(String name) {
        this.rmiAdaptorName = name;
    }

    @Override
    public String getRMIAdaptorName() {
        return this.rmiAdaptorName;
    }

    @Override
    public void setServiceURL(String url) {
        this.serviceURL = url;
    }

    @Override
    public String getServiceURL() {
        return this.serviceURL;
    }

    @Override
    public void setJMXConnectorEnvironment(Map env) {
        this.jmxConnectorEnvironment = env;
    }

    @Override
    public Map getJMXConnectorEnvironment() {
        return this.jmxConnectorEnvironment;
    }

    @Override
    public void setInterval(long interval) {
        this.interval = interval;
    }

    @Override
    public long getInterval() {
        return this.interval;
    }

    @Override
    public void setCategoryServiceName(ServiceName name) {
        this.categoryServiceName = name;
    }

    @Override
    public ServiceName getCategoryServiceName() {
        return this.categoryServiceName;
    }

    @Override
    public void setConnectOnStart(boolean isConnect) {
        this.isConnectOnStart = isConnect;
    }

    @Override
    public boolean isConnectOnStart() {
        return this.isConnectOnStart;
    }

    @Override
    public void setGetValueErrorMessageId(String id) {
        this.getValueErrorMessageId = id;
    }

    @Override
    public String getGetValueErrorMessageId() {
        return this.getValueErrorMessageId;
    }

    @Override
    public void setConnectErrorMessageId(String id) {
        this.connectErrorMessageId = id;
    }

    @Override
    public String getConnectErrorMessageId() {
        return this.connectErrorMessageId;
    }

    @Override
    public void setWriteErrorMessageId(String id) {
        this.writeErrorMessageId = id;
    }

    @Override
    public String getWriteErrorMessageId() {
        return this.writeErrorMessageId;
    }

    @Override
    public void setMBeanSet(boolean isSet) {
        this.isMBeanSet = isSet;
    }

    @Override
    public boolean isMBeanSet() {
        return this.isMBeanSet;
    }

    @Override
    public void setObjectName(String name) throws MalformedObjectNameException {
        this.objectName = new ObjectName(name);
    }

    @Override
    public String getObjectName() {
        return this.objectName == null ? null : this.objectName.toString();
    }

    @Override
    public void setQueryExp(QueryExp exp) {
        this.queryExp = exp;
    }

    @Override
    public QueryExp getQueryExp() {
        return this.queryExp;
    }

    public void addTarget(Target target) {
        if (this.targetList == null) {
            this.targetList = new ArrayList();
        }
        this.targetList.add(target);
    }

    @Override
    public List getTargetList() {
        return this.targetList;
    }

    @Override
    public void reset() {
        int imax = this.targetList.size();
        for (int i = 0; i < imax; ++i) {
            Target target = (Target)this.targetList.get(i);
            target.reset();
        }
    }

    @Override
    public void startService() throws Exception {
        if (this.jndiFinderServiceName != null) {
            this.jndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.jndiFinderServiceName);
        } else if (this.serviceURL != null) {
            if (this.isConnectOnStart) {
                this.connector = JMXConnectorFactory.newJMXConnector(new JMXServiceURL(this.serviceURL), this.jmxConnectorEnvironment);
                this.connector.connect();
            }
        } else {
            throw new IllegalArgumentException("ServiceURL or jndiFinderServiceName must be specified.");
        }
        if (this.categoryServiceName != null) {
            this.category = (Category)ServiceManagerFactory.getServiceObject(this.categoryServiceName);
        }
        int imax = this.targetList.size();
        for (int i = 0; i < imax; ++i) {
            Target target = (Target)this.targetList.get(i);
            target.setWatcherServiceName(this.getServiceNameObject());
            target.setWatcherService(this);
            target.setLogger(this.getLogger());
            target.start();
        }
        if (this.interval > 0L) {
            this.watcher = new Daemon(this);
            this.watcher.setName("Nimbus MBeanWatcher " + this.getServiceNameObject());
            this.watcher.setDaemon(true);
            this.watcher.start();
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.watcher != null) {
            this.watcher.stopNoWait();
            this.watcher = null;
        }
        if (this.connector != null) {
            this.connector.close();
            this.connector = null;
        }
        int imax = this.targetList.size();
        for (int i = 0; i < imax; ++i) {
            Target target = (Target)this.targetList.get(i);
            target.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map watch() throws Exception {
        JMXConnector tmpConnector = null;
        try {
            MBeanServerConnection connection = null;
            if (this.jndiFinder != null) {
                connection = (MBeanServerConnection)this.jndiFinder.lookup(this.rmiAdaptorName);
            } else if (this.connector == null) {
                tmpConnector = JMXConnectorFactory.newJMXConnector(new JMXServiceURL(this.serviceURL), this.jmxConnectorEnvironment);
                tmpConnector.connect();
                connection = tmpConnector.getMBeanServerConnection();
            } else {
                connection = this.connector.getMBeanServerConnection();
            }
            LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
            int imax = this.targetList.size();
            for (int i = 0; i < imax; ++i) {
                Target target = (Target)this.targetList.get(i);
                try {
                    Object value = target.getValue(connection);
                    if (target.getKey() == null) continue;
                    out.put(target.getKey(), value);
                    continue;
                }
                catch (Exception e) {
                    if (this.getValueErrorMessageId == null) continue;
                    this.getLogger().write(this.getValueErrorMessageId, target, (Throwable)e);
                }
            }
            LinkedHashMap<String, Object> linkedHashMap = out;
            return linkedHashMap;
        }
        finally {
            if (tmpConnector != null) {
                try {
                    tmpConnector.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void write() throws Exception {
        this.write(this.watch());
    }

    private void write(Object out) throws MessageWriteException {
        if (this.category != null) {
            this.category.write(out);
        }
    }

    @Override
    public boolean onStart() {
        return true;
    }

    @Override
    public boolean onStop() {
        return true;
    }

    @Override
    public boolean onSuspend() {
        return true;
    }

    @Override
    public boolean onResume() {
        return true;
    }

    @Override
    public Object provide(DaemonControl ctrl) throws Throwable {
        this.startTime = System.currentTimeMillis();
        try {
            return this.watch();
        }
        catch (Throwable e) {
            if (this.connectErrorMessageId != null && ctrl.isRunning()) {
                this.getLogger().write(this.connectErrorMessageId, (Object)this.serviceURL, e);
            }
            return null;
        }
    }

    @Override
    public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
        block4: {
            if (paramObj == null) {
                return;
            }
            try {
                this.write(paramObj);
            }
            catch (Throwable e) {
                if (this.writeErrorMessageId == null || !ctrl.isRunning()) break block4;
                this.getLogger().write(this.writeErrorMessageId, paramObj, e);
            }
        }
        long processTime = System.currentTimeMillis() - this.startTime;
        long sleepTime = this.interval - processTime;
        if (sleepTime > 0L) {
            Thread.sleep(sleepTime);
        }
    }

    @Override
    public void garbage() {
    }

    protected void setContextValue(String name, Object value) {
        this.contextMap.put(name, value);
    }

    protected Object getContextValue(String name) {
        return this.contextMap.get(name);
    }

    public static class Min
    extends SetOperation {
        private static final long serialVersionUID = -8356445551875453616L;

        @Override
        protected BigDecimal calculate(BigDecimal[] numbers) throws Exception {
            BigDecimal result = null;
            for (int i = 0; i < numbers.length; ++i) {
                result = result == null ? numbers[i] : result.min(numbers[i]);
            }
            return result;
        }
    }

    public static class Max
    extends SetOperation {
        private static final long serialVersionUID = 3152818165408079349L;

        @Override
        protected BigDecimal calculate(BigDecimal[] numbers) throws Exception {
            BigDecimal result = null;
            for (int i = 0; i < numbers.length; ++i) {
                result = result == null ? numbers[i] : result.max(numbers[i]);
            }
            return result;
        }
    }

    public static class Average
    extends Sum {
        private static final long serialVersionUID = -7262525074283633937L;
        private int roundingMode = 6;

        public void setRoundingMode(int mode) {
            this.roundingMode = mode;
        }

        public int getRoundingMode() {
            return this.roundingMode;
        }

        @Override
        protected BigDecimal calculate(BigDecimal[] numbers) throws Exception {
            return super.calculate(numbers).divide(new BigDecimal((double)numbers.length), this.roundingMode);
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",roundingMode=").append(this.roundingMode);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class Median
    extends SetOperation {
        private static final long serialVersionUID = 4138874599919750663L;
        private int roundingMode = 6;

        public void setRoundingMode(int mode) {
            this.roundingMode = mode;
        }

        public int getRoundingMode() {
            return this.roundingMode;
        }

        @Override
        protected BigDecimal calculate(BigDecimal[] numbers) throws Exception {
            Arrays.sort(numbers);
            if ((numbers.length + 1) % 2 == 0) {
                return numbers[(numbers.length + 1) / 2 - 1];
            }
            BigDecimal result = new BigDecimal(0.0);
            result = result.add(numbers[numbers.length / 2 - 1]);
            result = result.add(numbers[numbers.length / 2]);
            result.divide(new BigDecimal(2.0), this.roundingMode);
            return result;
        }
    }

    public static class Sum
    extends SetOperation {
        private static final long serialVersionUID = 2277773295544965565L;

        @Override
        protected BigDecimal calculate(BigDecimal[] numbers) throws Exception {
            BigDecimal result = new BigDecimal(0.0);
            for (int i = 0; i < numbers.length; ++i) {
                result = result.add(numbers[i]);
            }
            return result;
        }
    }

    public static abstract class SetOperation
    extends EditTarget {
        private static final long serialVersionUID = -7200261696645994257L;

        @Override
        public boolean isElementEdit() {
            return true;
        }

        @Override
        public Object getValue(MBeanServerConnection connection) throws Exception {
            Object value = this.target.getValue(connection);
            if (value == null) {
                value = new BigDecimal(0.0);
            } else {
                Object[] array = null;
                if (value instanceof Map) {
                    array = ((Map)value).values().toArray();
                } else if (value instanceof Collection) {
                    array = ((Collection)value).toArray();
                } else if (value.getClass().isArray()) {
                    Object[] sourceArray = (Object[])value;
                    array = new Object[sourceArray.length];
                    System.arraycopy(sourceArray, 0, array, 0, sourceArray.length);
                }
                if (array != null) {
                    if (array.length == 0) {
                        value = new BigDecimal(0.0);
                    } else {
                        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
                        for (int i = 0; i < array.length; ++i) {
                            if (array[i] == null || !(array[i] instanceof Number)) continue;
                            BigDecimal target = Target.toBigDecimal(array[i], true);
                            list.add(target);
                        }
                        value = list.size() == 0 ? new BigDecimal(0.0) : this.edit(list);
                    }
                }
            }
            if (value != null && this.contextKey != null) {
                this.watcher.setContextValue(this.contextKey, value);
            }
            return value;
        }

        @Override
        protected Object edit(Object value) throws Exception {
            List list = (List)value;
            return this.calculate(list.toArray(new BigDecimal[list.size()]));
        }

        protected abstract BigDecimal calculate(BigDecimal[] var1) throws Exception;

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",isElementEdit=").append(this.isElementEdit());
            buf.append('}');
            return buf.toString();
        }
    }

    public static class MinOperation
    extends BinaryOperation {
        private static final long serialVersionUID = -4042120812950659730L;

        @Override
        protected BigDecimal calculate(BigDecimal first, BigDecimal second) throws Exception {
            return first.min(second);
        }
    }

    public static class MaxOperation
    extends BinaryOperation {
        private static final long serialVersionUID = 7889957820603303173L;

        @Override
        protected BigDecimal calculate(BigDecimal first, BigDecimal second) throws Exception {
            return first.max(second);
        }
    }

    public static class DivideOperation
    extends BinaryOperation {
        private static final long serialVersionUID = -5331257610256153532L;
        private static final BigDecimal ZERO = new BigDecimal(0.0);
        private int roundingMode = 6;
        private int scale = -1;
        private boolean isReturnNullOnZeroDivide = true;

        public void setRoundingMode(int mode) {
            this.roundingMode = mode;
        }

        public int getRoundingMode() {
            return this.roundingMode;
        }

        public void setScale(int scale) {
            this.scale = scale;
        }

        public int getScale() {
            return this.scale;
        }

        public void setReturnNullOnZeroDivide(boolean isReturnNull) {
            this.isReturnNullOnZeroDivide = isReturnNull;
        }

        public boolean isReturnNullOnZeroDivide() {
            return this.isReturnNullOnZeroDivide;
        }

        @Override
        protected BigDecimal calculate(BigDecimal first, BigDecimal second) throws Exception {
            if (ZERO.equals(second) && this.isReturnNullOnZeroDivide) {
                return null;
            }
            return this.scale >= 0 ? first.divide(second, this.scale, this.roundingMode) : first.divide(second, this.roundingMode);
        }
    }

    public static class MultiplyOperation
    extends BinaryOperation {
        private static final long serialVersionUID = -5651446587284471517L;

        @Override
        protected BigDecimal calculate(BigDecimal first, BigDecimal second) throws Exception {
            return first.multiply(second);
        }
    }

    public static class SubtractOperation
    extends BinaryOperation {
        private static final long serialVersionUID = -2343694151274725683L;

        @Override
        protected BigDecimal calculate(BigDecimal first, BigDecimal second) throws Exception {
            return first.subtract(second);
        }
    }

    public static class AddOperation
    extends BinaryOperation {
        private static final long serialVersionUID = -5086486388715849637L;

        @Override
        protected BigDecimal calculate(BigDecimal first, BigDecimal second) throws Exception {
            return first.add(second);
        }
    }

    public static abstract class BinaryOperation
    extends WrapTarget {
        private static final long serialVersionUID = 7253736292096568710L;
        protected Target secondTarget;
        protected boolean isNullToZero;

        @Override
        public void setWatcherServiceName(ServiceName name) {
            super.setWatcherServiceName(name);
            this.secondTarget.setWatcherServiceName(name);
        }

        @Override
        protected void setWatcherService(MBeanWatcherService watcher) {
            super.setWatcherService(watcher);
            this.secondTarget.setWatcherService(watcher);
        }

        @Override
        public void setLogger(Logger logger) {
            super.setLogger(logger);
            this.secondTarget.setLogger(logger);
        }

        public void setSecondTarget(Target target) {
            this.secondTarget = target;
        }

        public Target getSecondTarget() {
            return this.secondTarget;
        }

        public void setNullToZero(boolean isNullToZero) {
            this.isNullToZero = isNullToZero;
        }

        public boolean isNullToZero() {
            return this.isNullToZero;
        }

        @Override
        public Object getValue(MBeanServerConnection connection) throws Exception {
            BigDecimal first = Target.toBigDecimal(this.target.getValue(connection), this.isNullToZero);
            BigDecimal second = Target.toBigDecimal(this.secondTarget.getValue(connection), this.isNullToZero);
            if (first == null || second == null) {
                return null;
            }
            BigDecimal value = this.calculate(first, second);
            if (value != null && this.contextKey != null) {
                this.watcher.setContextValue(this.contextKey, value);
            }
            return value;
        }

        protected abstract BigDecimal calculate(BigDecimal var1, BigDecimal var2) throws Exception;

        @Override
        public void reset() {
            super.reset();
            this.secondTarget.reset();
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",secondTarget=").append(this.secondTarget);
            buf.append(",isNullToZero=").append(this.isNullToZero);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class Period
    extends WrapTarget
    implements DaemonRunnable {
        private static final long serialVersionUID = 6105816116626297923L;
        private long interval = 1000L;
        private int count = 60;
        private List valueList = new ArrayList();
        private Daemon periodicGetter;
        private long startTime;

        public void setInterval(long millis) {
            this.interval = millis;
        }

        public long getInterval() {
            return this.interval;
        }

        public void setCount(int cnt) {
            this.count = cnt;
        }

        public int getCount() {
            return this.count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getValue(MBeanServerConnection connection) throws Exception {
            ArrayList value = null;
            List list = this.valueList;
            synchronized (list) {
                value = new ArrayList(this.valueList);
            }
            if (value != null && this.contextKey != null) {
                this.watcher.setContextValue(this.contextKey, value);
            }
            return value;
        }

        @Override
        public void start() {
            super.start();
            this.periodicGetter = new Daemon(this);
            this.periodicGetter.setName("Nimbus MBeanWatcher periodic value getter " + this.getWatcherServiceName() + this.target);
            this.periodicGetter.setDaemon(true);
            this.periodicGetter.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            if (this.periodicGetter != null) {
                this.periodicGetter.stopNoWait();
                this.periodicGetter = null;
            }
            List list = this.valueList;
            synchronized (list) {
                this.valueList.clear();
            }
            super.stop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() {
            super.reset();
            List list = this.valueList;
            synchronized (list) {
                this.valueList.clear();
            }
        }

        @Override
        public boolean onStart() {
            return true;
        }

        @Override
        public boolean onStop() {
            return true;
        }

        @Override
        public boolean onSuspend() {
            return true;
        }

        @Override
        public boolean onResume() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object provide(DaemonControl ctrl) throws Throwable {
            this.startTime = System.currentTimeMillis();
            JMXConnector tmpConnector = null;
            try {
                MBeanServerConnection connection = null;
                if (this.watcher.jndiFinder != null) {
                    connection = (MBeanServerConnection)this.watcher.jndiFinder.lookup(this.watcher.rmiAdaptorName);
                } else if (this.watcher.connector == null) {
                    tmpConnector = JMXConnectorFactory.newJMXConnector(new JMXServiceURL(this.watcher.serviceURL), this.watcher.jmxConnectorEnvironment);
                    tmpConnector.connect();
                    connection = tmpConnector.getMBeanServerConnection();
                } else {
                    connection = this.watcher.connector.getMBeanServerConnection();
                }
                Object object = this.target.getValue(connection);
                return object;
            }
            catch (Exception e) {
                Object var4_6 = null;
                return var4_6;
            }
            finally {
                if (tmpConnector != null) {
                    try {
                        tmpConnector.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
            List list = this.valueList;
            synchronized (list) {
                this.valueList.add(paramObj);
                if (this.valueList.size() > this.count) {
                    int imax = this.count - this.valueList.size();
                    for (int i = 0; i < imax; ++i) {
                        this.valueList.remove(0);
                    }
                }
            }
            long processTime = System.currentTimeMillis() - this.startTime;
            long sleepTime = this.interval - processTime;
            if (sleepTime > 0L) {
                Thread.sleep(sleepTime);
            }
        }

        @Override
        public void garbage() {
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",interval=").append(this.interval);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class Change
    extends WrapTarget {
        private static final long serialVersionUID = 315703698395044669L;
        private boolean isNullToZero;
        private BigDecimal lastValue;

        public void setNullToZero(boolean isNullToZero) {
            this.isNullToZero = isNullToZero;
        }

        public boolean isNullToZero() {
            return this.isNullToZero;
        }

        @Override
        public Object getValue(MBeanServerConnection connection) throws Exception {
            BigDecimal value = Target.toBigDecimal(this.target.getValue(connection), this.isNullToZero);
            if (this.lastValue == null) {
                this.lastValue = value;
                value = this.isNullToZero ? new BigDecimal(0.0) : null;
            } else {
                BigDecimal result = value.subtract(this.lastValue);
                this.lastValue = value;
                value = result;
            }
            if (value != null && this.contextKey != null) {
                this.watcher.setContextValue(this.contextKey, value);
            }
            return value;
        }

        @Override
        public void reset() {
            super.reset();
            this.lastValue = null;
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",isNullToZero=").append(this.isNullToZero);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class Convert
    extends EditTarget {
        private static final long serialVersionUID = 1737702373890781789L;
        private ServiceName converterServiceName;
        private Converter converter;

        public void setConverter(Converter converter) {
            this.converter = converter;
        }

        public Converter getConverter() {
            return this.converter;
        }

        public void setConverterServiceName(ServiceName name) {
            this.converterServiceName = name;
        }

        public ServiceName getConverterServiceName() {
            return this.converterServiceName;
        }

        @Override
        protected Object edit(Object value) throws Exception {
            Converter conv = this.converter;
            if (this.converterServiceName != null) {
                conv = (Converter)ServiceManagerFactory.getServiceObject(this.converterServiceName);
            }
            return conv.convert(value);
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",converter=").append(this.converter);
            buf.append(",converterServiceName=").append(this.converterServiceName);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class Property
    extends EditTarget {
        private static final long serialVersionUID = 5990303499820230369L;
        private jp.ossc.nimbus.beans.Property property;
        private boolean isIgnoreNullProperty;

        public void setProperty(jp.ossc.nimbus.beans.Property property) {
            property.setIgnoreNullProperty(this.isIgnoreNullProperty);
            this.property = property;
        }

        public jp.ossc.nimbus.beans.Property getProperty() {
            return this.property;
        }

        public void setIgnoreNullProperty(boolean isIgnore) {
            this.isIgnoreNullProperty = isIgnore;
            if (this.property != null) {
                this.property.setIgnoreNullProperty(this.isIgnoreNullProperty);
            }
        }

        public boolean isIgnoreNullProperty() {
            return this.isIgnoreNullProperty;
        }

        @Override
        protected Object edit(Object value) throws Exception {
            return this.property.getProperty(value);
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",property=").append(this.property);
            buf.append(",isIgnoreNullProperty=").append(this.isIgnoreNullProperty);
            buf.append('}');
            return buf.toString();
        }
    }

    public static abstract class EditTarget
    extends WrapTarget {
        private static final long serialVersionUID = -3292286495172239503L;
        protected boolean isElementEdit;

        public void setElementEdit(boolean isElement) {
            this.isElementEdit = isElement;
        }

        public boolean isElementEdit() {
            return this.isElementEdit;
        }

        @Override
        public Object getValue(MBeanServerConnection connection) throws Exception {
            Object[] value = this.target.getValue(connection);
            if (this.isElementEdit) {
                Object[] array = null;
                if (value instanceof Map) {
                    array = ((Map)value).values().toArray();
                } else if (value instanceof Collection) {
                    array = ((Collection)value).toArray();
                } else if (value.getClass().isArray()) {
                    Object[] sourceArray = value;
                    array = new Object[sourceArray.length];
                    System.arraycopy(sourceArray, 0, array, 0, sourceArray.length);
                } else {
                    value = this.edit(value);
                }
                if (array != null) {
                    for (int i = 0; i < array.length; ++i) {
                        array[i] = this.edit(array[i]);
                    }
                    value = array;
                }
            } else {
                value = this.edit(value);
            }
            if (value != null && this.contextKey != null) {
                this.watcher.setContextValue(this.contextKey, value);
            }
            return value;
        }

        protected abstract Object edit(Object var1) throws Exception;

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",isElementEdit=").append(this.isElementEdit);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class Check
    extends WrapTarget {
        private static final long serialVersionUID = -8821714143031466189L;
        private boolean isNullToZero;
        private ServiceName loggerServiceName;
        private List checkConditions = new ArrayList();

        public void setNullToZero(boolean isNullToZero) {
            this.isNullToZero = isNullToZero;
        }

        public boolean isNullToZero() {
            return this.isNullToZero;
        }

        public void setLoggerServiceName(ServiceName name) {
            this.loggerServiceName = name;
        }

        public ServiceName getLoggerServiceName() {
            return this.loggerServiceName;
        }

        @Override
        public Logger getLogger() {
            if (this.loggerServiceName == null) {
                return super.getLogger();
            }
            return (Logger)ServiceManagerFactory.getServiceObject(this.loggerServiceName);
        }

        public void addCheckCondition(Condition condition) {
            this.checkConditions.add(condition);
        }

        public List getCheckConditionList() {
            return this.checkConditions;
        }

        @Override
        public Object getValue(MBeanServerConnection connection) throws Exception {
            Object value = this.target.getValue(connection);
            if (this.isNullToZero) {
                value = Target.toBigDecimal(value, this.isNullToZero);
            }
            boolean checkError = false;
            int imax = this.checkConditions.size();
            for (int i = 0; i < imax; ++i) {
                Condition condition = (Condition)this.checkConditions.get(i);
                if (checkError) {
                    condition.reset();
                    continue;
                }
                if (condition.check(value, this.getLogger(), this.getWatcherServiceName(), this.getKey())) continue;
                checkError = true;
            }
            if (value != null && this.contextKey != null) {
                this.watcher.setContextValue(this.contextKey, value);
            }
            return value;
        }

        @Override
        public void reset() {
            super.reset();
            int imax = this.checkConditions.size();
            for (int i = 0; i < imax; ++i) {
                Condition condition = (Condition)this.checkConditions.get(i);
                condition.reset();
            }
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append("checkConditions=").append(this.checkConditions);
            buf.append(",isNullToZero=").append(this.isNullToZero);
            buf.append(",loggerServiceName=").append(this.loggerServiceName);
            buf.append('}');
            return buf.toString();
        }

        public static class Condition
        implements Serializable {
            private static final long serialVersionUID = 451166286622455937L;
            public static final String VALUE = "value";
            private Expression checkExpression;
            private String expression;
            private Map idMap = new TreeMap(new ErrorCountComparator());
            private int errorCount;
            private List checkTimes;
            private List checkTerms;

            public void setCheckExpression(String expression) throws Exception {
                this.checkExpression = ExpressionFactory.createExpression((String)expression);
                this.expression = expression;
            }

            public String getCheckExpression() {
                return this.expression;
            }

            public void setLogMessageId(String id) {
                this.setLogMessageIdByErrorCount(1, id);
            }

            public void setLogMessageIdByErrorCount(int errorCount, String id) {
                this.idMap.put(new Integer(errorCount), id);
            }

            public void setCheckTimes(String[] times) throws ParseException {
                if (times == null || times.length == 0) {
                    this.checkTimes = null;
                } else {
                    this.checkTimes = new ArrayList();
                    for (int i = 0; i < times.length; ++i) {
                        CheckTime ct = new CheckTime(times[i]);
                        this.checkTimes.add(ct);
                    }
                    Collections.sort(this.checkTimes);
                }
            }

            public String[] getCheckTimes() {
                if (this.checkTimes == null) {
                    return null;
                }
                String[] result = new String[this.checkTimes.size()];
                for (int i = 0; i < this.checkTimes.size(); ++i) {
                    result[i] = this.checkTimes.get(i).toString();
                }
                return result;
            }

            public void setCheckTerms(String[] terms) throws ParseException {
                if (terms == null || terms.length == 0) {
                    this.checkTerms = null;
                } else {
                    this.checkTerms = new ArrayList();
                    for (int i = 0; i < terms.length; ++i) {
                        Term term = new Term(terms[i]);
                        this.checkTerms.add(term);
                    }
                    Collections.sort(this.checkTerms);
                }
            }

            public String[] getCheckTerms() {
                if (this.checkTerms == null) {
                    return null;
                }
                String[] result = new String[this.checkTerms.size()];
                for (int i = 0; i < this.checkTerms.size(); ++i) {
                    result[i] = this.checkTerms.get(i).toString();
                }
                return result;
            }

            protected boolean check(Object value, Logger logger, ServiceName watcherServiceName, String key) throws Exception {
                int i;
                ArrayList<CheckTime> currentCheckTimes = null;
                Day nowDay = null;
                Time nowTime = null;
                if (this.checkTimes != null) {
                    Calendar now = Calendar.getInstance();
                    nowDay = new Day(now);
                    nowTime = new Time(now);
                    for (i = 0; i < this.checkTimes.size(); ++i) {
                        CheckTime ct = (CheckTime)this.checkTimes.get(i);
                        if (ct.isChecked(nowDay) || nowTime.compareTo(ct) < 0) continue;
                        if (currentCheckTimes == null) {
                            currentCheckTimes = new ArrayList<CheckTime>();
                        }
                        currentCheckTimes.add(ct);
                    }
                    if (currentCheckTimes == null) {
                        return true;
                    }
                }
                if (currentCheckTimes == null && this.checkTerms != null) {
                    if (nowTime == null) {
                        nowTime = new Time(Calendar.getInstance());
                    }
                    boolean check = false;
                    for (i = 0; i < this.checkTerms.size(); ++i) {
                        Term term = (Term)this.checkTerms.get(i);
                        if (!term.contains(nowTime)) continue;
                        check = true;
                    }
                    if (!check) {
                        return true;
                    }
                }
                JexlContext jexlContext = JexlHelper.createContext();
                jexlContext.getVars().put(VALUE, value);
                Boolean error = (Boolean)this.checkExpression.evaluate(jexlContext);
                if (error.booleanValue()) {
                    ++this.errorCount;
                    boolean isFirst = true;
                    for (Map.Entry entry : this.idMap.entrySet()) {
                        Integer count = (Integer)entry.getKey();
                        if (this.errorCount >= count) {
                            if (isFirst || this.errorCount == count) {
                                logger.write((String)entry.getValue(), new Object[]{watcherServiceName, key, this.expression, value, count});
                            }
                            if (isFirst) {
                                this.errorCount = 0;
                                if (currentCheckTimes != null) {
                                    for (int i2 = 0; i2 < currentCheckTimes.size(); ++i2) {
                                        CheckTime ct = (CheckTime)currentCheckTimes.get(i2);
                                        ct.setCheckDay(nowDay);
                                    }
                                }
                            }
                            return false;
                        }
                        isFirst = false;
                    }
                } else {
                    this.errorCount = 0;
                }
                if (currentCheckTimes != null) {
                    for (int i3 = 0; i3 < currentCheckTimes.size(); ++i3) {
                        CheckTime ct = (CheckTime)currentCheckTimes.get(i3);
                        ct.setCheckDay(nowDay);
                    }
                }
                return true;
            }

            protected void reset() {
                this.errorCount = 0;
            }

            public String toString() {
                StringBuffer buf = new StringBuffer();
                buf.append("Condition{");
                buf.append(",expression=").append(this.expression);
                buf.append(",idMap=").append(this.idMap);
                buf.append('}');
                return buf.toString();
            }

            private class CheckTime
            extends Time {
                private static final long serialVersionUID = 5309699914961118492L;
                private Day checkDay;

                public CheckTime(String time) throws ParseException {
                    super(time);
                }

                public boolean isChecked(Day currentDay) {
                    if (this.checkDay == null) {
                        return false;
                    }
                    return currentDay.compareTo(this.checkDay) <= 0;
                }

                public void setCheckDay(Day day) {
                    this.checkDay = day;
                }
            }

            private class Term
            implements Serializable,
            Comparable {
                private static final long serialVersionUID = 4874635307721480812L;
                private Time from;
                private Time to;

                public Term(String term) throws ParseException {
                    if (term.indexOf(45) == -1) {
                        throw new ParseException("Format is 'from-to' : " + term, term.length());
                    }
                    String[] times = term.split("-");
                    if (times.length != 2) {
                        throw new ParseException("Format is 'from-to' : " + term, term.length());
                    }
                    this.from = new Time(times[0]);
                    this.to = new Time(times[1]);
                }

                public boolean contains(Time time) {
                    return time.compareTo(this.from) >= 0 && time.compareTo(this.to) < 0;
                }

                public int hashCode() {
                    return this.from.hashCode() + this.to.hashCode();
                }

                public boolean equals(Object obj) {
                    if (obj == this) {
                        return true;
                    }
                    if (obj == null || !(obj instanceof Term)) {
                        return false;
                    }
                    Term cmp = (Term)obj;
                    return this.from.equals(cmp.from) && this.to.equals(cmp.to);
                }

                public int compareTo(Object obj) {
                    if (obj == null || !(obj instanceof Term)) {
                        return 1;
                    }
                    Term cmp = (Term)obj;
                    return this.from.compareTo(cmp.from);
                }

                public String toString() {
                    StringBuffer buf = new StringBuffer();
                    return buf.append(this.from).append('-').append(this.to).toString();
                }
            }

            private class Time
            implements Serializable,
            Comparable {
                private static final long serialVersionUID = 5738491787638885636L;
                private static final String TIME_FORMAT1 = "HH:mm:ss";
                private static final String TIME_FORMAT2 = "HH:mm:ss.SSS";
                private int time;

                public Time(Calendar now) {
                    this.time += now.get(11) * 10000000;
                    this.time += now.get(12) * 100000;
                    this.time += now.get(13) * 1000;
                    this.time += now.get(14);
                }

                public Time(String time) throws ParseException {
                    Date date = time.length() == 8 ? new SimpleDateFormat(TIME_FORMAT1).parse(time) : new SimpleDateFormat(TIME_FORMAT2).parse(time);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    this.time += cal.get(11) * 10000000;
                    this.time += cal.get(12) * 100000;
                    this.time += cal.get(13) * 1000;
                    this.time += cal.get(14);
                }

                public int hashCode() {
                    return this.time;
                }

                public boolean equals(Object obj) {
                    if (obj == this) {
                        return true;
                    }
                    if (obj == null || !(obj instanceof Time)) {
                        return false;
                    }
                    Time cmp = (Time)obj;
                    return this.time == cmp.time;
                }

                public int compareTo(Object obj) {
                    if (obj == null || !(obj instanceof Time)) {
                        return 1;
                    }
                    Time cmp = (Time)obj;
                    if (this.time == cmp.time) {
                        return 0;
                    }
                    return this.time > cmp.time ? 1 : -1;
                }

                public String toString() {
                    StringBuffer buf = new StringBuffer();
                    buf.append(this.time);
                    int length = buf.length();
                    buf.insert(length - 3, '.');
                    buf.insert(length - 5, ':');
                    buf.insert(length - 7, ':');
                    return buf.toString();
                }
            }

            private class Day
            implements Serializable,
            Comparable {
                private static final long serialVersionUID = -3482088973138104434L;
                private int day;

                public Day(Calendar now) {
                    this.day += now.get(1) * 1000;
                    this.day += now.get(6);
                }

                public int hashCode() {
                    return this.day;
                }

                public boolean equals(Object obj) {
                    if (obj == this) {
                        return true;
                    }
                    if (obj == null || !(obj instanceof Day)) {
                        return false;
                    }
                    Day cmp = (Day)obj;
                    return this.day == cmp.day;
                }

                public int compareTo(Object obj) {
                    if (obj == null || !(obj instanceof Day)) {
                        return 1;
                    }
                    Day cmp = (Day)obj;
                    if (this.day == cmp.day) {
                        return 0;
                    }
                    return this.day > cmp.day ? 1 : -1;
                }

                public String toString() {
                    return Integer.toString(this.day);
                }
            }
        }

        private static class ErrorCountComparator
        implements Comparator,
        Serializable {
            private static final long serialVersionUID = -8997521049688710362L;

            private ErrorCountComparator() {
            }

            public int compare(Object o1, Object o2) {
                return ((Comparable)o2).compareTo(o1);
            }
        }
    }

    public static abstract class WrapTarget
    extends Target {
        private static final long serialVersionUID = 6038448327332359108L;
        protected Target target;

        @Override
        public void setWatcherServiceName(ServiceName name) {
            super.setWatcherServiceName(name);
            this.target.setWatcherServiceName(name);
        }

        @Override
        protected void setWatcherService(MBeanWatcherService watcher) {
            super.setWatcherService(watcher);
            this.target.setWatcherService(watcher);
        }

        @Override
        public void setLogger(Logger logger) {
            super.setLogger(logger);
            this.target.setLogger(logger);
        }

        public void setTarget(Target target) {
            this.target = target;
        }

        public Target getTarget() {
            return this.target;
        }

        @Override
        public void reset() {
            super.reset();
            this.target.reset();
        }

        @Override
        public void start() {
            super.start();
            this.target.start();
        }

        @Override
        public void stop() {
            this.target.stop();
            super.stop();
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",target=").append(this.target);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class Operation
    extends MBeanTarget {
        private static final long serialVersionUID = 8874947184358756744L;
        private String name;
        private List params;
        private String[] signiture;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setSigniture(String[] sgn) {
            this.signiture = sgn;
        }

        public String[] getSigniture() {
            return this.signiture;
        }

        public void setParameters(Object[] params) {
            if (this.params == null) {
                this.params = new ArrayList();
            }
            for (int i = 0; i < params.length; ++i) {
                this.params.add(params[i]);
            }
        }

        public void addParameter(Object param) {
            if (this.params == null) {
                this.params = new ArrayList();
            }
            this.params.add(param);
        }

        public List getParameterList() {
            return this.params;
        }

        @Override
        public String getKey() {
            return super.getKey() != null ? super.getKey() : this.getObjectName() + '#' + this.getName() + '(' + (this.params == null ? "" : this.params.toString()) + ')';
        }

        @Override
        public Object getValue(MBeanServerConnection connection, ObjectName objectName) throws Exception {
            return connection.invoke(objectName, this.name, this.params == null ? null : this.params.toArray(), this.signiture);
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",name=").append(this.name);
            buf.append(",params=").append(this.params);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class Attribute
    extends MBeanTarget {
        private static final long serialVersionUID = 253836219685470254L;
        private String name;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getKey() {
            return super.getKey() != null ? super.getKey() : this.getObjectName() + '#' + this.getName();
        }

        @Override
        public Object getValue(MBeanServerConnection connection, ObjectName objectName) throws Exception {
            return connection.getAttribute(objectName, this.name);
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",name=").append(this.name);
            buf.append('}');
            return buf.toString();
        }
    }

    public static abstract class MBeanTarget
    extends Target {
        private static final long serialVersionUID = -5180685937237509600L;
        protected boolean isMBeanSet;
        protected ObjectName objectName;
        protected QueryExp queryExp;

        public void setMBeanSet(boolean isSet) {
            this.isMBeanSet = isSet;
        }

        public boolean isMBeanSet() {
            return this.isMBeanSet;
        }

        public void setObjectName(String name) throws MalformedObjectNameException {
            this.objectName = new ObjectName(name);
        }

        public String getObjectName() {
            return this.objectName == null ? null : this.objectName.toString();
        }

        public void setQueryExp(QueryExp exp) {
            this.queryExp = exp;
        }

        public QueryExp getQueryExp() {
            return this.queryExp;
        }

        @Override
        public Object getValue(MBeanServerConnection connection) throws Exception {
            boolean tmpIsMBeanSet = this.isMBeanSet;
            ObjectName tmpObjectName = this.objectName;
            QueryExp tmpQueryExp = this.queryExp;
            if (tmpObjectName == null) {
                tmpIsMBeanSet = this.watcher.isMBeanSet;
                tmpObjectName = this.watcher.objectName;
                tmpQueryExp = this.watcher.queryExp;
            }
            LinkedHashMap<String, Object> value = null;
            if (!tmpIsMBeanSet) {
                value = this.getValue(connection, tmpObjectName);
            } else {
                Set<ObjectName> objectNameSet = connection.queryNames(tmpObjectName, tmpQueryExp);
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                if (objectNameSet != null && objectNameSet.size() != 0) {
                    for (ObjectName name : objectNameSet) {
                        map.put(name.toString(), this.getValue(connection, name));
                    }
                }
                value = map;
            }
            if (value != null && this.contextKey != null) {
                this.watcher.setContextValue(this.contextKey, value);
            }
            return value;
        }

        protected abstract Object getValue(MBeanServerConnection var1, ObjectName var2) throws Exception;

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",objectName=").append(this.getObjectName());
            buf.append(",isMBeanSet=").append(this.isMBeanSet);
            buf.append(",queryExp=").append(this.queryExp);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class Context
    extends Target {
        private static final long serialVersionUID = 566760345569101974L;

        @Override
        public Object getValue(MBeanServerConnection connection) throws Exception {
            return this.watcher.getContextValue(this.contextKey);
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",contextKey=").append(this.contextKey);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class Timestamp
    extends Target {
        private static final long serialVersionUID = 3632167440398869434L;
        public static final String DEFAULT_KEY = "Timestamp";
        private String format;

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        @Override
        public String getKey() {
            return super.getKey() != null ? super.getKey() : DEFAULT_KEY;
        }

        @Override
        public Object getValue(MBeanServerConnection connection) throws Exception {
            Date value;
            Date date = value = this.format == null ? new Date() : new SimpleDateFormat(this.format).format(new Date());
            if (value != null && this.contextKey != null) {
                this.watcher.setContextValue(this.contextKey, value);
            }
            return value;
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",format=").append(this.format);
            buf.append('}');
            return buf.toString();
        }
    }

    public static abstract class Target
    implements Serializable {
        private static final long serialVersionUID = 3184726605262675808L;
        protected String key;
        protected transient Logger logger;
        protected transient MBeanWatcherService watcher;
        protected ServiceName watcherServiceName;
        protected String contextKey;

        protected void setWatcherServiceName(ServiceName name) {
            this.watcherServiceName = name;
        }

        protected ServiceName getWatcherServiceName() {
            return this.watcherServiceName;
        }

        protected void setWatcherService(MBeanWatcherService watcher) {
            this.watcher = watcher;
        }

        protected MBeanWatcherService getWatcherService() {
            return this.watcher;
        }

        protected void setLogger(Logger logger) {
            this.logger = logger;
        }

        protected Logger getLogger() {
            return this.logger == null ? ServiceManagerFactory.getLogger() : this.logger;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getContextKey() {
            return this.contextKey;
        }

        public void setContextKey(String key) {
            this.contextKey = key;
        }

        public abstract Object getValue(MBeanServerConnection var1) throws Exception;

        protected static BigDecimal toBigDecimal(Object value, boolean isNullToZero) throws NumberFormatException {
            BigDecimal result = null;
            result = value == null ? (isNullToZero ? new BigDecimal(0.0) : null) : (value instanceof BigDecimal ? (BigDecimal)value : (value instanceof BigInteger ? new BigDecimal((BigInteger)value) : (value instanceof Double || value instanceof Float ? new BigDecimal(((Number)value).doubleValue()) : (value instanceof Number ? BigDecimal.valueOf(((Number)value).longValue()) : new BigDecimal(value.toString())))));
            return result;
        }

        public void reset() {
        }

        public void start() {
        }

        public void stop() {
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.append('{');
            buf.append("key=").append(this.getKey());
            buf.append('}');
            return buf.toString();
        }
    }
}

