/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import jp.ossc.nimbus.service.journal.editor.BlockJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.DynaBeanJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;

public class DynaBeanJournalEditorService
extends BlockJournalEditorServiceBase
implements DynaBeanJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = 1591982612863625170L;
    private static final String DYNA_CLASS_HEADER = "DynaClass : ";
    private static final String PROPERTIES_HEADER = "Properties : ";
    protected static final String DEFAULT_SECRET_STRING = "******";
    protected static final String PROPERTY_SEPARATOR = " = ";
    protected static final String HEADER = "[DynaBean]";
    private boolean isOutputDynaClass = true;
    private boolean isOutputProperties = true;
    protected String secretString = "******";
    protected String[] secretProperties;
    protected Set secretPropertySet;
    private String[] enabledProperties;
    protected Set enabledPropertySet;

    public DynaBeanJournalEditorService() {
        this.setHeader(HEADER);
    }

    @Override
    public void setOutputDynaClass(boolean isOutput) {
        this.isOutputDynaClass = isOutput;
    }

    @Override
    public boolean isOutputDynaClass() {
        return this.isOutputDynaClass;
    }

    @Override
    public void setOutputProperties(boolean isOutput) {
        this.isOutputProperties = isOutput;
    }

    @Override
    public boolean isOutputProperties() {
        return this.isOutputProperties;
    }

    @Override
    public void setSecretString(String str) {
        this.secretString = str;
    }

    @Override
    public String getSecretString() {
        return this.secretString;
    }

    @Override
    public void setSecretProperties(String[] names) {
        this.secretProperties = names;
    }

    @Override
    public String[] getSecretProperties() {
        return this.secretProperties;
    }

    @Override
    public void setEnabledProperties(String[] names) {
        this.enabledProperties = names;
    }

    @Override
    public String[] getEnabledProperties() {
        return this.enabledProperties;
    }

    @Override
    public void createService() {
        this.secretPropertySet = new HashSet();
        this.enabledPropertySet = new HashSet();
    }

    @Override
    public void startService() {
        int i;
        if (this.secretProperties != null) {
            for (i = 0; i < this.secretProperties.length; ++i) {
                this.secretPropertySet.add(this.secretProperties[i]);
            }
        }
        if (this.enabledProperties != null) {
            for (i = 0; i < this.enabledProperties.length; ++i) {
                this.enabledPropertySet.add(this.enabledProperties[i]);
            }
        }
    }

    @Override
    public void stopService() {
        this.secretPropertySet.clear();
        this.enabledPropertySet.clear();
    }

    @Override
    public void destroyService() {
        this.secretPropertySet = null;
        this.enabledPropertySet = null;
    }

    @Override
    protected boolean processBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        DynaBean bean = (DynaBean)value;
        boolean isMake = false;
        if (this.isOutputDynaClass()) {
            this.makeDynaClassFormat(finder, key, bean, buf);
            isMake = true;
        }
        if (this.isOutputProperties()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makePropertiesFormat(finder, key, bean, buf);
            isMake = true;
        }
        return isMake;
    }

    protected StringBuffer makeDynaClassFormat(EditorFinder finder, Object key, DynaBean bean, StringBuffer buf) {
        buf.append(DYNA_CLASS_HEADER);
        this.makeObjectFormat(finder, null, bean.getDynaClass(), buf);
        return buf;
    }

    protected StringBuffer makePropertiesFormat(EditorFinder finder, Object key, DynaBean bean, StringBuffer buf) {
        buf.append(PROPERTIES_HEADER);
        DynaClass dynaClass = bean.getDynaClass();
        DynaProperty[] props = dynaClass.getDynaProperties();
        if (props == null || props.length == 0) {
            buf.append("null");
            return buf;
        }
        buf.append(this.getLineSeparator());
        StringBuffer subBuf = new StringBuffer();
        int max = props.length;
        for (int i = 0; i < max; ++i) {
            String name = props[i].getName();
            if (!this.enabledPropertySet.isEmpty() && !this.enabledPropertySet.contains(name)) continue;
            subBuf.append(name);
            subBuf.append(PROPERTY_SEPARATOR);
            if (this.secretPropertySet.contains(name)) {
                subBuf.append(this.getSecretString());
            } else {
                this.makeObjectFormat(finder, null, bean.get(name), subBuf);
            }
            if (i == max - 1) continue;
            subBuf.append(this.getLineSeparator());
        }
        this.addIndent(subBuf);
        return buf.append(subBuf);
    }
}

