/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.editor.CSVJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.DynaPropertyCSVJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editor.ImmutableJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import org.apache.commons.beanutils.DynaProperty;

public class DynaPropertyCSVJournalEditorService
extends CSVJournalEditorServiceBase
implements DynaPropertyCSVJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = 8869756517291240592L;
    private final Map outputElements = new HashMap();
    protected String[] outputElementKeys = new String[]{"NAME", "TYPE", "IS_INDEXED", "IS_MAPPED"};

    public DynaPropertyCSVJournalEditorService() {
        this.defineElements();
    }

    protected void defineElements() {
        this.defineElementEditor("NAME", new ElementEditor(){
            private static final long serialVersionUID = 8869756517291240592L;

            @Override
            protected StringBuffer toString(EditorFinder finder, Object key, DynaProperty prop, StringBuffer buf) {
                return DynaPropertyCSVJournalEditorService.this.makeNameFormat(finder, key, prop, buf);
            }
        });
        this.defineElementEditor("TYPE", new ElementEditor(){
            private static final long serialVersionUID = -5418879449848633884L;

            @Override
            protected StringBuffer toString(EditorFinder finder, Object key, DynaProperty prop, StringBuffer buf) {
                return DynaPropertyCSVJournalEditorService.this.makeTypeFormat(finder, key, prop, buf);
            }
        });
        this.defineElementEditor("IS_INDEXED", new ElementEditor(){
            private static final long serialVersionUID = -4868135956616505530L;

            @Override
            protected StringBuffer toString(EditorFinder finder, Object key, DynaProperty prop, StringBuffer buf) {
                return DynaPropertyCSVJournalEditorService.this.makeIsIndexedFormat(finder, key, prop, buf);
            }
        });
        this.defineElementEditor("IS_MAPPED", new ElementEditor(){
            private static final long serialVersionUID = 7193858190405094020L;

            @Override
            protected StringBuffer toString(EditorFinder finder, Object key, DynaProperty prop, StringBuffer buf) {
                return DynaPropertyCSVJournalEditorService.this.makeIsMappedFormat(finder, key, prop, buf);
            }
        });
    }

    protected void defineElementEditor(String key, ElementEditor editor) {
        this.outputElements.put(key, editor);
    }

    protected JournalEditor findElementEditor(String key) {
        return (JournalEditor)this.outputElements.get(key);
    }

    @Override
    public void setOutputElementKeys(String[] keys) throws IllegalArgumentException {
        if (keys != null && keys.length != 0) {
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (this.outputElements.containsKey(key)) continue;
                throw new IllegalArgumentException(key + " is undefined.");
            }
            this.outputElementKeys = keys;
        }
    }

    @Override
    public String[] getOutputElementKeys() {
        return this.outputElementKeys;
    }

    @Override
    protected void processCSV(EditorFinder finder, Object key, Object value) {
        for (int i = 0; i < this.outputElementKeys.length; ++i) {
            JournalEditor editor = this.findElementEditor(this.outputElementKeys[i]);
            this.addElement(editor.toObject(finder, key, value));
        }
    }

    protected StringBuffer makeNameFormat(EditorFinder finder, Object key, DynaProperty prop, StringBuffer buf) {
        return buf.append(prop.getName());
    }

    protected StringBuffer makeTypeFormat(EditorFinder finder, Object key, DynaProperty prop, StringBuffer buf) {
        this.makeObjectFormat(finder, null, prop.getType(), buf);
        return buf;
    }

    protected StringBuffer makeIsIndexedFormat(EditorFinder finder, Object key, DynaProperty prop, StringBuffer buf) {
        return buf.append(prop.isIndexed());
    }

    protected StringBuffer makeIsMappedFormat(EditorFinder finder, Object key, DynaProperty prop, StringBuffer buf) {
        return buf.append(prop.isMapped());
    }

    protected abstract class ElementEditor
    extends ImmutableJournalEditorServiceBase
    implements Serializable {
        private static final long serialVersionUID = -3475821913458633134L;

        protected ElementEditor() {
        }

        @Override
        public String toString(EditorFinder finder, Object key, Object value) {
            StringBuffer buf = new StringBuffer(super.toString(finder, key, value));
            return this.toString(finder, key, (DynaProperty)value, buf).toString();
        }

        protected abstract StringBuffer toString(EditorFinder var1, Object var2, DynaProperty var3, StringBuffer var4);
    }
}

