/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import jp.ossc.nimbus.service.journal.editor.BlockJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.DynaPropertyJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import org.apache.commons.beanutils.DynaProperty;

public class DynaPropertyJournalEditorService
extends BlockJournalEditorServiceBase
implements DynaPropertyJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = 7727362798894105781L;
    private static final String NAME_HEADER = "Name : ";
    private static final String TYPE_HEADER = "Type : ";
    private static final String IS_INDEXED_HEADER = "Is Indexed : ";
    private static final String IS_MAPPED_HEADER = "Is Mapped : ";
    protected static final String HEADER = "[DynaProperty]";
    private boolean isOutputName = true;
    private boolean isOutputType = true;
    private boolean isOutputIsIndexed = true;
    private boolean isOutputIsMapped = true;

    public DynaPropertyJournalEditorService() {
        this.setHeader(HEADER);
    }

    @Override
    public void setOutputName(boolean isOutput) {
        this.isOutputName = isOutput;
    }

    @Override
    public boolean isOutputName() {
        return this.isOutputName;
    }

    @Override
    public void setOutputType(boolean isOutput) {
        this.isOutputType = isOutput;
    }

    @Override
    public boolean isOutputType() {
        return this.isOutputType;
    }

    @Override
    public void setOutputIsIndexed(boolean isOutput) {
        this.isOutputIsIndexed = isOutput;
    }

    @Override
    public boolean isOutputIsIndexed() {
        return this.isOutputIsIndexed;
    }

    @Override
    public void setOutputIsMapped(boolean isOutput) {
        this.isOutputIsMapped = isOutput;
    }

    @Override
    public boolean isOutputIsMapped() {
        return this.isOutputIsMapped;
    }

    @Override
    protected boolean processBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        DynaProperty prop = (DynaProperty)value;
        boolean isMake = false;
        if (this.isOutputName()) {
            this.makeNameFormat(finder, key, prop, buf);
            isMake = true;
        }
        if (this.isOutputType()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeTypeFormat(finder, key, prop, buf);
            isMake = true;
        }
        if (this.isOutputIsIndexed()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeIsIndexedFormat(finder, key, prop, buf);
            isMake = true;
        }
        if (this.isOutputIsMapped()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeIsMappedFormat(finder, key, prop, buf);
            isMake = true;
        }
        return isMake;
    }

    protected StringBuffer makeNameFormat(EditorFinder finder, Object key, DynaProperty prop, StringBuffer buf) {
        return buf.append(NAME_HEADER).append(prop.getName());
    }

    protected StringBuffer makeTypeFormat(EditorFinder finder, Object key, DynaProperty prop, StringBuffer buf) {
        buf.append(TYPE_HEADER);
        this.makeObjectFormat(finder, null, prop.getType(), buf);
        return buf;
    }

    protected StringBuffer makeIsIndexedFormat(EditorFinder finder, Object key, DynaProperty prop, StringBuffer buf) {
        return buf.append(IS_INDEXED_HEADER).append(prop.isIndexed());
    }

    protected StringBuffer makeIsMappedFormat(EditorFinder finder, Object key, DynaProperty prop, StringBuffer buf) {
        return buf.append(IS_MAPPED_HEADER).append(prop.isMapped());
    }
}

