/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletRequest;
import jp.ossc.nimbus.service.journal.editor.BlockJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.ServletRequestJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class ServletRequestJournalEditorService
extends BlockJournalEditorServiceBase
implements ServletRequestJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = 4667997446381679299L;
    private static final String ATTRIBUTE_HEADER = "Attribute : ";
    private static final String PARAMETER_HEADER = "Parameter : ";
    private static final String CHARACTER_ENCODING_HEADER = "Character Encoding : ";
    private static final String CONTENT_LENGTH_HEADER = "Content Length : ";
    private static final String CONTENT_TYPE_HEADER = "Content Type : ";
    private static final String SENT_SERVER_HEADER = "Request Sent Server : ";
    private static final String RECEIVED_SERVER_HEADER = "Request Received Server : ";
    private static final String HOST_HEADER = "Host : ";
    private static final String PROTPCOL_HEADER = "Protocol : ";
    private static final String SCHEME_HEADER = "Scheme : ";
    private static final String LOCALE_HEADER = "Locale : ";
    private static final String ATTRIBUTE_SEPARATOR = " = ";
    private static final String PARAMETER_SEPARATOR = " = ";
    private static final String OPEN_BRACKET = "( ";
    private static final String CLOSE_BRACKET = " )";
    private static final String PORT_SEPARATOR = ":";
    private static final String HEADER = "[ServletRequest]";
    private static final String DEFAULT_SECRET_STRING = "******";
    private boolean isOutputSentServer = true;
    private boolean isOutputReceivedServer = true;
    private boolean isOutputHost = true;
    private boolean isOutputProtocol = true;
    private boolean isOutputScheme = true;
    private boolean isOutputLocale = true;
    private boolean isOutputContentType = true;
    private boolean isOutputContentLength = true;
    private boolean isOutputCharacterEncoding = true;
    private boolean isOutputAttributes = true;
    private boolean isOutputParameters = true;
    private boolean isOutputRemoteHost = true;
    private String secretString = "******";
    protected String[] secretAttributes;
    private Set secretAttributeSet;
    protected String[] secretParameters;
    private Set secretParameterSet;
    protected String[] enabledAttributes;
    private Set enabledAttributeSet;
    protected String[] enabledParameters;
    private Set enabledParameterSet;

    public ServletRequestJournalEditorService() {
        this.setHeader(HEADER);
    }

    @Override
    public void setOutputSentServer(boolean isOutput) {
        this.isOutputSentServer = isOutput;
    }

    @Override
    public boolean isOutputSentServer() {
        return this.isOutputSentServer;
    }

    @Override
    public void setOutputReceivedServer(boolean isOutput) {
        this.isOutputReceivedServer = isOutput;
    }

    @Override
    public boolean isOutputReceivedServer() {
        return this.isOutputReceivedServer;
    }

    @Override
    public void setOutputHost(boolean isOutput) {
        this.isOutputHost = isOutput;
    }

    @Override
    public boolean isOutputHost() {
        return this.isOutputHost;
    }

    @Override
    public void setOutputProtocol(boolean isOutput) {
        this.isOutputProtocol = isOutput;
    }

    @Override
    public boolean isOutputProtocol() {
        return this.isOutputProtocol;
    }

    @Override
    public void setOutputScheme(boolean isOutput) {
        this.isOutputScheme = isOutput;
    }

    @Override
    public boolean isOutputScheme() {
        return this.isOutputScheme;
    }

    @Override
    public void setOutputLocale(boolean isOutput) {
        this.isOutputLocale = isOutput;
    }

    @Override
    public boolean isOutputLocale() {
        return this.isOutputLocale;
    }

    @Override
    public void setOutputContentType(boolean isOutput) {
        this.isOutputContentType = isOutput;
    }

    @Override
    public boolean isOutputContentType() {
        return this.isOutputContentType;
    }

    @Override
    public void setOutputContentLength(boolean isOutput) {
        this.isOutputContentLength = isOutput;
    }

    @Override
    public boolean isOutputContentLength() {
        return this.isOutputContentLength;
    }

    @Override
    public void setOutputCharacterEncoding(boolean isOutput) {
        this.isOutputCharacterEncoding = isOutput;
    }

    @Override
    public boolean isOutputCharacterEncoding() {
        return this.isOutputCharacterEncoding;
    }

    @Override
    public void setOutputAttributes(boolean isOutput) {
        this.isOutputAttributes = isOutput;
    }

    @Override
    public boolean isOutputAttributes() {
        return this.isOutputAttributes;
    }

    @Override
    public void setOutputParameters(boolean isOutput) {
        this.isOutputParameters = isOutput;
    }

    @Override
    public boolean isOutputParameters() {
        return this.isOutputParameters;
    }

    @Override
    public void setSecretString(String str) {
        this.secretString = str;
    }

    @Override
    public String getSecretString() {
        return this.secretString;
    }

    @Override
    public void setSecretAttributes(String[] names) {
        this.secretAttributes = names;
    }

    @Override
    public String[] getSecretAttributes() {
        return this.secretAttributes;
    }

    @Override
    public void setEnabledAttributes(String[] names) {
        this.enabledAttributes = names;
    }

    @Override
    public String[] getEnabledAttributes() {
        return this.enabledAttributes;
    }

    @Override
    public void setSecretParameters(String[] names) {
        this.secretParameters = names;
    }

    @Override
    public String[] getSecretParameters() {
        return this.secretParameters;
    }

    @Override
    public void setEnabledParameters(String[] names) {
        this.enabledParameters = names;
    }

    @Override
    public String[] getEnabledParameters() {
        return this.enabledParameters;
    }

    @Override
    public void createService() throws Exception {
        this.secretAttributeSet = new HashSet();
        this.secretParameterSet = new HashSet();
        this.enabledAttributeSet = new HashSet();
        this.enabledParameterSet = new HashSet();
    }

    @Override
    public void startService() throws Exception {
        int i;
        if (this.secretAttributes != null) {
            for (i = 0; i < this.secretAttributes.length; ++i) {
                this.secretAttributeSet.add(this.secretAttributes[i]);
            }
        }
        if (this.enabledAttributes != null) {
            for (i = 0; i < this.enabledAttributes.length; ++i) {
                this.enabledAttributeSet.add(this.enabledAttributes[i]);
            }
        }
        if (this.secretParameters != null) {
            for (i = 0; i < this.secretParameters.length; ++i) {
                this.secretParameterSet.add(this.secretParameters[i]);
            }
        }
        if (this.enabledParameters != null) {
            for (i = 0; i < this.enabledParameters.length; ++i) {
                this.enabledParameterSet.add(this.enabledParameters[i]);
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        this.secretAttributeSet.clear();
        this.enabledAttributeSet.clear();
        this.secretParameterSet.clear();
        this.enabledParameterSet.clear();
    }

    @Override
    public void destroyService() throws Exception {
        this.secretAttributeSet = null;
        this.enabledAttributeSet = null;
        this.secretParameterSet = null;
        this.enabledParameterSet = null;
    }

    @Override
    protected boolean processBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        ServletRequest request = (ServletRequest)value;
        boolean isMake = false;
        if (this.isOutputSentServer()) {
            this.makeSentServerFormat(finder, key, request, buf);
            isMake = true;
        }
        if (this.isOutputReceivedServer()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeReceivedServerFormat(finder, key, request, buf);
            isMake = true;
        }
        if (this.isOutputHost()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeHostFormat(finder, key, request, buf);
            isMake = true;
        }
        if (this.isOutputProtocol()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeProtocolFormat(finder, key, request, buf);
            isMake = true;
        }
        if (this.isOutputScheme()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeSchemeFormat(finder, key, request, buf);
            isMake = true;
        }
        if (this.isOutputLocale()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeLocaleFormat(finder, key, request, buf);
            isMake = true;
        }
        if (this.isOutputContentType()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeContentTypeFormat(finder, key, request, buf);
            isMake = true;
        }
        if (this.isOutputContentLength()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeContentLengthFormat(finder, key, request, buf);
            isMake = true;
        }
        if (this.isOutputCharacterEncoding()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeCharacterEncodingFormat(finder, key, request, buf);
            isMake = true;
        }
        if (this.isOutputAttributes()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeAttributesFormat(finder, key, request, buf);
            isMake = true;
        }
        if (this.isOutputParameters()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeParametersFormat(finder, key, request, buf);
            isMake = true;
        }
        return isMake;
    }

    protected StringBuffer makeAttributesFormat(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
        buf.append(ATTRIBUTE_HEADER);
        Enumeration attrNames = request.getAttributeNames();
        if (!attrNames.hasMoreElements()) {
            buf.append("null");
            return buf;
        }
        buf.append(this.getLineSeparator());
        StringBuffer subBuf = new StringBuffer();
        while (attrNames.hasMoreElements()) {
            String name = (String)attrNames.nextElement();
            if (!this.enabledAttributeSet.isEmpty() && !this.enabledAttributeSet.contains(name)) continue;
            subBuf.append(name);
            subBuf.append(" = ");
            if (this.secretAttributeSet.contains(name)) {
                subBuf.append(this.getSecretString());
            } else {
                this.makeObjectFormat(finder, null, request.getAttribute(name), subBuf);
            }
            if (!attrNames.hasMoreElements()) continue;
            subBuf.append(this.getLineSeparator());
        }
        this.addIndent(subBuf);
        return buf.append(subBuf);
    }

    protected StringBuffer makeParametersFormat(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
        buf.append(PARAMETER_HEADER);
        Enumeration paramNames = request.getParameterNames();
        if (!paramNames.hasMoreElements()) {
            buf.append("null");
            return buf;
        }
        buf.append(this.getLineSeparator());
        StringBuffer subBuf = new StringBuffer();
        while (paramNames.hasMoreElements()) {
            String name = (String)paramNames.nextElement();
            if (!this.enabledParameterSet.isEmpty() && !this.enabledParameterSet.contains(name)) continue;
            subBuf.append(name);
            subBuf.append(" = ");
            if (this.secretParameterSet.contains(name)) {
                subBuf.append(this.getSecretString());
            } else {
                this.makeObjectFormat(finder, null, request.getParameterValues(name), subBuf);
            }
            if (!paramNames.hasMoreElements()) continue;
            subBuf.append(this.getLineSeparator());
        }
        this.addIndent(subBuf);
        return buf.append(subBuf);
    }

    protected StringBuffer makeCharacterEncodingFormat(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
        return buf.append(CHARACTER_ENCODING_HEADER).append(request.getCharacterEncoding());
    }

    protected StringBuffer makeContentLengthFormat(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
        return buf.append(CONTENT_LENGTH_HEADER).append(request.getContentLength());
    }

    protected StringBuffer makeContentTypeFormat(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
        return buf.append(CONTENT_TYPE_HEADER).append(request.getContentType());
    }

    protected StringBuffer makeSentServerFormat(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
        buf.append(SENT_SERVER_HEADER);
        buf.append(request.getRemoteAddr());
        try {
            int port = request.getRemotePort();
            buf.append(PORT_SEPARATOR);
            buf.append(port);
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
        if (this.isOutputRemoteHost) {
            buf.append(OPEN_BRACKET).append(request.getRemoteHost()).append(CLOSE_BRACKET);
        }
        return buf;
    }

    protected StringBuffer makeReceivedServerFormat(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
        try {
            String localAddr = request.getLocalAddr();
            buf.append(RECEIVED_SERVER_HEADER);
            buf.append(localAddr);
            int localPort = request.getLocalPort();
            buf.append(PORT_SEPARATOR);
            buf.append(localPort);
            String localName = request.getLocalName();
            buf.append(OPEN_BRACKET).append(localName).append(CLOSE_BRACKET);
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
        return buf;
    }

    protected StringBuffer makeHostFormat(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
        buf.append(HOST_HEADER);
        buf.append(request.getServerName());
        buf.append(PORT_SEPARATOR);
        buf.append(request.getServerPort());
        return buf;
    }

    protected StringBuffer makeProtocolFormat(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
        return buf.append(PROTPCOL_HEADER).append(request.getProtocol());
    }

    protected StringBuffer makeSchemeFormat(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
        return buf.append(SCHEME_HEADER).append(request.getScheme());
    }

    protected StringBuffer makeLocaleFormat(EditorFinder finder, Object key, ServletRequest request, StringBuffer buf) {
        buf.append(LOCALE_HEADER);
        this.makeObjectFormat(finder, null, request.getLocales(), buf);
        return buf;
    }

    @Override
    public boolean isOutputRemoteHost() {
        return this.isOutputRemoteHost;
    }

    @Override
    public void setOutputRemoteHost(boolean isOutput) {
        this.isOutputRemoteHost = isOutput;
    }
}

