/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.naming;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNameRef;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.naming.ServiceNamingServiceMBean;

public class ServiceNamingService
extends ServiceBase
implements ServiceNamingServiceMBean,
Serializable {
    private static final long serialVersionUID = 3146925421831880202L;
    private String[] servicePath;
    private String[] bootServicePath;
    private ServiceNameRef[] serviceNameRefs;
    private Map nameRefMap = new HashMap();

    @Override
    public void setServicePath(String[] path) {
        this.servicePath = path;
    }

    @Override
    public String[] getServicePath() {
        return this.servicePath;
    }

    @Override
    public void setBootServicePath(String[] path) {
        this.bootServicePath = path;
    }

    @Override
    public String[] getBootServicePath() {
        return this.bootServicePath;
    }

    @Override
    public void setServiceNameReferences(ServiceNameRef[] refs) {
        if (refs == null) {
            return;
        }
        HashMap<String, ServiceName> map = new HashMap<String, ServiceName>();
        int max = refs.length;
        for (int i = 0; i < max; ++i) {
            map.put(refs[i].getReferenceServiceName(), refs[i].getServiceName());
        }
        this.nameRefMap = map;
        this.serviceNameRefs = refs;
    }

    @Override
    public ServiceNameRef[] getServiceNameReferences() {
        return this.serviceNameRefs;
    }

    @Override
    public Object find(String name) {
        int i;
        int max;
        if (name == null) {
            return null;
        }
        if (this.nameRefMap.containsKey(name)) {
            return this.findObject((ServiceName)this.nameRefMap.get(name));
        }
        Object obj = null;
        if (this.bootServicePath != null) {
            max = this.bootServicePath.length;
            for (i = 0; i < max; ++i) {
                obj = this.findObject(this.bootServicePath[i], name);
                if (obj == null) continue;
                return obj;
            }
        }
        if ((obj = this.findObject(this.getServiceManagerName(), name)) != null) {
            return obj;
        }
        if (this.servicePath != null) {
            max = this.servicePath.length;
            for (i = 0; i < max; ++i) {
                obj = this.findObject(this.servicePath[i], name);
                if (obj == null) continue;
                return obj;
            }
        }
        return null;
    }

    protected Object findObject(ServiceName name) {
        try {
            return ServiceManagerFactory.getService(name);
        }
        catch (ServiceNotFoundException e) {
            return null;
        }
    }

    protected Object findObject(String manager, String name) {
        try {
            return ServiceManagerFactory.getService(manager, name);
        }
        catch (ServiceNotFoundException e) {
            return null;
        }
    }
}

