/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.ossc.nimbus.service.publish.ClientConnection;
import jp.ossc.nimbus.service.publish.ConnectException;
import jp.ossc.nimbus.service.publish.MessageListener;
import jp.ossc.nimbus.service.publish.MessageSendException;
import jp.ossc.nimbus.util.net.GlobalUID;

public class DistributedClientConnectionImpl
implements ClientConnection,
Serializable {
    private static final long serialVersionUID = -582594445717006869L;
    private List connectionList = new ArrayList();
    private Object id;
    private transient String serviceManagerName;

    public void addClientConnection(ClientConnection connection) {
        this.connectionList.add(connection);
    }

    @Override
    public void setServiceManagerName(String name) {
        this.serviceManagerName = name;
    }

    @Override
    public void connect() throws ConnectException {
        this.connect(null);
    }

    @Override
    public void connect(Object id) throws ConnectException {
        if (id == null) {
            try {
                this.id = new GlobalUID();
            }
            catch (UnknownHostException e) {
                throw new ConnectException(e);
            }
        } else {
            this.id = id;
        }
        int imax = this.connectionList.size();
        for (int i = 0; i < imax; ++i) {
            ClientConnection connection = (ClientConnection)this.connectionList.get(i);
            connection.setServiceManagerName(this.serviceManagerName);
            connection.connect(this.id);
        }
    }

    @Override
    public void addSubject(String subject) throws MessageSendException {
        int imax = this.connectionList.size();
        for (int i = 0; i < imax; ++i) {
            ((ClientConnection)this.connectionList.get(i)).addSubject(subject);
        }
    }

    @Override
    public void addSubject(String subject, String[] keys) throws MessageSendException {
        int imax = this.connectionList.size();
        for (int i = 0; i < imax; ++i) {
            ((ClientConnection)this.connectionList.get(i)).addSubject(subject, keys);
        }
    }

    @Override
    public void removeSubject(String subject) throws MessageSendException {
        int imax = this.connectionList.size();
        for (int i = 0; i < imax; ++i) {
            ((ClientConnection)this.connectionList.get(i)).removeSubject(subject);
        }
    }

    @Override
    public void removeSubject(String subject, String[] keys) throws MessageSendException {
        int imax = this.connectionList.size();
        for (int i = 0; i < imax; ++i) {
            ((ClientConnection)this.connectionList.get(i)).removeSubject(subject, keys);
        }
    }

    @Override
    public void startReceive() throws MessageSendException {
        this.startReceive(-1L);
    }

    @Override
    public void startReceive(long from) throws MessageSendException {
        int imax = this.connectionList.size();
        for (int i = 0; i < imax; ++i) {
            ((ClientConnection)this.connectionList.get(i)).startReceive(from);
        }
    }

    @Override
    public boolean isStartReceive() {
        int imax = this.connectionList.size();
        for (int i = 0; i < imax; ++i) {
            if (((ClientConnection)this.connectionList.get(i)).isStartReceive()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void stopReceive() throws MessageSendException {
        int imax = this.connectionList.size();
        for (int i = 0; i < imax; ++i) {
            ((ClientConnection)this.connectionList.get(i)).stopReceive();
        }
    }

    @Override
    public Set getSubjects() {
        HashSet result = new HashSet();
        int imax = this.connectionList.size();
        for (int i = 0; i < imax; ++i) {
            result.addAll(((ClientConnection)this.connectionList.get(i)).getSubjects());
        }
        return result;
    }

    @Override
    public Set getKeys(String subject) {
        HashSet result = new HashSet();
        int imax = this.connectionList.size();
        for (int i = 0; i < imax; ++i) {
            result.addAll(((ClientConnection)this.connectionList.get(i)).getKeys(subject));
        }
        return result;
    }

    @Override
    public void setMessageListener(MessageListener listener) {
        int imax = this.connectionList.size();
        for (int i = 0; i < imax; ++i) {
            ((ClientConnection)this.connectionList.get(i)).setMessageListener(listener);
        }
    }

    @Override
    public boolean isConnected() {
        return this.id != null;
    }

    @Override
    public boolean isServerClosed() {
        if (this.connectionList == null || this.connectionList.size() == 0) {
            return false;
        }
        int imax = this.connectionList.size();
        for (int i = 0; i < imax; ++i) {
            if (((ClientConnection)this.connectionList.get(i)).isServerClosed()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getId() {
        if (this.connectionList == null || this.connectionList.size() == 0) {
            return this.id;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int imax = this.connectionList.size();
        for (int i = 0; i < imax; ++i) {
            ClientConnection connection = (ClientConnection)this.connectionList.get(i);
            if (connection.getId() == null) continue;
            result.add(connection.getId());
        }
        return result.size() == 0 ? this.id : result;
    }

    @Override
    public void close() {
        int imax = this.connectionList.size();
        for (int i = 0; i < imax; ++i) {
            try {
                ((ClientConnection)this.connectionList.get(i)).close();
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('{');
        buf.append("id=").append(this.id);
        buf.append(", connectionList=").append(this.connectionList);
        buf.append('}');
        return buf.toString();
    }
}

