/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.publish.ConnectionCreateException;
import jp.ossc.nimbus.service.publish.ServerConnection;
import jp.ossc.nimbus.service.publish.ServerConnectionFactory;
import jp.ossc.nimbus.service.publish.ThinOutFilter;
import jp.ossc.nimbus.service.publish.ThinOutServerConnectionFactoryServiceMBean;
import jp.ossc.nimbus.service.publish.ThinOutServerConnectionImpl;

public class ThinOutServerConnectionFactoryService
extends ServiceBase
implements ServerConnectionFactory,
ThinOutServerConnectionFactoryServiceMBean {
    private static final long serialVersionUID = 5594630813249105749L;
    private ServiceName serverConnectionFactoryServiceName;
    private ServerConnectionFactory serverConnectionFactory;
    private ServiceName[] thinOutFilterServiceNames;
    private ThinOutFilter[] thinOutFilters;
    private long thinOutTimeout = 3000L;
    private long thinOutTimeoutCheckInterval = 1000L;
    private ThinOutServerConnectionImpl serverConnection;

    @Override
    public void setServerConnectionFactoryServiceName(ServiceName name) {
        this.serverConnectionFactoryServiceName = name;
    }

    @Override
    public ServiceName getServerConnectionFactoryServiceName() {
        return this.serverConnectionFactoryServiceName;
    }

    @Override
    public void setThinOutFilterServiceNames(ServiceName[] names) {
        this.thinOutFilterServiceNames = names;
    }

    @Override
    public ServiceName[] getThinOutFilterServiceNames() {
        return this.thinOutFilterServiceNames;
    }

    public void setServerConnectionFactory(ServerConnectionFactory factory) {
        this.serverConnectionFactory = factory;
    }

    public ServerConnectionFactory getServerConnectionFactory() {
        return this.serverConnectionFactory;
    }

    public void setThinOutFilters(ThinOutFilter[] filters) {
        this.thinOutFilters = filters;
    }

    public ThinOutFilter[] getThinOutFilters() {
        return this.thinOutFilters;
    }

    @Override
    public void setThinOutTimeoutCheckInterval(long interval) {
        this.thinOutTimeoutCheckInterval = interval;
    }

    @Override
    public long getThinOutTimeoutCheckInterval() {
        return this.thinOutTimeoutCheckInterval;
    }

    @Override
    public void setThinOutTimeout(long timeout) {
        this.thinOutTimeout = timeout;
    }

    @Override
    public long getThinOutTimeout() {
        return this.thinOutTimeout;
    }

    @Override
    public void startService() throws Exception {
        if (this.serverConnectionFactory == null) {
            if (this.serverConnectionFactoryServiceName == null) {
                throw new IllegalArgumentException("ServerConnectionFactory is null.");
            }
            this.serverConnectionFactory = (ServerConnectionFactory)ServiceManagerFactory.getServiceObject(this.serverConnectionFactoryServiceName);
        }
        if (this.thinOutFilters == null || this.thinOutFilters.length == 0) {
            if (this.thinOutFilterServiceNames == null) {
                throw new IllegalArgumentException("ThinOutFilters is null.");
            }
            this.thinOutFilters = new ThinOutFilter[this.thinOutFilterServiceNames.length];
            for (int i = 0; i < this.thinOutFilterServiceNames.length; ++i) {
                this.thinOutFilters[i] = (ThinOutFilter)ServiceManagerFactory.getServiceObject(this.thinOutFilterServiceNames[i]);
            }
        }
        this.serverConnection = new ThinOutServerConnectionImpl(this.serverConnectionFactory.getServerConnection(), this.thinOutFilters, this.thinOutTimeoutCheckInterval, this.thinOutTimeout);
    }

    @Override
    public void stopService() throws Exception {
        this.serverConnection.close();
        this.serverConnection = null;
    }

    @Override
    public ServerConnection getServerConnection() throws ConnectionCreateException {
        if (this.getState() != 3) {
            throw new ConnectionCreateException("Service not started. name=" + this.getServiceNameObject());
        }
        return this.serverConnection;
    }
}

