/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageCreateException;
import jp.ossc.nimbus.service.publish.MessageException;
import jp.ossc.nimbus.service.publish.MessageSendException;
import jp.ossc.nimbus.service.publish.ServerConnection;
import jp.ossc.nimbus.service.publish.ServerConnectionListener;
import jp.ossc.nimbus.service.publish.ThinOutFilter;

public class ThinOutServerConnectionImpl
implements ServerConnection {
    private ServerConnection serverConnection;
    private ThinOutFilter[] filters;
    private Map lastThinOutMap;
    private Set lastThinOutSet;
    private long thinOutTimeout;
    private long thinOutTimeoutCheckInterval;
    private Daemon thinOutTimeoutChecker;

    public ThinOutServerConnectionImpl(ServerConnection connection, ThinOutFilter[] filters, long checkInterval, long timeout) {
        this.serverConnection = connection;
        this.filters = filters;
        this.lastThinOutMap = new HashMap();
        this.lastThinOutSet = new HashSet();
        this.thinOutTimeoutCheckInterval = checkInterval;
        this.thinOutTimeout = timeout;
        this.thinOutTimeoutChecker = new Daemon(new ThinOutTimeoutChecker());
        this.thinOutTimeoutChecker.setName("Nimbus Publish ThinOutServerConnection ThinOutTimeoutChecker " + this.serverConnection);
        this.thinOutTimeoutChecker.setDaemon(true);
        this.thinOutTimeoutChecker.start();
    }

    @Override
    public void send(Message message) throws MessageSendException {
        this.sendInternal(message, false);
    }

    @Override
    public void sendAsynch(Message message) throws MessageSendException {
        this.sendInternal(message, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void sendInternal(Message message, boolean isAsynch) throws MessageSendException {
        HashMap<String, ThinOutMessage> messageMap = (HashMap<String, ThinOutMessage>)this.lastThinOutMap.get(message.getSubject());
        if (messageMap == null) {
            messageMap = new HashMap<String, ThinOutMessage>();
            this.lastThinOutMap.put(message.getSubject(), messageMap);
        }
        boolean isThinOut = true;
        for (int i = 0; i < this.filters.length; ++i) {
            Object object;
            if (isThinOut &= this.filters[i].isThinOut(message)) continue;
            ThinOutMessage msg = (ThinOutMessage)messageMap.get(message.getKey());
            if (msg != null) {
                object = this.lastThinOutSet;
                synchronized (object) {
                    this.lastThinOutSet.remove(msg);
                }
                msg.clear();
            }
            if (msg == null) {
                if (isAsynch) {
                    this.serverConnection.sendAsynch(message);
                } else {
                    this.serverConnection.send(message);
                }
            } else {
                object = msg;
                synchronized (object) {
                    if (isAsynch) {
                        this.serverConnection.sendAsynch(message);
                    } else {
                        this.serverConnection.send(message);
                    }
                }
            }
            for (int j = 0; j < this.filters.length; ++j) {
                this.filters[j].notifySendMessage(message);
            }
            return;
        }
        ThinOutMessage msg = (ThinOutMessage)messageMap.get(message.getKey());
        if (msg == null) {
            msg = new ThinOutMessage();
            messageMap.put(message.getKey(), msg);
        }
        msg.setMessage(message, isAsynch);
        Set set = this.lastThinOutSet;
        synchronized (set) {
            this.lastThinOutSet.add(msg);
        }
    }

    @Override
    public Message createMessage(String subject, String key) throws MessageCreateException {
        return this.serverConnection.createMessage(subject, key);
    }

    @Override
    public Message castMessage(Message message) throws MessageException {
        return this.serverConnection.castMessage(message);
    }

    @Override
    public void addServerConnectionListener(ServerConnectionListener listener) {
        this.serverConnection.addServerConnectionListener(listener);
    }

    @Override
    public void removeServerConnectionListener(ServerConnectionListener listener) {
        this.serverConnection.removeServerConnectionListener(listener);
    }

    @Override
    public int getClientCount() {
        return this.serverConnection.getClientCount();
    }

    @Override
    public Set getClientIds() {
        return this.serverConnection.getClientIds();
    }

    @Override
    public Set getReceiveClientIds(Message message) {
        return this.serverConnection.getReceiveClientIds(message);
    }

    @Override
    public Set getSubjects(Object id) {
        return this.serverConnection.getSubjects(id);
    }

    @Override
    public Set getKeys(Object id, String subject) {
        return this.serverConnection.getKeys(id, subject);
    }

    public void close() {
        if (this.thinOutTimeoutChecker != null) {
            this.thinOutTimeoutChecker.stopNoWait();
            this.thinOutTimeoutChecker = null;
        }
    }

    private class ThinOutMessage {
        private Message message;
        private boolean isAsynch;
        private long thinOutTime = -1L;

        private ThinOutMessage() {
        }

        public synchronized void setMessage(Message msg, boolean isAsynch) {
            this.message = msg;
            this.isAsynch = isAsynch;
            this.thinOutTime = System.currentTimeMillis();
        }

        public synchronized void clear() {
            this.message = null;
            this.thinOutTime = -1L;
        }

        public synchronized boolean isTimeout(long currentTime) {
            return this.message != null && ThinOutServerConnectionImpl.this.thinOutTimeout <= currentTime - this.thinOutTime;
        }

        public synchronized void send() {
            if (this.message == null) {
                return;
            }
            try {
                if (this.isAsynch) {
                    ThinOutServerConnectionImpl.this.serverConnection.sendAsynch(this.message);
                } else {
                    ThinOutServerConnectionImpl.this.serverConnection.send(this.message);
                }
            }
            catch (MessageSendException messageSendException) {
                // empty catch block
            }
            this.clear();
        }
    }

    private class ThinOutTimeoutChecker
    implements DaemonRunnable {
        private long lastCheckTime = -1L;

        private ThinOutTimeoutChecker() {
        }

        @Override
        public boolean onStart() {
            return true;
        }

        @Override
        public boolean onStop() {
            return true;
        }

        @Override
        public boolean onSuspend() {
            return true;
        }

        @Override
        public boolean onResume() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object provide(DaemonControl ctrl) throws Throwable {
            long sleepTime;
            long l = sleepTime = this.lastCheckTime > 0L ? ThinOutServerConnectionImpl.this.thinOutTimeoutCheckInterval - (System.currentTimeMillis() - this.lastCheckTime) : ThinOutServerConnectionImpl.this.thinOutTimeoutCheckInterval;
            if (sleepTime > 0L) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
            Set set = ThinOutServerConnectionImpl.this.lastThinOutSet;
            synchronized (set) {
                return ThinOutServerConnectionImpl.this.lastThinOutSet.toArray();
            }
        }

        @Override
        public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
            this.lastCheckTime = System.currentTimeMillis();
            if (paramObj == null) {
                return;
            }
            Object[] thinOutMessages = (Object[])paramObj;
            for (int i = 0; i < thinOutMessages.length; ++i) {
                ThinOutMessage thinOutMessage = (ThinOutMessage)thinOutMessages[i];
                if (!thinOutMessage.isTimeout(this.lastCheckTime)) continue;
                thinOutMessage.send();
            }
        }

        @Override
        public void garbage() {
        }
    }
}

