/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.util.HashMap;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.ThinOutFilter;
import jp.ossc.nimbus.service.publish.TimeIntervalThinOutFilterServiceMBean;

public class TimeIntervalThinOutFilterService
extends ServiceBase
implements ThinOutFilter,
TimeIntervalThinOutFilterServiceMBean {
    private static final long serialVersionUID = 4026088529165612279L;
    private long thinOutInterval = 1000L;
    private Map lastSendTimeSubjectMap;

    @Override
    public void setThinOutInterval(long interval) {
        this.thinOutInterval = interval;
    }

    @Override
    public long getThinOutInterval() {
        return this.thinOutInterval;
    }

    @Override
    public void createService() throws Exception {
        this.lastSendTimeSubjectMap = new HashMap();
    }

    @Override
    public void destroyService() throws Exception {
        this.lastSendTimeSubjectMap = null;
    }

    @Override
    public boolean isThinOut(Message msg) {
        if (this.getState() != 3) {
            return false;
        }
        Map lastSendTimeMap = (Map)this.lastSendTimeSubjectMap.get(msg.getSubject());
        if (lastSendTimeMap == null) {
            return false;
        }
        SendTime sendTime = (SendTime)lastSendTimeMap.get(msg.getKey());
        if (sendTime == null) {
            return false;
        }
        return sendTime.isThinOut();
    }

    @Override
    public void notifySendMessage(Message msg) {
        SendTime sendTime;
        HashMap<String, SendTime> lastSendTimeMap = (HashMap<String, SendTime>)this.lastSendTimeSubjectMap.get(msg.getSubject());
        if (lastSendTimeMap == null) {
            lastSendTimeMap = new HashMap<String, SendTime>();
            this.lastSendTimeSubjectMap.put(msg.getSubject(), lastSendTimeMap);
        }
        if ((sendTime = (SendTime)lastSendTimeMap.get(msg.getKey())) == null) {
            sendTime = new SendTime();
            lastSendTimeMap.put(msg.getKey(), sendTime);
        }
        sendTime.send();
    }

    private class SendTime {
        private long time;

        private SendTime() {
        }

        public void send() {
            this.time = System.currentTimeMillis();
        }

        public boolean isThinOut() {
            return TimeIntervalThinOutFilterService.this.thinOutInterval > System.currentTimeMillis() - this.time;
        }
    }
}

