/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish.websocket;

import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.publish.websocket.AbstractPublishMessageDispatcherServiceMBean;
import jp.ossc.nimbus.service.publish.websocket.MessageDispatcher;
import jp.ossc.nimbus.service.publish.websocket.MessageSender;
import jp.ossc.nimbus.service.queue.DistributedQueueHandlerContainerService;
import jp.ossc.nimbus.service.queue.QueueHandler;
import jp.ossc.nimbus.service.queue.QueueHandlerContainer;
import jp.ossc.nimbus.service.websocket.ExceptionHandlerMappingService;

public abstract class AbstractPublishMessageDispatcherService
extends ServiceBase
implements MessageDispatcher,
AbstractPublishMessageDispatcherServiceMBean {
    protected ServiceName messageListenerQueueHandlerContainerServiceName;
    protected ServiceName messageListenerQueueSelectorServiceName;
    protected ServiceName messageSendQueueHandlerContainerServiceName;
    protected ServiceName messageSendQueueSelectorServiceName;
    protected ServiceName messageSendExceptionHandlerMappingServiceName;
    protected String sendErrorMessageId = "WS___00006";
    protected QueueHandlerContainer messageListenerQueueHandler;
    protected DistributedQueueHandlerContainerService messageSendQueueHandler;
    protected ExceptionHandlerMappingService messageSendExceptionHandler;
    protected long messageReceiveCount;
    protected long messageSendCount;

    @Override
    public ServiceName getMessageListenerQueueHandlerContainerServiceName() {
        return this.messageListenerQueueHandlerContainerServiceName;
    }

    @Override
    public void setMessageListenerQueueHandlerContainerServiceName(ServiceName name) {
        this.messageListenerQueueHandlerContainerServiceName = name;
    }

    @Override
    public ServiceName getMessageSendQueueHandlerContainerServiceName() {
        return this.messageSendQueueHandlerContainerServiceName;
    }

    @Override
    public void setMessageSendQueueHandlerContainerServiceName(ServiceName name) {
        this.messageSendQueueHandlerContainerServiceName = name;
    }

    @Override
    public ServiceName getMessageListenerQueueSelectorServiceName() {
        return this.messageListenerQueueSelectorServiceName;
    }

    @Override
    public void setMessageListenerQueueSelectorServiceName(ServiceName name) {
        this.messageListenerQueueSelectorServiceName = name;
    }

    @Override
    public ServiceName getMessageSendExceptionHandlerMappingServiceName() {
        return this.messageSendExceptionHandlerMappingServiceName;
    }

    @Override
    public void setMessageSendExceptionHandlerMappingServiceName(ServiceName name) {
        this.messageSendExceptionHandlerMappingServiceName = name;
    }

    @Override
    public ServiceName getMessageSendQueueSelectorServiceName() {
        return this.messageSendQueueSelectorServiceName;
    }

    @Override
    public void setMessageSendQueueSelectorServiceName(ServiceName name) {
        this.messageSendQueueSelectorServiceName = name;
    }

    @Override
    public String getSendErrorMessageId() {
        return this.sendErrorMessageId;
    }

    @Override
    public void setSendErrorMessageId(String messageId) {
        this.sendErrorMessageId = messageId;
    }

    @Override
    public long getMessageReceiveCount() {
        return this.messageReceiveCount;
    }

    @Override
    public long getMessageSendCount() {
        return this.messageSendCount;
    }

    @Override
    public void startService() throws Exception {
        super.startService();
        if (this.messageListenerQueueHandlerContainerServiceName != null) {
            this.messageListenerQueueHandler = (QueueHandlerContainer)ServiceManagerFactory.getServiceObject(this.messageListenerQueueHandlerContainerServiceName);
        } else if (this.messageListenerQueueSelectorServiceName != null) {
            this.messageListenerQueueHandler = new DistributedQueueHandlerContainerService();
            ((DistributedQueueHandlerContainerService)this.messageListenerQueueHandler).setDistributedQueueSelectorServiceName(this.messageListenerQueueSelectorServiceName);
            ((DistributedQueueHandlerContainerService)this.messageListenerQueueHandler).startService();
        }
        if (this.messageListenerQueueHandler != null) {
            this.messageListenerQueueHandler.setQueueHandler(new MessageListenerQueueHandler());
            this.messageListenerQueueHandler.accept();
        }
        if (this.messageSendQueueHandlerContainerServiceName != null) {
            this.messageSendQueueHandler = (DistributedQueueHandlerContainerService)ServiceManagerFactory.getServiceObject(this.messageSendQueueHandlerContainerServiceName);
        } else if (this.messageSendQueueSelectorServiceName != null) {
            this.messageSendQueueHandler = new DistributedQueueHandlerContainerService();
            this.messageSendQueueHandler.setDistributedQueueSelectorServiceName(this.messageSendQueueSelectorServiceName);
            this.messageSendQueueHandler.startService();
        }
        if (this.messageSendQueueHandler != null) {
            this.messageSendQueueHandler.setQueueHandler(new MessageSendQueueHandler());
            this.messageSendQueueHandler.accept();
        }
        if (this.messageSendExceptionHandlerMappingServiceName != null) {
            this.messageSendExceptionHandler = (ExceptionHandlerMappingService)ServiceManagerFactory.getServiceObject(this.messageSendExceptionHandlerMappingServiceName);
        }
    }

    @Override
    public void stopService() throws Exception {
        super.startService();
        if (this.messageListenerQueueHandler != null) {
            this.messageListenerQueueHandler.stop();
        }
        if (this.messageSendQueueHandler != null) {
            this.messageSendQueueHandler.stop();
        }
    }

    @Override
    public void addMessageSender(MessageSender sender) {
        this.addMessageSenderProcess(sender);
    }

    @Override
    public void removeMessageSender(MessageSender sender) {
        this.removeMessageSenderProcess(sender);
    }

    @Override
    public void addKey(Object key, MessageSender sender) {
        this.addKeyProcess(key, sender);
    }

    @Override
    public void removeKey(Object key, MessageSender sender) {
        this.removeKeyProcess(key, sender);
    }

    public abstract void addMessageSenderProcess(MessageSender var1);

    public abstract void removeMessageSenderProcess(MessageSender var1);

    public abstract void addKeyProcess(Object var1, MessageSender var2);

    public abstract void removeKeyProcess(Object var1, MessageSender var2);

    protected void onMessageProcess(Object message) {
        ++this.messageReceiveCount;
        if (message != null) {
            if (this.messageListenerQueueHandler == null) {
                Set senders = this.getMessageSendTarget(message);
                if (senders != null && senders.size() != 0) {
                    this.sendMessageSenders(senders, message);
                }
            } else {
                this.messageListenerQueueHandler.push(message);
            }
        }
    }

    protected abstract Set getMessageSendTarget(Object var1);

    protected void sendMessageSenders(Set senders, Object message) {
        for (MessageSender sender : senders) {
            if (this.messageSendQueueHandler == null) {
                this.sendMessage(sender, message);
                continue;
            }
            Object[] objs = new Object[]{sender, message};
            this.messageSendQueueHandler.push(objs);
        }
    }

    protected void sendMessage(MessageSender sender, Object message) {
        block4: {
            try {
                sender.sendMessage(message);
                ++this.messageSendCount;
            }
            catch (Exception e) {
                if (this.messageSendExceptionHandler == null) break block4;
                try {
                    this.messageSendExceptionHandler.handleException(sender.getSession(), e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    protected class MessageSendQueueHandler
    implements QueueHandler {
        protected MessageSendQueueHandler() {
        }

        @Override
        public void handleDequeuedObject(Object obj) throws Throwable {
            if (obj == null) {
                return;
            }
            Object[] objs = (Object[])obj;
            AbstractPublishMessageDispatcherService.this.sendMessage((MessageSender)objs[0], objs[1]);
        }

        @Override
        public boolean handleError(Object obj, Throwable th) throws Throwable {
            Object[] objs = (Object[])obj;
            return ((MessageSender)objs[0]).getSession().isOpen();
        }

        @Override
        public void handleRetryOver(Object obj, Throwable th) throws Throwable {
        }
    }

    protected class MessageListenerQueueHandler
    implements QueueHandler {
        protected MessageListenerQueueHandler() {
        }

        @Override
        public void handleDequeuedObject(Object message) throws Throwable {
            if (message == null) {
                return;
            }
            Set senders = AbstractPublishMessageDispatcherService.this.getMessageSendTarget(message);
            if (senders != null && senders.size() != 0) {
                AbstractPublishMessageDispatcherService.this.sendMessageSenders(senders, message);
            }
        }

        @Override
        public boolean handleError(Object obj, Throwable th) throws Throwable {
            return false;
        }

        @Override
        public void handleRetryOver(Object obj, Throwable th) throws Throwable {
        }
    }
}

