/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.queue;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.service.beancontrol.BeanFlowMonitor;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.queue.AsynchContext;
import jp.ossc.nimbus.service.queue.BeanFlowAsynchContext;
import jp.ossc.nimbus.service.queue.BeanFlowInvokerCallQueueHandlerServiceMBean;
import jp.ossc.nimbus.service.queue.QueueHandler;
import jp.ossc.nimbus.util.ClassMappingTree;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

public class BeanFlowInvokerCallQueueHandlerService
extends ServiceBase
implements QueueHandler,
BeanFlowInvokerCallQueueHandlerServiceMBean {
    private static final long serialVersionUID = -7498066162472850636L;
    private static final String INPUT_KEY = "input";
    private String beanFlowKeyByInput;
    private Property beanFlowKeyByInputProp;
    private String beanFlowInputByInput;
    private Property beanFlowInputByInputProp;
    private Map classMapping;
    private ClassMappingTree classMap;
    private String[] conditions;
    private List conditionList;
    private String defaultBeanFlowKey;
    private ServiceName beanFlowInvokerFactoryServiceName;
    private BeanFlowInvokerFactory beanFlowInvokerFactory;
    private boolean isThrowOnNotFoundBeanFlow;
    private String errorLogMessageId;
    private String retryOverErrorLogMessageId;
    private ServiceName threadContextServiceName;
    private Context context;

    @Override
    public void setBeanFlowKeyByInput(String prop) {
        this.beanFlowKeyByInput = prop;
    }

    @Override
    public String getBeanFlowKeyByInput() {
        return this.beanFlowKeyByInput;
    }

    @Override
    public void setBeanFlowInputByInput(String prop) {
        this.beanFlowInputByInput = prop;
    }

    @Override
    public String getBeanFlowInputByInput() {
        return this.beanFlowInputByInput;
    }

    @Override
    public void setClassMapping(Map mapping) {
        this.classMapping = mapping;
    }

    @Override
    public Map getClassMapping() {
        return this.classMapping;
    }

    @Override
    public void setConditions(String[] conditions) {
        this.conditions = conditions;
    }

    @Override
    public String[] getConditions() {
        return this.conditions;
    }

    @Override
    public void setDefaultBeanFlowKey(String beanFlowKey) {
        this.defaultBeanFlowKey = beanFlowKey;
    }

    @Override
    public String getDefaultBeanFlowKey() {
        return this.defaultBeanFlowKey;
    }

    @Override
    public void setBeanFlowInvokerFactoryServiceName(ServiceName name) {
        this.beanFlowInvokerFactoryServiceName = name;
    }

    @Override
    public ServiceName getBeanFlowInvokerFactoryServiceName() {
        return this.beanFlowInvokerFactoryServiceName;
    }

    public void setBeanFlowInvokerFactory(BeanFlowInvokerFactory factory) {
        this.beanFlowInvokerFactory = factory;
    }

    public BeanFlowInvokerFactory getBeanFlowInvokerFactory() {
        return this.beanFlowInvokerFactory;
    }

    @Override
    public boolean isThrowOnNotFoundBeanFlow() {
        return this.isThrowOnNotFoundBeanFlow;
    }

    @Override
    public void setThrowOnNotFoundBeanFlow(boolean isThrow) {
        this.isThrowOnNotFoundBeanFlow = isThrow;
    }

    @Override
    public String getErrorLogMessageId() {
        return this.errorLogMessageId;
    }

    @Override
    public void setErrorLogMessageId(String id) {
        this.errorLogMessageId = id;
    }

    @Override
    public String getRetryOverErrorLogMessageId() {
        return this.retryOverErrorLogMessageId;
    }

    @Override
    public void setRetryOverErrorLogMessageId(String id) {
        this.retryOverErrorLogMessageId = id;
    }

    @Override
    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    @Override
    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    public void setThreadContext(Context context) {
        this.context = context;
    }

    public Context getThreadContext() {
        return this.context;
    }

    @Override
    public void startService() throws Exception {
        if (this.beanFlowInvokerFactoryServiceName != null) {
            this.beanFlowInvokerFactory = (BeanFlowInvokerFactory)ServiceManagerFactory.getServiceObject(this.beanFlowInvokerFactoryServiceName);
        }
        if (this.beanFlowInvokerFactory == null) {
            throw new IllegalArgumentException("BeanFlowInvoker is null.");
        }
        if (this.threadContextServiceName != null) {
            this.context = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
        }
        if (this.beanFlowKeyByInput != null) {
            if (!this.beanFlowKeyByInput.startsWith(INPUT_KEY)) {
                throw new IllegalArgumentException("BeanFlowKeyByInput don't start with 'input' : " + this.beanFlowKeyByInput);
            }
            if (!this.beanFlowKeyByInput.equals(INPUT_KEY)) {
                this.beanFlowKeyByInputProp = null;
            } else {
                String tmpProp = this.beanFlowKeyByInput.substring(INPUT_KEY.length());
                switch (tmpProp.charAt(0)) {
                    case '.': {
                        tmpProp = tmpProp.substring(1);
                        break;
                    }
                    case '(': 
                    case '[': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("BeanFlowKeyByInput is illegal : " + this.beanFlowKeyByInput);
                    }
                }
                this.beanFlowKeyByInputProp = PropertyFactory.createProperty(tmpProp);
            }
        } else if (this.classMapping != null && this.classMapping.size() != 0) {
            this.classMap = new ClassMappingTree(null);
            for (Map.Entry entry : this.classMapping.entrySet()) {
                Class clazz = Utility.convertStringToClass((String)entry.getKey());
                String beanFlowKey = (String)entry.getValue();
                this.classMap.add(clazz, beanFlowKey);
            }
        } else if (this.conditions != null && this.conditions.length != 0) {
            this.conditionList = new ArrayList();
            for (int i = 0; i < this.conditions.length; ++i) {
                String condition = this.conditions[i];
                int index = condition.lastIndexOf(61);
                if (index == 0 || index == -1 || index == condition.length() - 1) {
                    throw new IllegalArgumentException("Condition is illegal : " + condition);
                }
                String cond = condition.substring(0, index);
                String beanFlowKey = condition.substring(index + 1);
                this.conditionList.add(new Condition(cond, beanFlowKey));
            }
        }
        if (this.beanFlowInputByInput != null) {
            if (!this.beanFlowInputByInput.startsWith(INPUT_KEY)) {
                throw new IllegalArgumentException("BeanFlowInputByInput don't start with 'input' : " + this.beanFlowInputByInput);
            }
            if (!this.beanFlowInputByInput.equals(INPUT_KEY)) {
                this.beanFlowInputByInputProp = null;
            } else {
                String tmpProp = this.beanFlowInputByInput.substring(INPUT_KEY.length());
                switch (tmpProp.charAt(0)) {
                    case '.': {
                        tmpProp = tmpProp.substring(1);
                        break;
                    }
                    case '(': 
                    case '[': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("BeanFlowInputByInput is illegal : " + this.beanFlowInputByInput);
                    }
                }
                this.beanFlowInputByInputProp = PropertyFactory.createProperty(tmpProp);
            }
        }
    }

    @Override
    public void handleDequeuedObject(Object obj) throws Throwable {
        Object input = obj;
        AsynchContext asynchCtx = null;
        BeanFlowInvoker invoker = null;
        BeanFlowMonitor monitor = null;
        String beanFlowKey = null;
        if (obj instanceof AsynchContext) {
            asynchCtx = (AsynchContext)obj;
            if (asynchCtx.isCancel()) {
                return;
            }
            if (asynchCtx instanceof BeanFlowAsynchContext) {
                invoker = ((BeanFlowAsynchContext)asynchCtx).getBeanFlowInvoker();
                monitor = ((BeanFlowAsynchContext)asynchCtx).getBeanFlowMonitor();
                if (invoker == null) {
                    beanFlowKey = ((BeanFlowAsynchContext)asynchCtx).getFlowName();
                }
            }
            input = asynchCtx.getInput();
            if (this.context != null) {
                asynchCtx.applyThreadContext(this.context);
            }
        }
        if (input != null && this.beanFlowInputByInputProp != null) {
            input = this.beanFlowInputByInputProp.getProperty(input);
        }
        if (invoker == null && beanFlowKey == null && input != null) {
            if (this.beanFlowKeyByInput != null) {
                beanFlowKey = this.beanFlowKeyByInputProp == null ? (String)input : (String)this.beanFlowInputByInputProp.getProperty(input);
            } else if (this.classMap != null) {
                beanFlowKey = (String)this.classMap.getValue(input.getClass());
            } else if (this.conditionList != null && this.conditionList.size() != 0) {
                int imax = this.conditionList.size();
                for (int i = 0; i < imax; ++i) {
                    Condition condition = (Condition)this.conditionList.get(i);
                    if (!condition.evaluate(input)) continue;
                    beanFlowKey = condition.beanFlowKey;
                    break;
                }
            }
        }
        Object output = null;
        if (invoker == null) {
            if (beanFlowKey == null) {
                beanFlowKey = this.defaultBeanFlowKey;
            }
            if (beanFlowKey == null) {
                if (this.isThrowOnNotFoundBeanFlow) {
                    throw new BeanFlowNotFoundException("BeanFlow is not found. arg=" + obj);
                }
                output = null;
            } else {
                try {
                    invoker = this.beanFlowInvokerFactory.createFlow(beanFlowKey);
                }
                catch (Exception e2) {
                    throw new NoSuchBeanFlowException("BeanFlowKey : " + beanFlowKey, e2);
                }
                output = invoker.invokeFlow(input);
            }
        } else {
            output = invoker.invokeFlow(input, monitor);
        }
        if (asynchCtx != null) {
            asynchCtx.setOutput(output);
            if (asynchCtx.getResponseQueue() != null) {
                asynchCtx.getResponseQueue().push(asynchCtx);
            }
        }
    }

    @Override
    public boolean handleError(Object obj, Throwable th) throws Throwable {
        if (this.errorLogMessageId != null) {
            this.getLogger().write(this.errorLogMessageId, obj, th);
        }
        return !(th instanceof BeanFlowNotFoundException) && !(th instanceof NoSuchBeanFlowException);
    }

    @Override
    public void handleRetryOver(Object obj, Throwable th) throws Throwable {
        if (obj instanceof AsynchContext) {
            AsynchContext asynchCtx = (AsynchContext)obj;
            asynchCtx.setThrowable(th);
            if (asynchCtx.getResponseQueue() != null) {
                asynchCtx.getResponseQueue().push(asynchCtx);
            }
            if (this.retryOverErrorLogMessageId != null) {
                this.getLogger().write(this.retryOverErrorLogMessageId, obj, th);
            }
        } else {
            if (th instanceof BeanFlowNotFoundException || th instanceof NoSuchBeanFlowException) {
                throw th;
            }
            if (this.retryOverErrorLogMessageId != null) {
                this.getLogger().write(this.retryOverErrorLogMessageId, obj, th);
            }
        }
    }

    private static class Condition
    implements Serializable {
        private static final long serialVersionUID = -9155271482408748880L;
        public String beanFlowKey;
        private transient List properties;
        private transient Expression expression;
        private transient List keyList;
        private String condition;
        private static final String DELIMITER = "@";
        private static final String VALUE = "value";

        Condition(String cond, String beanFlowKey) throws Exception {
            this.initCondition(cond);
            this.condition = cond;
            this.beanFlowKey = beanFlowKey;
        }

        private void initCondition(String cond) throws Exception {
            this.keyList = new ArrayList();
            this.properties = new ArrayList();
            StringTokenizer token = new StringTokenizer(cond, DELIMITER, true);
            boolean keyFlg = false;
            String beforeToken = null;
            StringBuffer condBuf = new StringBuffer();
            while (token.hasMoreTokens()) {
                String str = token.nextToken();
                if (!keyFlg) {
                    if (DELIMITER.equals(str)) {
                        keyFlg = true;
                    } else {
                        condBuf.append(str);
                    }
                } else if (DELIMITER.equals(str)) {
                    keyFlg = false;
                    if (beforeToken != null) {
                        String tmpKey = "_conditionKey$" + this.keyList.size();
                        this.keyList.add(tmpKey);
                        condBuf.append(tmpKey);
                        Property prop = PropertyFactory.createProperty(beforeToken);
                        prop.setIgnoreNullProperty(true);
                        this.properties.add(prop);
                    } else {
                        condBuf.append(str);
                    }
                }
                beforeToken = str;
            }
            this.expression = ExpressionFactory.createExpression((String)condBuf.toString());
            this.evaluate("", true);
        }

        public boolean evaluate(Object object) throws ConditionEvaluateException {
            return this.evaluate(object, false);
        }

        protected boolean evaluate(Object object, boolean isTest) throws ConditionEvaluateException {
            JexlContext jexlContext = JexlHelper.createContext();
            jexlContext.getVars().put(VALUE, object);
            if (object != null) {
                int size = this.keyList.size();
                for (int i = 0; i < size; ++i) {
                    String keyString = (String)this.keyList.get(i);
                    Property property = (Property)this.properties.get(i);
                    Object val = null;
                    try {
                        val = property.getProperty(object);
                    }
                    catch (NoSuchPropertyException noSuchPropertyException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    jexlContext.getVars().put(keyString, val);
                }
            }
            try {
                Object exp = this.expression.evaluate(jexlContext);
                if (exp instanceof Boolean) {
                    return (Boolean)exp;
                }
                if (exp == null && isTest) {
                    return true;
                }
                throw new ConditionEvaluateException(this.expression.getExpression());
            }
            catch (Exception e) {
                throw new ConditionEvaluateException(e);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            try {
                this.initCondition(this.condition);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class ConditionEvaluateException
    extends Exception {
        private static final long serialVersionUID = 46810818400899018L;

        public ConditionEvaluateException() {
        }

        public ConditionEvaluateException(String message) {
            super(message);
        }

        public ConditionEvaluateException(Throwable cause) {
            super(cause);
        }

        public ConditionEvaluateException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class NoSuchBeanFlowException
    extends Exception {
        private static final long serialVersionUID = 5781750320267729638L;

        public NoSuchBeanFlowException() {
        }

        public NoSuchBeanFlowException(String message) {
            super(message);
        }

        public NoSuchBeanFlowException(Throwable cause) {
            super(cause);
        }

        public NoSuchBeanFlowException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class BeanFlowNotFoundException
    extends Exception {
        private static final long serialVersionUID = -3976145224105142118L;

        public BeanFlowNotFoundException() {
        }

        public BeanFlowNotFoundException(String message) {
            super(message);
        }

        public BeanFlowNotFoundException(Throwable cause) {
            super(cause);
        }

        public BeanFlowNotFoundException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

