/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.resource.datasource;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.resource.TransactionResource;
import jp.ossc.nimbus.service.resource.datasource.JdbcConnectionFactory;
import jp.ossc.nimbus.service.resource.datasource.JdbcConnectionFactoryFromDriverServiceMBean;
import jp.ossc.nimbus.service.resource.datasource.JdbcConnectionTransactionResource;
import jp.ossc.nimbus.util.CsvArrayList;

public class JdbcConnectionFactoryFromDriverService
extends ServiceBase
implements JdbcConnectionFactoryFromDriverServiceMBean,
JdbcConnectionFactory {
    private static final long serialVersionUID = 8490173969104394544L;
    private String mDriverName = null;
    private String mCondition = null;
    private boolean mIsAutoCommit = false;

    @Override
    public void startService() throws ClassNotFoundException {
        Class.forName(this.mDriverName, true, NimbusClassLoader.getInstance());
    }

    @Override
    public void setJdbcDriverName(String name) {
        this.mDriverName = name;
    }

    @Override
    public String getJdbcDriverName() {
        return this.mDriverName;
    }

    @Override
    public void setJdbcConnectCondition(String condition) {
        this.mCondition = condition;
    }

    @Override
    public String getJdbcConnectCondition() {
        return this.mCondition;
    }

    @Override
    public Connection makeConnection(String key) throws SQLException {
        Connection dbc = null;
        CsvArrayList al = new CsvArrayList();
        al.split(key, "#");
        dbc = DriverManager.getConnection(this.mCondition, al.getStr(0), al.getStr(1));
        dbc.setAutoCommit(this.mIsAutoCommit);
        return dbc;
    }

    @Override
    public TransactionResource makeResource(String key) throws Exception {
        Connection con = this.makeConnection(key);
        JdbcConnectionTransactionResource ret = new JdbcConnectionTransactionResource(con);
        return ret;
    }

    @Override
    public void setAutoCommit(boolean isAutoCommit) {
        this.mIsAutoCommit = isAutoCommit;
    }
}

