/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.rest;

import java.beans.PropertyEditor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.ossc.nimbus.beans.NimbusPropertyEditorManager;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyAccess;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.NimbusEntityResolver;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.rest.BeanFlowRestServerServiceMBean;
import jp.ossc.nimbus.service.rest.DeleteRestRequest;
import jp.ossc.nimbus.service.rest.DeleteRestResponse;
import jp.ossc.nimbus.service.rest.GetRestRequest;
import jp.ossc.nimbus.service.rest.GetRestResponse;
import jp.ossc.nimbus.service.rest.HeadRestRequest;
import jp.ossc.nimbus.service.rest.HeadRestResponse;
import jp.ossc.nimbus.service.rest.OptionsRestRequest;
import jp.ossc.nimbus.service.rest.OptionsRestResponse;
import jp.ossc.nimbus.service.rest.PostRestRequest;
import jp.ossc.nimbus.service.rest.PostRestResponse;
import jp.ossc.nimbus.service.rest.PutRestRequest;
import jp.ossc.nimbus.service.rest.PutRestResponse;
import jp.ossc.nimbus.service.rest.RestContext;
import jp.ossc.nimbus.service.rest.RestRequest;
import jp.ossc.nimbus.service.rest.RestResponse;
import jp.ossc.nimbus.service.rest.RestServer;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.nimbus.util.converter.BindingStreamConverter;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.StreamConverter;
import jp.ossc.nimbus.util.converter.StreamStringConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BeanFlowRestServerService
extends ServiceBase
implements RestServer,
BeanFlowRestServerServiceMBean {
    private static final long serialVersionUID = 7754807146567199126L;
    protected static final String HTTP_HEADER_NAME_ACCEPT = "Accept";
    protected static final String HTTP_HEADER_NAME_ACCEPT_CHARSET = "Accept-Charset";
    protected static final String HTTP_HEADER_NAME_CONTENT_TYPE = "Content-Type";
    protected static final String MEDIA_TYPE_FORM_URLENCODED = "application/x-www-form-urlencoded";
    protected static final String HTTP_HEADER_NAME_CONTENT_ENCODING = "Content-Encoding";
    protected static final String CONTENT_ENCODING_DEFLATE = "deflate";
    protected static final String CONTENT_ENCODING_GZIP = "gzip";
    protected static final String CONTENT_ENCODING_X_GZIP = "x-gzip";
    protected String serverDefinitionPath;
    protected String documentBuilderFactoryClassName;
    protected boolean isValidate;
    protected String validateFlowPrefix = "validate";
    protected String postMethodFlowPostfix = "$POST";
    protected String getMethodFlowPostfix = "$GET";
    protected String headMethodFlowPostfix = "$HEAD";
    protected String putMethodFlowPostfix = "$PUT";
    protected String deleteMethodFlowPostfix = "$DELETE";
    protected ServiceName beanFlowInvokerFactoryServiceName;
    protected ServiceName journalServiceName;
    protected ServiceName editorFinderServiceName;
    protected ServiceName sequenceServiceName;
    protected ServiceName contextServiceName;
    protected String requestIdKey = "REQUEST_ID";
    protected BeanFlowInvokerFactory beanFlowInvokerFactory;
    protected Journal journal;
    protected EditorFinder editorFinder;
    protected Sequence sequence;
    protected Context context;
    protected RestServerMetaData restServerMetaData;
    protected PropertyAccess propertyAccess;
    protected Map requestConverterServiceNameMapping;
    protected Map requestConverterMapping;
    protected Map responseConverterServiceNameMapping;
    protected Map responseConverterMapping;

    @Override
    public void setServerDefinitionPath(String path) {
        this.serverDefinitionPath = path;
    }

    @Override
    public String getServerDefinitionPath() {
        return this.serverDefinitionPath;
    }

    @Override
    public void setDocumentBuilderFactoryClassName(String name) {
        this.documentBuilderFactoryClassName = name;
    }

    @Override
    public String getDocumentBuilderFactoryClassName() {
        return this.documentBuilderFactoryClassName;
    }

    @Override
    public void setValidate(boolean validate) {
        this.isValidate = validate;
    }

    @Override
    public boolean isValidate() {
        return this.isValidate;
    }

    @Override
    public void setValidateFlowPrefix(String prefix) {
        this.validateFlowPrefix = prefix;
    }

    @Override
    public String getValidateFlowPrefix() {
        return this.validateFlowPrefix;
    }

    @Override
    public void setPostMethodFlowPostfix(String postfix) {
        this.postMethodFlowPostfix = postfix;
    }

    @Override
    public String getPostMethodFlowPostfix() {
        return this.postMethodFlowPostfix;
    }

    @Override
    public void setGetMethodFlowPostfix(String postfix) {
        this.getMethodFlowPostfix = postfix;
    }

    @Override
    public String getGetMethodFlowPostfix() {
        return this.getMethodFlowPostfix;
    }

    @Override
    public void setHeadMethodFlowPostfix(String postfix) {
        this.headMethodFlowPostfix = postfix;
    }

    @Override
    public String getHeadMethodFlowPostfix() {
        return this.headMethodFlowPostfix;
    }

    @Override
    public void setPutMethodFlowPostfix(String postfix) {
        this.putMethodFlowPostfix = postfix;
    }

    @Override
    public String getPutMethodFlowPostfix() {
        return this.putMethodFlowPostfix;
    }

    @Override
    public void setDeleteMethodFlowPostfix(String postfix) {
        this.deleteMethodFlowPostfix = postfix;
    }

    @Override
    public String getDeleteMethodFlowPostfix() {
        return this.deleteMethodFlowPostfix;
    }

    @Override
    public void setBeanFlowInvokerFactoryServiceName(ServiceName name) {
        this.beanFlowInvokerFactoryServiceName = name;
    }

    @Override
    public ServiceName getBeanFlowInvokerFactoryServiceName() {
        return this.beanFlowInvokerFactoryServiceName;
    }

    @Override
    public void setJournalServiceName(ServiceName name) {
        this.journalServiceName = name;
    }

    @Override
    public ServiceName getJournalServiceName() {
        return this.journalServiceName;
    }

    @Override
    public void setEditorFinderServiceName(ServiceName name) {
        this.editorFinderServiceName = name;
    }

    @Override
    public ServiceName getEditorFinderServiceName() {
        return this.editorFinderServiceName;
    }

    @Override
    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    @Override
    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    @Override
    public void setRequestIdKey(String key) {
        this.requestIdKey = key;
    }

    @Override
    public String getRequestIdKey() {
        return this.requestIdKey;
    }

    @Override
    public void setContextServiceName(ServiceName name) {
        this.contextServiceName = name;
    }

    @Override
    public ServiceName getContextServiceName() {
        return this.contextServiceName;
    }

    @Override
    public void setRequestConverterServiceNames(Map mapping) {
        this.requestConverterServiceNameMapping = mapping;
    }

    @Override
    public Map getRequestConverterServiceNames() {
        return this.requestConverterServiceNameMapping;
    }

    @Override
    public void setRequestConverterServiceName(String mediaType, ServiceName name) {
        if (this.requestConverterServiceNameMapping == null) {
            this.requestConverterServiceNameMapping = new LinkedHashMap();
        }
        this.requestConverterServiceNameMapping.put(mediaType, name);
    }

    @Override
    public ServiceName getRequestConverterServiceName(String mediaType) {
        if (this.requestConverterServiceNameMapping == null) {
            return null;
        }
        return (ServiceName)this.requestConverterServiceNameMapping.get(mediaType);
    }

    @Override
    public void setResponseConverterServiceNames(Map mapping) {
        this.responseConverterServiceNameMapping = mapping;
    }

    @Override
    public Map getResponseConverterServiceNames() {
        return this.responseConverterServiceNameMapping;
    }

    @Override
    public void setResponseConverterServiceName(String mediaType, ServiceName name) {
        if (this.responseConverterServiceNameMapping == null) {
            this.responseConverterServiceNameMapping = new HashMap();
        }
        this.responseConverterServiceNameMapping.put(mediaType, name);
    }

    @Override
    public ServiceName getResponseConverterServiceName(String mediaType) {
        if (this.responseConverterServiceNameMapping == null) {
            return null;
        }
        return (ServiceName)this.responseConverterServiceNameMapping.get(mediaType);
    }

    public void setRequestConverter(String mediaType, BindingStreamConverter converter) {
        if (this.requestConverterMapping == null) {
            this.requestConverterMapping = new LinkedHashMap();
        }
        this.requestConverterMapping.put(mediaType, converter);
    }

    public BindingStreamConverter getRequestConverter(String mediaType) {
        if (this.requestConverterMapping == null) {
            return null;
        }
        return (BindingStreamConverter)this.requestConverterMapping.get(mediaType);
    }

    public void setResponseConverter(String mediaType, StreamConverter converter) {
        if (this.responseConverterMapping == null) {
            this.responseConverterMapping = new HashMap();
        }
        this.responseConverterMapping.put(mediaType, converter);
    }

    public StreamConverter getResponseConverter(String mediaType) {
        if (this.responseConverterMapping == null) {
            return null;
        }
        return (StreamConverter)this.responseConverterMapping.get(mediaType);
    }

    public void setBeanFlowInvokerFactory(BeanFlowInvokerFactory factory) {
        this.beanFlowInvokerFactory = factory;
    }

    public BeanFlowInvokerFactory getBeanFlowInvokerFactory() {
        return this.beanFlowInvokerFactory;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public void setEditorFinder(EditorFinder editorFinder) {
        this.editorFinder = editorFinder;
    }

    public EditorFinder getEditorFinder() {
        return this.editorFinder;
    }

    public void setSequence(Sequence seq) {
        this.sequence = seq;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setContext(Context ctx) {
        this.context = ctx;
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public void createService() throws Exception {
        this.propertyAccess = new PropertyAccess();
        this.propertyAccess.setIgnoreNullProperty(true);
    }

    @Override
    public void startService() throws Exception {
        if (this.requestConverterServiceNameMapping != null) {
            for (Map.Entry entry : this.requestConverterServiceNameMapping.entrySet()) {
                if (this.requestConverterMapping == null) {
                    this.requestConverterMapping = new LinkedHashMap();
                }
                this.requestConverterMapping.put(entry.getKey(), (BindingStreamConverter)ServiceManagerFactory.getServiceObject((ServiceName)entry.getValue()));
            }
        }
        if (this.responseConverterServiceNameMapping != null) {
            for (Map.Entry entry : this.responseConverterServiceNameMapping.entrySet()) {
                if (this.responseConverterMapping == null) {
                    this.responseConverterMapping = new HashMap();
                }
                this.responseConverterMapping.put(entry.getKey(), (StreamConverter)ServiceManagerFactory.getServiceObject((ServiceName)entry.getValue()));
            }
        }
        if (this.beanFlowInvokerFactoryServiceName != null) {
            this.beanFlowInvokerFactory = (BeanFlowInvokerFactory)ServiceManagerFactory.getServiceObject(this.beanFlowInvokerFactoryServiceName);
        }
        if (this.beanFlowInvokerFactory == null) {
            throw new IllegalArgumentException("BeanFlowFactory is null");
        }
        if (this.journalServiceName != null) {
            this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalServiceName);
        }
        if (this.editorFinderServiceName != null) {
            this.editorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.editorFinderServiceName);
        }
        this.reload();
    }

    @Override
    public synchronized void reload() throws Exception {
        String filePath2;
        ServiceLoader loader;
        ServiceMetaData metaData;
        if (this.serverDefinitionPath == null || this.serverDefinitionPath.length() == 0) {
            throw new IllegalArgumentException("ServerDefinitionPath is null");
        }
        File serviceDefDir = null;
        if (this.getServiceNameObject() != null && (metaData = ServiceManagerFactory.getServiceMetaData(this.getServiceNameObject())) != null && (loader = metaData.getServiceLoader()) != null && (filePath2 = loader.getServiceURL().getFile()) != null) {
            serviceDefDir = new File(filePath2).getParentFile();
        }
        URL url = null;
        File localFile = new File(this.serverDefinitionPath);
        if (!localFile.exists() && serviceDefDir != null) {
            localFile = new File(serviceDefDir, this.serverDefinitionPath);
        }
        if (localFile.exists()) {
            if (!localFile.isFile()) {
                throw new IllegalArgumentException("ServerDefinitionPath must be file : " + localFile);
            }
            try {
                url = localFile.toURI().toURL();
            }
            catch (MalformedURLException filePath2) {}
        } else {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL resource = classLoader.getResource(this.serverDefinitionPath);
            if (resource != null) {
                url = resource;
            }
        }
        if (url == null) {
            throw new IllegalArgumentException("ServerDefinitionPath not found : " + this.serverDefinitionPath);
        }
        InputSource inputSource = new InputSource(url.openStream());
        DocumentBuilderFactory domFactory = null;
        domFactory = this.documentBuilderFactoryClassName == null ? DocumentBuilderFactory.newInstance() : (DocumentBuilderFactory)Class.forName(this.documentBuilderFactoryClassName, true, NimbusClassLoader.getInstance()).newInstance();
        domFactory.setValidating(this.isValidate());
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        NimbusEntityResolver resolver = new NimbusEntityResolver();
        builder.setEntityResolver(resolver);
        MyErrorHandler handler = new MyErrorHandler();
        builder.setErrorHandler(handler);
        Document doc = builder.parse(inputSource);
        if (handler.isError()) {
            throw new DeploymentException("Failed to parse ServerDefinition");
        }
        RestServerMetaData serverData = new RestServerMetaData();
        serverData.importXML(doc.getDocumentElement());
        this.restServerMetaData = serverData;
    }

    public RestServerMetaData getRestServerMetaData() {
        return this.restServerMetaData;
    }

    protected boolean processCheckAccept(RestRequest request, RestResponse response) throws Exception {
        String acceptStr = request.request.getHeader(HTTP_HEADER_NAME_ACCEPT);
        if (this.journal != null) {
            this.journal.addInfo(HTTP_HEADER_NAME_ACCEPT, acceptStr);
        }
        if (acceptStr == null) {
            return true;
        }
        if (this.responseConverterMapping != null) {
            String acceptCharsetStr = request.request.getHeader(HTTP_HEADER_NAME_ACCEPT_CHARSET);
            if (this.journal != null) {
                this.journal.addInfo("AcceptCharset", acceptCharsetStr);
            }
            if (acceptCharsetStr != null) {
                AcceptCharset acceptCharset = null;
                try {
                    acceptCharset = new AcceptCharset(acceptCharsetStr);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().write("BFRS_00029", (Object)acceptCharsetStr, (Throwable)e);
                    if (this.journal != null) {
                        this.journal.addInfo("Exception", e);
                    }
                    response.setResult(406);
                    return false;
                }
                boolean isSupported = false;
                for (int i = 0; i < acceptCharset.charsetRanges.size(); ++i) {
                    CharsetRange cr = (CharsetRange)acceptCharset.charsetRanges.get(i);
                    if (!Charset.isSupported(cr.getCharset())) continue;
                    isSupported = true;
                    response.getResponse().setCharacterEncoding(Charset.forName(cr.getCharset()).name());
                    break;
                }
                if (!isSupported) {
                    this.getLogger().write("BFRS_00030", (Object)acceptCharsetStr);
                    response.setResult(406);
                    return false;
                }
            }
            Accept accept = null;
            try {
                accept = new Accept(acceptStr);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().write("BFRS_00028", (Object)acceptStr, (Throwable)e);
                if (this.journal != null) {
                    this.journal.addInfo("Exception", e);
                }
                response.setResult(406);
                return false;
            }
            for (int i = 0; i < accept.mediaRanges.size(); ++i) {
                MediaRange mr = (MediaRange)accept.mediaRanges.get(i);
                if (!this.responseConverterMapping.containsKey(mr.getMediaType())) continue;
                return true;
            }
        }
        response.setResult(406);
        return false;
    }

    protected boolean processCheckContentType(RestRequest request, RestResponse response) throws Exception {
        String contentType = request.request.getHeader(HTTP_HEADER_NAME_CONTENT_TYPE);
        if (this.journal != null) {
            this.journal.addInfo("ContentType", contentType);
        }
        if (contentType == null) {
            return true;
        }
        MediaType mediaType = new MediaType(contentType);
        if (MEDIA_TYPE_FORM_URLENCODED.equals(mediaType.getMediaType())) {
            return true;
        }
        if (this.requestConverterMapping == null) {
            response.setResult(415);
            return false;
        }
        if (!this.requestConverterMapping.containsKey(mediaType.getMediaType())) {
            response.setResult(415);
            return false;
        }
        return true;
    }

    protected ResourceMetaData processFindResource(RestRequest request, RestResponse response, List paths) throws Exception {
        ResourceMetaData resource = this.restServerMetaData.resourceTree.getResource(paths);
        if (resource == null) {
            response.setResult(404);
            return null;
        }
        if (this.journal != null) {
            this.journal.addInfo("ResourcePath", resource.resourcePath.path);
        }
        return resource;
    }

    protected boolean processParsePathParameters(RestRequest request, RestResponse response, List paths, ResourceMetaData resource) throws Exception {
        try {
            Map pathParameters = resource.resourcePath.parseParameter(paths, null);
            if (this.journal != null) {
                this.journal.addInfo("PathParamsters", pathParameters);
            }
            request.setPathParameterMap(pathParameters);
        }
        catch (IndexOutOfBoundsException e) {
            this.getLogger().write("BFRS_00025", new Object[]{resource.resourcePath.path, paths}, (Throwable)e);
            if (this.journal != null) {
                this.journal.addInfo("Exception", e);
            }
            response.setResult(400);
            return false;
        }
        return true;
    }

    protected boolean processCreateRequestObject(RestRequest request, RestResponse response, List paths, ResourceMetaData resource, RequestMetaData requestData) throws Exception {
        if (requestData == null) {
            return true;
        }
        Map pathParameters = request.getPathParameterMap();
        Object requestObj = null;
        Class requestObjClass = null;
        try {
            requestObjClass = Utility.convertStringToClass(requestData.code, true);
        }
        catch (ClassNotFoundException e) {
            this.getLogger().write("BFRS_00004", new Object[]{resource.resourcePath.path, requestData.code}, (Throwable)e);
            if (this.journal != null) {
                this.journal.addInfo("Exception", e);
            }
            response.setResult(500);
            return false;
        }
        if (String.class.equals((Object)requestObjClass)) {
            if (pathParameters != null && pathParameters.size() != 0) {
                requestObj = pathParameters.values().iterator().next();
            }
        } else if (String[].class.equals((Object)requestObjClass)) {
            if (pathParameters != null && pathParameters.size() != 0) {
                requestObj = pathParameters.values().toArray();
            }
        } else if (Number.class.isAssignableFrom(requestObjClass)) {
            if (pathParameters != null && pathParameters.size() != 0) {
                String valStr = (String)pathParameters.values().iterator().next();
                try {
                    if (Byte.class.isAssignableFrom(requestObjClass)) {
                        requestObj = Byte.valueOf(valStr);
                    }
                    if (Short.class.isAssignableFrom(requestObjClass)) {
                        requestObj = Short.valueOf(valStr);
                    }
                    if (Integer.class.isAssignableFrom(requestObjClass)) {
                        requestObj = Integer.valueOf(valStr);
                    }
                    if (Long.class.isAssignableFrom(requestObjClass)) {
                        requestObj = Long.valueOf(valStr);
                    }
                    if (Float.class.isAssignableFrom(requestObjClass)) {
                        requestObj = Float.valueOf(valStr);
                    }
                    if (Double.class.isAssignableFrom(requestObjClass)) {
                        requestObj = Double.valueOf(valStr);
                    }
                    if (BigInteger.class.isAssignableFrom(requestObjClass)) {
                        requestObj = new BigInteger(valStr);
                    }
                    if (BigDecimal.class.isAssignableFrom(requestObjClass)) {
                        requestObj = new BigDecimal(valStr);
                    }
                    this.getLogger().write("BFRS_00005", new Object[]{resource.resourcePath.path, requestObjClass.getName()});
                    response.setResult(500);
                    return false;
                }
                catch (NumberFormatException e) {
                    this.getLogger().write("BFRS_00026", new Object[]{resource.resourcePath.path, pathParameters.keySet().iterator().next(), valStr}, (Throwable)e);
                    if (this.journal != null) {
                        this.journal.addInfo("Exception", e);
                    }
                    response.setResult(400, "Illegal number format. val=" + valStr);
                    return false;
                }
            }
        } else {
            try {
                requestObj = requestObjClass.newInstance();
            }
            catch (InstantiationException e) {
                this.getLogger().write("BFRS_00006", new Object[]{resource.resourcePath.path, requestObjClass.getName()}, (Throwable)e);
                if (this.journal != null) {
                    this.journal.addInfo("Exception", e);
                }
                response.setResult(500);
                return false;
            }
            catch (IllegalAccessException e) {
                this.getLogger().write("BFRS_00006", new Object[]{resource.resourcePath.path, requestObjClass.getName()}, (Throwable)e);
                if (this.journal != null) {
                    this.journal.addInfo("Exception", e);
                }
                response.setResult(500);
                return false;
            }
            if (pathParameters != null && pathParameters.size() != 0) {
                for (Map.Entry entry : pathParameters.entrySet()) {
                    Property prop = null;
                    try {
                        prop = this.propertyAccess.getProperty((String)entry.getKey());
                    }
                    catch (IllegalArgumentException e) {
                        this.getLogger().write("BFRS_00007", new Object[]{resource.resourcePath.path, entry.getKey()}, (Throwable)e);
                        if (this.journal != null) {
                            this.journal.addInfo("Exception", e);
                        }
                        response.setResult(500);
                        return false;
                    }
                    if (!prop.isReadable(requestObj)) continue;
                    Class propType = null;
                    try {
                        propType = prop.getPropertyType(requestObj);
                    }
                    catch (NoSuchPropertyException e) {
                        this.getLogger().write("BFRS_00008", new Object[]{resource.resourcePath.path, entry.getKey(), requestObjClass.getName()}, (Throwable)e);
                        if (this.journal != null) {
                            this.journal.addInfo("Exception", e);
                        }
                        response.setResult(500);
                        return false;
                    }
                    catch (InvocationTargetException e) {
                        this.getLogger().write("BFRS_00008", new Object[]{resource.resourcePath.path, entry.getKey(), requestObjClass.getName()}, (Throwable)e);
                        if (this.journal != null) {
                            this.journal.addInfo("Exception", e);
                        }
                        response.setResult(500);
                        return false;
                    }
                    if (!prop.isWritable(requestObj, propType)) continue;
                    if (propType.isAssignableFrom(String.class)) {
                        try {
                            prop.setProperty(requestObj, propType, entry.getValue());
                            continue;
                        }
                        catch (NoSuchPropertyException e) {
                            this.getLogger().write("BFRS_00009", new Object[]{resource.resourcePath.path, entry.getKey(), requestObjClass.getName()}, (Throwable)e);
                            if (this.journal != null) {
                                this.journal.addInfo("Exception", e);
                            }
                            response.setResult(500);
                            return false;
                        }
                        catch (InvocationTargetException e) {
                            this.getLogger().write("BFRS_00009", new Object[]{resource.resourcePath.path, entry.getKey(), requestObjClass.getName()}, (Throwable)e);
                            if (this.journal != null) {
                                this.journal.addInfo("Exception", e);
                            }
                            response.setResult(500);
                            return false;
                        }
                    }
                    PropertyEditor editor = NimbusPropertyEditorManager.findEditor(propType);
                    if (editor == null) {
                        this.getLogger().write("BFRS_00010", new Object[]{resource.resourcePath.path, entry.getKey(), propType.getName()});
                        response.setResult(500);
                        return false;
                    }
                    editor.setAsText((String)entry.getValue());
                    try {
                        prop.setProperty(requestObj, propType, editor.getValue());
                    }
                    catch (NoSuchPropertyException e) {
                        this.getLogger().write("BFRS_00009", new Object[]{resource.resourcePath.path, entry.getKey(), requestObjClass.getName()}, (Throwable)e);
                        if (this.journal != null) {
                            this.journal.addInfo("Exception", e);
                        }
                        response.setResult(500);
                        return false;
                    }
                    catch (InvocationTargetException e) {
                        this.getLogger().write("BFRS_00009", new Object[]{resource.resourcePath.path, entry.getKey(), requestObjClass.getName()}, (Throwable)e);
                        if (this.journal != null) {
                            this.journal.addInfo("Exception", e);
                        }
                        response.setResult(500);
                        return false;
                    }
                }
            }
        }
        request.setRequestObject(requestObj);
        return true;
    }

    protected boolean processSetupResponseObject(RestRequest request, RestResponse response, List paths, ResourceMetaData resource, ResponseMetaData responseData) throws Exception {
        if (responseData == null) {
            return true;
        }
        Class responseObjClass = null;
        try {
            responseObjClass = Utility.convertStringToClass(responseData.code, true);
        }
        catch (ClassNotFoundException e) {
            this.getLogger().write("BFRS_00011", new Object[]{resource.resourcePath.path, responseData.code}, (Throwable)e);
            if (this.journal != null) {
                this.journal.addInfo("Exception", e);
            }
            response.setResult(500);
            return false;
        }
        response.setResponseObjectClass(responseObjClass);
        return true;
    }

    protected boolean processReadQuery(RestRequest request, RestResponse response, List paths, ResourceMetaData resource) throws Exception {
        if (request.getRequest().getQueryString() == null) {
            return true;
        }
        return this.processReadParameter(request, response, paths, resource);
    }

    protected boolean processReadParameter(RestRequest request, RestResponse response, List paths, ResourceMetaData resource) throws Exception {
        if (this.journal != null) {
            this.journal.addInfo("RequestParamsters", request.getRequest().getParameterMap());
        }
        if (request.getRequestObject() == null) {
            request.setRequestObject(request.getRequest().getParameterMap());
        } else {
            Object requestObj = request.getRequestObject();
            for (Map.Entry entry : request.getRequest().getParameterMap().entrySet()) {
                Property prop = null;
                try {
                    prop = this.propertyAccess.getProperty((String)entry.getKey());
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().write("BFRS_00027", new Object[]{resource.resourcePath.path, entry.getKey()}, (Throwable)e);
                    if (this.journal != null) {
                        this.journal.addInfo("Exception", e);
                    }
                    response.setResult(400);
                    return false;
                }
                if (!prop.isReadable(requestObj)) continue;
                Class propType = null;
                try {
                    propType = prop.getPropertyType(requestObj);
                }
                catch (NoSuchPropertyException e) {
                    this.getLogger().write("BFRS_00012", new Object[]{resource.resourcePath.path, entry.getKey(), requestObj.getClass().getName()}, (Throwable)e);
                    if (this.journal != null) {
                        this.journal.addInfo("Exception", e);
                    }
                    response.setResult(500);
                    return false;
                }
                catch (InvocationTargetException e) {
                    this.getLogger().write("BFRS_00012", new Object[]{resource.resourcePath.path, entry.getKey(), requestObj.getClass().getName()}, (Throwable)e);
                    if (this.journal != null) {
                        this.journal.addInfo("Exception", e);
                    }
                    response.setResult(500);
                    return false;
                }
                if (!prop.isWritable(requestObj, propType)) continue;
                if (propType.isAssignableFrom(String.class)) {
                    try {
                        prop.setProperty(requestObj, propType, ((String[])entry.getValue())[0]);
                        continue;
                    }
                    catch (NoSuchPropertyException e) {
                        this.getLogger().write("BFRS_00013", new Object[]{resource.resourcePath.path, entry.getKey(), requestObj.getClass().getName()}, (Throwable)e);
                        if (this.journal != null) {
                            this.journal.addInfo("Exception", e);
                        }
                        response.setResult(500);
                        return false;
                    }
                    catch (InvocationTargetException e) {
                        this.getLogger().write("BFRS_00013", new Object[]{resource.resourcePath.path, entry.getKey(), requestObj.getClass().getName()}, (Throwable)e);
                        if (this.journal != null) {
                            this.journal.addInfo("Exception", e);
                        }
                        response.setResult(500);
                        return false;
                    }
                }
                if (propType.isAssignableFrom(String[].class)) {
                    try {
                        prop.setProperty(requestObj, propType, entry.getValue());
                        continue;
                    }
                    catch (NoSuchPropertyException e) {
                        this.getLogger().write("BFRS_00013", new Object[]{resource.resourcePath.path, entry.getKey(), requestObj.getClass().getName()}, (Throwable)e);
                        if (this.journal != null) {
                            this.journal.addInfo("Exception", e);
                        }
                        response.setResult(500);
                        return false;
                    }
                    catch (InvocationTargetException e) {
                        this.getLogger().write("BFRS_00013", new Object[]{resource.resourcePath.path, entry.getKey(), requestObj.getClass().getName()}, (Throwable)e);
                        if (this.journal != null) {
                            this.journal.addInfo("Exception", e);
                        }
                        response.setResult(500);
                        return false;
                    }
                }
                if (propType.isAssignableFrom(List.class) || propType.isAssignableFrom(Set.class)) {
                    AbstractCollection collection = null;
                    try {
                        collection = (AbstractCollection)prop.getProperty(requestObj);
                    }
                    catch (NoSuchPropertyException e) {
                        this.getLogger().write("BFRS_00014", new Object[]{resource.resourcePath.path, entry.getKey(), requestObj.getClass().getName()}, (Throwable)e);
                        if (this.journal != null) {
                            this.journal.addInfo("Exception", e);
                        }
                        response.setResult(500);
                        return false;
                    }
                    catch (InvocationTargetException e) {
                        this.getLogger().write("BFRS_00014", new Object[]{resource.resourcePath.path, entry.getKey(), requestObj.getClass().getName()}, (Throwable)e);
                        if (this.journal != null) {
                            this.journal.addInfo("Exception", e);
                        }
                        response.setResult(500);
                        return false;
                    }
                    if (collection == null) {
                        if (propType.isInterface()) {
                            collection = propType.isAssignableFrom(List.class) ? new ArrayList() : new HashSet();
                        } else {
                            try {
                                collection = (Collection)propType.newInstance();
                            }
                            catch (InstantiationException e) {
                                this.getLogger().write("BFRS_00015", new Object[]{resource.resourcePath.path, entry.getKey(), requestObj.getClass().getName(), propType}, (Throwable)e);
                                if (this.journal != null) {
                                    this.journal.addInfo("Exception", e);
                                }
                                response.setResult(500);
                                return false;
                            }
                            catch (IllegalAccessException e) {
                                this.getLogger().write("BFRS_00015", new Object[]{resource.resourcePath.path, entry.getKey(), requestObj.getClass().getName(), propType}, (Throwable)e);
                                if (this.journal != null) {
                                    this.journal.addInfo("Exception", e);
                                }
                                response.setResult(500);
                                return false;
                            }
                        }
                    }
                    try {
                        String[] params = (String[])entry.getValue();
                        for (int i = 0; i < params.length; ++i) {
                            collection.add(params[i]);
                        }
                        prop.setProperty(requestObj, propType, collection);
                        continue;
                    }
                    catch (NoSuchPropertyException e) {
                        this.getLogger().write("BFRS_00013", new Object[]{resource.resourcePath.path, entry.getKey(), requestObj.getClass().getName()}, (Throwable)e);
                        if (this.journal != null) {
                            this.journal.addInfo("Exception", e);
                        }
                        response.setResult(500);
                        return false;
                    }
                    catch (InvocationTargetException e) {
                        this.getLogger().write("BFRS_00013", new Object[]{resource.resourcePath.path, entry.getKey(), requestObj.getClass().getName()}, (Throwable)e);
                        if (this.journal != null) {
                            this.journal.addInfo("Exception", e);
                        }
                        response.setResult(500);
                        return false;
                    }
                }
                if (propType.isArray()) {
                    Class<?> componentType = propType.getComponentType();
                    PropertyEditor editor = NimbusPropertyEditorManager.findEditor(componentType);
                    if (editor == null) {
                        this.getLogger().write("BFRS_00017", new Object[]{resource.resourcePath.path, entry.getKey(), componentType.getName()});
                        response.setResult(500);
                        return false;
                    }
                    String[] params = (String[])entry.getValue();
                    Object array = Array.newInstance(componentType, params.length);
                    try {
                        for (int i = 0; i < params.length; ++i) {
                            editor.setAsText(((String[])entry.getValue())[0]);
                            Array.set(array, i, editor.getValue());
                        }
                        prop.setProperty(requestObj, propType, array);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        this.getLogger().write("BFRS_00013", new Object[]{resource.resourcePath.path, entry.getKey(), requestObj.getClass().getName()}, (Throwable)e);
                        if (this.journal != null) {
                            this.journal.addInfo("Exception", e);
                        }
                        response.setResult(500);
                        return false;
                    }
                    catch (NoSuchPropertyException e) {
                        this.getLogger().write("BFRS_00013", new Object[]{resource.resourcePath.path, entry.getKey(), requestObj.getClass().getName()}, (Throwable)e);
                        if (this.journal != null) {
                            this.journal.addInfo("Exception", e);
                        }
                        response.setResult(500);
                        return false;
                    }
                    catch (InvocationTargetException e) {
                        this.getLogger().write("BFRS_00013", new Object[]{resource.resourcePath.path, entry.getKey(), requestObj.getClass().getName()}, (Throwable)e);
                        if (this.journal != null) {
                            this.journal.addInfo("Exception", e);
                        }
                        response.setResult(500);
                        return false;
                    }
                }
                PropertyEditor editor = NimbusPropertyEditorManager.findEditor(propType);
                if (editor == null) {
                    this.getLogger().write("BFRS_00017", new Object[]{resource.resourcePath.path, entry.getKey(), propType.getName()});
                    response.setResult(500);
                    return false;
                }
                editor.setAsText(((String[])entry.getValue())[0]);
                try {
                    prop.setProperty(requestObj, propType, editor.getValue());
                }
                catch (NoSuchPropertyException e) {
                    this.getLogger().write("BFRS_00013", new Object[]{resource.resourcePath.path, entry.getKey(), requestObj.getClass().getName()}, (Throwable)e);
                    if (this.journal != null) {
                        this.journal.addInfo("Exception", e);
                    }
                    response.setResult(500);
                    return false;
                }
                catch (InvocationTargetException e) {
                    this.getLogger().write("BFRS_00013", new Object[]{resource.resourcePath.path, entry.getKey(), requestObj.getClass().getName()}, (Throwable)e);
                    if (this.journal != null) {
                        this.journal.addInfo("Exception", e);
                    }
                    response.setResult(500);
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processReadRequestBody(RestRequest request, RestResponse response, List paths, ResourceMetaData resource) throws Exception {
        String contentType = request.request.getHeader(HTTP_HEADER_NAME_CONTENT_TYPE);
        BindingStreamConverter requestConverter = null;
        if (contentType == null) {
            if (this.requestConverterMapping != null) {
                requestConverter = (BindingStreamConverter)this.requestConverterMapping.values().iterator().next();
            }
        } else {
            MediaType mediaType = new MediaType(contentType);
            if (this.requestConverterMapping != null) {
                requestConverter = (BindingStreamConverter)this.requestConverterMapping.get(mediaType.getMediaType());
            }
        }
        if (requestConverter == null) {
            return this.processReadParameter(request, response, paths, resource);
        }
        if (request.getRequestObject() != null) {
            String encode = null;
            if (requestConverter instanceof StreamStringConverter) {
                if (request.getRequest().getCharacterEncoding() != null && !request.getRequest().getCharacterEncoding().equals(((StreamStringConverter)((Object)requestConverter)).getCharacterEncodingToObject())) {
                    requestConverter = (BindingStreamConverter)((Object)((StreamStringConverter)((Object)requestConverter)).cloneCharacterEncodingToObject(request.getRequest().getCharacterEncoding()));
                }
                encode = ((StreamStringConverter)((Object)requestConverter)).getCharacterEncodingToObject();
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ByteArrayInputStream bais = null;
            try {
                ServletInputStream sis = request.getRequest().getInputStream();
                byte[] bytes = new byte[2048];
                try {
                    int size = 0;
                    while ((size = sis.read(bytes)) != -1) {
                        baos.write(bytes, 0, size);
                    }
                }
                finally {
                    if (sis != null) {
                        sis.close();
                    }
                    bytes = null;
                }
                this.decompress(request.getRequest(), baos);
                if (this.journal != null) {
                    Object requestBody = null;
                    if (encode == null) {
                        requestBody = baos.toByteArray();
                    } else {
                        try {
                            requestBody = new String(baos.toByteArray(), encode);
                        }
                        catch (UnsupportedEncodingException e) {
                            requestBody = baos.toByteArray();
                        }
                    }
                    this.journal.addInfo("RequestBody", requestBody);
                }
                bais = new ByteArrayInputStream(baos.toByteArray());
                baos = null;
                request.setRequestObject(requestConverter.convertToObject(bais, request.getRequestObject()));
            }
            catch (ConvertException e) {
                this.getLogger().write("BFRS_00018", new Object[]{resource.resourcePath.path, request.getRequestObject().getClass().getName()}, (Throwable)e);
                if (this.journal != null) {
                    this.journal.addInfo("Exception", e);
                }
                response.setResult(400);
                boolean bl = false;
                return bl;
            }
            finally {
                if (bais != null) {
                    try {
                        bais.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteArrayOutputStream decompress(HttpServletRequest request, ByteArrayOutputStream baos) throws IOException {
        Enumeration encodeEnum = request.getHeaders(HTTP_HEADER_NAME_CONTENT_ENCODING);
        if (encodeEnum == null || !encodeEnum.hasMoreElements()) {
            return baos;
        }
        InputStream in = new ByteArrayInputStream(baos.toByteArray());
        try {
            ArrayList encodes = new ArrayList();
            while (encodeEnum.hasMoreElements()) {
                encodes.add(encodeEnum.nextElement());
            }
            for (int i = encodes.size() - 1; i >= 0; --i) {
                String encode = (String)encodes.get(i);
                if (encode == null) continue;
                if (encode.indexOf(CONTENT_ENCODING_DEFLATE) != -1) {
                    in = new InflaterInputStream(in);
                    continue;
                }
                if (encode.indexOf(CONTENT_ENCODING_GZIP) != -1 || encode.indexOf(CONTENT_ENCODING_X_GZIP) != -1) {
                    in = new GZIPInputStream(in);
                    continue;
                }
                throw new IOException("Can not decompress. [" + encode + "]");
            }
            baos.reset();
            byte[] bytes = new byte[1024];
            int length = 0;
            while ((length = in.read(bytes)) != -1) {
                baos.write(bytes, 0, length);
            }
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {}
        }
        return baos;
    }

    protected boolean processValidateRequestObject(RestRequest request, RestResponse response, List paths, ResourceMetaData resource) throws Exception {
        String flowName;
        if (this.journal != null) {
            this.journal.addInfo("RequestObject", request.getRequestObject());
        }
        if (!this.beanFlowInvokerFactory.containsFlow(flowName = this.validateFlowPrefix + resource.resourcePath.path)) {
            return true;
        }
        if (this.journal != null) {
            this.journal.addInfo("ValidateFlow", flowName);
        }
        BeanFlowInvoker flow = null;
        try {
            flow = this.beanFlowInvokerFactory.createFlow(flowName);
        }
        catch (Exception e) {
            this.getLogger().write("BFRS_00019", new Object[]{resource.resourcePath.path, flowName}, (Throwable)e);
            if (this.journal != null) {
                this.journal.addInfo("Exception", e);
            }
            response.setResult(500);
            return false;
        }
        try {
            Object ret = flow.invokeFlow(new RestContext(request, response));
            boolean result = false;
            if (ret != null && ret instanceof Boolean) {
                result = (Boolean)ret;
            }
            if (!result) {
                response.setResult(400);
            }
            return result;
        }
        catch (Throwable th) {
            this.getLogger().write("BFRS_00020", new Object[]{resource.resourcePath.path, flowName}, th);
            if (this.journal != null) {
                this.journal.addInfo("Exception", th);
            }
            response.setResult(500);
            return false;
        }
    }

    protected boolean processExecute(RestRequest request, RestResponse response, List paths, ResourceMetaData resource, String methodPostfix) throws Exception {
        String flowName = resource.resourcePath.path + methodPostfix;
        if (!this.beanFlowInvokerFactory.containsFlow(flowName)) {
            this.getLogger().write("BFRS_00021", new Object[]{resource.resourcePath.path, flowName});
            response.setResult(500);
            return false;
        }
        if (this.journal != null) {
            this.journal.addInfo("Flow", flowName);
        }
        BeanFlowInvoker flow = null;
        try {
            flow = this.beanFlowInvokerFactory.createFlow(flowName);
        }
        catch (Exception e) {
            this.getLogger().write("BFRS_00022", new Object[]{resource.resourcePath.path, flowName}, (Throwable)e);
            if (this.journal != null) {
                this.journal.addInfo("Exception", e);
            }
            response.setResult(500);
            return false;
        }
        try {
            flow.invokeFlow(new RestContext(request, response));
            return true;
        }
        catch (Throwable th) {
            this.getLogger().write("BFRS_00023", new Object[]{resource.resourcePath.path, flowName}, th);
            if (this.journal != null) {
                this.journal.addInfo("Exception", th);
            }
            response.setResult(500);
            return false;
        }
    }

    protected boolean processWriteResponseBody(RestRequest request, RestResponse response, List paths, ResourceMetaData resource) throws Exception {
        Object responseObject = response.getResponseObject();
        if (responseObject == null) {
            return true;
        }
        if (this.journal != null) {
            this.journal.addInfo("ResponseObject", responseObject);
        }
        String acceptStr = request.request.getHeader(HTTP_HEADER_NAME_ACCEPT);
        StreamConverter responseConverter = null;
        String mediaType = null;
        if (acceptStr == null) {
            mediaType = (String)this.responseConverterMapping.keySet().iterator().next();
            responseConverter = (StreamConverter)this.responseConverterMapping.get(mediaType);
        } else {
            Accept accept = null;
            try {
                accept = new Accept(acceptStr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            for (int i = 0; i < accept.mediaRanges.size(); ++i) {
                MediaRange mr = (MediaRange)accept.mediaRanges.get(i);
                responseConverter = (StreamConverter)this.responseConverterMapping.get(mr.getMediaType());
                if (responseConverter == null) continue;
                mediaType = mr.getMediaType();
                break;
            }
        }
        String encode = null;
        if (responseConverter instanceof StreamStringConverter) {
            if (response.getResponse().getCharacterEncoding() != null && !response.getResponse().getCharacterEncoding().equals(((StreamStringConverter)responseConverter).getCharacterEncodingToStream())) {
                responseConverter = ((StreamStringConverter)responseConverter).cloneCharacterEncodingToStream(response.getResponse().getCharacterEncoding());
            }
            encode = ((StreamStringConverter)responseConverter).getCharacterEncodingToStream();
        }
        response.getResponse().setContentType(new ContentType(mediaType, response.getResponse().getCharacterEncoding()).toString());
        InputStream is = null;
        try {
            is = responseConverter.convertToStream(responseObject);
        }
        catch (ConvertException e) {
            this.getLogger().write("BFRS_00024", new Object[]{resource.resourcePath.path, responseObject.getClass().getName()}, (Throwable)e);
            if (this.journal != null) {
                this.journal.addInfo("Exception", e);
            }
            response.setResult(500);
            return false;
        }
        ServletOutputStream sos = response.getResponse().getOutputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = new byte[2048];
        int readLen = 0;
        while ((readLen = is.read(bytes)) != -1) {
            baos.write(bytes, 0, readLen);
            sos.write(bytes, 0, readLen);
        }
        if (this.journal != null) {
            Object responseBody = null;
            if (encode == null) {
                responseBody = baos.toByteArray();
            } else {
                try {
                    responseBody = new String(baos.toByteArray(), encode);
                }
                catch (UnsupportedEncodingException e) {
                    responseBody = baos.toByteArray();
                }
            }
            this.journal.addInfo("ResponseBody", responseBody);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPost(PostRestRequest request, PostRestResponse response) throws Throwable {
        ResourceMetaData resource = null;
        try {
            if (this.journal != null) {
                this.journal.startJournal("RestProcess", this.editorFinder);
                if (this.sequence != null) {
                    String sequenceId = this.sequence.increment();
                    if (this.context != null) {
                        this.context.put(this.requestIdKey, sequenceId);
                    }
                    this.journal.setRequestId(sequenceId);
                } else if (this.context != null) {
                    this.journal.setRequestId((String)this.context.get(this.requestIdKey));
                }
                this.journal.addInfo("RequestURI", request.getURI());
                this.journal.addInfo("Method", request.getRequest().getMethod());
            }
            if (!this.processCheckAccept(request, response)) {
                return;
            }
            if (!this.processCheckContentType(request, response)) {
                return;
            }
            List paths = ResourcePath.splitPath(request.getURI());
            resource = this.processFindResource(request, response, paths);
            if (resource == null) {
                return;
            }
            if (resource.postData == null) {
                response.setResult(405);
                return;
            }
            if (!this.processParsePathParameters(request, response, paths, resource)) {
                return;
            }
            if (!this.processCreateRequestObject(request, response, paths, resource, resource.postData.requestData)) {
                return;
            }
            if (!this.processSetupResponseObject(request, response, paths, resource, resource.postData.responseData)) {
                return;
            }
            if (!this.processReadRequestBody(request, response, paths, resource)) {
                return;
            }
            if (this.processValidateRequestObject(request, response, paths, resource) && !this.processExecute(request, response, paths, resource, this.postMethodFlowPostfix)) {
                return;
            }
            this.processWriteResponseBody(request, response, paths, resource);
        }
        catch (Throwable th) {
            this.getLogger().write("BFRS_00031", new Object[]{resource == null ? request.getURI() : resource.resourcePath.path}, th);
            if (this.journal != null) {
                this.journal.addInfo("Exception", th);
            }
            response.setResult(500);
        }
        finally {
            if (this.journal != null) {
                this.journal.addInfo("ResultStatus", new Integer(response.getResultStatus()));
                this.journal.endJournal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processGet(GetRestRequest request, GetRestResponse response) throws Throwable {
        ResourceMetaData resource = null;
        try {
            if (this.journal != null) {
                this.journal.startJournal("RestProcess", this.editorFinder);
                if (this.sequence != null) {
                    String sequenceId = this.sequence.increment();
                    if (this.context != null) {
                        this.context.put(this.requestIdKey, sequenceId);
                    }
                    this.journal.setRequestId(sequenceId);
                } else if (this.context != null) {
                    this.journal.setRequestId((String)this.context.get(this.requestIdKey));
                }
                this.journal.addInfo("RequestURI", request.getURI());
                this.journal.addInfo("Method", request.getRequest().getMethod());
            }
            if (!this.processCheckAccept(request, response)) {
                return;
            }
            List paths = ResourcePath.splitPath(request.getURI());
            resource = this.processFindResource(request, response, paths);
            if (resource == null) {
                return;
            }
            if (resource.getData == null) {
                response.setResult(405);
                return;
            }
            if (!this.processParsePathParameters(request, response, paths, resource)) {
                return;
            }
            if (!this.processCreateRequestObject(request, response, paths, resource, resource.getData.requestData)) {
                return;
            }
            if (!this.processSetupResponseObject(request, response, paths, resource, resource.getData.responseData)) {
                return;
            }
            if (!this.processReadQuery(request, response, paths, resource)) {
                return;
            }
            if (this.processValidateRequestObject(request, response, paths, resource) && !this.processExecute(request, response, paths, resource, this.getMethodFlowPostfix)) {
                return;
            }
            if (response.getResponseObject() == null && response.getResultStatus() == 200) {
                response.setResult(204);
            }
            this.processWriteResponseBody(request, response, paths, resource);
        }
        catch (Throwable th) {
            this.getLogger().write("BFRS_00031", new Object[]{resource == null ? request.getURI() : resource.resourcePath.path}, th);
            if (this.journal != null) {
                this.journal.addInfo("Exception", th);
            }
            response.setResult(500);
        }
        finally {
            if (this.journal != null) {
                this.journal.addInfo("ResultStatus", new Integer(response.getResultStatus()));
                this.journal.endJournal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processHead(HeadRestRequest request, HeadRestResponse response) throws Throwable {
        ResourceMetaData resource = null;
        try {
            List paths;
            if (this.journal != null) {
                this.journal.startJournal("RestProcess", this.editorFinder);
                if (this.sequence != null) {
                    String sequenceId = this.sequence.increment();
                    if (this.context != null) {
                        this.context.put(this.requestIdKey, sequenceId);
                    }
                    this.journal.setRequestId(sequenceId);
                } else if (this.context != null) {
                    this.journal.setRequestId((String)this.context.get(this.requestIdKey));
                }
                this.journal.addInfo("RequestURI", request.getURI());
                this.journal.addInfo("Method", request.getRequest().getMethod());
            }
            if ((resource = this.processFindResource(request, response, paths = ResourcePath.splitPath(request.getURI()))) == null) {
                return;
            }
            if (resource.headData == null) {
                response.setResult(405);
                return;
            }
            if (!this.processParsePathParameters(request, response, paths, resource)) {
                return;
            }
            if (!this.processCreateRequestObject(request, response, paths, resource, resource.headData.requestData)) {
                return;
            }
            if (!this.processReadQuery(request, response, paths, resource)) {
                return;
            }
            if (this.processValidateRequestObject(request, response, paths, resource) && !this.processExecute(request, response, paths, resource, this.headMethodFlowPostfix)) {
                return;
            }
        }
        catch (Throwable th) {
            this.getLogger().write("BFRS_00031", new Object[]{resource == null ? request.getURI() : resource.resourcePath.path}, th);
            if (this.journal != null) {
                this.journal.addInfo("Exception", th);
            }
            response.setResult(500);
        }
        finally {
            if (this.journal != null) {
                this.journal.addInfo("ResultStatus", new Integer(response.getResultStatus()));
                this.journal.endJournal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPut(PutRestRequest request, PutRestResponse response) throws Throwable {
        ResourceMetaData resource = null;
        try {
            if (this.journal != null) {
                this.journal.startJournal("RestProcess", this.editorFinder);
                if (this.sequence != null) {
                    String sequenceId = this.sequence.increment();
                    if (this.context != null) {
                        this.context.put(this.requestIdKey, sequenceId);
                    }
                    this.journal.setRequestId(sequenceId);
                } else if (this.context != null) {
                    this.journal.setRequestId((String)this.context.get(this.requestIdKey));
                }
                this.journal.addInfo("RequestURI", request.getURI());
                this.journal.addInfo("Method", request.getRequest().getMethod());
            }
            if (!this.processCheckAccept(request, response)) {
                return;
            }
            if (!this.processCheckContentType(request, response)) {
                return;
            }
            List paths = ResourcePath.splitPath(request.getURI());
            resource = this.processFindResource(request, response, paths);
            if (resource == null) {
                return;
            }
            if (resource.putData == null) {
                response.setResult(405);
                return;
            }
            if (!this.processParsePathParameters(request, response, paths, resource)) {
                return;
            }
            if (!this.processCreateRequestObject(request, response, paths, resource, resource.putData.requestData)) {
                return;
            }
            if (!this.processSetupResponseObject(request, response, paths, resource, resource.putData.responseData)) {
                return;
            }
            if (!this.processReadRequestBody(request, response, paths, resource)) {
                return;
            }
            if (this.processValidateRequestObject(request, response, paths, resource) && !this.processExecute(request, response, paths, resource, this.putMethodFlowPostfix)) {
                return;
            }
            this.processWriteResponseBody(request, response, paths, resource);
        }
        catch (Throwable th) {
            this.getLogger().write("BFRS_00031", new Object[]{resource == null ? request.getURI() : resource.resourcePath.path}, th);
            if (this.journal != null) {
                this.journal.addInfo("Exception", th);
            }
            response.setResult(500);
        }
        finally {
            if (this.journal != null) {
                this.journal.addInfo("ResultStatus", new Integer(response.getResultStatus()));
                this.journal.endJournal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDelete(DeleteRestRequest request, DeleteRestResponse response) throws Throwable {
        ResourceMetaData resource = null;
        try {
            if (this.journal != null) {
                this.journal.startJournal("RestProcess", this.editorFinder);
                if (this.sequence != null) {
                    String sequenceId = this.sequence.increment();
                    if (this.context != null) {
                        this.context.put(this.requestIdKey, sequenceId);
                    }
                    this.journal.setRequestId(sequenceId);
                } else if (this.context != null) {
                    this.journal.setRequestId((String)this.context.get(this.requestIdKey));
                }
                this.journal.addInfo("RequestURI", request.getURI());
                this.journal.addInfo("Method", request.getRequest().getMethod());
            }
            if (!this.processCheckAccept(request, response)) {
                return;
            }
            List paths = ResourcePath.splitPath(request.getURI());
            resource = this.processFindResource(request, response, paths);
            if (resource == null) {
                return;
            }
            if (resource.deleteData == null) {
                response.setResult(405);
                return;
            }
            if (!this.processParsePathParameters(request, response, paths, resource)) {
                return;
            }
            if (!this.processCreateRequestObject(request, response, paths, resource, resource.deleteData.requestData)) {
                return;
            }
            if (!this.processSetupResponseObject(request, response, paths, resource, resource.deleteData.responseData)) {
                return;
            }
            if (!this.processReadQuery(request, response, paths, resource)) {
                return;
            }
            if (this.processValidateRequestObject(request, response, paths, resource) && !this.processExecute(request, response, paths, resource, this.deleteMethodFlowPostfix)) {
                return;
            }
            this.processWriteResponseBody(request, response, paths, resource);
        }
        catch (Throwable th) {
            this.getLogger().write("BFRS_00031", new Object[]{resource == null ? request.getURI() : resource.resourcePath.path}, th);
            if (this.journal != null) {
                this.journal.addInfo("Exception", th);
            }
            response.setResult(500);
        }
        finally {
            if (this.journal != null) {
                this.journal.addInfo("ResultStatus", new Integer(response.getResultStatus()));
                this.journal.endJournal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processOptions(OptionsRestRequest request, OptionsRestResponse response) throws Throwable {
        ResourceMetaData resource = null;
        try {
            List paths;
            if (this.journal != null) {
                this.journal.startJournal("RestProcess", this.editorFinder);
                if (this.sequence != null) {
                    String sequenceId = this.sequence.increment();
                    if (this.context != null) {
                        this.context.put(this.requestIdKey, sequenceId);
                    }
                    this.journal.setRequestId(sequenceId);
                } else if (this.context != null) {
                    this.journal.setRequestId((String)this.context.get(this.requestIdKey));
                }
                this.journal.addInfo("RequestURI", request.getURI());
                this.journal.addInfo("Method", request.getRequest().getMethod());
            }
            if ((resource = this.processFindResource(request, response, paths = ResourcePath.splitPath(request.getURI()))) == null) {
                return;
            }
            if (resource.optionsData == null) {
                response.setResult(405);
                return;
            }
            if (resource.postData != null) {
                response.allowPost();
            }
            if (resource.getData != null) {
                response.allowGet();
            }
            if (resource.headData != null) {
                response.allowHead();
            }
            if (resource.putData != null) {
                response.allowPut();
            }
            if (resource.deleteData != null) {
                response.allowDelete();
            }
            response.allowOptions();
        }
        catch (Throwable th) {
            this.getLogger().write("BFRS_00031", new Object[]{resource == null ? request.getURI() : resource.resourcePath.path}, th);
            if (this.journal != null) {
                this.journal.addInfo("Exception", th);
            }
            response.setResult(500);
        }
        finally {
            if (this.journal != null) {
                this.journal.addInfo("ResultStatus", new Integer(response.getResultStatus()));
                this.journal.endJournal();
            }
        }
    }

    static {
        NimbusEntityResolver.registerDTD("-//Nimbus//DTD Nimbus RestServer definition 1.0//JA", "jp/ossc/nimbus/service/rest/restserver_1_0.dtd");
    }

    protected static class AcceptCharset {
        protected final List charsetRanges;

        public AcceptCharset(String header) throws IllegalArgumentException {
            String[] charsetRangeArray = header.split(",");
            this.charsetRanges = new ArrayList(charsetRangeArray.length);
            for (int i = 0; i < charsetRangeArray.length; ++i) {
                this.charsetRanges.add(new CharsetRange(charsetRangeArray[i]));
            }
            Collections.sort(this.charsetRanges, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((CharsetRange)o1).q == ((CharsetRange)o2).q ? 0 : (((CharsetRange)o1).q > ((CharsetRange)o2).q ? -1 : 1);
                }
            });
        }
    }

    protected static class Accept {
        protected final List mediaRanges;

        public Accept(String header) throws IllegalArgumentException {
            String[] mediaRangeArray = header.split(",");
            this.mediaRanges = new ArrayList(mediaRangeArray.length);
            for (int i = 0; i < mediaRangeArray.length; ++i) {
                this.mediaRanges.add(new MediaRange(mediaRangeArray[i]));
            }
            Collections.sort(this.mediaRanges, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((MediaRange)o1).q == ((MediaRange)o2).q ? 0 : (((MediaRange)o1).q > ((MediaRange)o2).q ? -1 : 1);
                }
            });
        }
    }

    protected static class CharsetRange
    extends HeaderValue {
        protected float q = 1.0f;

        public CharsetRange(String header) throws IllegalArgumentException {
            super(header);
            String qvalue = this.getParameter("q");
            if (qvalue != null) {
                try {
                    this.q = Float.parseFloat(qvalue);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("qvalue is illegal. q=" + qvalue);
                }
            }
        }

        public String getCharset() {
            return this.getValue();
        }

        public void setCharset(String charset) {
            this.setValue(charset);
        }
    }

    protected static class MediaRange
    extends MediaType {
        protected float q = 1.0f;

        public MediaRange(String header) throws IllegalArgumentException {
            super(header);
            String qvalue = this.getParameter("q");
            if (qvalue != null) {
                try {
                    this.q = Float.parseFloat(qvalue);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("qvalue is illegal. q=" + qvalue);
                }
            }
        }
    }

    protected static class ContentType
    extends MediaType {
        public ContentType(String mediaType, String charset) {
            this.setMediaType(mediaType);
            this.setCharset(charset);
        }

        public String getCharset() {
            return this.getParameter("charset");
        }

        public void setCharset(String charset) {
            this.setParameter("charset", charset);
        }
    }

    protected static class MediaType
    extends HeaderValue {
        public MediaType() {
        }

        public MediaType(String header) {
            super(header);
        }

        public String getMediaType() {
            return this.getValue();
        }

        public void setMediaType(String type) {
            this.setValue(type);
        }
    }

    protected static class HeaderValue {
        protected String value;
        protected Map parameters;
        protected int hashCode;

        public HeaderValue() {
        }

        public HeaderValue(String header) {
            String[] types = header.split(";");
            this.value = types[0].trim();
            this.hashCode = this.value.hashCode();
            if (types.length > 1) {
                this.parameters = new HashMap();
                for (int i = 1; i < types.length; ++i) {
                    String parameter = types[i].trim();
                    int index = parameter.indexOf(61);
                    if (index != -1) {
                        this.parameters.put(parameter.substring(0, index).toLowerCase(), parameter.substring(index + 1).toLowerCase());
                        continue;
                    }
                    this.parameters.put(parameter.toLowerCase(), null);
                }
                this.hashCode += this.parameters.hashCode();
            }
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String val) {
            this.value = val;
        }

        public String getParameter(String name) {
            return this.parameters == null ? null : (String)this.parameters.get(name);
        }

        public void setParameter(String name, String value) {
            if (this.parameters == null) {
                this.parameters = new HashMap();
            }
            this.parameters.put(name, value);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.value);
            if (this.parameters != null) {
                for (Map.Entry entry : this.parameters.entrySet()) {
                    buf.append(';').append(entry.getKey()).append('=').append(entry.getValue());
                }
            }
            return buf.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof HeaderValue)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            HeaderValue cmp = (HeaderValue)obj;
            if (!this.value.equals(cmp.value)) {
                return false;
            }
            return !(this.parameters == null && cmp.parameters != null || this.parameters != null && cmp.parameters == null) && (this.parameters == null || this.parameters.equals(cmp.parameters));
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    public static class OptionsMetaData
    extends MetaData {
        private static final long serialVersionUID = -9220229909119120614L;
        public static final String TAG_NAME = "options";

        public OptionsMetaData(ResourceMetaData parent) {
            super(parent);
        }

        @Override
        public void importXML(Element element) throws DeploymentException {
            super.importXML(element);
            if (!element.getTagName().equals(TAG_NAME)) {
                throw new DeploymentException("tag must be options : " + element.getTagName());
            }
        }
    }

    public static class DeleteMetaData
    extends MetaData {
        private static final long serialVersionUID = -3735047733753523513L;
        public static final String TAG_NAME = "delete";
        protected String description;
        protected RequestMetaData requestData;
        protected ResponseMetaData responseData;

        public DeleteMetaData(ResourceMetaData parent) {
            super(parent);
        }

        public String getDescription() {
            return this.description;
        }

        public RequestMetaData getRequestMetaData() {
            return this.requestData;
        }

        public ResponseMetaData getResponseMetaData() {
            return this.responseData;
        }

        @Override
        public void importXML(Element element) throws DeploymentException {
            Element responseElement;
            Element requestElement;
            super.importXML(element);
            if (!element.getTagName().equals(TAG_NAME)) {
                throw new DeploymentException("tag must be delete : " + element.getTagName());
            }
            Element descElement = DeleteMetaData.getOptionalChild(element, "description");
            if (descElement != null) {
                this.description = DeleteMetaData.getElementContent(descElement);
            }
            if ((requestElement = DeleteMetaData.getOptionalChild(element, "request")) != null) {
                this.requestData = new RequestMetaData(this);
                this.requestData.importXML(requestElement);
            }
            if ((responseElement = DeleteMetaData.getOptionalChild(element, "response")) != null) {
                this.responseData = new ResponseMetaData(this);
                this.responseData.importXML(responseElement);
            }
        }
    }

    public static class PutMetaData
    extends MetaData {
        private static final long serialVersionUID = -5753138646526386529L;
        public static final String TAG_NAME = "put";
        protected String description;
        protected RequestMetaData requestData;
        protected ResponseMetaData responseData;

        public PutMetaData(ResourceMetaData parent) {
            super(parent);
        }

        public String getDescription() {
            return this.description;
        }

        public RequestMetaData getRequestMetaData() {
            return this.requestData;
        }

        public ResponseMetaData getResponseMetaData() {
            return this.responseData;
        }

        @Override
        public void importXML(Element element) throws DeploymentException {
            Element responseElement;
            Element requestElement;
            super.importXML(element);
            if (!element.getTagName().equals(TAG_NAME)) {
                throw new DeploymentException("tag must be put : " + element.getTagName());
            }
            Element descElement = PutMetaData.getOptionalChild(element, "description");
            if (descElement != null) {
                this.description = PutMetaData.getElementContent(descElement);
            }
            if ((requestElement = PutMetaData.getOptionalChild(element, "request")) != null) {
                this.requestData = new RequestMetaData(this);
                this.requestData.importXML(requestElement);
            }
            if ((responseElement = PutMetaData.getOptionalChild(element, "response")) != null) {
                this.responseData = new ResponseMetaData(this);
                this.responseData.importXML(responseElement);
            }
        }
    }

    public static class HeadMetaData
    extends MetaData {
        private static final long serialVersionUID = -5269682659140303058L;
        public static final String TAG_NAME = "head";
        protected String description;
        protected RequestMetaData requestData;

        public HeadMetaData(ResourceMetaData parent) {
            super(parent);
        }

        public String getDescription() {
            return this.description;
        }

        public RequestMetaData getRequestMetaData() {
            return this.requestData;
        }

        @Override
        public void importXML(Element element) throws DeploymentException {
            Element requestElement;
            super.importXML(element);
            if (!element.getTagName().equals(TAG_NAME)) {
                throw new DeploymentException("tag must be head : " + element.getTagName());
            }
            Element descElement = HeadMetaData.getOptionalChild(element, "description");
            if (descElement != null) {
                this.description = HeadMetaData.getElementContent(descElement);
            }
            if ((requestElement = HeadMetaData.getOptionalChild(element, "request")) != null) {
                this.requestData = new RequestMetaData(this);
                this.requestData.importXML(requestElement);
            }
        }
    }

    public static class GetMetaData
    extends MetaData {
        private static final long serialVersionUID = -7298962823068474227L;
        public static final String TAG_NAME = "get";
        protected String description;
        protected RequestMetaData requestData;
        protected ResponseMetaData responseData;

        public GetMetaData(ResourceMetaData parent) {
            super(parent);
        }

        public String getDescription() {
            return this.description;
        }

        public RequestMetaData getRequestMetaData() {
            return this.requestData;
        }

        public ResponseMetaData getResponseMetaData() {
            return this.responseData;
        }

        @Override
        public void importXML(Element element) throws DeploymentException {
            Element responseElement;
            Element requestElement;
            super.importXML(element);
            if (!element.getTagName().equals(TAG_NAME)) {
                throw new DeploymentException("tag must be get : " + element.getTagName());
            }
            Element descElement = GetMetaData.getOptionalChild(element, "description");
            if (descElement != null) {
                this.description = GetMetaData.getElementContent(descElement);
            }
            if ((requestElement = GetMetaData.getOptionalChild(element, "request")) != null) {
                this.requestData = new RequestMetaData(this);
                this.requestData.importXML(requestElement);
            }
            if ((responseElement = GetMetaData.getOptionalChild(element, "response")) != null) {
                this.responseData = new ResponseMetaData(this);
                this.responseData.importXML(responseElement);
            }
        }
    }

    public static class PostMetaData
    extends MetaData {
        private static final long serialVersionUID = -6372696917063102603L;
        public static final String TAG_NAME = "post";
        protected String description;
        protected RequestMetaData requestData;
        protected ResponseMetaData responseData;

        public PostMetaData(ResourceMetaData parent) {
            super(parent);
        }

        public String getDescription() {
            return this.description;
        }

        public RequestMetaData getRequestMetaData() {
            return this.requestData;
        }

        public ResponseMetaData getResponseMetaData() {
            return this.responseData;
        }

        @Override
        public void importXML(Element element) throws DeploymentException {
            Element responseElement;
            Element requestElement;
            super.importXML(element);
            if (!element.getTagName().equals(TAG_NAME)) {
                throw new DeploymentException("tag must be post : " + element.getTagName());
            }
            Element descElement = PostMetaData.getOptionalChild(element, "description");
            if (descElement != null) {
                this.description = PostMetaData.getElementContent(descElement);
            }
            if ((requestElement = PostMetaData.getOptionalChild(element, "request")) != null) {
                this.requestData = new RequestMetaData(this);
                this.requestData.importXML(requestElement);
            }
            if ((responseElement = PostMetaData.getOptionalChild(element, "response")) != null) {
                this.responseData = new ResponseMetaData(this);
                this.responseData.importXML(responseElement);
            }
        }
    }

    public static class ResponseMetaData
    extends MetaData {
        private static final long serialVersionUID = 4090435433096913841L;
        public static final String TAG_NAME = "response";
        public static final String ATTRIBUTE_NAME_CODE = "code";
        protected String code;

        public ResponseMetaData(MetaData parent) {
            super(parent);
        }

        public String getClassName() {
            return this.code;
        }

        @Override
        public void importXML(Element element) throws DeploymentException {
            super.importXML(element);
            if (!element.getTagName().equals(TAG_NAME)) {
                throw new DeploymentException("tag must be response : " + element.getTagName());
            }
            this.code = ResponseMetaData.getUniqueAttribute(element, ATTRIBUTE_NAME_CODE);
        }
    }

    public static class RequestMetaData
    extends MetaData {
        private static final long serialVersionUID = 6894091068389999950L;
        public static final String TAG_NAME = "request";
        public static final String ATTRIBUTE_NAME_CODE = "code";
        protected String code;

        public RequestMetaData(MetaData parent) {
            super(parent);
        }

        public String getClassName() {
            return this.code;
        }

        @Override
        public void importXML(Element element) throws DeploymentException {
            super.importXML(element);
            if (!element.getTagName().equals(TAG_NAME)) {
                throw new DeploymentException("tag must be request : " + element.getTagName());
            }
            this.code = RequestMetaData.getUniqueAttribute(element, ATTRIBUTE_NAME_CODE);
        }
    }

    public static class ResourceMetaData
    extends MetaData {
        private static final long serialVersionUID = -9068306933796302144L;
        public static final String TAG_NAME = "resource";
        public static final String ATTRIBUTE_NAME_NAME = "name";
        public static final String DESCRIPTION_TAG_NAME = "description";
        protected ResourcePath resourcePath;
        protected PostMetaData postData;
        protected GetMetaData getData;
        protected HeadMetaData headData;
        protected PutMetaData putData;
        protected DeleteMetaData deleteData;
        protected OptionsMetaData optionsData;

        public ResourceMetaData(RestServerMetaData parent) {
            super(parent);
        }

        public ResourcePath getResourcePath() {
            return this.resourcePath;
        }

        public PostMetaData getPostMetaData() {
            return this.postData;
        }

        public GetMetaData getGetMetaData() {
            return this.getData;
        }

        public HeadMetaData getHeadMetaData() {
            return this.headData;
        }

        public PutMetaData getPutMetaData() {
            return this.putData;
        }

        public DeleteMetaData getDeleteMetaData() {
            return this.deleteData;
        }

        public OptionsMetaData getOptionsMetaData() {
            return this.optionsData;
        }

        @Override
        public void importXML(Element element) throws DeploymentException {
            Element optionsElement;
            Element deleteElement;
            Element putElement;
            Element headElement;
            Element getElement;
            super.importXML(element);
            if (!element.getTagName().equals(TAG_NAME)) {
                throw new DeploymentException("tag must be resource : " + element.getTagName());
            }
            String name = ResourceMetaData.getUniqueAttribute(element, ATTRIBUTE_NAME_NAME);
            try {
                this.resourcePath = new ResourcePath(name);
            }
            catch (IllegalArgumentException e) {
                throw new DeploymentException("Resource name is illegal. name=" + name, e);
            }
            Element postElement = ResourceMetaData.getOptionalChild(element, "post");
            if (postElement != null) {
                this.postData = new PostMetaData(this);
                this.postData.importXML(postElement);
            }
            if ((getElement = ResourceMetaData.getOptionalChild(element, "get")) != null) {
                this.getData = new GetMetaData(this);
                this.getData.importXML(getElement);
            }
            if ((headElement = ResourceMetaData.getOptionalChild(element, "head")) != null) {
                this.headData = new HeadMetaData(this);
                this.headData.importXML(headElement);
            }
            if ((putElement = ResourceMetaData.getOptionalChild(element, "put")) != null) {
                this.putData = new PutMetaData(this);
                this.putData.importXML(putElement);
            }
            if ((deleteElement = ResourceMetaData.getOptionalChild(element, "delete")) != null) {
                this.deleteData = new DeleteMetaData(this);
                this.deleteData.importXML(deleteElement);
            }
            if ((optionsElement = ResourceMetaData.getOptionalChild(element, "options")) != null) {
                this.optionsData = new OptionsMetaData(this);
                this.optionsData.importXML(optionsElement);
            }
        }
    }

    public static class RestServerMetaData
    extends MetaData {
        private static final long serialVersionUID = -8221854228229536891L;
        public static final String TAG_NAME = "restserver";
        protected List resources = new ArrayList();
        protected ResourceTree resourceTree = new ResourceTree();

        public List getResourceMetaDataList() {
            return this.resources;
        }

        @Override
        public void importXML(Element element) throws DeploymentException {
            super.importXML(element);
            if (!element.getTagName().equals(TAG_NAME)) {
                throw new DeploymentException("Root tag must be restserver : " + element.getTagName());
            }
            Iterator propElements = RestServerMetaData.getChildrenByTagName(element, "resource");
            while (propElements.hasNext()) {
                ResourceMetaData resourceData = new ResourceMetaData(this);
                resourceData.importXML((Element)propElements.next());
                this.resources.add(resourceData);
                this.resourceTree.addResource(resourceData);
            }
        }
    }

    public static class ResourcePath {
        protected String path;
        protected List pathElements = new ArrayList();
        protected List parameterPathIndex;

        public ResourcePath(String path) throws IllegalArgumentException {
            if (path.length() == 0) {
                throw new IllegalArgumentException("empty path : path=" + path);
            }
            this.path = path;
            List elements = ResourcePath.splitPath(path);
            for (int i = 0; i < elements.size(); ++i) {
                String element = (String)elements.get(i);
                if (ParameterPath.isParameterPath(element)) {
                    if (this.parameterPathIndex == null) {
                        this.parameterPathIndex = new ArrayList();
                    }
                    if (this.pathElements.size() == 0) {
                        throw new IllegalArgumentException("First path must not be parameter : path=" + path);
                    }
                    this.parameterPathIndex.add(new Integer(this.pathElements.size()));
                    this.pathElements.add(new ParameterPath(element));
                    continue;
                }
                this.pathElements.add(element);
            }
        }

        public String getPath() {
            return this.path;
        }

        public List getPathElementList() {
            return this.pathElements;
        }

        public int getParameterPathSize() {
            return this.parameterPathIndex == null ? 0 : this.parameterPathIndex.size();
        }

        public ParameterPath getParameterPathIndex(int index) {
            return this.parameterPathIndex == null || this.parameterPathIndex.size() <= index ? null : (ParameterPath)this.pathElements.get((Integer)this.parameterPathIndex.get(index));
        }

        public static List splitPath(String path) {
            String[] paths = path.split("/");
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < paths.length; ++i) {
                String p = paths[i];
                if (p.length() == 0) continue;
                result.add("/" + p);
            }
            return result;
        }

        public boolean hasParameterPath() {
            return this.parameterPathIndex != null;
        }

        public Map parseParameter(List paths, Map result) throws IndexOutOfBoundsException {
            if (!this.hasParameterPath()) {
                return result;
            }
            for (int i = 0; i < this.parameterPathIndex.size(); ++i) {
                Integer index = (Integer)this.parameterPathIndex.get(i);
                ParameterPath pp = (ParameterPath)this.pathElements.get(index);
                result = pp.parseParameter((String)paths.get(index), result);
            }
            return result;
        }

        public String toString() {
            return this.path;
        }

        public static class ParameterPath {
            protected static final Pattern PARAMETER_PATTERN = Pattern.compile("\\{.+?\\}");
            protected final String path;
            protected final int paramCount;
            protected List paramElements = new ArrayList();

            public ParameterPath(String path) throws IllegalArgumentException {
                this.path = path;
                Matcher m = PARAMETER_PATTERN.matcher(path);
                int offset = 0;
                int count = 0;
                while (m.find()) {
                    if (offset != 0 || m.start() == offset) {
                        throw new IllegalArgumentException("deletemer not exists. path=" + path);
                    }
                    this.paramElements.add(path.substring(offset, m.start()));
                    this.paramElements.add(new ParameterElement(m.group()));
                    ++count;
                    offset = m.end();
                }
                if (offset != path.length()) {
                    this.paramElements.add(path.substring(offset));
                }
                this.paramCount = count;
            }

            public String getPath() {
                return this.path;
            }

            public int getParameterCount() {
                return this.paramCount;
            }

            public List getParameterElementList() {
                return this.paramElements;
            }

            public Map parseParameter(String path, Map result) throws IndexOutOfBoundsException {
                if (result == null) {
                    result = new LinkedHashMap<String, String>();
                }
                int offset = 0;
                ParameterElement prePe = null;
                for (int i = 0; i < this.paramElements.size(); ++i) {
                    Object element = this.paramElements.get(i);
                    if (prePe == null) {
                        if (element instanceof String) {
                            offset += ((String)element).length();
                            continue;
                        }
                        prePe = (ParameterElement)element;
                        continue;
                    }
                    result.put(prePe.name, path.substring(offset, path.indexOf((String)element, offset)));
                    offset += ((String)element).length();
                    prePe = null;
                }
                if (prePe != null) {
                    result.put(prePe.name, path.substring(offset));
                }
                return result;
            }

            public String toString() {
                return this.path;
            }

            public int hashCode() {
                return this.path.hashCode();
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof ParameterPath)) {
                    return false;
                }
                return this.path.equals(((ParameterPath)obj).path);
            }

            public static boolean isParameterPath(String path) {
                Matcher m = PARAMETER_PATTERN.matcher(path);
                return m.find();
            }

            protected static class ParameterElement {
                protected final String name;

                public ParameterElement(String element) {
                    this.name = element.substring(1, element.length() - 1);
                }

                public String getName() {
                    return this.name;
                }
            }
        }
    }

    public static class ResourceTree {
        protected Map treeMap = new HashMap();

        public void addResource(ResourceMetaData resource) throws DeploymentException {
            ResourceTreeElement currentElement = null;
            int imax = resource.resourcePath.pathElements.size();
            for (int i = 0; i < imax; ++i) {
                Object pathElement = resource.resourcePath.pathElements.get(i);
                if (pathElement instanceof ResourcePath.ParameterPath) {
                    if (currentElement == null) {
                        throw new DeploymentException("Root path must not be parameter. resource=" + resource.resourcePath);
                    }
                    if (currentElement.parameterPath != null && !currentElement.parameterPath.equals(pathElement)) {
                        throw new DeploymentException("Resource is duplicated. resource1=" + currentElement.parameterChild.resource.resourcePath + ", resource2=" + resource.resourcePath);
                    }
                    if (currentElement.parameterPath == null) {
                        currentElement.parameterPath = (ResourcePath.ParameterPath)pathElement;
                        currentElement = currentElement.parameterChild = new ResourceTreeElement();
                    }
                } else {
                    String subPath;
                    Map currentMap = currentElement == null ? this.treeMap : currentElement.children;
                    if ((currentElement = (ResourceTreeElement)currentMap.get(subPath = (String)pathElement)) == null) {
                        currentElement = new ResourceTreeElement();
                        currentMap.put(subPath, currentElement);
                    }
                }
                if (i == imax - 1) {
                    if (currentElement.resource != null) {
                        throw new DeploymentException("Resource is duplicated. resource1=" + currentElement.resource.resourcePath + ", resource2=" + resource.resourcePath);
                    }
                    currentElement.resource = resource;
                    continue;
                }
                if (currentElement.children != null) continue;
                currentElement.children = new HashMap();
            }
        }

        public ResourceMetaData getResource(List paths) {
            ResourceTreeElement currentElement = null;
            int imax = paths.size();
            for (int i = 0; i < imax; ++i) {
                Map currentMap = currentElement == null ? this.treeMap : currentElement.children;
                ResourceTreeElement element = (ResourceTreeElement)currentMap.get(paths.get(i));
                if (element == null && currentElement != null && currentElement.parameterChild != null) {
                    element = currentElement.parameterChild;
                }
                if (element == null) {
                    return null;
                }
                if (i == imax - 1) {
                    return element.resource;
                }
                currentElement = element;
            }
            return null;
        }

        public static class ResourceTreeElement {
            public ResourceMetaData resource;
            public ResourcePath.ParameterPath parameterPath;
            public ResourceTreeElement parameterChild;
            public Map children;
        }
    }

    protected class MyErrorHandler
    implements ErrorHandler {
        private boolean isError;

        protected MyErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            BeanFlowRestServerService.this.getLogger().write("BFRS_00001", new Object[]{e.getMessage(), BeanFlowRestServerService.this.serverDefinitionPath, new Integer(e.getLineNumber()), new Integer(e.getColumnNumber())});
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.isError = true;
            BeanFlowRestServerService.this.getLogger().write("BFRS_00002", new Object[]{e.getMessage(), BeanFlowRestServerService.this.serverDefinitionPath, new Integer(e.getLineNumber()), new Integer(e.getColumnNumber())});
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.isError = true;
            BeanFlowRestServerService.this.getLogger().write("BFRS_00003", new Object[]{e.getMessage(), BeanFlowRestServerService.this.serverDefinitionPath, new Integer(e.getLineNumber()), new Integer(e.getColumnNumber())});
        }

        public boolean isError() {
            return this.isError;
        }
    }
}

