/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.io.CSVReader;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.scheduler2.BeanFlowScheduleExecutorService;
import jp.ossc.nimbus.service.scheduler2.ConcentrateBackupException;
import jp.ossc.nimbus.service.scheduler2.ConcentrateBackupManager;
import jp.ossc.nimbus.service.scheduler2.ConcentrateRequest;
import jp.ossc.nimbus.service.scheduler2.ConcentrateResponse;
import jp.ossc.nimbus.service.scheduler2.ConcentrateScheduleExecutorServiceMBean;
import jp.ossc.nimbus.service.scheduler2.Schedule;

public class ConcentrateScheduleExecutorService
extends BeanFlowScheduleExecutorService
implements ConcentrateScheduleExecutorServiceMBean {
    private static final long serialVersionUID = -2690240488435859910L;
    protected ServiceName concentrateBackupManagerServiceName;
    protected ConcentrateBackupManager concentrateBackupManager;

    public ConcentrateScheduleExecutorService() {
        this.type = "CONCENTRATE";
    }

    @Override
    public void setConcentrateBackupManagerServiceName(ServiceName name) {
        this.concentrateBackupManagerServiceName = name;
    }

    @Override
    public ServiceName getConcentrateBackupManagerServiceName() {
        return this.concentrateBackupManagerServiceName;
    }

    public void setConcentrateBackupManager(ConcentrateBackupManager manager) {
        this.concentrateBackupManager = manager;
    }

    public ConcentrateBackupManager getConcentrateBackupManager() {
        return this.concentrateBackupManager;
    }

    @Override
    public void startService() throws Exception {
        if (this.concentrateBackupManagerServiceName != null) {
            this.concentrateBackupManager = (ConcentrateBackupManager)ServiceManagerFactory.getServiceObject(this.concentrateBackupManagerServiceName);
        }
        super.startService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Schedule executeInternal(Schedule schedule) throws Throwable {
        block38: {
            Object rawInput = schedule.getInput();
            try {
                File rootDir;
                ConcentrateRequest request = null;
                ConcentrateResponse response = null;
                if (rawInput instanceof String) {
                    String inputStr = (String)rawInput;
                    String[] params = CSVReader.toArray(inputStr, ',', '\\', '\"', "", null, true, false, true, false);
                    if (params.length != 3) {
                        throw new IllegalArgumentException("Input is illegal : " + rawInput);
                    }
                    String key = this.toKey(schedule);
                    int processType = ConcentrateRequest.toProcessType(params[0]);
                    if (processType == 0) {
                        throw new IllegalArgumentException("ProcessType is illegal : " + rawInput);
                    }
                    String source = params[1];
                    if (source == null || source.length() == 0) {
                        throw new IllegalArgumentException("Source is null : " + rawInput);
                    }
                    String dest = params[2];
                    if (dest == null || dest.length() == 0) {
                        throw new IllegalArgumentException("Destination is null : " + rawInput);
                    }
                    request = new ConcentrateRequest(key, processType, source, dest);
                    schedule.setInput(request);
                } else if (rawInput instanceof Map) {
                    Map jsonMap = (Map)rawInput;
                    String key = this.toKey(schedule);
                    int processType = ConcentrateRequest.toProcessType((String)jsonMap.get("processType"));
                    if (processType == 0) {
                        throw new IllegalArgumentException("ProcessType is illegal : " + rawInput);
                    }
                    String source = (String)jsonMap.get("source");
                    if (source == null || source.length() == 0) {
                        throw new IllegalArgumentException("Source is null : " + rawInput);
                    }
                    String dest = (String)jsonMap.get("destination");
                    if (dest == null || dest.length() == 0) {
                        throw new IllegalArgumentException("Destination is null : " + rawInput);
                    }
                    request = new ConcentrateRequest(key, processType, source, dest);
                    schedule.setInput(request);
                }
                response = new ConcentrateResponse();
                schedule.setOutput(response);
                schedule = super.executeInternal(schedule);
                Object output = schedule.getOutput();
                if (request == null || output == null || !(output instanceof ConcentrateResponse)) break block38;
                response = (ConcentrateResponse)output;
                if (response.getOutput() != null) {
                    schedule.setOutput(response.getOutput());
                }
                File[] files = response.getFiles();
                String rootDirPath = response.getRootDirectory();
                File file = rootDir = rootDirPath == null ? null : new File(rootDirPath);
                if (files != null && files.length != 0) {
                    if (this.concentrateBackupManager != null) {
                        Object result = null;
                        for (int i = 0; i < files.length; ++i) {
                            File file2 = files[i];
                            Date date = response.getDate(file2);
                            String key = response.getKey(file2);
                            boolean isCompressed = response.getFileCompressed(file2);
                            if (rootDir != null && !file2.isAbsolute()) {
                                file2 = new File(rootDir, file2.getPath());
                            }
                            result = response.getGroup() == null && date == null && key == null ? this.concentrateBackupManager.backup(this.toFlowName(schedule), null, ConcentrateRequest.toProcessTypeString(request.getProcessType()), file2, isCompressed, result) : this.concentrateBackupManager.backup(response.getGroup(), date, key, file2, isCompressed, result);
                        }
                        if (response.getOutput() == null) {
                            schedule.setOutput(result);
                        }
                    } else if (response.getOutput() == null) {
                        ArrayList<File> list = new ArrayList<File>();
                        for (int i = 0; i < files.length; ++i) {
                            list.add(files[i]);
                        }
                        schedule.setOutput(list);
                    }
                    File dir = null;
                    switch (request.getProcessType()) {
                        case 1: {
                            File destFile = new File(request.getDestination());
                            String tmpDest = request.getDestination().replaceAll("\\\\", "/");
                            if (files.length == 1 && !tmpDest.endsWith("/")) {
                                if (files[0].exists()) {
                                    dir = destFile.getParentFile();
                                    if (dir != null && !dir.exists()) {
                                        dir.mkdirs();
                                    }
                                    files[0].renameTo(destFile);
                                    break;
                                }
                            } else {
                                File destDir = destFile;
                                if (destDir != null && !destDir.exists()) {
                                    destDir.mkdirs();
                                }
                                for (int i = 0; i < files.length; ++i) {
                                    File file3 = files[i];
                                    File targetFile = null;
                                    if (rootDir == null) {
                                        targetFile = file3;
                                        destFile = new File(destDir, file3.getName());
                                    } else {
                                        String rootPath;
                                        targetFile = file3.isAbsolute() ? file3.getCanonicalFile() : new File(rootDir, file3.getPath()).getCanonicalFile();
                                        String targetPath = targetFile.getPath();
                                        if (!targetPath.startsWith(rootPath = rootDir.getCanonicalPath())) {
                                            throw new ConcentrateBackupException("File not exists in root directory. file=" + targetPath + ", rootDir=" + rootPath);
                                        }
                                        destFile = new File(destDir, targetPath.substring(rootPath.length()));
                                        dir = destFile.getParentFile();
                                        if (dir != null && !dir.exists()) {
                                            dir.mkdirs();
                                        }
                                    }
                                    if (!targetFile.exists()) continue;
                                    targetFile.renameTo(destFile);
                                }
                            }
                            break block38;
                        }
                        default: {
                            if (response.isClean()) {
                                for (int i = 0; i < files.length; ++i) {
                                    if (!files[i].exists()) continue;
                                    files[i].delete();
                                }
                            }
                            break block38;
                        }
                    }
                    break block38;
                }
                if (response.getOutput() == null) {
                    schedule.setOutput(null);
                }
            }
            finally {
                schedule.setInput(rawInput);
            }
        }
        return schedule;
    }

    @Override
    protected void checkPreExecute(Schedule schedule) throws Exception {
        BeanFlowInvoker invoker = this.beanFlowInvokerFactory.createFlow(this.toFlowName(schedule));
        if (invoker == null) {
            throw new IllegalArgumentException("BeanFlow is not found : " + this.toFlowName(schedule));
        }
    }

    @Override
    protected BeanFlowInvoker getBeanFlowInvoker(Schedule schedule) throws Throwable {
        return this.beanFlowInvokerFactory.createFlow(this.toFlowName(schedule));
    }

    protected String toFlowName(Schedule schedule) {
        String flowName = schedule.getTaskName();
        int index = flowName.indexOf(58);
        if (index != -1) {
            flowName = flowName.substring(0, index);
        }
        return flowName;
    }

    protected String toKey(Schedule schedule) {
        String key = schedule.getTaskName();
        int index = key.indexOf(58);
        if (index != -1) {
            key = key.substring(index + 1);
        }
        return key;
    }
}

