/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.scheduler.DateEvaluator;
import jp.ossc.nimbus.service.scheduler2.DatabaseConditionScheduleMakerServiceMBean;
import jp.ossc.nimbus.service.scheduler2.DefaultScheduleMakerService;
import jp.ossc.nimbus.service.scheduler2.ScheduleMakeException;
import jp.ossc.nimbus.service.scheduler2.ScheduleMaster;

public class DatabaseConditionScheduleMakerService
extends DefaultScheduleMakerService
implements DateEvaluator,
DatabaseConditionScheduleMakerServiceMBean {
    private static final long serialVersionUID = -5158949647626532438L;
    protected ServiceName connectionFactoryServiceName;
    protected ConnectionFactory connectionFactory;
    protected String query;
    protected String dateFormat;

    @Override
    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    @Override
    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    @Override
    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public void startService() throws Exception {
        if (this.connectionFactoryServiceName != null) {
            this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
        }
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("ConnectionFactory is null.");
        }
        if (this.query == null) {
            throw new IllegalArgumentException("Query is null.");
        }
    }

    public void setConnectionFactory(ConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    protected boolean isNecessaryMake(java.util.Date date, ScheduleMaster master) throws ScheduleMakeException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleMakeException(e);
        }
        boolean result = false;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement(this.query);
            ParameterMetaData paramData = st.getParameterMetaData();
            if (paramData == null) {
                if (this.dateFormat == null) {
                    st.setDate(1, new Date(date.getTime()));
                } else {
                    st.setString(1, new SimpleDateFormat(this.dateFormat).format(date));
                }
            } else {
                for (int i = 0; i < paramData.getParameterCount(); ++i) {
                    if (this.dateFormat == null) {
                        st.setDate(i + 1, new Date(date.getTime()));
                        continue;
                    }
                    st.setString(i + 1, new SimpleDateFormat(this.dateFormat).format(date));
                }
            }
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleMakeException("Size of ResultSet is 0.");
            }
            Object ret = rs.getObject(1);
            if (rs.wasNull()) {
                throw new ScheduleMakeException("Result value is null.");
            }
            result = ret instanceof Boolean ? (Boolean)ret : (ret instanceof Number ? ((Number)ret).intValue() != 0 : !"0".equals(ret.toString()));
        }
        catch (SQLException e) {
            throw new ScheduleMakeException(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return result;
    }

    @Override
    public boolean equalsDate(String key, Calendar cal) throws Exception {
        return this.isNecessaryMake(cal.getTime(), null);
    }
}

