/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.transaction;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.transaction.JndiTransactionManagerFactoryServiceMBean;
import jp.ossc.nimbus.service.transaction.TransactionManagerFactory;
import jp.ossc.nimbus.service.transaction.TransactionManagerFactoryException;

public class JndiTransactionManagerFactoryService
extends ServiceBase
implements JndiTransactionManagerFactoryServiceMBean,
TransactionManagerFactory {
    private static final long serialVersionUID = -3095915948460748531L;
    private String transactionManagerName = "java:/TransactionManager";
    private ServiceName jndiFinderServiceName;
    private JndiFinder jndiFinder;
    private TransactionManager transactionManager;

    @Override
    public void setTransactionManagerName(String name) {
        this.transactionManagerName = name;
    }

    @Override
    public String getTransactionManagerName() {
        return this.transactionManagerName;
    }

    @Override
    public void setJndiFinderServiceName(ServiceName name) {
        this.jndiFinderServiceName = name;
    }

    @Override
    public ServiceName getJndiFinderServiceName() {
        return this.jndiFinderServiceName;
    }

    @Override
    public void startService() throws Exception {
        if (this.jndiFinderServiceName != null) {
            this.jndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.jndiFinderServiceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionManager getTransactionManager() throws TransactionManagerFactoryException {
        if (this.transactionManager == null) {
            JndiTransactionManagerFactoryService jndiTransactionManagerFactoryService = this;
            synchronized (jndiTransactionManagerFactoryService) {
                if (this.transactionManager == null) {
                    try {
                        if (this.getJndiFinder() == null) {
                            InitialContext context = new InitialContext();
                            this.transactionManager = (TransactionManager)context.lookup(this.getTransactionManagerName());
                        } else {
                            this.transactionManager = (TransactionManager)this.getJndiFinder().lookup(this.getTransactionManagerName());
                        }
                    }
                    catch (NamingException e) {
                        throw new TransactionManagerFactoryException(e);
                    }
                }
            }
        }
        return this.transactionManager;
    }

    public void setJndiFinder(JndiFinder finder) {
        this.jndiFinder = finder;
    }

    public JndiFinder getJndiFinder() {
        return this.jndiFinder;
    }
}

