/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.validator;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.validator.BeanFlowValidatorServiceMBean;
import jp.ossc.nimbus.util.ClassMappingTree;
import jp.ossc.nimbus.util.validator.ValidateException;
import jp.ossc.nimbus.util.validator.Validator;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

public class BeanFlowValidatorService
extends ServiceBase
implements Validator,
BeanFlowValidatorServiceMBean {
    private static final long serialVersionUID = -5396783198786410663L;
    private Map classMapping;
    private ClassMappingTree classMap;
    private String[] conditions;
    private List conditionList;
    private String defaultBeanFlowKey;
    private ServiceName beanFlowInvokerFactoryServiceName;
    private BeanFlowInvokerFactory beanFlowInvokerFactory;

    @Override
    public void setClassMapping(Map mapping) {
        this.classMapping = mapping;
    }

    @Override
    public Map getClassMapping() {
        return this.classMapping;
    }

    @Override
    public void setConditions(String[] conditions) {
        this.conditions = conditions;
    }

    @Override
    public String[] getConditions() {
        return this.conditions;
    }

    @Override
    public void setDefaultBeanFlowKey(String beanFlowKey) {
        this.defaultBeanFlowKey = beanFlowKey;
    }

    @Override
    public String getDefaultBeanFlowKey() {
        return this.defaultBeanFlowKey;
    }

    @Override
    public void setBeanFlowInvokerFactoryServiceName(ServiceName name) {
        this.beanFlowInvokerFactoryServiceName = name;
    }

    @Override
    public ServiceName getBeanFlowInvokerFactoryServiceName() {
        return this.beanFlowInvokerFactoryServiceName;
    }

    public void setBeanFlowInvokerFactory(BeanFlowInvokerFactory factory) {
        this.beanFlowInvokerFactory = factory;
    }

    public BeanFlowInvokerFactory getBeanFlowInvokerFactory() {
        return this.beanFlowInvokerFactory;
    }

    @Override
    public void startService() throws Exception {
        if (this.beanFlowInvokerFactoryServiceName != null) {
            this.beanFlowInvokerFactory = (BeanFlowInvokerFactory)ServiceManagerFactory.getServiceObject(this.beanFlowInvokerFactoryServiceName);
        }
        if (this.beanFlowInvokerFactory == null) {
            throw new IllegalArgumentException("BeanFlowInvoker is null.");
        }
        Set flowKeySet = this.beanFlowInvokerFactory.getBeanFlowKeySet();
        if (this.classMapping != null && this.classMapping.size() != 0) {
            this.classMap = new ClassMappingTree(null);
            for (Map.Entry entry : this.classMapping.entrySet()) {
                Class clazz = Utility.convertStringToClass((String)entry.getKey());
                String beanFlowKey = (String)entry.getValue();
                if (!flowKeySet.contains(beanFlowKey)) {
                    throw new IllegalArgumentException("BeanFlow is not found : " + beanFlowKey);
                }
                this.classMap.add(clazz, beanFlowKey);
            }
        } else if (this.classMap != null) {
            this.classMap.clear();
        }
        if (this.conditions != null && this.conditions.length != 0) {
            if (this.conditionList != null) {
                this.conditionList.clear();
            } else {
                this.conditionList = new ArrayList();
            }
            for (int i = 0; i < this.conditions.length; ++i) {
                String condition = this.conditions[i];
                int index = condition.lastIndexOf(61);
                if (index == 0 || index == -1 || index == condition.length() - 1) {
                    throw new IllegalArgumentException("Condition is illegal : " + condition);
                }
                String cond = condition.substring(0, index);
                String beanFlowKey = condition.substring(index + 1);
                if (!flowKeySet.contains(beanFlowKey)) {
                    throw new IllegalArgumentException("BeanFlow is not found : " + beanFlowKey);
                }
                this.conditionList.add(new Condition(cond, beanFlowKey));
            }
        } else if (this.conditionList != null) {
            this.conditionList.clear();
        }
        if (this.defaultBeanFlowKey != null && !flowKeySet.contains(this.defaultBeanFlowKey)) {
            throw new IllegalArgumentException("BeanFlow is not found : " + this.defaultBeanFlowKey);
        }
        if (!(this.classMapping != null && this.classMapping.size() != 0 || this.conditionList != null && this.conditionList.size() != 0 || this.defaultBeanFlowKey != null)) {
            throw new IllegalArgumentException("BeanFlowKey is not specified.");
        }
    }

    @Override
    public boolean validate(Object obj) throws ValidateException {
        String beanFlowKey = null;
        if (obj != null && this.classMap != null) {
            beanFlowKey = (String)this.classMap.getValue(obj.getClass());
        }
        if (beanFlowKey == null && this.conditionList != null && this.conditionList.size() != 0) {
            int imax = this.conditionList.size();
            for (int i = 0; i < imax; ++i) {
                Condition condition = (Condition)this.conditionList.get(i);
                if (!condition.evaluate(obj)) continue;
                beanFlowKey = condition.beanFlowKey;
                break;
            }
        }
        if (beanFlowKey == null) {
            beanFlowKey = this.defaultBeanFlowKey;
        }
        if (beanFlowKey == null) {
            throw new ValidateException("Validate BeanFlow is not found.");
        }
        try {
            Object ret = this.beanFlowInvokerFactory.createFlow(beanFlowKey).invokeFlow(obj);
            if (ret == null || !(ret instanceof Boolean)) {
                throw new ValidateException("Result of BeanFlow is not boolean.");
            }
            return (Boolean)ret;
        }
        catch (Exception e) {
            throw new ValidateException(e);
        }
    }

    private static class Condition
    implements Serializable {
        private static final long serialVersionUID = -9155271482408748880L;
        public String beanFlowKey;
        private transient List properties;
        private transient Expression expression;
        private transient List keyList;
        private String condition;
        private static final String DELIMITER = "@";
        private static final String VALUE = "value";

        Condition(String cond, String beanFlowKey) throws Exception {
            this.initCondition(cond);
            this.condition = cond;
            this.beanFlowKey = beanFlowKey;
        }

        private void initCondition(String cond) throws Exception {
            this.keyList = new ArrayList();
            this.properties = new ArrayList();
            StringTokenizer token = new StringTokenizer(cond, DELIMITER, true);
            boolean keyFlg = false;
            String beforeToken = null;
            StringBuffer condBuf = new StringBuffer();
            while (token.hasMoreTokens()) {
                String str = token.nextToken();
                if (!keyFlg) {
                    if (DELIMITER.equals(str)) {
                        keyFlg = true;
                    } else {
                        condBuf.append(str);
                    }
                } else if (DELIMITER.equals(str)) {
                    keyFlg = false;
                    if (beforeToken != null) {
                        String tmpKey = "_conditionKey$" + this.keyList.size();
                        this.keyList.add(tmpKey);
                        condBuf.append(tmpKey);
                        Property prop = PropertyFactory.createProperty(beforeToken);
                        prop.setIgnoreNullProperty(true);
                        this.properties.add(prop);
                    } else {
                        condBuf.append(str);
                    }
                }
                beforeToken = str;
            }
            this.expression = ExpressionFactory.createExpression((String)condBuf.toString());
            this.evaluate("", true);
        }

        public boolean evaluate(Object object) throws ValidateException {
            return this.evaluate(object, false);
        }

        protected boolean evaluate(Object object, boolean isTest) throws ValidateException {
            JexlContext jexlContext = JexlHelper.createContext();
            jexlContext.getVars().put(VALUE, object);
            if (object != null) {
                int size = this.keyList.size();
                for (int i = 0; i < size; ++i) {
                    String keyString = (String)this.keyList.get(i);
                    Property property = (Property)this.properties.get(i);
                    Object val = null;
                    try {
                        val = property.getProperty(object);
                    }
                    catch (NoSuchPropertyException noSuchPropertyException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    jexlContext.getVars().put(keyString, val);
                }
            }
            try {
                Object exp = this.expression.evaluate(jexlContext);
                if (exp instanceof Boolean) {
                    return (Boolean)exp;
                }
                if (exp == null && isTest) {
                    return true;
                }
                throw new ValidateException(this.expression.getExpression());
            }
            catch (Exception e) {
                throw new ValidateException(e);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            try {
                this.initCondition(this.condition);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

