/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.websocket;

import javax.websocket.CloseReason;

public class CustomCloseReason
extends CloseReason {
    public CustomCloseReason(CloseReason.CloseCode closeCode, String reasonPhrase) {
        super(closeCode, reasonPhrase);
    }

    public static enum CloseCodes implements CloseReason.CloseCode
    {
        MAX_CLIENT_SIZE_OVER(4000),
        HANDSHAKE_AUTH_FAILED(4001),
        SERVER_ACCESS_DENIED(4002),
        SYSTEM_FORCED_DISCONNECTION(4999);

        private int code;

        private CloseCodes(int code) {
            this.code = code;
        }

        public static CloseReason.CloseCode getCloseCode(int code) {
            switch (code) {
                case 4000: {
                    return MAX_CLIENT_SIZE_OVER;
                }
                case 4001: {
                    return HANDSHAKE_AUTH_FAILED;
                }
                case 4002: {
                    return SERVER_ACCESS_DENIED;
                }
                case 4999: {
                    return SYSTEM_FORCED_DISCONNECTION;
                }
            }
            throw new IllegalArgumentException("Invalid close code: [" + code + "]");
        }

        public int getCode() {
            return this.code;
        }
    }
}

