/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceFactoryServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.queue.QueueHandler;
import jp.ossc.nimbus.service.queue.QueueHandlerContainer;
import jp.ossc.nimbus.service.queue.QueueHandlerContainerService;
import jp.ossc.nimbus.service.websocket.DefaultPingPongHandlerServiceMBean;
import jp.ossc.nimbus.service.websocket.SessionMessageHandler;
import jp.ossc.nimbus.service.websocket.SessionProperties;

public class DefaultPingPongHandlerService
extends ServiceFactoryServiceBase
implements DaemonRunnable,
DefaultPingPongHandlerServiceMBean {
    protected ServiceName pingSendQueueHandlerContainerServiceName;
    protected int queueHandlerSize = 1;
    protected String pingMessage = "";
    protected long pingSendInterval = 5000L;
    protected int maxRetryCount = 6;
    protected String pingSendErrorMessageId = "WS___00005";
    protected boolean isAllowNoPong = false;
    protected QueueHandlerContainer queue;
    protected Daemon daemon;
    protected Set sessionSet;
    protected ByteBuffer pingByteBuffer;

    @Override
    public ServiceName getPingSendQueueHandlerContainerServiceName() {
        return this.pingSendQueueHandlerContainerServiceName;
    }

    @Override
    public void setPingSendQueueHandlerContainerServiceName(ServiceName name) {
        this.pingSendQueueHandlerContainerServiceName = name;
    }

    @Override
    public int getQueueHandlerSize() {
        return this.queueHandlerSize;
    }

    @Override
    public void setQueueHandlerSize(int size) {
        this.queueHandlerSize = size;
    }

    @Override
    public String getPingMessage() {
        return this.pingMessage;
    }

    @Override
    public void setPingMessage(String message) {
        this.pingMessage = message;
    }

    @Override
    public long getPingSendInterval() {
        return this.pingSendInterval;
    }

    @Override
    public void setPingSendInterval(long interval) {
        this.pingSendInterval = interval;
    }

    @Override
    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    @Override
    public void setMaxRetryCount(int retryCount) {
        this.maxRetryCount = retryCount;
    }

    @Override
    public String getPingSendErrorMessageId() {
        return this.pingSendErrorMessageId;
    }

    @Override
    public void setPingSendErrorMessageId(String messageId) {
        this.pingSendErrorMessageId = messageId;
    }

    @Override
    public void createService() throws Exception {
        this.sessionSet = new HashSet();
        this.daemon = new Daemon(this);
        this.daemon.setName("Nimbus WebSocket PingSendAndPongCheckDaemon " + this.getServiceNameObject());
    }

    @Override
    public void startService() throws Exception {
        if (this.pingSendQueueHandlerContainerServiceName != null) {
            this.queue = (QueueHandlerContainer)ServiceManagerFactory.getServiceObject(this.pingSendQueueHandlerContainerServiceName);
        } else {
            QueueHandlerContainerService qhc = new QueueHandlerContainerService();
            qhc.setQueueHandlerSize(this.queueHandlerSize);
            qhc.setMaxRetryCount(3);
            this.queue = qhc;
        }
        this.pingByteBuffer = ByteBuffer.wrap(this.pingMessage.getBytes());
        this.queue.setQueueHandler(new PingSendQueueHandler());
        this.queue.accept();
        this.daemon.start();
    }

    @Override
    public void stopService() throws Exception {
        this.daemon.stop();
        if (this.queue != null) {
            this.queue.release();
            this.queue.stop();
        }
    }

    @Override
    public void destroyService() throws Exception {
        this.daemon = null;
        if (this.queue != null) {
            this.queue = null;
        }
    }

    @Override
    protected Service createServiceInstance() throws Exception {
        return new DefaultKeepAliveHandlerService();
    }

    @Override
    public boolean onStart() {
        return true;
    }

    @Override
    public boolean onStop() {
        return true;
    }

    @Override
    public boolean onSuspend() {
        return true;
    }

    @Override
    public boolean onResume() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object provide(DaemonControl ctrl) throws Throwable {
        if (this.getState() != 3) {
            return null;
        }
        try {
            ctrl.sleep(this.pingSendInterval, false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ArrayList<Session> list = new ArrayList<Session>();
        Set set = this.sessionSet;
        synchronized (set) {
            for (Session session : this.sessionSet) {
                SessionProperties prop = SessionProperties.getSessionProperty(session);
                if (!this.isPongReceive(prop)) {
                    CloseReason reason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, "PongReceiveCheck");
                    try {
                        session.close(reason);
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                if (prop == null || prop.getPingRequestTime() != -1L && (prop.getPingSendTime() == -1L || prop.getPingRequestTime() > prop.getPingSendTime())) continue;
                prop.setPingRequestTime(System.currentTimeMillis());
                list.add(session);
            }
        }
        return list;
    }

    @Override
    public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
        if (paramObj != null) {
            List list = (List)paramObj;
            for (int i = 0; i < list.size(); ++i) {
                this.queue.push(list.get(i));
            }
        }
    }

    @Override
    public void garbage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void regist(Session session) {
        Set set = this.sessionSet;
        synchronized (set) {
            this.sessionSet.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregist(Session session) {
        Set set = this.sessionSet;
        synchronized (set) {
            this.sessionSet.remove(session);
        }
    }

    private boolean isPongReceive(SessionProperties prop) {
        if (this.isAllowNoPong) {
            return true;
        }
        if (prop != null && prop.getPingSendTime() != -1L) {
            long lastReceivePongTime = prop.getPongReceiveTime();
            if (System.currentTimeMillis() > lastReceivePongTime + this.pingSendInterval * (long)this.maxRetryCount) {
                return false;
            }
        }
        return true;
    }

    protected class PingSendQueueHandler
    implements QueueHandler {
        protected PingSendQueueHandler() {
        }

        @Override
        public void handleDequeuedObject(Object obj) throws Throwable {
            if (obj == null) {
                return;
            }
            Session session = (Session)obj;
            try {
                if (session.isOpen()) {
                    session.getBasicRemote().sendPing(DefaultPingPongHandlerService.this.pingByteBuffer);
                }
            }
            finally {
                SessionProperties.getSessionProperty(session).setPingSendTime(System.currentTimeMillis());
            }
        }

        @Override
        public boolean handleError(Object obj, Throwable th) throws Throwable {
            Session session = (Session)obj;
            return session.isOpen();
        }

        @Override
        public void handleRetryOver(Object obj, Throwable th) throws Throwable {
            Session session = (Session)obj;
            if (session.isOpen()) {
                DefaultPingPongHandlerService.this.getLogger().write(DefaultPingPongHandlerService.this.pingSendErrorMessageId, SessionProperties.getSessionProperty(session), th);
            }
        }
    }

    public class DefaultKeepAliveHandlerService
    extends ServiceBase
    implements SessionMessageHandler,
    MessageHandler.Whole<PongMessage> {
        protected Session session;

        public void onMessage(PongMessage message) {
            SessionProperties.getSessionProperty(this.session).setPongReceiveTime(System.currentTimeMillis());
        }

        @Override
        public void onOpen(Session session, EndpointConfig config) {
            this.session = session;
            DefaultPingPongHandlerService.this.regist(session);
        }

        @Override
        public void onClose(Session session, CloseReason closeReason) {
            DefaultPingPongHandlerService.this.unregist(session);
            try {
                super.stopService();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void onError(Session session, Throwable thr) {
        }
    }
}

