/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.websocket;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.Set;
import javax.websocket.Session;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.websocket.ExceptionHandler;
import jp.ossc.nimbus.service.websocket.ExceptionHandlerMappingServiceMBean;
import jp.ossc.nimbus.util.ClassMappingTree;

public class ExceptionHandlerMappingService
extends ServiceBase
implements ExceptionHandlerMappingServiceMBean {
    private static final String SERVLET_EXCEPTION_NAME = "javax.servlet.ServletException";
    private static final String GET_ROOT_CAUSE_METHOD = "getRootCause";
    private static final String JMS_EXCEPTION_NAME = "javax.jms.JMSException";
    private static final String GET_LINKED_EXCEPTION_METHOD = "getLinkedException";
    protected Properties exceptionAndHandlerMapping;
    protected ClassMappingTree exceptionMapForHandler;
    protected ServiceName defaultExceptionHandlerServiceName;
    protected ExceptionHandler defaultExceptionHandler;

    @Override
    public void setExceptionAndHandlerMapping(Properties map) {
        this.exceptionAndHandlerMapping = map;
    }

    @Override
    public Properties getExceptionAndHandlerMapping() {
        return this.exceptionAndHandlerMapping;
    }

    @Override
    public void setDefaultExceptionHandlerServiceName(ServiceName name) {
        this.defaultExceptionHandlerServiceName = name;
    }

    @Override
    public ServiceName getDefaultExceptionHandlerServiceName() {
        return this.defaultExceptionHandlerServiceName;
    }

    @Override
    public void startService() throws Exception {
        NimbusClassLoader loader = NimbusClassLoader.getInstance();
        if (this.exceptionAndHandlerMapping != null) {
            this.exceptionMapForHandler = new ClassMappingTree();
            ServiceNameEditor editor = new ServiceNameEditor();
            editor.setServiceManagerName(this.getServiceManagerName());
            for (String string : this.exceptionAndHandlerMapping.keySet()) {
                Class<?> clazz = Class.forName(string, true, loader);
                String name = (String)this.exceptionAndHandlerMapping.get(string);
                editor.setAsText(name);
                ServiceName serviceName = (ServiceName)editor.getValue();
                this.exceptionMapForHandler.add(clazz, ServiceManagerFactory.getServiceObject(serviceName));
            }
        }
        if (this.defaultExceptionHandlerServiceName != null) {
            this.defaultExceptionHandler = (ExceptionHandler)ServiceManagerFactory.getServiceObject(this.defaultExceptionHandlerServiceName);
        }
    }

    protected ExceptionHandler getTargetExceptionHandlerCause(Throwable th) {
        ExceptionHandler handler = (ExceptionHandler)this.getTargetHandlerCause(this.exceptionMapForHandler, th);
        return handler == null ? this.defaultExceptionHandler : handler;
    }

    protected Object getTargetHandlerCause(ClassMappingTree handlers, Throwable th) {
        if (handlers == null) {
            return null;
        }
        Object handler = handlers.getValue(th.getClass());
        if (handler != null) {
            return handler;
        }
        Throwable cause = this.getCause(th);
        return cause == null ? null : this.getTargetHandlerCause(handlers, cause);
    }

    protected Throwable getTargetException(ClassMappingTree handlers, Throwable th) {
        if (handlers == null) {
            return th;
        }
        Object handler = handlers.getValue(th.getClass());
        if (handler != null) {
            return th;
        }
        Throwable cause = this.getCause(th);
        return cause == null ? null : this.getTargetException(handlers, cause);
    }

    protected boolean isIgnoreException(Set ignoreExceptions, Throwable th) {
        if (ignoreExceptions == null || ignoreExceptions.isEmpty()) {
            return false;
        }
        boolean isIgnore = ignoreExceptions.contains(th.getClass());
        if (isIgnore) {
            return true;
        }
        Throwable cause = this.getCause(th);
        return cause == null ? false : this.isIgnoreException(ignoreExceptions, cause);
    }

    protected Throwable getCause(Throwable th) {
        Throwable cause = null;
        String thClassName = th.getClass().getName();
        if (thClassName.equals(SERVLET_EXCEPTION_NAME)) {
            try {
                cause = (Throwable)th.getClass().getMethod(GET_ROOT_CAUSE_METHOD, null).invoke((Object)th, (Object[])null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        } else if (thClassName.equals(JMS_EXCEPTION_NAME)) {
            try {
                cause = (Exception)th.getClass().getMethod(GET_LINKED_EXCEPTION_METHOD, null).invoke((Object)th, (Object[])null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        } else {
            cause = th.getCause();
        }
        return cause == th ? null : cause;
    }

    public void handleException(Session session, Throwable th) throws Throwable {
        ExceptionHandler handler = this.getTargetExceptionHandlerCause(th);
        if (handler != null) {
            Throwable targetTh = this.getTargetException(this.exceptionMapForHandler, th);
            if (targetTh == null) {
                targetTh = th;
            }
            handler.handleException(session, targetTh);
        }
    }
}

