/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.websocket;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.websocket.AuthResult;
import jp.ossc.nimbus.service.websocket.AuthenticateException;
import jp.ossc.nimbus.service.websocket.SimpleTicketAuthenticatorServiceMBean;
import jp.ossc.nimbus.util.crypt.CryptParameters;
import jp.ossc.nimbus.util.crypt.FalsifiedParameterException;
import jp.ossc.nimbus.util.crypt.OverLimitExpiresException;

public class SimpleTicketAuthenticatorService
extends ServiceBase
implements SimpleTicketAuthenticatorServiceMBean {
    private static final long serialVersionUID = 8021761307165570160L;
    protected String idKey = "id";
    protected String ticketKey = "ticket";
    protected byte[] key = DEFAULT_KEY;
    protected String algorithm = "AES";
    protected String transformation = "AES/CBC/PKCS5Padding";
    protected int ivLength = 16;
    protected String provider;
    protected String hashKey = "DefaultHashKey99";
    protected long overLimitTime = -1L;
    private Map<String, String> idAndTicketMapping;
    protected CryptParameters wsCipher;

    @Override
    public void setTicketMapping(String id, String ticket) {
        if (this.idAndTicketMapping == null) {
            this.idAndTicketMapping = new HashMap<String, String>();
        }
        this.idAndTicketMapping.put(id, ticket);
    }

    @Override
    public String getTicketMapping(String id) {
        return this.idAndTicketMapping == null ? null : this.idAndTicketMapping.get(id);
    }

    @Override
    public Map getTicketMappings() {
        return this.idAndTicketMapping;
    }

    @Override
    public String getIdKey() {
        return this.idKey;
    }

    @Override
    public void setIdKey(String key) {
        this.idKey = key;
    }

    @Override
    public String getTicketKey() {
        return this.ticketKey;
    }

    @Override
    public void setTicketKey(String key) {
        this.ticketKey = key;
    }

    @Override
    public byte[] getKey() {
        return this.key;
    }

    @Override
    public void setKey(byte[] keyBytes) {
        this.key = keyBytes;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public void setAlgorithm(String paramAlgorithm) {
        this.algorithm = paramAlgorithm;
    }

    @Override
    public String getTransformation() {
        return this.transformation;
    }

    @Override
    public void setTransformation(String paramTransformation) {
        this.transformation = paramTransformation;
    }

    @Override
    public int getIvLength() {
        return this.ivLength;
    }

    @Override
    public void setIvLength(int length) {
        this.ivLength = length;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(String paramProvider) {
        this.provider = paramProvider;
    }

    @Override
    public String getHashKey() {
        return this.hashKey;
    }

    @Override
    public void setHashKey(String hash) {
        this.hashKey = hash;
    }

    @Override
    public long getOverLimitTime() {
        return this.overLimitTime;
    }

    @Override
    public void setOverLimitTime(long time) {
        this.overLimitTime = time;
    }

    @Override
    public void startService() throws Exception {
        this.wsCipher = new CryptParameters(this.key, this.algorithm, this.transformation, this.ivLength, this.provider, this.hashKey);
    }

    @Override
    public AuthResult login(HttpServletRequest req, HttpServletResponse res) throws AuthenticateException {
        AuthResult result = new AuthResult();
        String id = req.getParameter(this.idKey);
        result.setId(id);
        String ticket = req.getParameter(this.ticketKey);
        if (id == null) {
            throw new AuthenticateException("id is null");
        }
        if (ticket == null) {
            throw new AuthenticateException("ticket is null");
        }
        if (!ticket.equals(this.getTicketMapping(id))) {
            throw new AuthenticateException("Did not authenticated : " + id);
        }
        Map map = this.wsCipher.createParametersMap();
        map.put(this.idKey, id);
        map.put(this.ticketKey, ticket);
        String wsTicket = null;
        try {
            wsTicket = URLEncoder.encode(this.wsCipher.encrypt(null, map), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AuthenticateException(e);
        }
        result.setTicket(wsTicket);
        result.setResult(true);
        return result;
    }

    @Override
    public boolean handshake(String id, String ticket) throws AuthenticateException {
        try {
            if (id == null) {
                throw new AuthenticateException("id is null");
            }
            if (ticket == null) {
                throw new AuthenticateException("ticket is null");
            }
            Map map = null;
            map = this.overLimitTime != -1L ? this.wsCipher.decrypt(null, ticket, this.overLimitTime) : this.wsCipher.decrypt(null, ticket);
            String mapId = (String)map.get(this.idKey);
            String mapTicket = (String)map.get(this.ticketKey);
            if (!id.equals(mapId)) {
                throw new AuthenticateException("ticket is incorrect value. id:" + id + " ticket:" + ticket);
            }
        }
        catch (OverLimitExpiresException e) {
            throw new AuthenticateException(e);
        }
        catch (FalsifiedParameterException e) {
            throw new AuthenticateException(e);
        }
        return true;
    }

    @Override
    public void logout(String id, String ticket, boolean isForce) throws AuthenticateException {
    }
}

