/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.websocket;

import java.util.Map;
import javax.websocket.CloseReason;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.nimbus.service.websocket.AuthResult;
import jp.ossc.nimbus.service.websocket.WebSocketAccessJournalServiceMBean;

public class WebSocketAccessJournalService
extends ServiceBase
implements WebSocketAccessJournalServiceMBean {
    protected ServiceName journalServiceName;
    protected ServiceName requestEditorFinderServiceName;
    protected ServiceName sequenceServiceName;
    protected String accessJournalKey = "Access";
    protected String idJournalKey = "Id";
    protected String ticketJournalKey = "Ticket";
    protected String webSocketSessionIdJournalKey = "WebSocketSessionId";
    protected String httpSessionIdJournalKey = "HttpSessionId";
    protected String pathJournalKey = "Path";
    protected String ipJournalKey = "Ip";
    protected String portJournalKey = "Port";
    protected String headerJournalKey = "Header";
    protected String parameterJournalKey = "Parameter";
    protected String requestMessageJournalKey = "Message";
    protected String closeReasonJournalKey = "CloseReason";
    protected String authResultJournalKey = "CloseReason";
    protected String exceptionJournalKey = "Exception";
    protected Journal journal;
    protected EditorFinder editorFinder;
    protected Sequence sequence;

    @Override
    public void setJournalServiceName(ServiceName name) {
        this.journalServiceName = name;
    }

    @Override
    public ServiceName getJournalServiceName() {
        return this.journalServiceName;
    }

    @Override
    public void setEditorFinderServiceName(ServiceName name) {
        this.requestEditorFinderServiceName = name;
    }

    @Override
    public ServiceName getEditorFinderServiceName() {
        return this.requestEditorFinderServiceName;
    }

    @Override
    public void setAccessJournalKey(String key) {
        this.accessJournalKey = key;
    }

    @Override
    public String getAccessJournalKey() {
        return this.accessJournalKey;
    }

    @Override
    public void setIdJournalKey(String key) {
        this.idJournalKey = key;
    }

    @Override
    public String getIdJournalKey() {
        return this.idJournalKey;
    }

    @Override
    public void setTicketJournalKey(String key) {
        this.ticketJournalKey = key;
    }

    @Override
    public String getTicketJournalKey() {
        return this.ticketJournalKey;
    }

    @Override
    public void setWebSocketSessionIdJournalKey(String key) {
        this.webSocketSessionIdJournalKey = key;
    }

    @Override
    public String getWebSocketSessionIdJournalKey() {
        return this.webSocketSessionIdJournalKey;
    }

    @Override
    public String getHttpSessionIdJournalKey() {
        return this.httpSessionIdJournalKey;
    }

    @Override
    public void setHttpSessionIdJournalKey(String key) {
        this.httpSessionIdJournalKey = key;
    }

    @Override
    public String getPathJournalKey() {
        return this.pathJournalKey;
    }

    @Override
    public void setPathJournalKey(String key) {
        this.pathJournalKey = key;
    }

    @Override
    public String getIpJournalKey() {
        return this.ipJournalKey;
    }

    @Override
    public void setIpJournalKey(String key) {
        this.ipJournalKey = key;
    }

    @Override
    public String getPortJournalKey() {
        return this.portJournalKey;
    }

    @Override
    public void setPortJournalKey(String key) {
        this.portJournalKey = key;
    }

    @Override
    public void setRequestMessageJournalKey(String key) {
        this.requestMessageJournalKey = key;
    }

    @Override
    public String getRequestMessageJournalKey() {
        return this.requestMessageJournalKey;
    }

    @Override
    public void setCloseReasonJournalKey(String key) {
        this.closeReasonJournalKey = key;
    }

    @Override
    public String getCloseReasonJournalKey() {
        return this.closeReasonJournalKey;
    }

    @Override
    public void setAuthResultJournalKey(String key) {
        this.authResultJournalKey = key;
    }

    @Override
    public String getAuthResultJournalKey() {
        return this.authResultJournalKey;
    }

    @Override
    public void setExceptionJournalKey(String key) {
        this.exceptionJournalKey = key;
    }

    @Override
    public String getExceptionJournalKey() {
        return this.exceptionJournalKey;
    }

    @Override
    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    @Override
    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    @Override
    public void startService() throws Exception {
        if (this.journalServiceName != null) {
            this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalServiceName);
            if (this.requestEditorFinderServiceName != null) {
                this.editorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.requestEditorFinderServiceName);
            }
            if (this.sequenceServiceName != null) {
                this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
            } else {
                throw new IllegalArgumentException("SequenceServiceName is null.");
            }
        }
    }

    public void startJournal() {
        this.journal.startJournal(this.accessJournalKey, this.editorFinder);
        this.journal.setRequestId(this.sequence.increment());
    }

    public void endJournal() {
        this.journal.endJournal();
    }

    public boolean isStartJournal() {
        return this.journal.isStartJournal();
    }

    public void addIdInfo(String id) {
        this.journal.addInfo(this.idJournalKey, id);
    }

    public void addTicketInfo(String ticket) {
        this.journal.addInfo(this.ticketJournalKey, ticket);
    }

    public void addWebSocketSessionIdInfo(String webSocketSessionId) {
        this.journal.addInfo(this.webSocketSessionIdJournalKey, webSocketSessionId);
    }

    public void addHttpSessionIdInfo(String HttpSessionId) {
        this.journal.addInfo(this.httpSessionIdJournalKey, HttpSessionId);
    }

    public void addPathInfo(String path) {
        this.journal.addInfo(this.pathJournalKey, path);
    }

    public void addIpInfo(String ip) {
        this.journal.addInfo(this.ipJournalKey, ip);
    }

    public void addPortInfo(String port) {
        this.journal.addInfo(this.portJournalKey, port);
    }

    public void addHeaderInfo(Map header) {
        this.journal.addInfo(this.headerJournalKey, header.toString());
    }

    public void addParameterInfo(Map parameter) {
        this.journal.addInfo(this.parameterJournalKey, parameter.toString());
    }

    public void addRequestMessageInfo(String requestMessage) {
        this.journal.addInfo(this.requestMessageJournalKey, requestMessage);
    }

    public void addCloseReasonInfo(CloseReason closeReason) {
        this.journal.addInfo(this.closeReasonJournalKey, closeReason.toString());
    }

    public void addAuthResultInfo(AuthResult authResult) {
        this.journal.addInfo(this.authResultJournalKey, authResult.toString());
    }

    public void addExceptionMessageInfo(Exception e) {
        this.journal.addInfo(this.exceptionJournalKey, e);
    }
}

