/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.servlet;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.DefaultInterceptorChain;
import jp.ossc.nimbus.service.aop.DefaultThreadLocalInterceptorChain;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.Invoker;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;

public class InterceptorChainCallFilter
implements Filter,
Invoker {
    public static final String INIT_PARAM_NAME_INTERCEPTOR_CHAIN_LIST_SERVICE_NAME = "InterceptorChainListServiceName";
    public static final String INIT_PARAM_NAME_USE_THREAD_LOCAL_INTERCEPTOR_CHAIN = "UseThreadLocalInterceptorChain";
    protected boolean isUseThreadLocalInterceptorChain = true;
    protected InterceptorChain interceptorChain;

    public void init(FilterConfig filterConfig) throws ServletException {
        String isUseStr;
        ServiceNameEditor editor = new ServiceNameEditor();
        String name = filterConfig.getInitParameter(INIT_PARAM_NAME_INTERCEPTOR_CHAIN_LIST_SERVICE_NAME);
        ServiceName interceptorChainListServiceName = null;
        if (name != null) {
            editor.setAsText(name);
            interceptorChainListServiceName = (ServiceName)editor.getValue();
        }
        if ((isUseStr = filterConfig.getInitParameter(INIT_PARAM_NAME_USE_THREAD_LOCAL_INTERCEPTOR_CHAIN)) != null) {
            this.isUseThreadLocalInterceptorChain = Boolean.valueOf(isUseStr);
        }
        if (interceptorChainListServiceName != null) {
            if (this.isUseThreadLocalInterceptorChain) {
                DefaultThreadLocalInterceptorChain chain = new DefaultThreadLocalInterceptorChain(interceptorChainListServiceName, null);
                chain.setInvoker(this);
                this.interceptorChain = chain;
            } else {
                DefaultInterceptorChain chain = new DefaultInterceptorChain(interceptorChainListServiceName, null);
                chain.setInvoker(this);
                this.interceptorChain = chain;
            }
        }
    }

    public void destroy() {
        this.interceptorChain = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.interceptorChain == null) {
            chain.doFilter(request, response);
        } else {
            InterceptorChain localChain = this.interceptorChain;
            if (!this.isUseThreadLocalInterceptorChain) {
                localChain = localChain.cloneChain();
            }
            try {
                localChain.setCurrentInterceptorIndex(-1);
                localChain.invokeNext(new ServletFilterInvocationContext(request, response, chain));
            }
            catch (IOException e) {
                throw e;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error err) {
                throw err;
            }
            catch (Throwable th) {
                throw new UndeclaredThrowableException(th);
            }
            finally {
                localChain.setCurrentInterceptorIndex(-1);
            }
        }
    }

    @Override
    public Object invoke(InvocationContext context) throws Throwable {
        ServletFilterInvocationContext filterContext = (ServletFilterInvocationContext)context;
        filterContext.getFilterChain().doFilter(filterContext.getServletRequest(), filterContext.getServletResponse());
        return null;
    }
}

