/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.sql;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.nimbus.util.sql.CallableStatementWrapper;
import jp.ossc.nimbus.util.sql.ConnectionWrapper;
import jp.ossc.nimbus.util.sql.PreparedStatementWrapper;
import jp.ossc.nimbus.util.sql.StatementWrapper;

public class TransactionLoggingConnection
extends ConnectionWrapper {
    private static final long serialVersionUID = -1258743316970234356L;
    public static final String DEFAULT_TRANSACTION_TABLE_NAME = "TRANSACTION_LOG";
    public static final String TRANSACTION_TABLE_COLUMN_NAME_SEQNO = "SEQNO";
    public static final String TRANSACTION_TABLE_COLUMN_NAME_QUERY = "QUERY";
    public static final String TRANSACTION_TABLE_COLUMN_NAME_QUERY_TYPE = "QUERY_TYPE";
    public static final String TRANSACTION_TABLE_COLUMN_NAME_UPDATE_TIME = "UPDATE_TIME";
    public static final String TRANSACTION_TABLE_COLUMN_NAME_UPDATE_USER = "UPDATE_USER";
    public static final int QUERY_TYPE_STATEMENT = 1;
    public static final int QUERY_TYPE_PREPARED_STATEMENT = 2;
    public static final int QUERY_TYPE_CALLABLE_STATEMENT = 3;
    public static final String DEFAULT_TRANSACTION_PARAM_TABLE_NAME = "TRANSACTION_PARAMS_LOG";
    public static final String TRANSACTION_PARAM_TABLE_COLUMN_NAME_SEQNO = "SEQNO";
    public static final String TRANSACTION_PARAM_TABLE_COLUMN_NAME_PARAM_INDEX = "PARAM_INDEX";
    public static final String TRANSACTION_PARAM_TABLE_COLUMN_NAME_PARAM_NAME = "PARAM_NAME";
    public static final String TRANSACTION_PARAM_TABLE_COLUMN_NAME_PARAM_TYPE = "PARAM_TYPE";
    public static final String TRANSACTION_PARAM_TABLE_COLUMN_NAME_PARAM_LENGTH = "PARAM_LENGTH";
    public static final String TRANSACTION_PARAM_TABLE_COLUMN_NAME_PARAM = "PARAM";
    protected static final String LOCAL_HOST_NAME;
    protected String transactionTableName = "TRANSACTION_LOG";
    protected String transactionParamTableName = "TRANSACTION_PARAMS_LOG";
    protected PreparedStatement transactionInsertStatement;
    protected PreparedStatement transactionParamInsertStatement;
    protected ServiceName sequenceServiceName;
    protected Sequence sequence;
    protected String updateUser = LOCAL_HOST_NAME;
    protected boolean isBatch = true;

    public TransactionLoggingConnection(Connection con) {
        super(con);
    }

    public void setTransactionTableName(String name) {
        this.transactionTableName = name;
    }

    public void setTransactionParamTableName(String name) {
        this.transactionParamTableName = name;
    }

    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public void setUpdateUser(String name) {
        this.updateUser = name;
    }

    public void setBatch(boolean isBatch) {
        this.isBatch = isBatch;
    }

    protected synchronized void initTransactionStatement() throws SQLException {
        if (this.transactionInsertStatement != null && this.transactionParamInsertStatement != null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        if (this.transactionInsertStatement == null) {
            sql.append("insert into ");
            sql.append(this.transactionTableName);
            sql.append('(');
            sql.append("SEQNO");
            sql.append(',');
            sql.append(TRANSACTION_TABLE_COLUMN_NAME_QUERY);
            sql.append(',');
            sql.append(TRANSACTION_TABLE_COLUMN_NAME_QUERY_TYPE);
            sql.append(',');
            sql.append(TRANSACTION_TABLE_COLUMN_NAME_UPDATE_TIME);
            sql.append(',');
            sql.append(TRANSACTION_TABLE_COLUMN_NAME_UPDATE_USER);
            sql.append(") values(?, ?, ?, ?, ?)");
            this.transactionInsertStatement = super.createPreparedStatementWrapper(this.connection.prepareStatement(sql.toString()), sql.toString());
        }
        sql.setLength(0);
        if (this.transactionParamInsertStatement == null) {
            sql.append("insert into ");
            sql.append(this.transactionParamTableName);
            sql.append('(');
            sql.append("SEQNO");
            sql.append(',');
            sql.append(TRANSACTION_PARAM_TABLE_COLUMN_NAME_PARAM_INDEX);
            sql.append(',');
            sql.append(TRANSACTION_PARAM_TABLE_COLUMN_NAME_PARAM_NAME);
            sql.append(',');
            sql.append(TRANSACTION_PARAM_TABLE_COLUMN_NAME_PARAM_TYPE);
            sql.append(',');
            sql.append(TRANSACTION_PARAM_TABLE_COLUMN_NAME_PARAM_LENGTH);
            sql.append(',');
            sql.append(TRANSACTION_PARAM_TABLE_COLUMN_NAME_PARAM);
            sql.append(") values(?, ?, ?, ?, ?, ?)");
            this.transactionParamInsertStatement = super.createPreparedStatementWrapper(this.connection.prepareStatement(sql.toString()), sql.toString());
        }
    }

    protected void writeLog(String sql, int queryType) throws SQLException {
        this.writeLog(sql, queryType, null);
    }

    protected void writeLog(String sql, int queryType, PrepareValue[] params) throws SQLException {
        if (!this.isUpdateQuery(sql)) {
            return;
        }
        this.initTransactionStatement();
        Sequence sequence = this.sequence;
        if (sequence == null && this.sequenceServiceName != null) {
            try {
                sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
        }
        if (sequence == null) {
            throw new SQLException("Sequence is null.");
        }
        String seq = sequence.increment();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) continue;
                this.transactionParamInsertStatement.setString(1, seq);
                this.transactionParamInsertStatement.setInt(2, i + 1);
                this.setParam(params[i]);
                if (this.isBatch) {
                    this.transactionParamInsertStatement.addBatch();
                    continue;
                }
                this.transactionParamInsertStatement.executeUpdate();
            }
            if (this.isBatch && this.getAutoCommit()) {
                this.transactionParamInsertStatement.executeBatch();
            }
        }
        this.transactionInsertStatement.setString(1, seq);
        this.transactionInsertStatement.setCharacterStream(2, (Reader)new CharArrayReader(sql.toCharArray()), sql.length());
        this.transactionInsertStatement.setInt(3, queryType);
        this.transactionInsertStatement.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
        this.transactionInsertStatement.setString(5, this.updateUser);
        if (!this.isBatch || this.getAutoCommit()) {
            this.transactionInsertStatement.executeUpdate();
        } else {
            this.transactionInsertStatement.addBatch();
        }
    }

    private boolean isUpdateQuery(String sql) {
        if (sql == null) {
            return true;
        }
        int commandIndex = 0;
        int imax = sql.length();
        for (int i = 0; i < imax; ++i) {
            char c = sql.charAt(i);
            if (commandIndex == 0 && Character.isWhitespace(c)) continue;
            boolean isMatch = false;
            switch (commandIndex) {
                case 0: {
                    isMatch = c == 's' || c == 'S';
                    break;
                }
                case 1: {
                    isMatch = c == 'e' || c == 'E';
                    break;
                }
                case 2: {
                    isMatch = c == 'l' || c == 'L';
                    break;
                }
                case 3: {
                    isMatch = c == 'e' || c == 'E';
                    break;
                }
                case 4: {
                    isMatch = c == 'c' || c == 'C';
                    break;
                }
                case 5: {
                    isMatch = c == 't' || c == 'T';
                    break;
                }
                case 6: {
                    isMatch = Character.isWhitespace(c);
                }
            }
            if (!isMatch) break;
            if (commandIndex == 6) {
                return false;
            }
            ++commandIndex;
        }
        return true;
    }

    @Override
    public void commit() throws SQLException {
        try {
            if (this.transactionParamInsertStatement != null) {
                if (this.isBatch) {
                    this.transactionParamInsertStatement.executeBatch();
                }
                this.transactionParamInsertStatement.close();
            }
            if (this.transactionInsertStatement != null) {
                if (this.isBatch) {
                    this.transactionInsertStatement.executeBatch();
                }
                this.transactionInsertStatement.close();
            }
            super.commit();
        }
        finally {
            this.transactionParamInsertStatement = null;
            this.transactionInsertStatement = null;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.transactionParamInsertStatement != null) {
                if (this.isBatch) {
                    this.transactionParamInsertStatement.executeBatch();
                }
                this.transactionParamInsertStatement.close();
            }
            if (this.transactionInsertStatement != null) {
                if (this.isBatch) {
                    this.transactionInsertStatement.executeBatch();
                }
                this.transactionInsertStatement.close();
            }
            super.close();
        }
        finally {
            this.transactionParamInsertStatement = null;
            this.transactionInsertStatement = null;
        }
    }

    private void setParam(PrepareValue param) throws SQLException {
        if (param.name == null) {
            this.transactionParamInsertStatement.setNull(3, 12);
        } else {
            this.transactionParamInsertStatement.setString(3, param.name);
        }
        if (param.type == Integer.MIN_VALUE) {
            this.transactionParamInsertStatement.setNull(4, 4);
        } else {
            this.transactionParamInsertStatement.setInt(4, param.type);
        }
        switch (param.type) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                if (param.value == null) {
                    this.transactionParamInsertStatement.setNull(5, 4);
                    this.transactionParamInsertStatement.setNull(6, 2004);
                    break;
                }
                if (param.value instanceof byte[]) {
                    this.transactionParamInsertStatement.setInt(5, ((byte[])param.value).length);
                    this.transactionParamInsertStatement.setBinaryStream(6, (InputStream)new ByteArrayInputStream((byte[])param.value), ((byte[])param.value).length);
                    break;
                }
                if (param.value instanceof InputStream) {
                    this.transactionParamInsertStatement.setInt(5, param.length);
                    this.transactionParamInsertStatement.setBinaryStream(6, (InputStream)param.value, param.length);
                    break;
                }
                if (!(param.value instanceof Blob)) break;
                long len = ((Blob)param.value).length();
                if (len > Integer.MAX_VALUE) {
                    throw new SQLException("Not support large CLOB.");
                }
                this.transactionParamInsertStatement.setInt(5, (int)len);
                this.transactionParamInsertStatement.setBlob(6, (Blob)param.value);
                break;
            }
            case -1: 
            case 2005: {
                if (param.value == null) {
                    this.transactionParamInsertStatement.setNull(5, 4);
                    this.transactionParamInsertStatement.setNull(6, 2004);
                    break;
                }
                if (param.value instanceof char[]) {
                    byte[] bytes = new String((char[])param.value).getBytes();
                    this.transactionParamInsertStatement.setInt(5, bytes.length);
                    this.transactionParamInsertStatement.setBinaryStream(6, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
                    break;
                }
                if (param.value instanceof InputStream) {
                    this.transactionParamInsertStatement.setInt(5, param.length);
                    this.transactionParamInsertStatement.setBinaryStream(6, (InputStream)param.value, param.length);
                    break;
                }
                if (!(param.value instanceof Clob)) break;
                long len = ((Clob)param.value).length();
                if (len > Integer.MAX_VALUE) {
                    throw new SQLException("Not support large CLOB.");
                }
                this.transactionParamInsertStatement.setInt(5, (int)len);
                this.transactionParamInsertStatement.setBinaryStream(6, ((Clob)param.value).getAsciiStream(), (int)len);
                break;
            }
            default: {
                this.transactionParamInsertStatement.setNull(5, 4);
                if (param.value == null) {
                    this.transactionParamInsertStatement.setNull(6, 2004);
                    break;
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(param.value);
                    oos.flush();
                }
                catch (IOException e) {
                    throw new SQLException("Not serializable: " + e);
                }
                byte[] bytes = baos.toByteArray();
                this.transactionParamInsertStatement.setBinaryStream(6, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
            }
        }
    }

    @Override
    protected Statement createStatementWrapper(Statement stmt) throws SQLException {
        return new TransactionLoggingStatement(this, super.createStatementWrapper(stmt));
    }

    @Override
    protected PreparedStatement createPreparedStatementWrapper(PreparedStatement stmt, String sql) throws SQLException {
        return new TransactionLoggingPreparedStatement(this, super.createPreparedStatementWrapper(stmt, sql), sql);
    }

    static {
        String localHostName = null;
        try {
            localHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            localHostName = "localhost";
        }
        LOCAL_HOST_NAME = localHostName;
    }

    protected static class PrepareValue
    implements Serializable {
        private static final long serialVersionUID = 9218174048444548492L;
        public String name;
        public int type;
        public Object value;
        public int length;

        public PrepareValue(int type, Object value) {
            this.type = type;
            this.value = value;
        }

        public PrepareValue(int type, Object value, int length) {
            this(type, value);
            this.length = length;
        }

        public PrepareValue(String name, int type, Object value) {
            this(type, value);
            this.name = name;
        }

        public PrepareValue(String name, int type, Object value, int length) {
            this(type, value, length);
            this.name = name;
        }
    }

    protected static class TransactionLoggingCallableStatement
    extends CallableStatementWrapper {
        private static final long serialVersionUID = 3397485731634034392L;
        protected List params;
        protected List batchList;

        public TransactionLoggingCallableStatement(Connection con, CallableStatement st, String sql) throws SQLException {
            super(con, st, sql);
        }

        protected void setParam(int index, PrepareValue val) {
            if (this.params == null) {
                this.params = new ArrayList();
            }
            if (index == -1) {
                this.params.add(val);
            } else if (this.params.size() < index) {
                int imax = index - 1 - this.params.size();
                for (int i = 0; i < imax; ++i) {
                    this.params.add(null);
                }
                this.params.add(val);
            } else {
                this.params.set(index - 1, val);
            }
        }

        protected PrepareValue[] getParams() {
            if (this.params == null || this.params.size() == 0) {
                return null;
            }
            return this.params.toArray(new PrepareValue[this.params.size()]);
        }

        protected void clearParams() {
            if (this.params == null) {
                return;
            }
            for (int i = 0; i < this.params.size(); ++i) {
                this.params.set(i, null);
            }
        }

        protected byte[] toBytes(InputStream is) throws SQLException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            int length = 0;
            try {
                while ((length = is.read(bytes)) != -1) {
                    baos.write(bytes, 0, length);
                }
            }
            catch (IOException e) {
                throw new SQLException(e.toString());
            }
            return baos.toByteArray();
        }

        protected char[] toChars(Reader reader) throws SQLException {
            CharArrayWriter writer = new CharArrayWriter();
            char[] chars = new char[1024];
            int length = 0;
            try {
                while ((length = reader.read(chars)) != -1) {
                    writer.write(chars, 0, length);
                }
            }
            catch (IOException e) {
                throw new SQLException(e.toString());
            }
            return writer.toCharArray();
        }

        @Override
        public boolean execute() throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(this.preparedSql, 3, this.getParams());
                this.clearParams();
            }
            return super.execute();
        }

        @Override
        public boolean execute(String arg0) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 3);
                this.clearParams();
            }
            return super.execute(arg0);
        }

        @Override
        public boolean execute(String arg0, int arg1) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 3);
                this.clearParams();
            }
            return super.execute(arg0, arg1);
        }

        @Override
        public boolean execute(String arg0, int[] arg1) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 3);
                this.clearParams();
            }
            return super.execute(arg0, arg1);
        }

        @Override
        public boolean execute(String arg0, String[] arg1) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 3);
                this.clearParams();
            }
            return super.execute(arg0, arg1);
        }

        @Override
        public int executeUpdate(String arg0, String[] arg1) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 3);
                this.clearParams();
            }
            return super.executeUpdate(arg0, arg1);
        }

        @Override
        public int executeUpdate(String arg0, int arg1) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 3);
                this.clearParams();
            }
            return super.executeUpdate(arg0, arg1);
        }

        @Override
        public int executeUpdate(String arg0, int[] arg1) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 3);
                this.clearParams();
            }
            return super.executeUpdate(arg0, arg1);
        }

        @Override
        public int executeUpdate() throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(this.preparedSql, 3, this.getParams());
                this.clearParams();
            }
            return super.executeUpdate();
        }

        @Override
        public ResultSet executeQuery(String arg0) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 3);
                this.clearParams();
            }
            return super.executeQuery(arg0);
        }

        @Override
        public ResultSet executeQuery() throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(this.preparedSql, 3, this.getParams());
                this.clearParams();
            }
            return super.executeQuery();
        }

        @Override
        public void addBatch() throws SQLException {
            super.addBatch();
            PrepareValue[] tmpParams = this.getParams();
            if (tmpParams != null) {
                if (this.batchList == null) {
                    this.batchList = new ArrayList();
                }
                this.batchList.add(tmpParams);
                this.clearParams();
            }
        }

        @Override
        public void clearBatch() throws SQLException {
            super.clearBatch();
            if (this.batchList != null) {
                this.batchList.clear();
            }
        }

        @Override
        public void clearParameters() throws SQLException {
            super.clearParameters();
            this.clearParams();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int[] executeBatch() throws SQLException {
            int[] result = null;
            try {
                result = super.executeBatch();
            }
            finally {
                if (this.connection != null && this.batchList != null) {
                    for (int i = 0; i < this.batchList.size(); ++i) {
                        PrepareValue[] tmpParams = (PrepareValue[])this.batchList.get(i);
                        ((TransactionLoggingConnection)this.connection).writeLog(this.preparedSql, 3, tmpParams);
                    }
                    this.batchList.clear();
                }
            }
            return result;
        }

        @Override
        public void setBlob(int arg0, Blob arg1) throws SQLException {
            byte[] bytes = this.toBytes(arg1.getBinaryStream());
            super.setBinaryStream(arg0, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
            this.setParam(arg0, new PrepareValue(-4, new ByteArrayInputStream(bytes), bytes.length));
        }

        @Override
        public void setClob(int arg0, Clob arg1) throws SQLException {
            char[] chars = this.toChars(arg1.getCharacterStream());
            super.setCharacterStream(arg0, (Reader)new CharArrayReader(chars), chars.length);
            this.setParam(arg0, new PrepareValue(-1, new CharArrayReader(chars), chars.length));
        }

        @Override
        public void setByte(int arg0, byte arg1) throws SQLException {
            super.setByte(arg0, arg1);
            this.setParam(arg0, new PrepareValue(-6, new Byte(arg1)));
        }

        @Override
        public void setByte(String arg0, byte arg1) throws SQLException {
            super.setByte(arg0, arg1);
            this.setParam(-1, new PrepareValue(arg0, -6, new Byte(arg1)));
        }

        @Override
        public void setDouble(int arg0, double arg1) throws SQLException {
            super.setDouble(arg0, arg1);
            this.setParam(arg0, new PrepareValue(8, new Double(arg1)));
        }

        @Override
        public void setDouble(String arg0, double arg1) throws SQLException {
            super.setDouble(arg0, arg1);
            this.setParam(-1, new PrepareValue(arg0, 8, new Double(arg1)));
        }

        @Override
        public void setFloat(int arg0, float arg1) throws SQLException {
            super.setFloat(arg0, arg1);
            this.setParam(arg0, new PrepareValue(6, new Float(arg1)));
        }

        @Override
        public void setFloat(String arg0, float arg1) throws SQLException {
            super.setFloat(arg0, arg1);
            this.setParam(-1, new PrepareValue(arg0, 6, new Float(arg1)));
        }

        @Override
        public void setInt(int arg0, int arg1) throws SQLException {
            super.setInt(arg0, arg1);
            this.setParam(arg0, new PrepareValue(4, new Integer(arg1)));
        }

        @Override
        public void setInt(String arg0, int arg1) throws SQLException {
            super.setInt(arg0, arg1);
            this.setParam(-1, new PrepareValue(arg0, 4, new Integer(arg1)));
        }

        @Override
        public void setNull(int arg0, int arg1) throws SQLException {
            super.setNull(arg0, arg1);
            this.setParam(arg0, new PrepareValue(arg1, null));
        }

        @Override
        public void setNull(String arg0, int arg1) throws SQLException {
            super.setNull(arg0, arg1);
            this.setParam(-1, new PrepareValue(arg0, arg1, null));
        }

        @Override
        public void setNull(int arg0, int arg1, String arg2) throws SQLException {
            super.setNull(arg0, arg1);
            this.setParam(arg0, new PrepareValue(arg1, null));
        }

        @Override
        public void setNull(String arg0, int arg1, String arg2) throws SQLException {
            super.setNull(arg0, arg1);
            this.setParam(-1, new PrepareValue(arg0, arg1, null));
        }

        @Override
        public void setLong(int arg0, long arg1) throws SQLException {
            super.setLong(arg0, arg1);
            this.setParam(arg0, new PrepareValue(-5, new Long(arg1)));
        }

        @Override
        public void setLong(String arg0, long arg1) throws SQLException {
            super.setLong(arg0, arg1);
            this.setParam(-1, new PrepareValue(arg0, -5, new Long(arg1)));
        }

        @Override
        public void setShort(int arg0, short arg1) throws SQLException {
            super.setShort(arg0, arg1);
            this.setParam(arg0, new PrepareValue(5, new Short(arg1)));
        }

        @Override
        public void setShort(String arg0, short arg1) throws SQLException {
            super.setShort(arg0, arg1);
            this.setParam(-1, new PrepareValue(arg0, 5, new Short(arg1)));
        }

        @Override
        public void setBoolean(int arg0, boolean arg1) throws SQLException {
            super.setBoolean(arg0, arg1);
            this.setParam(arg0, new PrepareValue(5, arg1 ? Boolean.TRUE : Boolean.FALSE));
        }

        @Override
        public void setBoolean(String arg0, boolean arg1) throws SQLException {
            super.setBoolean(arg0, arg1);
            this.setParam(-1, new PrepareValue(arg0, 5, arg1 ? Boolean.TRUE : Boolean.FALSE));
        }

        @Override
        public void setBytes(int arg0, byte[] arg1) throws SQLException {
            super.setBytes(arg0, arg1);
            this.setParam(arg0, new PrepareValue(-3, arg1));
        }

        @Override
        public void setBytes(String arg0, byte[] arg1) throws SQLException {
            super.setBytes(arg0, arg1);
            this.setParam(-1, new PrepareValue(arg0, -3, arg1));
        }

        @Override
        public void setAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
            byte[] bytes = this.toBytes(arg1);
            super.setAsciiStream(arg0, (InputStream)new ByteArrayInputStream(bytes), arg2);
            this.setParam(arg0, new PrepareValue(-1, new ByteArrayInputStream(bytes), arg2));
        }

        @Override
        public void setAsciiStream(String arg0, InputStream arg1, int arg2) throws SQLException {
            byte[] bytes = this.toBytes(arg1);
            super.setAsciiStream(arg0, (InputStream)new ByteArrayInputStream(bytes), arg2);
            this.setParam(-1, new PrepareValue(arg0, -1, new ByteArrayInputStream(bytes), arg2));
        }

        @Override
        public void setBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
            byte[] bytes = this.toBytes(arg1);
            super.setBinaryStream(arg0, (InputStream)new ByteArrayInputStream(bytes), arg2);
            this.setParam(arg0, new PrepareValue(-4, new ByteArrayInputStream(bytes), arg2));
        }

        @Override
        public void setBinaryStream(String arg0, InputStream arg1, int arg2) throws SQLException {
            byte[] bytes = this.toBytes(arg1);
            super.setBinaryStream(arg0, (InputStream)new ByteArrayInputStream(bytes), arg2);
            this.setParam(-1, new PrepareValue(arg0, -4, new ByteArrayInputStream(bytes), arg2));
        }

        @Override
        public void setCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
            char[] chars = this.toChars(arg1);
            super.setCharacterStream(arg0, (Reader)new CharArrayReader(chars), chars.length);
            this.setParam(arg0, new PrepareValue(-1, new CharArrayReader(chars), chars.length));
        }

        @Override
        public void setCharacterStream(String arg0, Reader arg1, int arg2) throws SQLException {
            char[] chars = this.toChars(arg1);
            super.setCharacterStream(arg0, (Reader)new CharArrayReader(chars), chars.length);
            this.setParam(-1, new PrepareValue(arg0, -1, new CharArrayReader(chars), chars.length));
        }

        @Override
        public void setObject(int arg0, Object arg1) throws SQLException {
            super.setObject(arg0, arg1);
            this.setParam(arg0, new PrepareValue(2000, arg1));
        }

        @Override
        public void setObject(String arg0, Object arg1) throws SQLException {
            super.setObject(arg0, arg1);
            this.setParam(-1, new PrepareValue(arg0, 2000, arg1));
        }

        @Override
        public void setObject(int arg0, Object arg1, int arg2) throws SQLException {
            super.setObject(arg0, arg1, arg2);
            this.setParam(arg0, new PrepareValue(arg2, arg1));
        }

        @Override
        public void setObject(String arg0, Object arg1, int arg2) throws SQLException {
            super.setObject(arg0, arg1, arg2);
            this.setParam(-1, new PrepareValue(arg0, arg2, arg1));
        }

        @Override
        public void setObject(int arg0, Object arg1, int arg2, int arg3) throws SQLException {
            super.setObject(arg0, arg1, arg2, arg3);
            if (arg1 != null) {
                if (arg1 instanceof Float) {
                    arg1 = new BigDecimal(arg1.toString()).setScale(arg3);
                } else if (arg1 instanceof Double) {
                    arg1 = new BigDecimal((Double)arg1).setScale(arg3);
                } else if (arg1 instanceof BigDecimal) {
                    arg1 = ((BigDecimal)arg1).setScale(arg3);
                }
            }
            this.setParam(arg0, new PrepareValue(arg2, arg1));
        }

        @Override
        public void setObject(String arg0, Object arg1, int arg2, int arg3) throws SQLException {
            super.setObject(arg0, arg1, arg2, arg3);
            if (arg1 != null) {
                if (arg1 instanceof Float) {
                    arg1 = new BigDecimal(arg1.toString()).setScale(arg3);
                } else if (arg1 instanceof Double) {
                    arg1 = new BigDecimal((Double)arg1).setScale(arg3);
                } else if (arg1 instanceof BigDecimal) {
                    arg1 = ((BigDecimal)arg1).setScale(arg3);
                }
            }
            this.setParam(-1, new PrepareValue(arg0, arg2, arg1));
        }

        @Override
        public void setString(int arg0, String arg1) throws SQLException {
            super.setString(arg0, arg1);
            this.setParam(arg0, new PrepareValue(12, arg1));
        }

        @Override
        public void setString(String arg0, String arg1) throws SQLException {
            super.setString(arg0, arg1);
            this.setParam(-1, new PrepareValue(arg0, 12, arg1));
        }

        @Override
        public void setBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
            super.setBigDecimal(arg0, arg1);
            this.setParam(arg0, new PrepareValue(2, arg1));
        }

        @Override
        public void setBigDecimal(String arg0, BigDecimal arg1) throws SQLException {
            super.setBigDecimal(arg0, arg1);
            this.setParam(-1, new PrepareValue(arg0, 2, arg1));
        }

        @Override
        public void setURL(int arg0, URL arg1) throws SQLException {
            throw new SQLException("Not support type.");
        }

        @Override
        public void setURL(String arg0, URL arg1) throws SQLException {
            throw new SQLException("Not support type.");
        }

        @Override
        public void setDate(int arg0, Date arg1) throws SQLException {
            super.setDate(arg0, arg1);
            Calendar cal = Calendar.getInstance();
            cal.setTime(arg1);
            this.setParam(arg0, new PrepareValue(91, cal));
        }

        @Override
        public void setDate(String arg0, Date arg1) throws SQLException {
            super.setDate(arg0, arg1);
            Calendar cal = Calendar.getInstance();
            cal.setTime(arg1);
            this.setParam(-1, new PrepareValue(arg0, 91, cal));
        }

        @Override
        public void setTime(int arg0, Time arg1) throws SQLException {
            super.setTime(arg0, arg1);
            Calendar cal = Calendar.getInstance();
            cal.setTime(arg1);
            this.setParam(arg0, new PrepareValue(92, cal));
        }

        @Override
        public void setTime(String arg0, Time arg1) throws SQLException {
            super.setTime(arg0, arg1);
            Calendar cal = Calendar.getInstance();
            cal.setTime(arg1);
            this.setParam(-1, new PrepareValue(arg0, 92, cal));
        }

        @Override
        public void setTimestamp(int arg0, Timestamp arg1) throws SQLException {
            super.setTimestamp(arg0, arg1);
            Calendar cal = Calendar.getInstance();
            cal.setTime(arg1);
            this.setParam(arg0, new PrepareValue(93, cal));
        }

        @Override
        public void setTimestamp(String arg0, Timestamp arg1) throws SQLException {
            super.setTimestamp(arg0, arg1);
            Calendar cal = Calendar.getInstance();
            cal.setTime(arg1);
            this.setParam(-1, new PrepareValue(arg0, 93, cal));
        }

        @Override
        public void setDate(int arg0, Date arg1, Calendar arg2) throws SQLException {
            super.setDate(arg0, arg1, arg2);
            Calendar cal = arg2 == null ? Calendar.getInstance() : (Calendar)arg2.clone();
            cal.setTime(arg1);
            this.setParam(arg0, new PrepareValue(91, cal));
        }

        @Override
        public void setDate(String arg0, Date arg1, Calendar arg2) throws SQLException {
            super.setDate(arg0, arg1, arg2);
            Calendar cal = arg2 == null ? Calendar.getInstance() : (Calendar)arg2.clone();
            cal.setTime(arg1);
            this.setParam(-1, new PrepareValue(arg0, 91, cal));
        }

        @Override
        public void setTime(int arg0, Time arg1, Calendar arg2) throws SQLException {
            super.setTime(arg0, arg1, arg2);
            Calendar cal = arg2 == null ? Calendar.getInstance() : (Calendar)arg2.clone();
            cal.setTime(arg1);
            this.setParam(arg0, new PrepareValue(92, cal));
        }

        @Override
        public void setTime(String arg0, Time arg1, Calendar arg2) throws SQLException {
            super.setTime(arg0, arg1, arg2);
            Calendar cal = arg2 == null ? Calendar.getInstance() : (Calendar)arg2.clone();
            cal.setTime(arg1);
            this.setParam(-1, new PrepareValue(arg0, 92, cal));
        }

        @Override
        public void setTimestamp(int arg0, Timestamp arg1, Calendar arg2) throws SQLException {
            super.setTimestamp(arg0, arg1, arg2);
            Calendar cal = arg2 == null ? Calendar.getInstance() : (Calendar)arg2.clone();
            cal.setTime(arg1);
            this.setParam(arg0, new PrepareValue(93, cal));
        }

        @Override
        public void setTimestamp(String arg0, Timestamp arg1, Calendar arg2) throws SQLException {
            super.setTimestamp(arg0, arg1, arg2);
            Calendar cal = arg2 == null ? Calendar.getInstance() : (Calendar)arg2.clone();
            cal.setTime(arg1);
            this.setParam(-1, new PrepareValue(arg0, 93, cal));
        }
    }

    protected static class TransactionLoggingPreparedStatement
    extends PreparedStatementWrapper {
        private static final long serialVersionUID = -567672969227456696L;
        protected List params;
        protected List batchList;

        public TransactionLoggingPreparedStatement(Connection con, PreparedStatement st, String sql) throws SQLException {
            super(con, st, sql);
        }

        protected void setParam(int index, PrepareValue val) {
            if (this.params == null) {
                this.params = new ArrayList();
            }
            if (this.params.size() < index) {
                int imax = index - 1 - this.params.size();
                for (int i = 0; i < imax; ++i) {
                    this.params.add(null);
                }
                this.params.add(val);
            } else {
                this.params.set(index - 1, val);
            }
        }

        protected PrepareValue[] getParams() {
            if (this.params == null || this.params.size() == 0) {
                return null;
            }
            return this.params.toArray(new PrepareValue[this.params.size()]);
        }

        protected void clearParams() {
            if (this.params == null) {
                return;
            }
            for (int i = 0; i < this.params.size(); ++i) {
                this.params.set(i, null);
            }
        }

        protected byte[] toBytes(InputStream is) throws SQLException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            int length = 0;
            try {
                while ((length = is.read(bytes)) != -1) {
                    baos.write(bytes, 0, length);
                }
            }
            catch (IOException e) {
                throw new SQLException(e.toString());
            }
            return baos.toByteArray();
        }

        protected char[] toChars(Reader reader) throws SQLException {
            CharArrayWriter writer = new CharArrayWriter();
            char[] chars = new char[1024];
            int length = 0;
            try {
                while ((length = reader.read(chars)) != -1) {
                    writer.write(chars, 0, length);
                }
            }
            catch (IOException e) {
                throw new SQLException(e.toString());
            }
            return writer.toCharArray();
        }

        @Override
        public boolean execute() throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(this.preparedSql, 2, this.getParams());
                this.clearParams();
            }
            return super.execute();
        }

        @Override
        public boolean execute(String arg0) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 1);
                this.clearParams();
            }
            return super.execute(arg0);
        }

        @Override
        public boolean execute(String arg0, int arg1) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 1);
                this.clearParams();
            }
            return super.execute(arg0, arg1);
        }

        @Override
        public boolean execute(String arg0, int[] arg1) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 1);
                this.clearParams();
            }
            return super.execute(arg0, arg1);
        }

        @Override
        public boolean execute(String arg0, String[] arg1) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 1);
                this.clearParams();
            }
            return super.execute(arg0, arg1);
        }

        @Override
        public int executeUpdate(String arg0, String[] arg1) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 1);
                this.clearParams();
            }
            return super.executeUpdate(arg0, arg1);
        }

        @Override
        public int executeUpdate(String arg0, int arg1) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 1);
                this.clearParams();
            }
            return super.executeUpdate(arg0, arg1);
        }

        @Override
        public int executeUpdate(String arg0, int[] arg1) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 1);
                this.clearParams();
            }
            return super.executeUpdate(arg0, arg1);
        }

        @Override
        public int executeUpdate() throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(this.preparedSql, 2, this.getParams());
                this.clearParams();
            }
            return super.executeUpdate();
        }

        @Override
        public ResultSet executeQuery(String arg0) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 1);
                this.clearParams();
            }
            return super.executeQuery(arg0);
        }

        @Override
        public ResultSet executeQuery() throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(this.preparedSql, 2, this.getParams());
                this.clearParams();
            }
            return super.executeQuery();
        }

        @Override
        public void addBatch() throws SQLException {
            super.addBatch();
            PrepareValue[] tmpParams = this.getParams();
            if (tmpParams != null) {
                if (this.batchList == null) {
                    this.batchList = new ArrayList();
                }
                this.batchList.add(tmpParams);
                this.clearParams();
            }
        }

        @Override
        public void clearBatch() throws SQLException {
            super.clearBatch();
            if (this.batchList != null) {
                this.batchList.clear();
            }
        }

        @Override
        public void clearParameters() throws SQLException {
            super.clearParameters();
            this.clearParams();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int[] executeBatch() throws SQLException {
            int[] result = null;
            try {
                result = super.executeBatch();
            }
            finally {
                if (this.connection != null && this.batchList != null) {
                    for (int i = 0; i < this.batchList.size(); ++i) {
                        PrepareValue[] tmpParams = (PrepareValue[])this.batchList.get(i);
                        if (tmpParams == null || tmpParams.length == 0) {
                            ((TransactionLoggingConnection)this.connection).writeLog(this.preparedSql, 1);
                            continue;
                        }
                        ((TransactionLoggingConnection)this.connection).writeLog(this.preparedSql, 2, tmpParams);
                    }
                    this.batchList.clear();
                }
            }
            return result;
        }

        @Override
        public void setByte(int arg0, byte arg1) throws SQLException {
            super.setByte(arg0, arg1);
            this.setParam(arg0, new PrepareValue(-6, new Byte(arg1)));
        }

        @Override
        public void setDouble(int arg0, double arg1) throws SQLException {
            super.setDouble(arg0, arg1);
            this.setParam(arg0, new PrepareValue(8, new Double(arg1)));
        }

        @Override
        public void setFloat(int arg0, float arg1) throws SQLException {
            super.setFloat(arg0, arg1);
            this.setParam(arg0, new PrepareValue(6, new Float(arg1)));
        }

        @Override
        public void setInt(int arg0, int arg1) throws SQLException {
            super.setInt(arg0, arg1);
            this.setParam(arg0, new PrepareValue(4, new Integer(arg1)));
        }

        @Override
        public void setNull(int arg0, int arg1) throws SQLException {
            super.setNull(arg0, arg1);
            this.setParam(arg0, new PrepareValue(arg1, null));
        }

        @Override
        public void setNull(int arg0, int arg1, String arg2) throws SQLException {
            super.setNull(arg0, arg1);
            this.setParam(arg0, new PrepareValue(arg1, null));
        }

        @Override
        public void setLong(int arg0, long arg1) throws SQLException {
            super.setLong(arg0, arg1);
            this.setParam(arg0, new PrepareValue(-5, new Long(arg1)));
        }

        @Override
        public void setShort(int arg0, short arg1) throws SQLException {
            super.setShort(arg0, arg1);
            this.setParam(arg0, new PrepareValue(5, new Short(arg1)));
        }

        @Override
        public void setBoolean(int arg0, boolean arg1) throws SQLException {
            super.setBoolean(arg0, arg1);
            this.setParam(arg0, new PrepareValue(5, arg1 ? Boolean.TRUE : Boolean.FALSE));
        }

        @Override
        public void setBytes(int arg0, byte[] arg1) throws SQLException {
            super.setBytes(arg0, arg1);
            this.setParam(arg0, new PrepareValue(-3, arg1));
        }

        @Override
        public void setAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
            byte[] bytes = this.toBytes(arg1);
            super.setAsciiStream(arg0, (InputStream)new ByteArrayInputStream(bytes), arg2);
            this.setParam(arg0, new PrepareValue(-1, new ByteArrayInputStream(bytes), arg2));
        }

        @Override
        public void setBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
            byte[] bytes = this.toBytes(arg1);
            super.setBinaryStream(arg0, (InputStream)new ByteArrayInputStream(bytes), arg2);
            this.setParam(arg0, new PrepareValue(-4, new ByteArrayInputStream(bytes), arg2));
        }

        @Override
        public void setUnicodeStream(int arg0, InputStream arg1, int arg2) throws SQLException {
            byte[] bytes = this.toBytes(arg1);
            super.setUnicodeStream(arg0, new ByteArrayInputStream(bytes), arg2);
            this.setParam(arg0, new PrepareValue(-1, new ByteArrayInputStream(bytes), arg2));
        }

        @Override
        public void setCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
            char[] chars = this.toChars(arg1);
            super.setCharacterStream(arg0, (Reader)new CharArrayReader(chars), arg2);
            this.setParam(arg0, new PrepareValue(-1, new CharArrayReader(chars), arg2));
        }

        @Override
        public void setObject(int arg0, Object arg1) throws SQLException {
            super.setObject(arg0, arg1);
            this.setParam(arg0, new PrepareValue(Integer.MIN_VALUE, arg1));
        }

        @Override
        public void setObject(int arg0, Object arg1, int arg2) throws SQLException {
            super.setObject(arg0, arg1, arg2);
            this.setParam(arg0, new PrepareValue(arg2, arg1));
        }

        @Override
        public void setObject(int arg0, Object arg1, int arg2, int arg3) throws SQLException {
            super.setObject(arg0, arg1, arg2, arg3);
            if (arg1 != null) {
                if (arg1 instanceof Float) {
                    arg1 = new BigDecimal(arg1.toString()).setScale(arg3);
                } else if (arg1 instanceof Double) {
                    arg1 = new BigDecimal((Double)arg1).setScale(arg3);
                } else if (arg1 instanceof BigDecimal) {
                    arg1 = ((BigDecimal)arg1).setScale(arg3);
                }
            }
            this.setParam(arg0, new PrepareValue(arg2, arg1));
        }

        @Override
        public void setString(int arg0, String arg1) throws SQLException {
            super.setString(arg0, arg1);
            this.setParam(arg0, new PrepareValue(12, arg1));
        }

        @Override
        public void setBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
            super.setBigDecimal(arg0, arg1);
            this.setParam(arg0, new PrepareValue(2, arg1));
        }

        @Override
        public void setURL(int arg0, URL arg1) throws SQLException {
            throw new SQLException("Not support type.");
        }

        @Override
        public void setArray(int arg0, Array arg1) throws SQLException {
            throw new SQLException("Not support type.");
        }

        @Override
        public void setBlob(int arg0, Blob arg1) throws SQLException {
            byte[] bytes = this.toBytes(arg1.getBinaryStream());
            super.setBinaryStream(arg0, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
            this.setParam(arg0, new PrepareValue(-4, new ByteArrayInputStream(bytes), bytes.length));
        }

        @Override
        public void setClob(int arg0, Clob arg1) throws SQLException {
            char[] chars = this.toChars(arg1.getCharacterStream());
            super.setCharacterStream(arg0, (Reader)new CharArrayReader(chars), chars.length);
            this.setParam(arg0, new PrepareValue(-1, new CharArrayReader(chars), chars.length));
        }

        @Override
        public void setRef(int arg0, Ref arg1) throws SQLException {
            throw new SQLException("Not support type.");
        }

        @Override
        public void setDate(int arg0, Date arg1) throws SQLException {
            super.setDate(arg0, arg1);
            Calendar cal = Calendar.getInstance();
            cal.setTime(arg1);
            this.setParam(arg0, new PrepareValue(91, cal));
        }

        @Override
        public void setTime(int arg0, Time arg1) throws SQLException {
            super.setTime(arg0, arg1);
            Calendar cal = Calendar.getInstance();
            cal.setTime(arg1);
            this.setParam(arg0, new PrepareValue(92, cal));
        }

        @Override
        public void setTimestamp(int arg0, Timestamp arg1) throws SQLException {
            super.setTimestamp(arg0, arg1);
            Calendar cal = Calendar.getInstance();
            cal.setTime(arg1);
            this.setParam(arg0, new PrepareValue(93, cal));
        }

        @Override
        public void setDate(int arg0, Date arg1, Calendar arg2) throws SQLException {
            super.setDate(arg0, arg1, arg2);
            Calendar cal = arg2 == null ? Calendar.getInstance() : (Calendar)arg2.clone();
            cal.setTime(arg1);
            this.setParam(arg0, new PrepareValue(91, cal));
        }

        @Override
        public void setTime(int arg0, Time arg1, Calendar arg2) throws SQLException {
            super.setTime(arg0, arg1, arg2);
            Calendar cal = arg2 == null ? Calendar.getInstance() : (Calendar)arg2.clone();
            cal.setTime(arg1);
            this.setParam(arg0, new PrepareValue(92, cal));
        }

        @Override
        public void setTimestamp(int arg0, Timestamp arg1, Calendar arg2) throws SQLException {
            super.setTimestamp(arg0, arg1, arg2);
            Calendar cal = arg2 == null ? Calendar.getInstance() : (Calendar)arg2.clone();
            cal.setTime(arg1);
            this.setParam(arg0, new PrepareValue(93, cal));
        }
    }

    protected static class TransactionLoggingStatement
    extends StatementWrapper {
        private static final long serialVersionUID = 7932933028646279493L;
        protected List batchList;

        public TransactionLoggingStatement(TransactionLoggingConnection con, Statement st) {
            super(con, st);
        }

        @Override
        public boolean execute(String arg0) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 1);
            }
            return super.execute(arg0);
        }

        @Override
        public boolean execute(String arg0, int arg1) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 1);
            }
            return super.execute(arg0, arg1);
        }

        @Override
        public boolean execute(String arg0, int[] arg1) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 1);
            }
            return super.execute(arg0, arg1);
        }

        @Override
        public boolean execute(String arg0, String[] arg1) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 1);
            }
            return super.execute(arg0, arg1);
        }

        @Override
        public int executeUpdate(String arg0) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 1);
            }
            return super.executeUpdate(arg0);
        }

        @Override
        public int executeUpdate(String arg0, int arg1) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 1);
            }
            return super.executeUpdate(arg0, arg1);
        }

        @Override
        public int executeUpdate(String arg0, int[] arg1) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 1);
            }
            return super.executeUpdate(arg0, arg1);
        }

        @Override
        public int executeUpdate(String arg0, String[] arg1) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 1);
            }
            return super.executeUpdate(arg0, arg1);
        }

        @Override
        public ResultSet executeQuery(String arg0) throws SQLException {
            if (this.connection != null) {
                ((TransactionLoggingConnection)this.connection).writeLog(arg0, 1);
            }
            return super.executeQuery(arg0);
        }

        @Override
        public void addBatch(String arg0) throws SQLException {
            super.addBatch(arg0);
            if (this.batchList == null) {
                this.batchList = new ArrayList();
            }
            this.batchList.add(arg0);
        }

        @Override
        public void clearBatch() throws SQLException {
            super.clearBatch();
            if (this.batchList != null) {
                this.batchList.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int[] executeBatch() throws SQLException {
            int[] result = null;
            try {
                result = super.executeBatch();
            }
            finally {
                if (this.connection != null && this.batchList != null) {
                    for (int i = 0; i < this.batchList.size(); ++i) {
                        String sql = (String)this.batchList.get(i);
                        ((TransactionLoggingConnection)this.connection).writeLog(sql, 1);
                    }
                    this.batchList.clear();
                }
            }
            return result;
        }
    }
}

