/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.validator;

import java.io.Serializable;
import java.util.regex.Pattern;
import jp.ossc.nimbus.util.validator.AbstractStringValidator;
import jp.ossc.nimbus.util.validator.ValidateException;

public class MailAddressStringValidator
extends AbstractStringValidator
implements Serializable {
    private static final long serialVersionUID = 6744750492948377241L;
    protected static final String SPECIAL_CHARS = "\\(\\)<>@,;:\\\\\\\"\\.\\[\\]";
    protected static final String VALID_CHARS = "[\\S\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]";
    protected static final String QUOTED_USER = "(\"[^\"]*\")";
    protected static final String ATOM = "[\\S\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+";
    protected static final String ATOM2 = "[\\S\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]*";
    protected static final String WORD = "([\\S\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+|(\"[^\"]*\"))";
    protected static final String WORD2 = "([\\S\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]*|(\"[^\"]*\"))";
    protected static Pattern LEGAL_ASCII_PATTERN = Pattern.compile("^[\\0000-\\0177]+$");
    protected static Pattern EMAIL_PATTERN = Pattern.compile("^(.+)@(.+)$");
    protected static Pattern USER_PATTERN = Pattern.compile("\\S*([\\S\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+|(\"[^\"]*\"))(\\.([\\S\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]*|(\"[^\"]*\")))*\\S*$");
    protected static Pattern DOMAIN_PATTERN = Pattern.compile("\\S*[\\S\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+(\\.[\\S\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+)*\\S*$");
    protected static Pattern IP_DOMAIN_PATTERN = Pattern.compile("^\\[(\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})\\]$");
    protected static Pattern ATOM_PATTERN = Pattern.compile("([\\S\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+)");

    @Override
    protected boolean validateString(String str) throws ValidateException {
        if (str.charAt(str.length() - 1) == '.') {
            return false;
        }
        if (!LEGAL_ASCII_PATTERN.matcher(str).matches()) {
            return false;
        }
        if (!EMAIL_PATTERN.matcher(str).matches()) {
            return false;
        }
        int index = str.indexOf(64);
        String account = str.substring(0, index);
        if (!USER_PATTERN.matcher(account).matches()) {
            return false;
        }
        String domain = str.substring(index + 1);
        if (IP_DOMAIN_PATTERN.matcher(domain).matches()) {
            String[] ipSegments = domain.split("\\.");
            if (ipSegments.length != 4) {
                return false;
            }
            for (int i = 0; i < 4; ++i) {
                int ipSegment = 0;
                try {
                    ipSegment = Integer.parseInt(ipSegments[i]);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (ipSegment <= 255) continue;
                return false;
            }
        } else if (DOMAIN_PATTERN.matcher(domain).matches()) {
            String[] domainSegments = domain.split("\\.");
            if (domainSegments.length < 2) {
                return false;
            }
            if (domainSegments[domainSegments.length - 1].length() < 2 || domainSegments[domainSegments.length - 1].length() > 4) {
                return false;
            }
            for (int i = 0; i < domainSegments.length; ++i) {
                if (ATOM_PATTERN.matcher(domainSegments[i]).matches()) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

