/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InterceptorChainList;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.Invoker;
import jp.ossc.nimbus.service.aop.interceptor.MetricsInfo;

public class DefaultInterceptorChain
implements InterceptorChain,
Serializable,
Cloneable {
    private static final long serialVersionUID = 3689361711046717596L;
    protected int currentIndex = -1;
    protected transient InterceptorChainList interceptorChainList;
    protected ServiceName interceptorChainListServiceName;
    protected transient Invoker invoker;
    protected ServiceName invokerServiceName;
    protected Map metricsInfos;
    protected boolean isCalculateOnlyNormal;

    public DefaultInterceptorChain() {
    }

    public DefaultInterceptorChain(InterceptorChainList list, Invoker invoker) {
        this.setInterceptorChainList(list);
        this.setInvoker(invoker);
    }

    public DefaultInterceptorChain(ServiceName listServiceName, ServiceName invokerServiceName) {
        this.setInterceptorChainListServiceName(listServiceName);
        this.setInvokerServiceName(invokerServiceName);
    }

    public void setMetricsInfoMap(Map infos) {
        this.metricsInfos = infos;
    }

    public Map getMetricsInfoMap() {
        return this.metricsInfos;
    }

    public void setCalculateOnlyNormal(boolean isCalc) {
        this.isCalculateOnlyNormal = isCalc;
    }

    public boolean isCalculateOnlyNormal() {
        return this.isCalculateOnlyNormal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invokeNext(InvocationContext context) throws Throwable {
        int index;
        block51: {
            InterceptorChainList list = this.getInterceptorChainList();
            boolean isError = false;
            boolean isException = false;
            long start = 0L;
            if (this.metricsInfos != null) {
                start = System.currentTimeMillis();
            }
            if (list == null) {
                Invoker ivk = this.getInvoker();
                if (ivk != null) {
                    try {
                        Object object = ivk.invoke(context);
                        return object;
                    }
                    catch (Exception e) {
                        isException = true;
                        throw e;
                    }
                    catch (Error err) {
                        isError = true;
                        throw err;
                    }
                    finally {
                        if (this.metricsInfos != null) {
                            long end = System.currentTimeMillis();
                            Map map = this.metricsInfos;
                            synchronized (map) {
                                MetricsInfo metricsInfo = (MetricsInfo)this.metricsInfos.get(ivk);
                                if (metricsInfo == null) {
                                    metricsInfo = new MetricsInfo(this.createKey(ivk), this.isCalculateOnlyNormal);
                                    this.metricsInfos.put(ivk, metricsInfo);
                                }
                                metricsInfo.calculate(end - start, isException, isError);
                            }
                        }
                    }
                }
                return null;
            }
            index = this.getCurrentInterceptorIndex();
            this.setCurrentInterceptorIndex(++index);
            Interceptor interceptor = list.getInterceptor(context, index);
            if (interceptor != null) {
                try {
                    Object end = interceptor.invoke(context, this);
                    return end;
                }
                catch (Exception e) {
                    isException = true;
                    throw e;
                }
                catch (Error err) {
                    isError = true;
                    throw err;
                }
                finally {
                    if (this.metricsInfos != null) {
                        long end = System.currentTimeMillis();
                        Map map = this.metricsInfos;
                        synchronized (map) {
                            MetricsInfo metricsInfo = (MetricsInfo)this.metricsInfos.get(interceptor);
                            if (metricsInfo == null) {
                                metricsInfo = new MetricsInfo(this.createKey(interceptor), this.isCalculateOnlyNormal);
                                this.metricsInfos.put(interceptor, metricsInfo);
                            }
                            metricsInfo.calculate(end - start, isException, isError);
                        }
                    }
                }
            }
            Invoker ivk = this.getInvoker();
            if (ivk == null) break block51;
            try {
                Object end = ivk.invoke(context);
                return end;
            }
            catch (Exception e) {
                isException = true;
                throw e;
            }
            catch (Error err) {
                isError = true;
                throw err;
            }
            finally {
                if (this.metricsInfos != null) {
                    long end = System.currentTimeMillis();
                    Map map = this.metricsInfos;
                    synchronized (map) {
                        MetricsInfo metricsInfo = (MetricsInfo)this.metricsInfos.get(ivk);
                        if (metricsInfo == null) {
                            metricsInfo = new MetricsInfo(this.createKey(ivk), this.isCalculateOnlyNormal);
                            this.metricsInfos.put(ivk, metricsInfo);
                        }
                        metricsInfo.calculate(end - start, isException, isError);
                    }
                }
            }
        }
        Object var10_34 = null;
        return var10_34;
        finally {
            this.setCurrentInterceptorIndex(--index);
        }
    }

    protected String createKey(Object target) {
        if (target instanceof Service) {
            Service service = (Service)target;
            if (service.getServiceNameObject() != null) {
                return service.getServiceNameObject().toString();
            }
            if (service.getServiceName() != null) {
                return service.getServiceName().toString();
            }
            return service.toString();
        }
        return target.toString();
    }

    @Override
    public int getCurrentInterceptorIndex() {
        return this.currentIndex;
    }

    @Override
    public void setCurrentInterceptorIndex(int index) {
        this.currentIndex = index;
    }

    @Override
    public InterceptorChainList getInterceptorChainList() {
        if (this.interceptorChainListServiceName != null) {
            try {
                return (InterceptorChainList)ServiceManagerFactory.getServiceObject(this.interceptorChainListServiceName);
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
        }
        return this.interceptorChainList;
    }

    public void setInterceptorChainList(InterceptorChainList list) {
        Service service;
        if (this.interceptorChainList instanceof ServiceBase) {
            this.interceptorChainListServiceName = ((ServiceBase)((Object)list)).getServiceNameObject();
        } else if (this.interceptorChainList instanceof Service && (service = (Service)((Object)list)).getServiceManagerName() != null) {
            this.interceptorChainListServiceName = new ServiceName(service.getServiceManagerName(), service.getServiceName());
        }
        if (this.interceptorChainListServiceName == null) {
            this.interceptorChainList = list;
        }
    }

    public void setInterceptorChainListServiceName(ServiceName name) {
        this.interceptorChainListServiceName = name;
    }

    @Override
    public Invoker getInvoker() {
        if (this.invokerServiceName != null) {
            try {
                return (Invoker)ServiceManagerFactory.getServiceObject(this.invokerServiceName);
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
        }
        return this.invoker;
    }

    @Override
    public void setInvoker(Invoker invoker) {
        Service service;
        if (invoker instanceof ServiceBase) {
            this.invokerServiceName = ((ServiceBase)((Object)invoker)).getServiceNameObject();
        } else if (invoker instanceof Service && (service = (Service)((Object)invoker)).getServiceManagerName() != null) {
            this.invokerServiceName = new ServiceName(service.getServiceManagerName(), service.getServiceName());
        }
        if (this.invokerServiceName == null) {
            this.invoker = invoker;
        }
    }

    public void setInvokerServiceName(ServiceName name) {
        this.invokerServiceName = name;
    }

    @Override
    public InterceptorChain cloneChain() {
        try {
            DefaultInterceptorChain clone = (DefaultInterceptorChain)this.clone();
            clone.currentIndex = -1;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.interceptorChainListServiceName == null) {
            out.writeObject(this.interceptorChainList);
        }
        if (this.invokerServiceName == null) {
            out.writeObject(this.invoker);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.interceptorChainList = this.interceptorChainListServiceName == null ? (InterceptorChainList)in.readObject() : (InterceptorChainList)ServiceManagerFactory.getServiceObject(this.interceptorChainListServiceName);
        this.invoker = this.invokerServiceName == null ? (Invoker)in.readObject() : (Invoker)ServiceManagerFactory.getServiceObject(this.invokerServiceName);
    }
}

