/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import jp.ossc.nimbus.core.NimbusClassLoader;

public class IncompatibleExceptionWrapExeption
extends RuntimeException {
    private static final long serialVersionUID = 5174983898976241044L;
    private static final String SERVLET_EXCEPTION_NAME = "javax.servlet.ServletException";
    private static final String GET_ROOT_CAUSE_METHOD = "getRootCause";
    private static final String JMS_EXCEPTION_NAME = "javax.jms.JMSException";
    private static final String GET_LINKED_EXCEPTION_METHOD = "getLinkedException";
    private static final String SET_LINKED_EXCEPTION_METHOD = "setLinkedException";
    private static final String GET_ERROR_CODE_METHOD = "getErrorCode";
    private String sourceExceptionClassName;
    private String errorCode;

    public IncompatibleExceptionWrapExeption(Throwable source) {
        super(source.getMessage(), IncompatibleExceptionWrapExeption.getCause(source));
        this.setStackTrace(source.getStackTrace());
        this.sourceExceptionClassName = source.getClass().getName();
        if (this.sourceExceptionClassName.equals(JMS_EXCEPTION_NAME)) {
            try {
                this.errorCode = (String)source.getClass().getMethod(GET_ERROR_CODE_METHOD, null).invoke((Object)source, (Object[])null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public Throwable unwrap() {
        NimbusClassLoader loader = NimbusClassLoader.getInstance();
        try {
            Class<?> clazz = Class.forName(this.sourceExceptionClassName, true, loader);
            String message = this.getMessage();
            Throwable cause = this.getCause();
            Throwable result = null;
            if (clazz.getName().equals(JMS_EXCEPTION_NAME)) {
                Constructor<?> c = clazz.getConstructor(String.class, String.class);
                result = (Throwable)c.newInstance(message, this.errorCode);
                if (cause != null) {
                    clazz.getMethod(SET_LINKED_EXCEPTION_METHOD, Exception.class).invoke((Object)result, cause);
                }
            } else if (message != null && cause != null) {
                Constructor<?> c = clazz.getConstructor(String.class, Throwable.class);
                result = (Throwable)c.newInstance(message, cause);
            } else if (message != null && cause == null) {
                Constructor<?> c = clazz.getConstructor(String.class);
                result = (Throwable)c.newInstance(message);
            } else if (message == null && cause != null) {
                Constructor<?> c = clazz.getConstructor(Throwable.class);
                result = (Throwable)c.newInstance(cause);
            } else if (message == null && cause == null) {
                result = (Throwable)clazz.newInstance();
            }
            result.setStackTrace(this.getStackTrace());
            return result;
        }
        catch (ClassNotFoundException e) {
            return this;
        }
        catch (SecurityException e) {
            return this;
        }
        catch (InstantiationException e) {
            return this;
        }
        catch (NoSuchMethodException e) {
            return this;
        }
        catch (IllegalAccessException e) {
            return this;
        }
        catch (InvocationTargetException e) {
            return this;
        }
    }

    public static Throwable getCause(Throwable th) {
        Throwable cause = null;
        if (th.getClass().getName().equals(SERVLET_EXCEPTION_NAME)) {
            cause = th.getCause();
            if (cause == null) {
                try {
                    cause = (Throwable)th.getClass().getMethod(GET_ROOT_CAUSE_METHOD, null).invoke((Object)th, (Object[])null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
        } else if (th.getClass().getName().equals(JMS_EXCEPTION_NAME)) {
            try {
                cause = (Exception)th.getClass().getMethod(GET_LINKED_EXCEPTION_METHOD, null).invoke((Object)th, (Object[])null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        } else {
            cause = th.getCause();
        }
        return cause == th ? null : cause;
    }

    public static void setCause(Throwable th, Throwable cause) {
        if (th.getClass().getName().equals(JMS_EXCEPTION_NAME)) {
            try {
                th.getClass().getMethod(SET_LINKED_EXCEPTION_METHOD, Exception.class).invoke((Object)th, cause);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        } else {
            th.initCause(cause);
        }
    }
}

