/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.HttpServletRequestURLConvertInterceptorServiceMBean;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorService;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.journal.Journal;

public class HttpServletRequestURLConvertInterceptorService
extends ServletFilterInterceptorService
implements HttpServletRequestURLConvertInterceptorServiceMBean {
    private static final long serialVersionUID = 8599129621419714729L;
    protected ServiceName threadContextServiceName;
    protected ServiceName journalServiceName;
    protected Context threadContext;
    protected Journal journal;
    protected String[] resourcePaths;
    protected List resourcePathList;

    @Override
    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    @Override
    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    @Override
    public void setJournalServiceName(ServiceName name) {
        this.journalServiceName = name;
    }

    @Override
    public ServiceName getJournalServiceName() {
        return this.journalServiceName;
    }

    @Override
    public void setResourcePaths(String[] paths) {
        this.resourcePaths = paths;
    }

    @Override
    public String[] getResourcePaths() {
        return this.resourcePaths;
    }

    @Override
    public void startService() throws Exception {
        if (this.resourcePaths == null) {
            throw new IllegalArgumentException("ResourcePaths must be specified.");
        }
        this.resourcePathList = new ArrayList();
        for (int i = 0; i < this.resourcePaths.length; ++i) {
            ResourcePath rp = new ResourcePath(this.resourcePaths[i]);
            this.resourcePathList.add(rp);
        }
        if (this.threadContextServiceName != null) {
            this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
        }
        if (this.journalServiceName != null) {
            this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalServiceName);
        }
    }

    @Override
    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3) {
            HttpServletRequest request = (HttpServletRequest)context.getServletRequest();
            String uri = request.getRequestURI();
            for (int i = 0; i < this.resourcePathList.size(); ++i) {
                String pathInfo;
                ResourcePath rp = (ResourcePath)this.resourcePathList.get(i);
                if (!rp.isPatternMatch(uri)) continue;
                HashMap paramMap = new HashMap();
                rp.parseParameter(uri, paramMap);
                for (Map.Entry entry : paramMap.entrySet()) {
                    if (this.journal != null && this.journal.isStartJournal()) {
                        this.journal.addInfo((String)entry.getKey(), entry.getValue());
                    }
                    if (this.threadContext == null) continue;
                    this.threadContext.put((String)entry.getKey(), entry.getValue());
                }
                int index = 1;
                List paramIndexList = rp.getParameterPathIndex();
                String servletPath = request.getServletPath();
                if (servletPath != null && !"".equals(servletPath)) {
                    StringBuffer sb = new StringBuffer();
                    List list = ResourcePath.splitPath(servletPath);
                    for (int j = 0; j < list.size(); ++j) {
                        boolean isAdd = true;
                        for (int k = 0; k < paramIndexList.size(); ++k) {
                            if (index != (Integer)paramIndexList.get(k)) continue;
                            isAdd = false;
                        }
                        if (isAdd) {
                            sb.append(list.get(j));
                        }
                        ++index;
                    }
                    servletPath = sb.toString();
                }
                if ((pathInfo = request.getPathInfo()) != null && !"".equals(pathInfo)) {
                    StringBuffer sb = new StringBuffer();
                    List list = ResourcePath.splitPath(pathInfo);
                    for (int j = 0; j < list.size(); ++j) {
                        boolean isAdd = true;
                        for (int k = 0; k < paramIndexList.size(); ++k) {
                            if (index != (Integer)paramIndexList.get(k)) continue;
                            isAdd = false;
                        }
                        if (isAdd) {
                            sb.append(list.get(j));
                        }
                        ++index;
                    }
                    pathInfo = sb.toString();
                }
                URLConvertHttpServletRequestWrapper servletRequestWrapper = new URLConvertHttpServletRequestWrapper(request, servletPath, pathInfo, paramMap);
                context.setServletRequest((ServletRequest)servletRequestWrapper);
                break;
            }
        }
        return chain.invokeNext(context);
    }

    public static class ResourcePath {
        protected String path;
        protected List pathElements = new ArrayList();
        protected List parameterPathIndex;

        public ResourcePath(String path) throws IllegalArgumentException {
            if (path.length() == 0) {
                throw new IllegalArgumentException("empty path : path=" + path);
            }
            this.path = path;
            List elements = ResourcePath.splitPath(path);
            for (int i = 0; i < elements.size(); ++i) {
                String element = (String)elements.get(i);
                if (ParameterPath.isParameterPath(element)) {
                    if (this.parameterPathIndex == null) {
                        this.parameterPathIndex = new ArrayList();
                    }
                    this.parameterPathIndex.add(new Integer(this.pathElements.size()));
                    this.pathElements.add(new ParameterPath(element));
                    continue;
                }
                this.pathElements.add(element);
            }
        }

        public String getPath() {
            return this.path;
        }

        public List getPathElementList() {
            return this.pathElements;
        }

        public int getParameterPathSize() {
            return this.parameterPathIndex == null ? 0 : this.parameterPathIndex.size();
        }

        public ParameterPath getParameterPathIndex(int index) {
            return this.parameterPathIndex == null || this.parameterPathIndex.size() <= index ? null : (ParameterPath)this.pathElements.get((Integer)this.parameterPathIndex.get(index));
        }

        public static List splitPath(String path) {
            String[] paths = path.split("/");
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < paths.length; ++i) {
                String p = paths[i];
                if (p.length() == 0) continue;
                result.add("/" + p);
            }
            return result;
        }

        public boolean hasParameterPath() {
            return this.parameterPathIndex != null;
        }

        public List getParameterPathIndex() {
            return this.parameterPathIndex;
        }

        public boolean isPatternMatch(String path) {
            List paths = ResourcePath.splitPath(path);
            if (paths.size() < this.pathElements.size()) {
                return false;
            }
            for (int i = 0; i < this.pathElements.size(); ++i) {
                Pattern pattern;
                Matcher m;
                Object peo = this.pathElements.get(i);
                if (peo instanceof ParameterPath) continue;
                String pe = (String)peo;
                String p = (String)paths.get(i);
                if (i == this.pathElements.size() - 1) {
                    StringBuffer sb = new StringBuffer(p);
                    for (int j = i; j < paths.size(); ++j) {
                        sb.append(paths.get(j));
                    }
                    p = sb.toString();
                }
                if (pe.equals(p) || (m = (pattern = Pattern.compile(pe)).matcher(p)).find()) continue;
                return false;
            }
            return true;
        }

        public String parseParameter(String path, Map result) throws IndexOutOfBoundsException {
            if (!this.hasParameterPath()) {
                return path;
            }
            List paths = ResourcePath.splitPath(path);
            for (int i = 0; i < this.parameterPathIndex.size(); ++i) {
                Integer index = (Integer)this.parameterPathIndex.get(i);
                ParameterPath pp = (ParameterPath)this.pathElements.get(index);
                result = pp.parseParameter((String)paths.get(index), result);
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < paths.size(); ++i) {
                String p = (String)paths.get(i);
                boolean isAdd = true;
                for (int j = 0; j < this.parameterPathIndex.size(); ++j) {
                    Integer index = (Integer)this.parameterPathIndex.get(j);
                    if (i != index) continue;
                    isAdd = false;
                }
                if (!isAdd) continue;
                sb.append(p);
            }
            return sb.toString();
        }

        public String toString() {
            return this.path;
        }

        public static class ParameterPath {
            protected static final Pattern PARAMETER_PATTERN = Pattern.compile("\\{.+?\\}");
            protected final String path;
            protected final int paramCount;
            protected List paramElements = new ArrayList();

            public ParameterPath(String path) throws IllegalArgumentException {
                this.path = path;
                Matcher m = PARAMETER_PATTERN.matcher(path);
                int offset = 0;
                int count = 0;
                while (m.find()) {
                    if (offset != 0 || m.start() == offset) {
                        throw new IllegalArgumentException("deletemer not exists. path=" + path);
                    }
                    this.paramElements.add(path.substring(offset, m.start()));
                    this.paramElements.add(new ParameterElement(m.group()));
                    ++count;
                    offset = m.end();
                }
                if (offset != path.length()) {
                    this.paramElements.add(path.substring(offset));
                }
                this.paramCount = count;
            }

            public String getPath() {
                return this.path;
            }

            public int getParameterCount() {
                return this.paramCount;
            }

            public List getParameterElementList() {
                return this.paramElements;
            }

            public Map parseParameter(String path, Map result) throws IndexOutOfBoundsException {
                if (result == null) {
                    result = new LinkedHashMap<String, String>();
                }
                int offset = 0;
                ParameterElement prePe = null;
                for (int i = 0; i < this.paramElements.size(); ++i) {
                    Object element = this.paramElements.get(i);
                    if (prePe == null) {
                        if (element instanceof String) {
                            offset += ((String)element).length();
                            continue;
                        }
                        prePe = (ParameterElement)element;
                        continue;
                    }
                    result.put(prePe.name, path.substring(offset, path.indexOf((String)element, offset)));
                    offset += ((String)element).length();
                    prePe = null;
                }
                if (prePe != null) {
                    result.put(prePe.name, path.substring(offset));
                }
                return result;
            }

            public String toString() {
                return this.path;
            }

            public int hashCode() {
                return this.path.hashCode();
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof ParameterPath)) {
                    return false;
                }
                return this.path.equals(((ParameterPath)obj).path);
            }

            public static boolean isParameterPath(String path) {
                Matcher m = PARAMETER_PATTERN.matcher(path);
                return m.find();
            }

            protected static class ParameterElement {
                protected final String name;

                public ParameterElement(String element) {
                    this.name = element.substring(1, element.length() - 1);
                }

                public String getName() {
                    return this.name;
                }
            }
        }
    }

    public class URLConvertHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private Map parameterMap;
        private String servletPath;
        private String pathInfo;

        public URLConvertHttpServletRequestWrapper(HttpServletRequest request, String servletPath, String pathInfo, Map map) {
            super(request);
            this.parameterMap = map;
            this.servletPath = servletPath;
            this.pathInfo = pathInfo;
        }

        public Map getParameterMap() {
            return this.parameterMap;
        }

        public String getRequestURI() {
            StringBuffer uri = new StringBuffer();
            uri.append(this.getContextPath());
            if (this.getServletPath() != null) {
                uri.append(this.getServletPath());
            }
            if (this.getPathInfo() != null) {
                uri.append(this.getPathInfo());
            }
            return uri.toString();
        }

        public StringBuffer getRequestURL() {
            StringBuffer url = new StringBuffer();
            url.append(this.getScheme());
            url.append("://").append(this.getLocalAddr());
            url.append(":").append(this.getLocalPort());
            url.append(this.getRequestURI());
            return url;
        }

        public String getServletPath() {
            return this.servletPath;
        }

        public String getPathInfo() {
            return this.pathInfo;
        }
    }
}

