/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.HttpServletResponseDeflateInterceptorServiceMBean;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorService;
import jp.ossc.nimbus.service.performance.PerformanceRecorder;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.xerial.snappy.Snappy;

public class HttpServletResponseDeflateInterceptorService
extends ServletFilterInterceptorService
implements HttpServletResponseDeflateInterceptorServiceMBean {
    private static final long serialVersionUID = -8811812672782874906L;
    private static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    private static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    private static final String CONTENT_ENCODING_DEFLATE = "deflate";
    private static final String CONTENT_ENCODING_GZIP = "gzip";
    private static final String CONTENT_ENCODING_X_GZIP = "x-gzip";
    private static final String CONTENT_ENCODING_SNAPPY = "snappy";
    private static final String CONTENT_ENCODING_LZ4 = "lz4";
    private static final String CONTENT_ENCODING_IDENTITY = "identity";
    private static final String CONTENT_ENCODING_ALL = "*";
    private static final String DEFAULT_ENC = "ISO_8859-1";
    private String[] enabledContentTypes;
    private String[] disabledContentTypes;
    private int deflateLength = -1;
    private long responseCount;
    private long compressCount;
    private long compressedCount;
    private double totalCompressedRate;
    private ServiceName performanceRecorderServiceName;
    private PerformanceRecorder performanceRecorder;
    private ServiceName beforeCompressSizePerformanceRecorderServiceName;
    private PerformanceRecorder beforeCompressSizePerformanceRecorder;
    private ServiceName afterCompressSizePerformanceRecorderServiceName;
    private PerformanceRecorder afterCompressSizePerformanceRecorder;

    @Override
    public void setEnabledContentTypes(String[] contentTypes) {
        this.enabledContentTypes = contentTypes;
    }

    @Override
    public String[] getEnabledContentTypes() {
        return this.enabledContentTypes;
    }

    @Override
    public void setDisabledContentTypes(String[] contentTypes) {
        this.disabledContentTypes = contentTypes;
    }

    @Override
    public String[] getDisabledContentTypes() {
        return this.disabledContentTypes;
    }

    @Override
    public void setDeflateLength(int length) {
        this.deflateLength = length;
    }

    @Override
    public int getDeflateLength() {
        return this.deflateLength;
    }

    @Override
    public void setPerformanceRecorderServiceName(ServiceName name) {
        this.performanceRecorderServiceName = name;
    }

    @Override
    public ServiceName getPerformanceRecorderServiceName() {
        return this.performanceRecorderServiceName;
    }

    @Override
    public void setBeforeCompressSizePerformanceRecorderServiceName(ServiceName name) {
        this.beforeCompressSizePerformanceRecorderServiceName = name;
    }

    @Override
    public ServiceName getBeforeCompressSizePerformanceRecorderServiceName() {
        return this.beforeCompressSizePerformanceRecorderServiceName;
    }

    @Override
    public void setAfterCompressSizePerformanceRecorderServiceName(ServiceName name) {
        this.afterCompressSizePerformanceRecorderServiceName = name;
    }

    @Override
    public ServiceName getAfterCompressSizePerformanceRecorderServiceName() {
        return this.afterCompressSizePerformanceRecorderServiceName;
    }

    @Override
    public long getResponseCount() {
        return this.responseCount;
    }

    @Override
    public long getCompressCount() {
        return this.compressCount;
    }

    @Override
    public double getCompressRate() {
        return (double)this.compressCount / (double)this.responseCount;
    }

    @Override
    public long getCompressedCount() {
        return this.compressedCount;
    }

    @Override
    public double getCompressedRate() {
        return (double)this.compressedCount / (double)this.compressCount;
    }

    @Override
    public double getAverageCompressionRate() {
        return this.totalCompressedRate / (double)this.compressedCount;
    }

    @Override
    public void startService() throws Exception {
        if (this.performanceRecorderServiceName != null) {
            this.performanceRecorder = (PerformanceRecorder)ServiceManagerFactory.getServiceObject(this.performanceRecorderServiceName);
        }
        if (this.beforeCompressSizePerformanceRecorderServiceName != null) {
            this.beforeCompressSizePerformanceRecorder = (PerformanceRecorder)ServiceManagerFactory.getServiceObject(this.beforeCompressSizePerformanceRecorderServiceName);
        }
        if (this.afterCompressSizePerformanceRecorderServiceName != null) {
            this.afterCompressSizePerformanceRecorder = (PerformanceRecorder)ServiceManagerFactory.getServiceObject(this.afterCompressSizePerformanceRecorderServiceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3) {
            String acceptEncoding;
            ServletRequest request = context.getServletRequest();
            boolean isWrap = false;
            if (request instanceof HttpServletRequest && (acceptEncoding = ((HttpServletRequest)request).getHeader(HEADER_ACCEPT_ENCODING)) != null) {
                context.setServletResponse((ServletResponse)new DeflateHttpServletResponseWrapper((HttpServletResponse)context.getServletResponse(), acceptEncoding, this.enabledContentTypes, this.disabledContentTypes, this.deflateLength));
                isWrap = true;
            }
            try {
                Object object = chain.invokeNext(context);
                return object;
            }
            finally {
                if (isWrap) {
                    ServletResponse response = context.getServletResponse();
                    if (response instanceof DeflateHttpServletResponseWrapper) {
                        ((DeflateHttpServletResponseWrapper)response).flushBuffer();
                        context.setServletResponse(((DeflateHttpServletResponseWrapper)response).getResponse());
                    } else {
                        while (response instanceof ServletResponseWrapper && !(response instanceof DeflateHttpServletResponseWrapper)) {
                            response = ((ServletResponseWrapper)response).getResponse();
                        }
                        if (response instanceof DeflateHttpServletResponseWrapper) {
                            ((DeflateHttpServletResponseWrapper)response).flushBuffer();
                        }
                    }
                }
            }
        }
        return chain.invokeNext(context);
    }

    private class DeflateServletOutputStreamWrapper
    extends ServletOutputStream {
        private HttpServletResponse response;
        private ByteArrayOutputStream baos;
        private PrintStream ps;
        private ServletOutputStream sos;
        private String acceptEncoding;
        private int deflateLength = -1;
        private int writeLength;

        public DeflateServletOutputStreamWrapper(HttpServletResponse response, String acceptEncoding, String charEncoding, int deflateLength) throws IOException {
            this.response = response;
            this.baos = new ByteArrayOutputStream();
            this.acceptEncoding = acceptEncoding;
            this.deflateLength = deflateLength;
            this.ps = new PrintStream((OutputStream)this.baos, true, charEncoding == null ? HttpServletResponseDeflateInterceptorService.DEFAULT_ENC : charEncoding);
        }

        public void write(int b) throws IOException {
            this.baos.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.baos.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.baos.write(b, off, len);
        }

        public void print(String s) throws IOException {
            this.ps.print(s);
        }

        public void print(boolean b) throws IOException {
            this.ps.print(b);
        }

        public void print(char c) throws IOException {
            this.ps.print(c);
        }

        public void print(int i) throws IOException {
            this.ps.print(i);
        }

        public void print(long l) throws IOException {
            this.ps.print(l);
        }

        public void print(float f) throws IOException {
            this.ps.print(f);
        }

        public void print(double d) throws IOException {
            this.ps.print(d);
        }

        public void println() throws IOException {
            this.ps.println();
        }

        public void println(String s) throws IOException {
            this.ps.println(s);
        }

        public void println(boolean b) throws IOException {
            this.ps.println(b);
        }

        public void println(char c) throws IOException {
            this.ps.println(c);
        }

        public void println(int i) throws IOException {
            this.ps.println(i);
        }

        public void println(long l) throws IOException {
            this.ps.println(l);
        }

        public void println(float f) throws IOException {
            this.ps.println(f);
        }

        public void println(double d) throws IOException {
            this.ps.println(d);
        }

        private String getAppropriateEncoding(String encoding) {
            if (encoding.indexOf(59) == -1) {
                if (encoding.indexOf(HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_ALL) != -1 || encoding.indexOf(HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_GZIP) != -1 || encoding.indexOf(HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_X_GZIP) != -1) {
                    return HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_GZIP;
                }
                if (encoding.indexOf(HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_DEFLATE) != -1) {
                    return HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_DEFLATE;
                }
                if (encoding.indexOf(HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_SNAPPY) != -1) {
                    return HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_SNAPPY;
                }
                if (encoding.indexOf(HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_LZ4) != -1) {
                    return HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_LZ4;
                }
                return HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_IDENTITY;
            }
            double currentQValue = 0.0;
            String result = HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_IDENTITY;
            String[] encodes = encoding.split(",");
            for (int i = 0; i < encodes.length; ++i) {
                String encode = encodes[i].trim();
                if (!encode.startsWith(HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_DEFLATE) && !encode.startsWith(HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_GZIP) && !encode.startsWith(HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_X_GZIP) && !encode.startsWith(HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_ALL) && !encode.startsWith(HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_SNAPPY) && !encode.startsWith(HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_LZ4) && !encode.startsWith(HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_IDENTITY)) continue;
                int index = encode.indexOf(59);
                double qValue = 1.0;
                if (index == -1) continue;
                String qValueStr = encode.substring(index + 1);
                encode = encode.substring(0, index).trim();
                index = qValueStr.indexOf(61);
                if (index != -1) {
                    qValueStr = qValueStr.substring(index + 1);
                    try {
                        qValue = Double.parseDouble(qValueStr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (qValue == 0.0 && HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_IDENTITY.equals(encode) && HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_IDENTITY.equals(result)) {
                    result = null;
                }
                if (!(qValue > currentQValue)) continue;
                result = HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_ALL.equals(encode) ? HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_GZIP : (HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_X_GZIP.equals(encode) ? HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_GZIP : encode);
            }
            return result;
        }

        public void flushBuffer() throws IOException {
            HttpServletResponseDeflateInterceptorService.this.responseCount++;
            this.ps.flush();
            byte[] bytes = this.baos.toByteArray();
            if (bytes != null && bytes.length != 0) {
                if (bytes.length >= this.deflateLength) {
                    this.baos.reset();
                    String encoding = this.getAppropriateEncoding(this.acceptEncoding);
                    if (encoding == null || HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_IDENTITY.equals(encoding)) {
                        if (HttpServletResponseDeflateInterceptorService.this.beforeCompressSizePerformanceRecorder != null) {
                            HttpServletResponseDeflateInterceptorService.this.beforeCompressSizePerformanceRecorder.recordValue(System.currentTimeMillis(), bytes.length);
                        }
                    } else {
                        long start = System.currentTimeMillis();
                        HttpServletResponseDeflateInterceptorService.this.compressCount++;
                        byte[] compressedBytes = null;
                        double compressedRate = 0.0;
                        if (HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_SNAPPY.equals(encoding)) {
                            compressedBytes = Snappy.compress((byte[])bytes);
                        } else if (HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_LZ4.equals(encoding)) {
                            LZ4BlockOutputStream lzos = new LZ4BlockOutputStream((OutputStream)this.baos);
                            lzos.write(bytes);
                            lzos.flush();
                            lzos.finish();
                            lzos.close();
                            compressedBytes = this.baos.toByteArray();
                            this.baos.reset();
                        } else {
                            DeflaterOutputStream dos = null;
                            if (HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_DEFLATE.equals(encoding)) {
                                dos = new DeflaterOutputStream(this.baos);
                            } else if (HttpServletResponseDeflateInterceptorService.CONTENT_ENCODING_GZIP.equals(encoding)) {
                                dos = new GZIPOutputStream(this.baos);
                            }
                            if (dos != null) {
                                dos.write(bytes);
                                dos.flush();
                                dos.finish();
                                dos.close();
                                compressedBytes = this.baos.toByteArray();
                                this.baos.reset();
                            }
                        }
                        long currentTime = System.currentTimeMillis();
                        if (HttpServletResponseDeflateInterceptorService.this.performanceRecorder != null) {
                            HttpServletResponseDeflateInterceptorService.this.performanceRecorder.record(start, currentTime);
                        }
                        if (HttpServletResponseDeflateInterceptorService.this.beforeCompressSizePerformanceRecorder != null) {
                            HttpServletResponseDeflateInterceptorService.this.beforeCompressSizePerformanceRecorder.recordValue(currentTime, bytes.length);
                        }
                        if (bytes.length > compressedBytes.length) {
                            if (HttpServletResponseDeflateInterceptorService.this.afterCompressSizePerformanceRecorder != null) {
                                HttpServletResponseDeflateInterceptorService.this.afterCompressSizePerformanceRecorder.recordValue(currentTime, compressedBytes.length);
                            }
                            HttpServletResponseDeflateInterceptorService.this.compressedCount++;
                            HttpServletResponseDeflateInterceptorService.this.totalCompressedRate = HttpServletResponseDeflateInterceptorService.this.totalCompressedRate + (double)compressedBytes.length / (double)bytes.length;
                            bytes = compressedBytes;
                            this.response.setHeader(HttpServletResponseDeflateInterceptorService.HEADER_CONTENT_ENCODING, encoding);
                        }
                    }
                }
                if (this.sos == null) {
                    this.sos = this.response.getOutputStream();
                }
                this.response.setContentLength(bytes.length);
                this.sos.write(bytes);
                this.sos.flush();
                this.writeLength += bytes.length;
            }
        }

        public int getWriteLength() {
            return this.writeLength;
        }

        public void close() throws IOException {
            this.flush();
            this.ps.close();
            this.baos.close();
            if (this.sos != null) {
                this.sos.close();
            }
            super.close();
        }
    }

    private class DeflateHttpServletResponseWrapper
    extends HttpServletResponseWrapper {
        private String acceptEncoding;
        private String[] enabledContentTypes;
        private String[] disabledContentTypes;
        private ServletOutputStream sos;
        private PrintWriter pw;
        private int deflateLength;

        public DeflateHttpServletResponseWrapper(HttpServletResponse response, String acceptEncoding, String[] enabledContentTypes, String[] disabledContentTypes, int deflateLength) {
            super(response);
            this.deflateLength = -1;
            this.acceptEncoding = acceptEncoding;
            this.enabledContentTypes = enabledContentTypes;
            this.disabledContentTypes = disabledContentTypes;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            int i;
            String contentType;
            if (this.sos != null) {
                return this.sos;
            }
            if (this.disabledContentTypes != null && this.disabledContentTypes.length != 0) {
                contentType = this.getContentType();
                boolean disable = false;
                for (i = 0; i < this.disabledContentTypes.length; ++i) {
                    if (!this.disabledContentTypes[i].equalsIgnoreCase(contentType)) continue;
                    disable = true;
                    break;
                }
                if (disable) {
                    this.sos = super.getOutputStream();
                    return this.sos;
                }
            }
            if (this.enabledContentTypes != null && this.enabledContentTypes.length != 0) {
                contentType = this.getContentType();
                boolean enable = false;
                for (i = 0; i < this.enabledContentTypes.length; ++i) {
                    if (!this.enabledContentTypes[i].equalsIgnoreCase(contentType)) continue;
                    enable = true;
                    break;
                }
                if (!enable) {
                    this.sos = super.getOutputStream();
                    return this.sos;
                }
            }
            this.sos = new DeflateServletOutputStreamWrapper((HttpServletResponse)this.getResponse(), this.acceptEncoding, this.getCharacterEncoding(), this.deflateLength);
            return this.sos;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.pw == null) {
                String charEncoding = this.getCharacterEncoding();
                this.pw = new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), charEncoding == null ? HttpServletResponseDeflateInterceptorService.DEFAULT_ENC : charEncoding));
            }
            return this.pw;
        }

        public void flushBuffer() throws IOException {
            if (this.sos instanceof DeflateServletOutputStreamWrapper) {
                ((DeflateServletOutputStreamWrapper)this.sos).flushBuffer();
                this.setContentLength(((DeflateServletOutputStreamWrapper)this.sos).getWriteLength());
            }
            super.flushBuffer();
        }
    }
}

